/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.resource.AddrGroup;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.NodePushStatus;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceRouteException;
import com.raplix.util.logger.Logger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

class RouteTree
implements RPCSerializable,
Messages {
    private Hashtable mSubRoutes = new Hashtable();
    private boolean mIsDestination = false;
    private RoxAddress mRootAddress = null;
    private int mRootStatus = 0;
    private ResourceException mRootException = null;
    private int mMaxRouteLength = 0;

    RouteTree() {
    }

    public RouteTree(RoxAddress inAddress) {
        this.mRootAddress = inAddress;
    }

    public RoxAddress getRootAddress() {
        return this.mRootAddress;
    }

    public int getRootStatus() {
        return this.mRootStatus;
    }

    public ResourceException getRootException() {
        return this.mRootException;
    }

    public void setRootStatus(int inStatus, ResourceException inException) {
        this.mRootStatus = inStatus;
        this.mRootException = inException;
    }

    public int size() {
        return this.mSubRoutes.size();
    }

    public void integrate(RoxAddress[] inRoute) throws ResourceRouteException {
        int theRouteLength = inRoute.length;
        if (theRouteLength > this.mMaxRouteLength) {
            this.mMaxRouteLength = theRouteLength;
        }
        this.integrate(inRoute, 1);
    }

    public int getMaxRouteLength() {
        return this.mMaxRouteLength;
    }

    boolean expectingMoreStatus() {
        if (!NodePushStatus.isTerminated(this.mRootStatus)) {
            return true;
        }
        Iter theIter = this.iterator();
        while (theIter.hasNext()) {
            if (!theIter.next().expectingMoreStatus()) continue;
            return true;
        }
        return false;
    }

    public AddrGroup getAllAddrs() {
        AddrGroup theAddrGroup = new AddrGroup();
        this.addAddrs(theAddrGroup);
        return theAddrGroup;
    }

    private void addAddrs(AddrGroup inAddrGroup) {
        inAddrGroup.add(this.getRootAddress());
        Iter theIter = this.iterator();
        while (theIter.hasNext()) {
            theIter.next().addAddrs(inAddrGroup);
        }
    }

    public void markCascadingErrors(ResourceSubsysImpl inRsrcCtx, int inRootStatus, ResourceException inRootException) {
        if (!NodePushStatus.isError(inRootStatus) && Logger.isWarnEnabled(this)) {
            Logger.warn(ROXMessageManager.messageAsString("rsrc.MARKCASCADINGERRORS_NONERROR", new Object[]{new Integer(inRootStatus)}), this);
        }
        this.mRootStatus = inRootStatus;
        this.mRootException = inRootException;
        Iter theIter = this.iterator();
        while (theIter.hasNext()) {
            theIter.next().markSubtreeEntirely(inRsrcCtx, -5, null);
        }
    }

    public void markAnyUnterminated(ResourceSubsysImpl inRsrcCtx) {
        if (!NodePushStatus.isTerminated(this.mRootStatus)) {
            this.mRootStatus = -1;
        }
        Iter theIter = this.iterator();
        while (theIter.hasNext()) {
            theIter.next().markAnyUnterminated(inRsrcCtx);
        }
    }

    public void markSubtreeEntirely(ResourceSubsysImpl inRsrcCtx, int inStatus, ResourceException inException) {
        this.mRootStatus = inStatus;
        this.mRootException = inException;
        Iter theIter = this.iterator();
        while (theIter.hasNext()) {
            theIter.next().markSubtreeEntirely(inRsrcCtx, inStatus, inException);
        }
    }

    public RouteTree getRouteTree(RoxAddress inAddress) {
        if (inAddress.equals(this.mRootAddress)) {
            return this;
        }
        Iter theIter = this.iterator();
        while (theIter.hasNext()) {
            RouteTree theSubRouteTree = theIter.next().getRouteTree(inAddress);
            if (theSubRouteTree == null) continue;
            return theSubRouteTree;
        }
        return null;
    }

    private void integrate(RoxAddress[] inRoute, int inOffset) throws ResourceRouteException {
        RoxAddress theNextHop = inRoute[inOffset];
        RouteTree theSubRouteTree = (RouteTree)this.mSubRoutes.get(theNextHop);
        if (theSubRouteTree == null) {
            theSubRouteTree = new RouteTree(theNextHop);
            this.mSubRoutes.put(theNextHop, theSubRouteTree);
        }
        if (inOffset == inRoute.length - 1) {
            theSubRouteTree.setIsDestination();
        } else {
            theSubRouteTree.integrate(inRoute, inOffset + 1);
        }
    }

    void setIsDestination() {
        if (this.mIsDestination && Logger.isWarnEnabled(this)) {
            Logger.warn(ROXMessageManager.messageAsString("rsrc.DEST_REDUNDANT", new Object[]{this.mRootAddress}), this);
        }
        this.mIsDestination = true;
    }

    boolean getIsDestination() {
        return this.mIsDestination;
    }

    RouteTree getSubRouteTreeByIdx(int inIdx) throws ResourceException {
        if (inIdx > this.size()) {
            throw new ResourceException("rsrc.msg0431");
        }
        Iter theIter = this.iterator();
        while (inIdx-- > 0) {
            theIter.next();
        }
        return theIter.next();
    }

    public Iter iterator() {
        return new Iter();
    }

    public class Iter {
        private Iterator mIter;

        public Iter() {
            this.mIter = RouteTree.this.mSubRoutes.entrySet().iterator();
        }

        boolean hasNext() {
            return this.mIter.hasNext();
        }

        RouteTree next() {
            return (RouteTree)((Map.Entry)this.mIter.next()).getValue();
        }
    }
}

