/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PostTransactionException;
import com.raplix.rolloutexpress.persist.PreCommitException;
import com.raplix.rolloutexpress.persist.TopLevelTransactionListener;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.resource.DeferredDeleteTable;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.ResourceTreeMover;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.arbitration.Executable;
import com.raplix.rolloutexpress.resource.util.arbitration.StringArbitrator;
import java.util.Vector;

public class ResourceTreeMover
implements Messages {
    private String mSimulateSQLErrForTest = null;
    private ResourceSubsystem mCtx;
    private static final StringArbitrator sArbitrator = new StringArbitrator();

    public ResourceTreeMover(ResourceSubsystem inCtx) {
        this.mCtx = inCtx;
    }

    public void moveTrees(final String inSrcName, final String inDstName) throws ResourceException {
        String theSecondArbString;
        String theFirstArbString;
        if (inSrcName.compareTo(inDstName) < 0) {
            theFirstArbString = inSrcName;
            theSecondArbString = inDstName;
        } else {
            theFirstArbString = inDstName;
            theSecondArbString = inSrcName;
        }
        sArbitrator.execute(theFirstArbString, new Executable(){

            public Object execute() throws ResourceException {
                sArbitrator.execute(theSecondArbString, new Executable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object execute() throws ResourceException {
                        try {
                            PersistenceManager.getInstance().getTransactionManager().transact(new Transaction(this){
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public Object execute() throws ClassMapException, PersistenceManagerException, QueryException {
                                    try {
                                        ResourceTreeMover.access$400(1.access$300(2.access$000(this.this$2)), 1.access$100(2.access$000(this.this$2)), 1.access$200(2.access$000(this.this$2)));
                                    }
                                    catch (ResourceException e) {
                                        throw new PersistenceManagerException(e);
                                    }
                                    TreeMoverFileQueue theTreeMoverFileQueue = new TreeMoverFileQueue();
                                    PersistenceManager.getInstance().getTransactionManager().registerTopLevelTransactionListener(theTreeMoverFileQueue);
                                    ResourceTreeMover.access$500(1.access$300(2.access$000(this.this$2)), 1.access$100(2.access$000(this.this$2)), 1.access$200(2.access$000(this.this$2)), theTreeMoverFileQueue);
                                    return null;
                                }
                            });
                            return null;
                        }
                        catch (PersistenceManagerException e) {
                            throw new ResourceException(e);
                        }
                    }

                    static /* synthetic */ 1 access$000(2 x0) {
                        return x0.this$1;
                    }
                });
                return null;
            }

            static /* synthetic */ String access$100(1 x0) {
                return x0.inSrcName;
            }

            static /* synthetic */ String access$200(1 x0) {
                return x0.inDstName;
            }

            static /* synthetic */ ResourceTreeMover access$300(1 x0) {
                return x0.ResourceTreeMover.this;
            }
        });
    }

    private void verifySrcExistAndDstNotExist(String inSrcName, String inDstName) throws ResourceException {
        try {
            this.mCtx.getRsrcInfo(new ResourceSpec(inSrcName), VersionNumber.ROOT, null);
        }
        catch (ResourceNotLocalException e) {
            throw new ResourceException("rsrc.SRC_SQL_MUST_EXIST");
        }
        catch (Throwable t) {
            MiscUtils.resourceThrow(t);
        }
        RsrcInfo theDstRootInfo = null;
        try {
            theDstRootInfo = this.mCtx.getRsrcInfo(new ResourceSpec(inDstName), VersionNumber.ROOT, null);
        }
        catch (ResourceNotLocalException e) {
        }
        catch (Throwable t) {
            MiscUtils.resourceThrow(t);
        }
        if (theDstRootInfo != null) {
            throw new ResourceException("rsrc.DST_MUST_NOT_EXIST");
        }
    }

    private void moveTree(String inSrcName, String inDstName, TreeMoverFileQueue inTreeMoverFileQueue) throws PersistenceManagerException {
        try {
            ResourceSpec theSrcSpec = new ResourceSpec(inSrcName);
            ResourceSpec theDstSpec = new ResourceSpec(inDstName);
            inTreeMoverFileQueue.enterMovesWithinTrees(theSrcSpec, theDstSpec);
            if (this.mSimulateSQLErrForTest != null) {
                throw new PersistenceManagerException(new ROXMessage(this.mSimulateSQLErrForTest));
            }
            ResourceTable t = ResourceTable.DEFAULT;
            WhereClause whereHasName = QueryBuilder.where(QueryBuilder.equals(t.cName(), theSrcSpec.getName()));
            Select updatedIDs = t.select(QueryBuilder.sList(t.ID), whereHasName);
            t.notifyDependenciesOfUpdate(updatedIDs);
            QueryBuilder.execute(QueryBuilder.update(t, QueryBuilder.uList(QueryBuilder.set(t.cName(), theDstSpec.getName())), whereHasName));
        }
        catch (ResourceException e) {
            throw new PersistenceManagerException(e);
        }
    }

    public void forTestOnly_SimulateSQLError(Object inTest) {
        if (inTest == null) {
            this.mSimulateSQLErrForTest = null;
        } else {
            String theClassname = inTest.getClass().getName();
            if (theClassname.indexOf(".test.") == -1) {
                throw new IllegalStateException();
            }
            this.mSimulateSQLErrForTest = theClassname;
        }
    }

    static /* synthetic */ void access$400(ResourceTreeMover x0, String x1, String x2) throws ResourceException {
        x0.verifySrcExistAndDstNotExist(x1, x2);
    }

    static /* synthetic */ void access$500(ResourceTreeMover x0, String x1, String x2, TreeMoverFileQueue x3) throws PersistenceManagerException {
        x0.moveTree(x1, x2, x3);
    }

    static class TreeMoverFileQueue
    implements TopLevelTransactionListener {
        private Vector mMovesToLeave = new Vector();

        TreeMoverFileQueue() {
        }

        public void aboutToComplete(boolean isCommitable) throws PreCommitException {
        }

        public void transactionComplete(boolean isCommitted) throws PostTransactionException {
            this.leaveMovesWithinTrees();
        }

        public void enterMovesWithinTrees(ResourceSpec inSrcSpec, ResourceSpec inDstSpec) throws ResourceException {
            DeferredDeleteTable.enterMoveWithinTrees(inSrcSpec, inDstSpec);
            this.mMovesToLeave.add(new ResourceSpec[]{inSrcSpec, inDstSpec});
        }

        private void leaveMovesWithinTrees() {
            for (int i = 0; i < this.mMovesToLeave.size(); ++i) {
                DeferredDeleteTable.leaveMoveWithinTrees((ResourceSpec[])this.mMovesToLeave.get(i));
            }
        }
    }
}

