/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.CannotEnforceException;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.ConsistencyEnforcer;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.DeleteSessionID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.resource.AbsoluteFileSpec;
import com.raplix.rolloutexpress.resource.FileMover;
import com.raplix.rolloutexpress.resource.GetRemoteFileListener;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.MultiRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceIDSet;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.RsrcCheckoutInfo;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.RsrcInfoOrder;
import com.raplix.rolloutexpress.resource.RsrcPush;
import com.raplix.rolloutexpress.resource.capture.SnapshotContentsTable;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInMode;
import com.raplix.rolloutexpress.resource.checkInJob.RedundancyCheckMode;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceTypeAndOptions;
import com.raplix.rolloutexpress.resource.checkInJob.StatusMonitor;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.CheckInStatus;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Failed;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Succeeded;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceIOException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.exception.ResourcePersistenceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PermOptions;
import com.raplix.rolloutexpress.resource.packageformat.PlatformPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.RedundancyMode;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.TransPackageKeys;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.util.memix.commands.SessionCommand;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;

public class ResourceSubsystem
extends Subsystem
implements Messages,
ConsistencyEnforcer {
    public static final byte FTHID = 23;
    public static final String CONFIG_VARNAME_RSRC_MIN_MS_REPO_VOL_FREE_SPACE = "minMSRepoVolFreeSpace";
    public static final String CONFIG_VARNAME_RSRC_MAX_TRANSIENT_REPO_SIZE = "maxTransientRepoSize";
    public static final String CONFIG_DEFAULT_RSRC_MIN_MS_REPO_VOL_FREE_SPACE = "10000000";
    public static final String CONFIG_DEFAULT_RSRC_MAX_TRANSIENT_REPO_SIZE = "1000000000";
    public static final String CONFIG_VARNAME_RSRC_REDUNDANCY_MODE = "redundancy";
    public static final String CONFIG_DEFAULT_RSRC_REDUNDANCY_MODE = RedundancyMode.DATESIZE.getLabel();
    public static final String CONFIG_VARNAME_UPSTREAM_STATUS_RETRY_INTERVAL = "upstreamStatusRetryInterval";
    public static final String CONFIG_VARNAME_UPSTREAM_STATUS_RESEND_TIMEOUT = "upstreamStatusResendTimeout";
    public static final String CONFIG_VARNAME_MAX_SEG_SIZE = "maxSegSize";
    public static final String CONFIG_VARNAME_MAX_SEG_ENTRIES = "maxSegEntries";
    public static final String CONFIG_VARNAME_MAX_CACHED_RESOURCE_SIZES = "maxCachedSizes";
    private ResourceSubsysImpl mResourceSubsysImpl = null;
    private static final String CONFIG_VARNAME_DEFAULT_RSRC_PROVIDER = "defaultRsrcProvider";
    private static final String DEFAULT_VARNAME_DEFAULT_RSRC_PROVIDER = "127.0.0.1:7600";
    private static DefaultConfiguration[] sDefaultConfiguration = new DefaultConfiguration[]{new DefaultConfiguration("defaultRsrcProvider", "127.0.0.1:7600", "Address of the default resource provider, ie LD"), new DefaultConfiguration("minMSRepoVolFreeSpace", "10000000", "Minimum number of bytes the MS repo should be allowed to leave free before refusing to check in more resources"), new DefaultConfiguration("maxTransientRepoSize", "1000000000", "Maximum number of bytes the LD/RA repos should be allowed to grow to"), new DefaultConfiguration("redundancy", CONFIG_DEFAULT_RSRC_REDUNDANCY_MODE, "The criteria used at checkin time to detect redundancies in resources"), new DefaultConfiguration("upstreamStatusRetryInterval", "60", "The seconds between attempts to resend failed upstream status"), new DefaultConfiguration("upstreamStatusResendTimeout", "3600", "The number of seconds for which failed upstream status resends will be attempted"), new DefaultConfiguration("maxSegSize", "2040109000", "The maximum bytes of data to have in a resource segment"), new DefaultConfiguration("maxSegEntries", "128", "The maximum number of entries to have in a resource segment"), new DefaultConfiguration("maxCachedSizes", "250", "The maximum number of resource sizes to cache")};

    public FileMover forTestOnly_GetFileMover() {
        return this.mResourceSubsysImpl.getFileMover();
    }

    public NodePerms createDefaultNodePerms() {
        return this.mResourceSubsysImpl.createDefaultNodePerms();
    }

    public SnapshotContentsTable getSnapshotContentsTable() {
        return this.mResourceSubsysImpl.getSnapshotContentsTable();
    }

    public long getMinMSVolFreeSpace() throws ResourceException {
        return this.mResourceSubsysImpl.getMinMSVolFreeSpace();
    }

    public void setMinMSVolFreeSpace(long inMinMSVolFreeSpace) throws ResourceException {
        this.mResourceSubsysImpl.setMinMSVolFreeSpace(inMinMSVolFreeSpace);
    }

    public void setNonMSMaxCacheSize(long inMaxCache) throws ResourceException {
        this.mResourceSubsysImpl.setNonMSMaxCacheSize(inMaxCache);
    }

    public long getNonMSMaxCacheSize() {
        return this.mResourceSubsysImpl.getNonMSMaxCacheSize();
    }

    public long getNonMSTotalRepoSize() {
        return this.mResourceSubsysImpl.getNonMSTotalRepoSize();
    }

    public long forTestOnly_RefreshNonMSCurContentSize() {
        return this.mResourceSubsysImpl.calculateNonMSCurContentSize();
    }

    public void flushUnlockedResources() throws ResourceException {
        this.mResourceSubsysImpl.flushUnlockedResources();
    }

    public long getTotalSnapshotBytes() {
        return this.mResourceSubsysImpl.getTotalSnapshotBytes();
    }

    public ResourceEntry getTopResourceEntry(ResourceID inResourceID) throws ResourceException, RPCException {
        return this.mResourceSubsysImpl.getTopResourceEntry(inResourceID);
    }

    public void prepareForShutdown() throws RaplixShutdownException {
        this.mResourceSubsysImpl.prepareForShutdown();
    }

    boolean getPreparingForShutdown() {
        return this.mResourceSubsysImpl.getPreparingForShutdown();
    }

    public void backOutOfShutdown() throws RaplixShutdownException {
        this.mResourceSubsysImpl.backOutOfShutdown();
    }

    public void shutdown() throws RaplixShutdownException {
        this.mResourceSubsysImpl.shutdown();
    }

    public void forTestOnly_SetPushDropReception(boolean isReceptionOn) {
        this.mResourceSubsysImpl.forTestOnly_SetPushDropReception(isReceptionOn);
    }

    public long forTestOnly_GetInternalResSize(ResourceID inResourceID, PushID inPushID) throws ResourceException {
        return this.mResourceSubsysImpl.forTestOnly_GetInternalResSize(inResourceID, inPushID);
    }

    public File forTestOnly_GetInternalRepoFile(ResourceID inResourceID, PushID inPushID) throws ResourceException {
        return this.mResourceSubsysImpl.forTestOnly_GetInternalRepoFile(inResourceID, inPushID);
    }

    public Vector getAllPushes() {
        return this.mResourceSubsysImpl.getAllPushes();
    }

    public RsrcPush getRsrcPush(PushID inPushID) throws ResourceException {
        return this.mResourceSubsysImpl.getRsrcPush(inPushID);
    }

    public void getRemoteFile(AbsoluteFileSpec inRemoteAbsSrcSpec, RoxAddress inRemoteAddress, AbsoluteFileSpec inLocalAbsDstSpec, ObjectID inJobID) throws ResourceException, RPCException {
        this.mResourceSubsysImpl.getRemoteFile(inRemoteAbsSrcSpec, inRemoteAddress, inLocalAbsDstSpec, inJobID);
    }

    public RsrcInfo getRsrcInfo(ResourceSpec inResourceSpec, VersionNumber inVersion, PushID inPushID) throws ResourceException, RPCException {
        return this.mResourceSubsysImpl.getRsrcInfo(inResourceSpec, inVersion, inPushID);
    }

    public RsrcInfo getRsrcInfo(ResourceID inResourceID, PushID inPushID) throws ResourceException, RPCException {
        return this.mResourceSubsysImpl.getRsrcInfo(inResourceID, inPushID);
    }

    public RsrcCheckoutInfo getCheckoutInfo(ResourceID inResourceID) throws ResourceException, RPCException {
        return this.mResourceSubsysImpl.getCheckoutInfo(inResourceID);
    }

    public boolean forTestOnly_IsSnapshotOptimizable(ResourceID inResourceID, RoxAddress inAgentAddress) throws ResourceException {
        return this.mResourceSubsysImpl.isSnapshotOptimizable(inResourceID, inAgentAddress);
    }

    public void enforceConsistency() throws CannotEnforceException {
        try {
            this.enforceOrphanResourceConsistency();
        }
        catch (Throwable e) {
            throw new CannotEnforceException(new ROXMessage("rsrc.ERR_ENFORCE_CONSISTENCY"), e);
        }
    }

    private void enforceOrphanResourceConsistency() throws RPCException, PersistenceManagerException, InterruptedException, UnsupportedSubsystemException {
        MultiRsrcInfoQuery theOrphanQuery = ResourceSubsystem.getOrphans();
        RsrcInfo[] theOrphans = theOrphanQuery.select();
        if (null != theOrphans && 0 != theOrphans.length) {
            ResourceID[] theRIDs = new ResourceID[theOrphans.length];
            for (int i = 0; i < theOrphans.length; ++i) {
                theRIDs[i] = theOrphans[i].getResourceID();
            }
            ResourceIDSet theRIDSet = new ResourceIDSet(Arrays.asList(theRIDs));
            DeleteSessionID theOrphanReourceDeleteSessionID = ObjectID.delete(theRIDSet, true);
            while (1.0 > theOrphanReourceDeleteSessionID.getProgress()) {
                Thread.sleep(300L);
            }
        }
    }

    static MultiRsrcInfoQuery getOrphans() {
        MultiRsrcInfoQuery theOrphanQuery = MultiRsrcInfoQuery.all();
        theOrphanQuery.setObjectOrder(RsrcInfoOrder.BY_VERSION_DESC);
        theOrphanQuery.addFilter(new ObjectFilter(){

            public void addFilterCondition(QueryContext ctx) {
                ResourceTable theRsrcTable = (ResourceTable)ctx.getFirstTable();
                ComponentImplTable theCompTable = ComponentImplTable.DEFAULT;
                ctx.addAndWhereCondition(QueryBuilder.not(QueryBuilder.in((ColumnNode)theRsrcTable.ID, QueryBuilder.select(QueryBuilder.sList(theCompTable.LocalResourceID), QueryBuilder.tList(theCompTable), QueryBuilder.where(QueryBuilder.not(QueryBuilder.isNull(theCompTable.LocalResourceID)))))));
            }
        });
        return theOrphanQuery;
    }

    public static MultiRsrcInfoQuery getOrphans(Object inKey) {
        TransPackageKeys.verifyResourceKey(inKey);
        return ResourceSubsystem.getOrphans();
    }

    public RsrcInfo forTestOnly_CheckFilesInToMS(File inSrcTree, ResourceSpec inResourceSpec, boolean inIsConfig, String inDescription, PermOptions inPermOpts, VersionedSaveContext inVersionedSaveContext) throws ResourceException, RPCException {
        return this.mResourceSubsysImpl.forTestOnly_CheckFilesInToMS(inSrcTree, inResourceSpec, inIsConfig, inPermOpts, inVersionedSaveContext, RedundancyCheckMode.NO_REDUNDANCY_CHECK, true);
    }

    public RsrcInfo forTestOnly_CheckFilesInToMS(File inSrcTree, ResourceSpec inResourceSpec, boolean inIsConfig, PermOptions inPermOpts, VersionedSaveContext inVersionedSaveContext, RedundancyCheckMode inRedundancyCheckMode, boolean inResolveLinks) throws ResourceException, RPCException {
        return this.mResourceSubsysImpl.forTestOnly_CheckFilesInToMS(inSrcTree, inResourceSpec, inIsConfig, inPermOpts, inVersionedSaveContext, inRedundancyCheckMode, inResolveLinks);
    }

    public StatusMonitor beginCheckIn(ResourceTypeAndOptions inResourceTypeAndOptions, CategoryIDSet inCategoryIDSet, boolean inConfigurable, ResourceSpec inResourceSpec, RedundancyCheckMode inRedundancyCheck, VersionedSaveContext inVersionedSaveContext, HostSetID inPlatform, boolean inResolveLinks, boolean inIsAsync, PluginID pluginID) throws ResourceException, RPCException {
        return this.mResourceSubsysImpl.beginCheckIn_SM(inResourceTypeAndOptions, inCategoryIDSet, inConfigurable, inResourceSpec, inRedundancyCheck, inVersionedSaveContext, inPlatform, inResolveLinks, inIsAsync, pluginID, false);
    }

    public StatusMonitor beginCheckIn(ResourceTypeAndOptions inResourceTypeAndOptions, CategoryIDSet inCategoryIDSet, boolean inConfigurable, ResourceSpec inResourceSpec, RedundancyCheckMode inRedundancyCheck, VersionedSaveContext inVersionedSaveContext, HostSetID inPlatform, boolean inResolveLinks) throws ResourceException, RPCException {
        return this.beginCheckIn(inResourceTypeAndOptions, inCategoryIDSet, inConfigurable, inResourceSpec, inRedundancyCheck, inVersionedSaveContext, inPlatform, inResolveLinks, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RsrcInfo checkInStreamAsConfig(InputStream inStream, ResourceSpec inResourceSpec, String inDescription, NodePerms inPerms, VersionedSaveContext inVersionedSaveContext) throws ResourceException, RPCException {
        File theTmpDiskFile = null;
        try {
            theTmpDiskFile = File.createTempFile("tmp_", null);
        }
        catch (IOException e) {
            throw new ResourceIOException("rsrc.msg0088", (Throwable)e);
        }
        try {
            StatusMonitor theMonitor;
            CheckInStatus theStatus;
            ResourceFileUtils.writeStreamToFile(theTmpDiskFile, System.currentTimeMillis(), inStream);
            PermOptions thePermOpts = null;
            if (inPerms != null) {
                thePermOpts = PlatformPermissionFactory.getInstance().createOverrideOptions(inPerms);
            }
            if (!((theStatus = (theMonitor = this.mResourceSubsysImpl.beginCheckIn_SM(ResourceTypeAndOptions.makeCheckIn(RsrcInfo.getFileTypeName(), theTmpDiskFile, Host.MASTER_SERVER_ID, thePermOpts, CheckInMode.REPLACE), null, true, inResourceSpec, RedundancyCheckMode.DELTA_ONLY, inVersionedSaveContext, null, true, true, null, true)).waitWhileInProgress()) instanceof Succeeded)) {
                if (theStatus instanceof Failed) {
                    CommandException theException = ((Failed)theStatus).getException();
                    throw new ResourceException("rsrc.msg0368", (Throwable)theException);
                }
                throw new ResourceException("rsrc.msg0369");
            }
            RsrcInfo rsrcInfo = ((Succeeded)theStatus).getRsrcInfo();
            return rsrcInfo;
        }
        finally {
            if (theTmpDiskFile != null) {
                theTmpDiskFile.delete();
            }
        }
    }

    public boolean isLocal(ResourceID inResourceID, PushID inPushID) throws ResourceException {
        return this.mResourceSubsysImpl.isLocal(inResourceID, inPushID);
    }

    public boolean forTestOnly_IsLocked(ResourceID inResourceID) {
        return this.mResourceSubsysImpl.forTestOnly_IsLocked(inResourceID);
    }

    public void forTestOnly_ReinflateRepo() throws ResourceException {
        this.mResourceSubsysImpl.forTestOnly_ReinflateRepo();
    }

    public void forTestOnly_SetPushFailure(boolean inDoForceFailure, int inFailMode) {
        this.mResourceSubsysImpl.forTestOnly_SetPushFailure(inDoForceFailure, inFailMode);
    }

    public void forTestOnly_VerifyPushesDisposed() throws ResourceException {
        this.mResourceSubsysImpl.forTestOnly_VerifyPushesDisposed();
    }

    public RsrcInfo getMostRecentRsrcInfo(ResourceSpec inResourceSpec) throws ResourcePersistenceException, ResourceNotLocalException {
        return this.mResourceSubsysImpl.getMostRecentRsrcInfo(inResourceSpec);
    }

    public ResourceID forTestOnly_CreateRandomResource() throws ResourceException, IOException {
        return this.mResourceSubsysImpl.forTestOnly_CreateRandomResource(null, RsrcInfo.getFileTypeName(), false, false);
    }

    public ResourceID forTestOnly_CreateRandomResource(ResourceSpec inSpec, String inType, boolean inConfigurable, boolean inHasPermissions) throws ResourceException, IOException {
        return this.mResourceSubsysImpl.forTestOnly_CreateRandomResource(inSpec, inType, inConfigurable, inHasPermissions);
    }

    public void externalize(ResourceID inResourceID, PushID inTransportingPushID, DeployMode inDeployMode, AbsoluteFileSpec inDstLocation, NodePerms inGlobalOverridePerms) throws ResourceException, RPCException {
        this.mResourceSubsysImpl.externalize(inResourceID, inTransportingPushID, inDeployMode, inDstLocation, inGlobalOverridePerms);
    }

    public void externalizeToMemix(ResourceID inResourceID, PushID inTransportingPushID, DeployMode inDeployMode, AbsoluteFileSpec inDstLocation, SessionCommand inSessionCommand, NodePerms inGlobalOverridePerms) throws ResourceException, RPCException {
        this.mResourceSubsysImpl.externalizeToMemix(inResourceID, inTransportingPushID, inDeployMode, inDstLocation, inSessionCommand, inGlobalOverridePerms);
    }

    public String getConfigLocalRepo() throws ConfigurationException {
        return this.mApplication.getDataDirAbsPath();
    }

    private ResourceSubsystem() {
    }

    public ResourceSubsystem(Application inApp) throws ConfigurationException {
        this(inApp, false);
    }

    public ResourceSubsystem(Application inApp, boolean inForceServer) throws ConfigurationException {
        super(inApp);
        boolean isServer = inApp instanceof Server || inForceServer;
        this.mResourceSubsysImpl = new ResourceSubsysImpl(inApp, this.getConfigLocalRepo(), this, isServer, this.getConfigMaxSegSize(), this.getConfigMaxSegEntries(), this.getConfigMaxCachedSizes());
    }

    public long getConfigurationAsALong(String inConfigurationTag) throws ConfigurationException {
        return this.getConfigurationAsLong(inConfigurationTag);
    }

    public int getConfigUpstreamStatusRetryInterval() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_UPSTREAM_STATUS_RETRY_INTERVAL);
    }

    public int getConfigUpstreamStatusResendTimeout() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_UPSTREAM_STATUS_RESEND_TIMEOUT);
    }

    public long getConfigMaxSegSize() throws ConfigurationException {
        return this.getConfigurationAsLong(CONFIG_VARNAME_MAX_SEG_SIZE);
    }

    public int getConfigMaxSegEntries() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_MAX_SEG_ENTRIES);
    }

    public int getConfigMaxCachedSizes() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_MAX_CACHED_RESOURCE_SIZES);
    }

    ResourceSubsysImpl getImpl() {
        return this.mResourceSubsysImpl;
    }

    public ResourceSubsysImpl getImpl(Object inKey) {
        TransPackageKeys.verifyResourceKey(inKey);
        return this.mResourceSubsysImpl;
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        return sDefaultConfiguration;
    }

    public void registerRPCInterfaces(RPCManager inRPCManager) throws RPCException {
        this.mResourceSubsysImpl.registerRPCInterfaces(inRPCManager);
    }

    protected String getConfigurationPropertyPrefix() {
        return "rsrc";
    }

    public String getSubsystemName() {
        return ResourceSubsystem.getClassSubsystemName();
    }

    public static String getClassSubsystemName() {
        return "ResourceSubsystem";
    }

    public GetRemoteFileListener getGetRequestListener() {
        return this.mResourceSubsysImpl.getFileMover().getGetRequestListener();
    }

    public void setGetRequestListener(GetRemoteFileListener inGetRequestListener) {
        this.mResourceSubsysImpl.getFileMover().setGetRequestListener(inGetRequestListener);
    }
}

