/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.event.NotificationManagerException;
import com.raplix.rolloutexpress.event.query.bean.RunningDiffBean;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.rpc.ServiceUnavailableException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SetupException;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PostTransactionException;
import com.raplix.rolloutexpress.persist.PreCommitException;
import com.raplix.rolloutexpress.persist.TopLevelTransactionListener;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedPersistentObject;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.resource.AbsoluteFileSpec;
import com.raplix.rolloutexpress.resource.BootID;
import com.raplix.rolloutexpress.resource.DeploymentScope;
import com.raplix.rolloutexpress.resource.DirPath;
import com.raplix.rolloutexpress.resource.DiskMetaDbase;
import com.raplix.rolloutexpress.resource.FileMover;
import com.raplix.rolloutexpress.resource.Key;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.MetaDbase;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.PushParams;
import com.raplix.rolloutexpress.resource.RemoteResourceMgr;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceMgrUpstreamServices;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RouteTree;
import com.raplix.rolloutexpress.resource.RsrcCheckoutInfo;
import com.raplix.rolloutexpress.resource.RsrcDirLayout;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.RsrcPush;
import com.raplix.rolloutexpress.resource.RsrcPushImpl;
import com.raplix.rolloutexpress.resource.SQLMetaDbase;
import com.raplix.rolloutexpress.resource.TimedSequence;
import com.raplix.rolloutexpress.resource.VersionMap;
import com.raplix.rolloutexpress.resource.capture.SnapshotContentsTable;
import com.raplix.rolloutexpress.resource.capture.SnapshotOwnerTable;
import com.raplix.rolloutexpress.resource.checkInJob.CLIRemoteCheckInInterface;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInInterface;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInJobMgr;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInMode;
import com.raplix.rolloutexpress.resource.checkInJob.RedundancyCheckMode;
import com.raplix.rolloutexpress.resource.checkInJob.RemoteCheckInInterface;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceTypeAndOptions;
import com.raplix.rolloutexpress.resource.checkInJob.StatusMonitor;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.CheckInStatus;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Failed;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Succeeded;
import com.raplix.rolloutexpress.resource.diffdeploy.DeployLogger;
import com.raplix.rolloutexpress.resource.exception.CaptureException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLockableException;
import com.raplix.rolloutexpress.resource.exception.ResourcePersistenceException;
import com.raplix.rolloutexpress.resource.exception.ResourcePushFinishedWithErrorsException;
import com.raplix.rolloutexpress.resource.exception.ResourceTransportException;
import com.raplix.rolloutexpress.resource.multipipe.MultiReceivePipe;
import com.raplix.rolloutexpress.resource.multipipe.MultiSendPipe;
import com.raplix.rolloutexpress.resource.packageformat.FileSystemExternalizer;
import com.raplix.rolloutexpress.resource.packageformat.MetaMetaData;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PermOptions;
import com.raplix.rolloutexpress.resource.packageformat.PlatformPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.PosixPermOptions;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.RsrcPacker;
import com.raplix.rolloutexpress.resource.packageformat.SizedStream;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.CallbackClosure;
import com.raplix.rolloutexpress.resource.util.CallbackDispatcher;
import com.raplix.rolloutexpress.resource.util.CallbackDispatcherInterface;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceMemixUtils;
import com.raplix.rolloutexpress.resource.util.ResourceRandomUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.resource.util.Sequence;
import com.raplix.rolloutexpress.resource.util.TransPackageKeys;
import com.raplix.rolloutexpress.resource.util.arbitration.Executable;
import com.raplix.rolloutexpress.resource.util.arbitration.StringArbitrator;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleAppInstanceQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledResourceQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.Session;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.Semaphore;
import com.raplix.util.file.FileUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.memix.commands.SessionCommand;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.SafeThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class ResourceSubsysImpl
implements RemoteResourceMgr,
ResourceMgrUpstreamServices,
Messages {
    private static long MAX_SEG_SIZE;
    private static int MAX_SEG_ENTRIES;
    private CallbackDispatcher mCallbackCallbackDispatcher;
    private RepoSizeManager mRepoSizeManager;
    private MetaDbase mMetaDbase;
    private FileMover mFileMover;
    private boolean mIsServer;
    private Application mApplication;
    private RemoteResourceMgr mCachedMSRsrcMgr;
    private DirPath mAbsRepoRoot;
    private String mAbsRepoRootString;
    private Random mRandom;
    private boolean mPushDropReception;
    private boolean mPreparingForShutdown;
    private HashMap mExternOps;
    private StringArbitrator mArbitrator;
    private BootID mBootSignature;
    private long mMasterPushSequenceNumber;
    private boolean mDoForceFailure;
    private int mForcedPushFailMode;
    private SnapshotContentsTable mSnapshotContentsTable;
    private SnapshotOwnerTable mSnapshotOwnerTable;
    private TimedSequence mMostRecentTimedSequence;
    private NodePerms mDefaultNodePerms;
    private Hashtable mWaitingPushRcvThreads;
    public static final String RSRC_MGR = "rsrcMgr";
    private CheckInJobMgr mCheckInJobMgr;
    private CheckInInterface mCheckInInterface;
    private Context mGlobalContext;
    private static final PushID[] sPushIDTypeDummy;
    private static long sMaxDownloadableArchiveSize;
    private static long sMaxDownloadableFileCount;

    public static long getMaxSegSize() {
        return MAX_SEG_SIZE;
    }

    public static int getMaxSegEntries() {
        return MAX_SEG_ENTRIES;
    }

    public void forTestOnly_SetMaxSegSize(Object inKey, long inMaxSegSize) {
        TransPackageKeys.verifyResourceKey(inKey);
        MAX_SEG_SIZE = inMaxSegSize;
    }

    public void forTestOnly_SetMaxSegEntries(Object inKey, int inMaxSegEntries) {
        TransPackageKeys.verifyResourceKey(inKey);
        MAX_SEG_ENTRIES = inMaxSegEntries;
    }

    public boolean forTestOnly_DidDirTraversalOccur(Object inKey) {
        TransPackageKeys.verifyResourceKey(inKey);
        if (this.mIsServer) {
            return false;
        }
        if (this.mRepoSizeManager.getIsInited()) {
            return true;
        }
        if (this.mMetaDbase instanceof DiskMetaDbase) {
            return ((DiskMetaDbase)this.mMetaDbase).forTestOnly_DidDirTraversalOccur();
        }
        return false;
    }

    boolean getDoForceFailure() {
        return this.mDoForceFailure;
    }

    int getForcedPushFailMode() {
        return this.mForcedPushFailMode;
    }

    public FileMover getFileMover() {
        return this.mFileMover;
    }

    public Context getGlobalContext() {
        return this.mGlobalContext;
    }

    public RsrcPushImpl getPush(PushID inPushID) {
        return this.mMetaDbase.get(inPushID);
    }

    long getTotalSnapshotBytes() {
        File theSnapshotContentsDir;
        long theSum = 0L;
        if (this.mSnapshotContentsTable != null) {
            theSnapshotContentsDir = new File(RsrcDirLayout.getSnapshotContentsDir(this).toString());
            theSum += ResourceFileUtils.getBytesInDir(theSnapshotContentsDir);
        }
        if (this.mSnapshotOwnerTable != null) {
            theSnapshotContentsDir = new File(RsrcDirLayout.getSnapshotOwnerDir(this).toString());
            theSum += ResourceFileUtils.getBytesInDir(theSnapshotContentsDir);
        }
        return theSum;
    }

    public boolean isSnapshotOptimizable(ResourceID inResourceID, RoxAddress inRoxAddress) throws ResourceException {
        HostID theHostID;
        AppInstanceID theAppInstanceID;
        try {
            theAppInstanceID = this.getApplication().getNetSubsystem().getTransport().getHostUpdateManager().getAppInstanceID(inRoxAddress);
        }
        catch (SetupException e) {
            throw new ResourceException("rsrc.msg0445", new Object[]{inRoxAddress});
        }
        if (theAppInstanceID == null) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unable to resolve host for " + inRoxAddress, this);
            }
            return false;
        }
        final AppInstanceID theFinalAppInstanceID = theAppInstanceID;
        try {
            theHostID = (HostID)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PersistenceManagerException, RPCException {
                    return theFinalAppInstanceID.getByIDQuery().select().getHostID();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new ResourceException("rsrc.msg0446", (Throwable)e);
        }
        return DeploymentScope.isResourceDeployingOnHost(this, inResourceID, theHostID);
    }

    public CheckInJobMgr getCheckInJobMgr() {
        return this.mCheckInJobMgr;
    }

    public SnapshotContentsTable getSnapshotContentsTable() {
        return this.mSnapshotContentsTable;
    }

    public SnapshotOwnerTable getSnapshotOwnerTable() {
        return this.mSnapshotOwnerTable;
    }

    public long getMinMSVolFreeSpace() throws ResourceException {
        return this.mRepoSizeManager.getMinMSVolFreeSpace();
    }

    public void setMinMSVolFreeSpace(long inMinMSVolFreeSpace) throws ResourceException {
        this.mRepoSizeManager.setMinMSVolFreeSpace(inMinMSVolFreeSpace);
    }

    public void setNonMSMaxCacheSize(long inMaxCacheBytes) throws ResourceException {
        this.mRepoSizeManager.setNonMSMaxRepoSize(inMaxCacheBytes);
    }

    long getNonMSMaxCacheSize() {
        return this.mRepoSizeManager.getNonMSMaxCacheSize();
    }

    long getNonMSTotalRepoSize() {
        return this.mRepoSizeManager.getNonMSTotalRepoSize();
    }

    long calculateNonMSCurContentSize() {
        return this.mRepoSizeManager.getNonMSTotalRepoSize(true);
    }

    void flushUnlockedResources() throws ResourceException {
        this.mRepoSizeManager.flushUnlockedResources();
    }

    void prepareForShutdown() throws RaplixShutdownException {
        this.mPreparingForShutdown = true;
    }

    boolean getPreparingForShutdown() {
        return this.mPreparingForShutdown;
    }

    void backOutOfShutdown() throws RaplixShutdownException {
        this.mPreparingForShutdown = false;
    }

    void shutdown() throws RaplixShutdownException {
        Vector thePushes = this.mMetaDbase.getAllPushes();
        int theNumPushes = thePushes.size();
        for (int i = 0; i < theNumPushes; ++i) {
            try {
                ((RsrcPush)thePushes.get(i)).dispose();
                continue;
            }
            catch (ResourceException e) {
                throw new RaplixShutdownException("rsrc.msg0180", (Throwable)e);
            }
        }
    }

    public void forTestOnly_SetPushDropReception(boolean isReceptionOn) {
        this.mPushDropReception = isReceptionOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PushID[] getCurrentPushesOnNode(RoxAddress inNodeAddress) throws RPCException, ResourceException {
        ArrayList<PushID> thePushIDCollection = new ArrayList<PushID>();
        MetaDbase metaDbase = this.mMetaDbase;
        synchronized (metaDbase) {
            Vector thePushes = this.mMetaDbase.getAllPushes();
            int theNumPushes = thePushes.size();
            thePushIDCollection.ensureCapacity(theNumPushes);
            for (int i = 0; i < theNumPushes; ++i) {
                PushID thePushID = ((RsrcPush)thePushes.get(i)).getPushID();
                thePushIDCollection.add(thePushID);
            }
        }
        PushID[] thePushIDArray = thePushIDCollection.toArray(sPushIDTypeDummy);
        return thePushIDArray;
    }

    UserID getCurrentUserID() throws ResourceException {
        if (!this.mIsServer) {
            throw new ResourceException("rsrc.msg0153");
        }
        try {
            Session theSession = this.mApplication.getUserDBSubsystem().getSessionTable().getCurrentSession();
            if (theSession == null) {
                return null;
            }
            return theSession.getUserID();
        }
        catch (UnsupportedSubsystemException e) {
            throw new ResourceException("rsrc.msg0153", (Throwable)e);
        }
    }

    public Vector getAllPushes() {
        return this.mMetaDbase.getAllPushes();
    }

    public RsrcPush getRsrcPush(PushID inPushID) throws ResourceException {
        return new RsrcPush(this.getRsrcPushImpl(inPushID));
    }

    void verifyPushIsLive(PushID inPushID) throws ResourceException {
        RsrcPushImpl thePush;
        if (inPushID != null && ((thePush = this.mMetaDbase.get(inPushID)) == null || thePush.getIsDisposing())) {
            throw new ResourceException("rsrc.msg0181");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpPushData(PushID inPushID) {
        block6: {
            this.mFileMover.abortKeys(inPushID);
            PushRcvThread thePushRcvThread = null;
            Hashtable hashtable = this.mWaitingPushRcvThreads;
            synchronized (hashtable) {
                thePushRcvThread = (PushRcvThread)this.mWaitingPushRcvThreads.remove(inPushID);
            }
            if (thePushRcvThread != null) {
                thePushRcvThread.interruptSafe();
                try {
                    thePushRcvThread.halt();
                }
                catch (ResourceException e) {
                    if (!Logger.isErrorEnabled(this)) break block6;
                    Logger.error("Exception while attempting to halt PushRcvThread", e, this);
                }
            }
        }
    }

    long getBytesStreamed(PushID inPushID) {
        return this.mFileMover.getBytesStreamed(inPushID);
    }

    public RsrcInfo sendResourceAsZipFile(ResourceSpec inResourceSpec, VersionNumber inVersionNumber, final AbsoluteFileSpec inRemoteAbsDstSpec) throws ResourceException, RPCException {
        if (!this.mIsServer) {
            throw new ResourceException("rsrc.msg0304");
        }
        if (this.mPreparingForShutdown) {
            throw new ResourceException("rsrc.msg0182");
        }
        TransportInfo transportInfo = this.mApplication.getNetSubsystem().getRPC().getInvokerTransportInfo();
        if (transportInfo.isClientSide()) {
            throw new ResourceException("rsrc.REQUEST_NOT_CLI");
        }
        final Resource theResource = this.getResource(inResourceSpec, inVersionNumber, null);
        new ResourceAccessor(this, null){

            public Object innerAccess() throws ResourceException {
                SizedStream theSizedStream = this.getZippedStream(theResource.getResourceID());
                try {
                    ResourceSubsysImpl.this.mFileMover.sendStream(theSizedStream.getInputStream(), theSizedStream.getSize(), inRemoteAbsDstSpec, null, null);
                }
                catch (RPCException e) {
                    throw new ResourceException("rsrc.msg0265", (Throwable)e);
                }
                return null;
            }
        }.access();
        return new RsrcInfo(theResource);
    }

    public ResourceEntry getTopResourceEntry(final ResourceID inResourceID) throws ResourceException, RPCException {
        if (!this.mIsServer) {
            throw new IllegalStateException();
        }
        return (ResourceEntry)new ResourceAccessor(this, null){

            public Object innerAccess() throws ResourceException {
                RsrcManifest theManifest = this.getManifest(inResourceID, null);
                ResourceEntryIterator theIter = theManifest.getEntryIterator();
                ResourceEntry resourceEntry = null;
                if (theIter.hasNext()) {
                    resourceEntry = theIter.next();
                }
                return resourceEntry;
            }
        }.access();
    }

    public void getRemoteFile(AbsoluteFileSpec inRemoteAbsSrcSpec, RoxAddress inRemoteAddress, AbsoluteFileSpec inLocalAbsDstSpec, ObjectID inJobID) throws ResourceException, RPCException {
        if (this.mPreparingForShutdown) {
            throw new ResourceException("rsrc.msg0183");
        }
        if (this.mAbsRepoRoot.containsPath(inLocalAbsDstSpec.getAbsDirPath())) {
            throw new ResourceException("rsrc.msg0035");
        }
        this.mFileMover.getRemoteFile(inRemoteAbsSrcSpec, inLocalAbsDstSpec, inRemoteAddress, this.getMSAddress(), inJobID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void lockRsrcPush(RsrcPushImpl inRsrcPushImpl, boolean inWithLocks) throws ResourcePersistenceException, ResourceNotLockableException, ResourceNotLocalException, ResourceException {
        int theNumRsrcsLocked;
        Resource[] theResources = inRsrcPushImpl.getResourcesThatNeedLocking();
        int theNumResources = theResources.length;
        boolean succeeded = false;
        try {
            if (inWithLocks) {
                for (theNumRsrcsLocked = 0; theNumRsrcsLocked < theNumResources; ++theNumRsrcsLocked) {
                    Resource theResource = theResources[theNumRsrcsLocked];
                    this.mMetaDbase.lockResource(theResource, true);
                }
            }
            this.mMetaDbase.put(inRsrcPushImpl);
            return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (succeeded) throw throwable;
            for (int theRsrcIdx = 0; theRsrcIdx < theNumRsrcsLocked; ++theRsrcIdx) {
                Resource theResource = theResources[theRsrcIdx];
                try {
                    this.mMetaDbase.unlockResource(theResource);
                    continue;
                }
                catch (Exception e) {
                    if (!Logger.isWarnEnabled(this)) continue;
                    Logger.warn("snuffing error, could not unlock resource " + theResource.getResourceSpec(), this);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockRsrcPush(RsrcPushImpl inRsrcPushImpl, boolean inWithLocks) throws ResourcePersistenceException {
        MetaDbase metaDbase = this.mMetaDbase;
        synchronized (metaDbase) {
            this.mMetaDbase.remove(inRsrcPushImpl.getPushID());
        }
        Resource[] theResources = inRsrcPushImpl.getResourcesThatNeedLocking();
        long theNumResources = theResources.length;
        if (inWithLocks) {
            int theRsrcIdx = 0;
            while ((long)theRsrcIdx < theNumResources) {
                block7: {
                    Resource theResource = theResources[theRsrcIdx];
                    try {
                        this.mMetaDbase.unlockResource(theResource);
                    }
                    catch (Exception e) {
                        if (!Logger.isWarnEnabled(this)) break block7;
                        Logger.warn("Exception from unlockResource, snuffing...", this);
                    }
                }
                ++theRsrcIdx;
            }
        }
    }

    private RoxAddress getMSAddress() throws ResourceTransportException {
        RoxAddress theMSAddress = null;
        try {
            theMSAddress = this.mApplication.getNetSubsystem().getMSAddress();
        }
        catch (ConfigurationException e) {
            throw new ResourceTransportException("rsrc.msg0169", (Throwable)e);
        }
        catch (TransportException e) {
            throw new ResourceTransportException("rsrc.msg0170", (Throwable)e);
        }
        return theMSAddress;
    }

    public RemoteResourceMgr getMSRsrcMgr() throws ResourceException {
        if (this.mCachedMSRsrcMgr == null) {
            this.mCachedMSRsrcMgr = this.getRemoteResourceMgr(this.getMSAddress());
        }
        return this.mCachedMSRsrcMgr;
    }

    public DirPath getAbsRepoRoot() {
        return this.mAbsRepoRoot;
    }

    public String getAbsRepoRootString() {
        return this.mAbsRepoRootString;
    }

    public RsrcInfo forTestOnly_CheckFilesInToMS(File inSrcTree, ResourceSpec inResourceSpec, boolean inIsConfig, PermOptions inPermOpts, VersionedSaveContext inVersionedSaveContext, RedundancyCheckMode inRedundancyCheckMode, boolean inResolveLinks) throws ResourceException, RPCException {
        if (this.mPreparingForShutdown) {
            throw new ResourceException("rsrc.msg0185");
        }
        StatusMonitor theMonitor = this.beginCheckIn_SM(ResourceTypeAndOptions.makeCheckIn(inSrcTree.isDirectory() ? RsrcInfo.getDirTypeName() : RsrcInfo.getFileTypeName(), inSrcTree, null, inPermOpts, CheckInMode.REPLACE), null, inIsConfig, inResourceSpec, inRedundancyCheckMode, inVersionedSaveContext, null, inResolveLinks, true, null, false);
        CheckInStatus theStatus = theMonitor.waitWhileInProgress();
        if (!(theStatus instanceof Succeeded)) {
            if (theStatus instanceof Failed) {
                CommandException theException = ((Failed)theStatus).getException();
                throw new ResourceException("rsrc.msg0368", (Throwable)theException);
            }
            throw new ResourceException("rsrc.msg0369");
        }
        return ((Succeeded)theStatus).getRsrcInfo();
    }

    public StatusMonitor beginCheckIn_SM(ResourceTypeAndOptions inResourceTypeAndOptions, CategoryIDSet inCategoryIDSet, boolean inConfigurable, ResourceSpec inResourceSpec, RedundancyCheckMode inRedundancyCheck, VersionedSaveContext inVersionedSaveContext, HostSetID inPlatform, boolean inResolveLinks, boolean inIsAsync, PluginID inPluginID, boolean inFromMSApp) throws ResourceException, RPCException {
        if (!this.mIsServer) {
            throw new IllegalStateException("This call may only be invoked on the server");
        }
        if (this.mPreparingForShutdown) {
            throw new ResourceException("rsrc.msg0185");
        }
        return this.spawnCheckInJobOnMS_SM(inResourceTypeAndOptions, inCategoryIDSet, inConfigurable, inResourceSpec, inRedundancyCheck, inVersionedSaveContext, inPlatform, inResolveLinks, inIsAsync, inPluginID, inFromMSApp);
    }

    public StatusMonitor spawnCheckInJobOnMS_SM(ResourceTypeAndOptions inResourceTypeAndOptions, CategoryIDSet inCategoryIDSet, boolean inConfigurable, ResourceSpec inResourceSpec, RedundancyCheckMode inRedundancyCheckMode, VersionedSaveContext inVersionedSaveContext, HostSetID inPlatform, boolean inResolveLinks, boolean inIsAsync, PluginID inPluginID, boolean inFromMSApp) throws ResourceException, RPCException {
        if (this.mCheckInJobMgr == null) {
            throw new ResourceException("rsrc.msg0374");
        }
        UserID theUserID = this.getCurrentUserID();
        return this.mCheckInJobMgr.spawnCheckInJobOnMS(inResourceTypeAndOptions, inCategoryIDSet, inConfigurable, inResourceSpec, inRedundancyCheckMode, inVersionedSaveContext, inPlatform, theUserID, inResolveLinks, inIsAsync, inPluginID, inFromMSApp);
    }

    public ResourceID getResourceID(ResourceSpec inResourceSpec, VersionNumber inVersion, PushID inPushID) throws ResourceException, ResourceNotLocalException {
        Resource theResource = this.getResource(inResourceSpec, inVersion, inPushID);
        if (theResource == null) {
            Object[] theSubs = new Object[]{inResourceSpec, inVersion};
            throw new ResourceNotLocalException("rsrc.msg0042", theSubs);
        }
        return theResource.getResourceID();
    }

    public RsrcInfo getRsrcInfo(ResourceID inResourceID, PushID inPushID) throws ResourceException, ResourceNotLocalException {
        Resource theResource = this.mMetaDbase.get(inResourceID, inPushID);
        if (theResource == null) {
            throw new ResourceNotLocalException("rsrc.msg0043", new Object[]{inResourceID});
        }
        return new RsrcInfo(theResource);
    }

    public RsrcCheckoutInfo getCheckoutInfo(final ResourceID inResourceID) throws ResourceException, ResourceNotLocalException {
        return (RsrcCheckoutInfo)new ResourceAccessor(this, null){

            public Object innerAccess() throws ResourceException {
                RsrcManifest theManifest = this.getManifest(inResourceID, null);
                MetaMetaData theMetaMetaData = theManifest.getMetaMetaData(Key.sKey);
                boolean isSizeOk = theMetaMetaData.mDataSizeSansAnyMeta < sMaxDownloadableArchiveSize;
                boolean isFileCountOk = theMetaMetaData.mNumSubFiles < sMaxDownloadableFileCount;
                return new RsrcCheckoutInfo(this, isSizeOk, isFileCountOk){
                    final boolean mSizeOk;
                    final boolean mFileCountOk;
                    private final /* synthetic */ boolean val$isSizeOk;
                    private final /* synthetic */ boolean val$isFileCountOk;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$isSizeOk = val$isSizeOk;
                        this.val$isFileCountOk = val$isFileCountOk;
                        this.mSizeOk = this.val$isSizeOk;
                        this.mFileCountOk = this.val$isFileCountOk;
                    }

                    public boolean getDataSizeAllowsGuiCheckout() {
                        return this.mSizeOk;
                    }

                    public boolean getNumFilesAllowsGuiCheckout() {
                        return this.mFileCountOk;
                    }
                };
            }
        }.access();
    }

    public long forTestOnly_SetMaxDownloadableArchiveSize(long inNewMaxArchiveBytes) {
        long thePrevMax = sMaxDownloadableArchiveSize;
        sMaxDownloadableArchiveSize = inNewMaxArchiveBytes;
        return thePrevMax;
    }

    public long forTestOnly_SetMaxDownloadableFileCount(long inNewMaxFileCount) {
        long thePrevMax = sMaxDownloadableFileCount;
        sMaxDownloadableFileCount = inNewMaxFileCount;
        return thePrevMax;
    }

    public Resource getResource(ResourceID inResourceID, PushID inPushID) throws ResourcePersistenceException, ResourceNotLocalException {
        return this.mMetaDbase.get(inResourceID, inPushID);
    }

    public Resource getNextHighestVersion(ResourceSpec inResourceSpec, VersionNumber inVersionNumber) throws ResourceException {
        return this.mMetaDbase.getNextHighestVersion(inResourceSpec, inVersionNumber);
    }

    public Resource getNextLowestVersion(ResourceSpec inResourceSpec, VersionNumber inVersionNumber) throws ResourceException {
        return this.mMetaDbase.getNextLowestVersion(inResourceSpec, inVersionNumber);
    }

    public RsrcInfo getRsrcInfo(ResourceSpec inResourceSpec, VersionNumber inVersion, PushID inPushID) throws ResourcePersistenceException, ResourceNotLocalException {
        Resource theResource = this.mMetaDbase.get(inResourceSpec, inVersion, inPushID);
        if (theResource == null) {
            return null;
        }
        return new RsrcInfo(theResource);
    }

    public Resource getResource(ResourceSpec inResourceSpec, VersionNumber inVersion, PushID inPushID) throws ResourcePersistenceException, ResourceNotLocalException {
        return this.mMetaDbase.get(inResourceSpec, inVersion, inPushID);
    }

    public boolean isLocal(ResourceID inResourceID, PushID inPushID) throws ResourceException {
        Resource theResource;
        try {
            theResource = this.mMetaDbase.get(inResourceID, inPushID);
        }
        catch (ResourceNotLocalException e) {
            return false;
        }
        if (!theResource.dataExists(this)) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Resource is missing data: " + theResource, this);
            }
            return false;
        }
        return true;
    }

    public long forTestOnly_GetInternalResSize(ResourceID inResourceID, PushID inPushID) throws ResourceException {
        Resource theResource = this.mMetaDbase.get(inResourceID, inPushID);
        return theResource.getSize(this);
    }

    public File forTestOnly_GetInternalRepoFile(ResourceID inResourceID, PushID inPushID) throws ResourceException {
        Resource theResource = this.mMetaDbase.get(inResourceID, inPushID);
        return theResource.getInternalRepoFile(this);
    }

    public boolean forTestOnly_IsLocked(ResourceID inResourceID) {
        return this.mMetaDbase.getLockCount(inResourceID) != 0;
    }

    public void forTestOnly_ReinflateRepo() throws ResourceException {
        MetaDbase theTestMetaDbase = null;
        try {
            theTestMetaDbase = this.mIsServer ? new SQLMetaDbase(this, this.mApplication, this.mAbsRepoRoot) : new DiskMetaDbase(this, this.mApplication, this.mAbsRepoRoot);
            theTestMetaDbase.inflate();
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0044", (Throwable)e);
        }
        this.mMetaDbase.forTestOnly_verifyEquivalent(theTestMetaDbase);
    }

    public void forTestOnly_SetPushFailure(boolean inDoForceFailure, int inFailMode) {
        this.mDoForceFailure = inDoForceFailure;
        this.mForcedPushFailMode = inFailMode;
    }

    public void forTestOnly_VerifyPushesDisposed() throws ResourceException {
        if (this.mMetaDbase.getNumPushes() > 0) {
            throw new ResourceException("rsrc.msg0045");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pullServerEntryToLocalFile(ResourceID inResourceID, String inRelPath, File inLocalFile) throws ResourceException {
        FileOutputStream theOutStream;
        try {
            theOutStream = new FileOutputStream(inLocalFile);
        }
        catch (FileNotFoundException e) {
            throw new ResourceException("rsrc.msg0426", new Object[]{inLocalFile});
        }
        DataId theDataId = this.mFileMover.registerOutStream(theOutStream);
        boolean didSucceed = false;
        try {
            try {
                this.getMSRsrcMgr().sendResourceEntry(inResourceID, inRelPath, theDataId);
            }
            catch (RPCException e) {
                throw new ResourceException("rsrc.msg0427", (Throwable)e);
            }
            didSucceed = true;
            Object var9_9 = null;
            this.mFileMover.removeOutStream(theDataId);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.mFileMover.removeOutStream(theDataId);
            try {
                ((OutputStream)theOutStream).close();
                throw throwable;
            }
            catch (IOException e) {
                if (didSucceed) throw throwable;
                throw new ResourceException("rsrc.msg0428", (Throwable)e);
            }
        }
        try {
            ((OutputStream)theOutStream).close();
            return;
        }
        catch (IOException e) {
            if (didSucceed) return;
            throw new ResourceException("rsrc.msg0428", (Throwable)e);
        }
    }

    public void sendResourceEntry(final ResourceID inResourceID, final String inRelPath, final DataId inDataId) throws ResourceException {
        if (!this.mIsServer) {
            throw new ResourceException("rsrc.msg0429");
        }
        this.verifySendResourceEntryAllowed(inResourceID);
        new ResourceAccessor(this, null){

            public Object innerAccess() throws ResourceException {
                RsrcManifest theManifest = this.getManifest(inResourceID, null);
                InputStream theInputStream = theManifest.getInputStream(inRelPath);
                if (theInputStream == null) {
                    throw new ResourceException("rsrc.msg0430", new Object[]{inRelPath});
                }
                try {
                    ResourceSubsysImpl.this.mFileMover.pushDataId(theInputStream, inDataId, ResourceSubsysImpl.this.getInvokerAddress());
                }
                catch (FileTransferException e) {
                    throw new ResourceException(e);
                }
                return null;
            }
        }.access();
    }

    private void verifySendResourceEntryAllowed(ResourceID inResourceID) throws ResourceException {
        try {
            RoxAddress address = this.getInvokerAddress();
            AppInstance appInst = null;
            try {
                appInst = SingleAppInstanceQuery.byAddress(address, AppType.RA).select();
            }
            catch (NoResultsFoundException e) {
                throw new ResourceException("rsrc.REQUESTED_RESOURCE_NOT_ON_REQUESTING_RA");
            }
            HostID hostID = appInst.getHostID();
            MultiInstalledResourceQuery query = MultiInstalledResourceQuery.byResourceID(inResourceID);
            query.setHostFilter(hostID, TargetType.PHYSICAL);
            query.setInstalledFilter(null);
            if (!query.selectExists()) {
                throw new ResourceException("rsrc.REQUESTED_RESOURCE_NOT_ON_REQUESTING_RA");
            }
            boolean foundAddress = false;
            Vector runningDiffs = this.getApplication().getNotificationManager().queryRunningDiffs(Integer.MAX_VALUE);
            if (runningDiffs != null) {
                RunningDiffBean[] diffBeans = runningDiffs.toArray(new RunningDiffBean[0]);
                for (int i = 0; i < diffBeans.length; ++i) {
                    HostID dstID;
                    Host dst;
                    DifferenceSettings settings = diffBeans[i].getDifferenceSettings();
                    if (settings.getDiffStyle() != 1 || !(dst = (dstID = new HostID(settings.getDstHostID())).getByIDQuery().select()).getRARoxAddress().equals(address)) continue;
                    foundAddress = true;
                    break;
                }
            }
            if (!foundAddress) {
                throw new ResourceException("rsrc.NO_DIFF_JOB_ON_REQUESTING_RA");
            }
        }
        catch (RPCException e) {
            throw new ResourceException(e);
        }
        catch (PersistenceManagerException e) {
            throw new ResourceException(e);
        }
        catch (UnsupportedSubsystemException e) {
            throw new ResourceException(e);
        }
        catch (NotificationManagerException e) {
            throw new ResourceException(e);
        }
    }

    private RoxAddress getInvokerAddress() {
        return this.mApplication.getNetSubsystem().getRPC().getInvokerAddress();
    }

    void verifySendResourceInternallyFormattedAllowed(Resource inResource, PushID inPushID) throws ResourceException {
        ResourceSpec spec;
        RoxAddress address = this.getInvokerAddress();
        RsrcPushImpl pushImpl = this.getPush(inPushID);
        if (!pushImpl.includesNonVirtualResource(spec = inResource.getResourceSpec(), inResource.getVersionNumber())) {
            throw new ResourceException("rsrc.REQUESTED_RESOURCE_NOT_IN_PUSH");
        }
        if (!pushImpl.addrInPush(address)) {
            throw new ResourceException("rsrc.REQUESTING_HOST_NOT_IN_PUSH");
        }
    }

    public RsrcPushImpl getRsrcPushImpl(PushID inPushID) throws ResourceNotLocalException {
        if (this.mIsServer) {
            throw new IllegalStateException("getRsrcPush should not be called on an MS node");
        }
        if (inPushID == null) {
            throw new NullPointerException("getRsrcPush requires a non-null pushID");
        }
        RsrcPushImpl thePush = this.mMetaDbase.get(inPushID);
        if (thePush == null) {
            throw new ResourceNotLocalException("rsrc.msg0247", new Object[]{inPushID});
        }
        return thePush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalize(final ResourceID inResourceID, final PushID inPushID, DeployMode inDeployMode, AbsoluteFileSpec inDstLocation, NodePerms inGlobalOverridePerms) throws ResourceException, RPCException {
        HashMap hashMap;
        RsrcPushImpl thePush;
        if (inDeployMode == null) {
            throw new NullPointerException();
        }
        RsrcPushImpl rsrcPushImpl = thePush = inPushID == null ? null : this.getRsrcPushImpl(inPushID);
        if (thePush != null && thePush.getIsSimulated()) {
            throw new ResourceException("rsrc.msg0249");
        }
        if (inResourceID == null) {
            throw new NullPointerException("externalize() was handed a null ResourceID");
        }
        DeployLogger theDeployLogger = DeployLogger.makeActualDeployLogger();
        File theDstFile = inDstLocation.toFile();
        String theSuppressedPath = null;
        if (thePush != null && (theSuppressedPath = thePush.getDiffSuppressedPath(inResourceID)) != null) {
            String theDstPath = theDstFile.getAbsolutePath();
            theDstPath = ResourceStringUtils.toNativePath(theDstPath);
            while (ResourceStringUtils.endsInSeparator(theDstPath)) {
                theDstPath = theDstPath.substring(0, theDstPath.length() - 1);
            }
            theSuppressedPath = ResourceStringUtils.toNativePath(theSuppressedPath);
            while (ResourceStringUtils.endsInSeparator(theSuppressedPath)) {
                theSuppressedPath = theSuppressedPath.substring(0, theDstPath.length() - 1);
            }
            if (!theSuppressedPath.equals(theDstPath)) {
                throw new ResourceException("rsrc.msg0456", new Object[]{inResourceID, theDstPath, theSuppressedPath});
            }
        }
        if (inDstLocation == null) {
            throw new NullPointerException("externalize() was handed a null destination");
        }
        if (this.mAbsRepoRoot.containsPath(inDstLocation.getAbsDirPath())) {
            throw new ResourceException("rsrc.msg0052");
        }
        SynchCounter theDstSynchCounter = null;
        Object object = this.mExternOps;
        synchronized (object) {
            theDstSynchCounter = (SynchCounter)this.mExternOps.get(theDstFile);
            if (theDstSynchCounter == null) {
                theDstSynchCounter = new SynchCounter();
                this.mExternOps.put(theDstFile, theDstSynchCounter);
            }
            theDstSynchCounter.increment();
        }
        try {
            object = theDstSynchCounter;
            synchronized (object) {
                if (thePush != null) {
                    thePush.beforeResourceExtern(inResourceID, theDstFile);
                }
                if (theSuppressedPath == null) {
                    VersionMap theFwdDeletionMap = null;
                    if (thePush != null) {
                        theFwdDeletionMap = thePush.getFwdDeletionMap();
                    }
                    new ResourceAccessor(this, theFwdDeletionMap){

                        public Object innerAccess() throws ResourceException {
                            RsrcManifest theManifest = this.getManifest(inResourceID, inPushID);
                            ResourceSubsysImpl.this.mSnapshotOwnerTable.addRefs(theManifest);
                            return null;
                        }
                    }.access();
                    VersionNumber thePrevRsrcVers = null;
                    if (thePush != null) {
                        thePrevRsrcVers = thePush.getPreviousResourceVersion(inResourceID);
                    }
                    new FileSystemExternalizer(inResourceID, inPushID, this, inDeployMode, theDstFile, thePrevRsrcVers, theDeployLogger).parse();
                }
                if (thePush != null) {
                    this.bottomUpCallbacks(inResourceID, thePush, theDstFile, inGlobalOverridePerms, null);
                }
                if (thePush != null) {
                    thePush.afterResourceExtern(inResourceID, theDstFile);
                }
            }
            Object var16_16 = null;
            hashMap = this.mExternOps;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            HashMap hashMap2 = this.mExternOps;
            synchronized (hashMap2) {
                if (theDstSynchCounter.decrement() == 0) {
                    this.mExternOps.remove(theDstFile);
                }
            }
            throw throwable;
        }
        synchronized (hashMap) {
            if (theDstSynchCounter.decrement() == 0) {
                this.mExternOps.remove(theDstFile);
            }
        }
    }

    private void createEnclosingMemixDirs(ResourceID inResourceID, RsrcPushImpl inPush, SessionCommand inMemixSession, File inCurDir, File inBottomDir) throws ResourceException {
        if (inCurDir == null) {
            return;
        }
        boolean doesPathExist = ResourceMemixUtils.nodeExists(inMemixSession, inCurDir);
        if (doesPathExist) {
            if (!ResourceMemixUtils.isAccessibleDirectory(inMemixSession, inCurDir)) {
                throw new ResourceException("rsrc.msg0244", new Object[]{inCurDir});
            }
        } else {
            this.createEnclosingMemixDirs(inResourceID, inPush, inMemixSession, inCurDir.getAbsoluteFile().getParentFile(), inBottomDir);
            ResourceMemixUtils.ensureDirExists(inMemixSession, inCurDir);
            inPush.afterEnclosingDirCreations(inResourceID, inBottomDir, inCurDir);
        }
    }

    public void externalizeToMemix(ResourceID inResourceID, PushID inPushID, DeployMode inDeployMode, AbsoluteFileSpec inDstLocation, SessionCommand inSessionCommand, NodePerms inGlobalOverridePerms) throws ResourceException, RPCException {
        RsrcPushImpl thePush;
        if (inDeployMode == null) {
            throw new NullPointerException();
        }
        RsrcPushImpl rsrcPushImpl = thePush = inPushID == null ? null : this.getRsrcPushImpl(inPushID);
        if (inResourceID == null) {
            throw new NullPointerException("externalizeToMemix() was handed a null ResourceID");
        }
        if (inDstLocation == null) {
            throw new NullPointerException("externalizeToMemix() was handed a null destination");
        }
        File theDstFile = inDstLocation.toFile();
        if (this.mAbsRepoRoot.containsPath(inDstLocation.getAbsDirPath())) {
            throw new ResourceException("rsrc.msg0052");
        }
        try {
            if (thePush != null) {
                thePush.beforeResourceExtern(inResourceID, theDstFile);
            }
            if (thePush != null && thePush.getIsSimulated()) {
                if (inDeployMode.equals(DeployMode.REPLACE)) {
                    ResourceMemixUtils.removeDirOrFile(inSessionCommand, theDstFile);
                }
            } else {
                throw new ResourceException("rsrc.msg0306");
            }
            this.createEnclosingMemixDirs(inResourceID, thePush, inSessionCommand, theDstFile.getParentFile(), theDstFile);
            thePush.externalize(inResourceID, inSessionCommand, theDstFile);
            if (thePush != null) {
                this.bottomUpCallbacks(inResourceID, thePush, theDstFile, inGlobalOverridePerms, inSessionCommand);
                thePush.afterResourceExtern(inResourceID, theDstFile);
            }
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0171", (Throwable)e);
        }
    }

    private void bottomUpCallbacks(final ResourceID inResourceID, final RsrcPushImpl inPush, final File inDstFile, final NodePerms inGlobalOverridePerms, final SessionCommand inMemixSession) throws ResourceException {
        if (inPush == null) {
            return;
        }
        new ResourceAccessor(this, inPush.getFwdDeletionMap()){

            public Object innerAccess() throws ResourceException {
                RsrcManifest theManifest = this.getManifest(inResourceID, inPush.getPushID());
                inPush.afterResourceSubFileExternBottomUp(inResourceID, inDstFile, theManifest, inGlobalOverridePerms, inMemixSession);
                return null;
            }
        }.access();
    }

    public ResourceSubsysImpl(Application inApp, String inLocalRepoPath, ResourceSubsystem inResourceSubsystem, boolean inIsServer, long inMaxSegSize, int inMaxSegEntries, int inMaxCachedResourceSizes) throws ConfigurationException {
        block30: {
            this.mCallbackCallbackDispatcher = new CallbackDispatcher();
            this.mMetaDbase = null;
            this.mFileMover = null;
            this.mIsServer = false;
            this.mApplication = null;
            this.mCachedMSRsrcMgr = null;
            this.mAbsRepoRoot = null;
            this.mRandom = new Random((long)(Math.random() * 1000000.0));
            this.mPushDropReception = true;
            this.mPreparingForShutdown = false;
            this.mExternOps = new HashMap();
            this.mArbitrator = new StringArbitrator();
            this.mBootSignature = BootID.generateBootID();
            this.mMasterPushSequenceNumber = 0L;
            this.mDoForceFailure = false;
            this.mForcedPushFailMode = 0;
            this.mSnapshotContentsTable = null;
            this.mSnapshotOwnerTable = null;
            this.mMostRecentTimedSequence = null;
            this.mWaitingPushRcvThreads = new Hashtable();
            this.mGlobalContext = new Context("ResourceMgrContext");
            this.mApplication = inApp;
            this.mIsServer = inIsServer;
            this.mRepoSizeManager = new RepoSizeManager(inResourceSubsystem, inIsServer);
            MAX_SEG_SIZE = inMaxSegSize;
            MAX_SEG_ENTRIES = inMaxSegEntries;
            Resource.setMaxCachedSizes(inMaxCachedResourceSizes);
            File theRepoRootFile = new File(inLocalRepoPath);
            this.mAbsRepoRootString = theRepoRootFile.getAbsolutePath() + File.separator + RSRC_MGR + File.separator;
            this.mAbsRepoRoot = new DirPath(this.mAbsRepoRootString);
            if (Logger.isInfoEnabled(this)) {
                Logger.info("RepoRoot is (" + (this.mIsServer ? "server) " : "non-server) ") + this.mAbsRepoRoot.toString(), this);
                try {
                    long theNumBytesFree = ResourceFileUtils.getBytesFreeOnVolume(theRepoRootFile);
                    if (theNumBytesFree > 1000000L) {
                        long theTenthsOfMFree = theNumBytesFree / 100000L;
                        double theMFree = (double)theTenthsOfMFree / 10.0;
                        Logger.info("Megabytes free on volume: " + theMFree, this);
                    } else {
                        Logger.info("Bytes free on volume: " + theNumBytesFree, this);
                    }
                }
                catch (ResourceException e) {
                    if (!Logger.isErrorEnabled(this)) break block30;
                    Logger.error("Unable to calculate bytes free", e, this);
                }
            }
        }
        try {
            this.resetData();
            this.mAbsRepoRoot.mkdirs();
        }
        catch (Exception e) {
            Object[] theSubs = new Object[]{this.mAbsRepoRoot};
            throw new ConfigurationException("rsrc.msg0067", (Throwable)e, theSubs);
        }
        try {
            this.mMetaDbase = this.mIsServer ? new SQLMetaDbase(this, this.mApplication, this.mAbsRepoRoot) : new DiskMetaDbase(this, this.mApplication, this.mAbsRepoRoot);
            this.mMetaDbase.inflate();
        }
        catch (Exception e) {
            throw new ConfigurationException("rsrc.msg0069", (Throwable)e);
        }
        try {
            this.mFileMover = new FileMover(23, this.mApplication);
        }
        catch (ResourceException e) {
            throw new ConfigurationException("rsrc.msg0164", (Throwable)e);
        }
        catch (RPCException e) {
            throw new ConfigurationException("rsrc.msg0165", (Throwable)e);
        }
        this.mCheckInInterface = new CheckInInterface(this.mFileMover, this.mApplication.getNetSubsystem()){

            public RemoteResourceMgr getMSRsrcMgr() throws ResourceException {
                if (ResourceSubsysImpl.this.mCachedMSRsrcMgr == null) {
                    ResourceSubsysImpl.this.mCachedMSRsrcMgr = ResourceSubsysImpl.this.getRemoteResourceMgr(ResourceSubsysImpl.this.getMSAddress());
                }
                return ResourceSubsysImpl.this.mCachedMSRsrcMgr;
            }
        };
        try {
            String theSnapshotContentsDir = RsrcDirLayout.getSnapshotContentsDir(this).toString();
            this.mSnapshotContentsTable = new SnapshotContentsTable(this, new File(theSnapshotContentsDir));
        }
        catch (CaptureException e) {
            throw new ConfigurationException("rsrc.msg0320", (Throwable)e);
        }
        try {
            String theSnapshotOwnerDir = RsrcDirLayout.getSnapshotOwnerDir(this).toString();
            this.mSnapshotOwnerTable = new SnapshotOwnerTable(this, new File(theSnapshotOwnerDir));
        }
        catch (CaptureException e) {
            throw new ConfigurationException("rsrc.msg0321", (Throwable)e);
        }
        File thePlaceholderDir = new File(RsrcDirLayout.getPlaceholderDir(this).toString());
        try {
            ResourceFileUtils.deleteDirectory(thePlaceholderDir);
        }
        catch (ResourceException e) {
            throw new ConfigurationException("Unable to delete directory " + thePlaceholderDir, (Throwable)e);
        }
        File theNodePermsDir = RsrcDirLayout.getNodePermsDir(this).getAbsoluteFile();
        try {
            ResourceFileUtils.deleteDirectory(theNodePermsDir);
        }
        catch (ResourceException e) {
            throw new ConfigurationException("Unable to delete directory " + theNodePermsDir, (Throwable)e);
        }
        theNodePermsDir.mkdir();
        try {
            File theTmpFile = File.createTempFile("DefAttrsFile_", null, theNodePermsDir);
            try {
                this.mDefaultNodePerms = PlatformPermissionFactory.getInstance().createNodePerms(theTmpFile, PlatformPermissionFactory.getInstance().getDefaultOptions());
            }
            catch (ResourceException e) {
                throw new ConfigurationException("rsrc.msg0346", (Throwable)e);
            }
            finally {
                theTmpFile.delete();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
        if (this.mIsServer) {
            try {
                this.mCheckInJobMgr = new CheckInJobMgr(this);
            }
            catch (ResourceException e) {
                throw new ConfigurationException(e);
            }
        }
    }

    private void resetData() throws IOException {
        if (this.mIsServer && PersistenceManager.getInstance().isResettingData()) {
            FileUtil.ensureDeleted(this.mAbsRepoRoot.toLocal());
        }
    }

    public NodePerms createDefaultNodePerms() {
        return this.mDefaultNodePerms == null ? null : this.mDefaultNodePerms.duplicate();
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public boolean isServer() {
        return this.mIsServer;
    }

    public RsrcInfo checkForMostRecentVersion(ResourceSpec inResourceSpec) throws ResourcePersistenceException {
        Resource theMostRecentResource = this.mMetaDbase.getMostRecentVersionOnMS(inResourceSpec);
        if (theMostRecentResource == null) {
            return null;
        }
        return new RsrcInfo(theMostRecentResource);
    }

    RsrcInfo getMostRecentRsrcInfo(ResourceSpec inResourceSpec) throws ResourcePersistenceException, ResourceNotLocalException {
        Resource theMostRecentResource = this.mMetaDbase.getMostRecentVersionOnMS(inResourceSpec);
        if (theMostRecentResource == null) {
            Object[] theSubs = new Object[]{inResourceSpec};
            throw new ResourceNotLocalException("rsrc.msg0073", theSubs);
        }
        return new RsrcInfo(theMostRecentResource);
    }

    public void registerRPCInterfaces(RPCManager inRPCManager) throws RPCException {
        inRPCManager.registerService(RemoteResourceMgr.class, this);
        inRPCManager.registerService(ResourceMgrUpstreamServices.class, this);
        inRPCManager.registerService(RemoteCheckInInterface.class, this.mCheckInInterface);
        inRPCManager.registerService(CallbackDispatcherInterface.class, this.mCallbackCallbackDispatcher);
    }

    public RemoteCheckInInterface getRemoteCheckInInterface(RoxAddress inRemoteAddress) throws ResourceException {
        return this.getCheckInInterface(inRemoteAddress, false);
    }

    public RemoteCheckInInterface getLocalProxyCheckInInterface(RoxAddress inRemoteAddress) throws ResourceException {
        return this.getCheckInInterface(inRemoteAddress, true);
    }

    private RemoteCheckInInterface getCheckInInterface(RoxAddress inRemoteAddress, boolean inGetAsLocalProxy) throws ResourceException {
        RemoteCheckInInterface theRemoteCheckInInterface = null;
        try {
            theRemoteCheckInInterface = inGetAsLocalProxy ? (RemoteCheckInInterface)this.mApplication.getLocalProxiedService(inRemoteAddress, RemoteCheckInInterface.class) : (RemoteCheckInInterface)this.mApplication.getRPCInterface(inRemoteAddress, RemoteCheckInInterface.class);
            return theRemoteCheckInInterface;
        }
        catch (ServiceUnavailableException e) {
            try {
                theRemoteCheckInInterface = inGetAsLocalProxy ? (RemoteCheckInInterface)this.mApplication.getLocalProxiedService(inRemoteAddress, CLIRemoteCheckInInterface.class) : (RemoteCheckInInterface)this.mApplication.getRPCInterface(inRemoteAddress, CLIRemoteCheckInInterface.class);
            }
            catch (Exception ex) {
                throw new ResourceException("rsrc.msg0375", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0375", (Throwable)e);
        }
        return theRemoteCheckInInterface;
    }

    public RemoteResourceMgr getRemoteResourceMgr(RoxAddress inRemoteAddress) throws ResourceException {
        RemoteResourceMgr theRemoteRsrcMgr = null;
        try {
            theRemoteRsrcMgr = (RemoteResourceMgr)this.mApplication.getRPCInterface(inRemoteAddress, RemoteResourceMgr.class);
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0074", (Throwable)e);
        }
        return theRemoteRsrcMgr;
    }

    private ResourceMgrUpstreamServices getResourceMgrUpstreamServices(RoxAddress inRemoteAddress) throws ResourceException {
        try {
            return (ResourceMgrUpstreamServices)this.mApplication.getRPCInterface(inRemoteAddress, ResourceMgrUpstreamServices.class);
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0074", (Throwable)e);
        }
    }

    public void receiveStatusUpdate(PushID inPushID, RoxAddress inAddress, int inStatus, ResourceException inResourceException) throws ResourceException, RPCException {
        RsrcPushImpl thePush = this.mMetaDbase.get(inPushID);
        if (thePush == null) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("assuming we tossed push " + inPushID, this);
            }
            return;
        }
        thePush.queueStatusUpdate(inAddress, inStatus, inResourceException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RsrcInfo finalizeCheckIn(final File inTmpRsrcDir, final ResourceTypeAndOptions inResourceTypeAndOptions, final boolean inConfigurable, final ResourceSpec inResourceSpec, final VersionedSaveContext inVersionedSaveContext, final HostSetID inPlatform, final CategoryIDSet inCategoryIDSet, final PluginID inPluginID, final long inTotalRsrcSize) throws ResourceException {
        void var12_12;
        block16: {
            PersistenceManager thePMSubsystem;
            if (!this.mIsServer) {
                throw new ResourceException("rsrc.msg0075");
            }
            try {
                thePMSubsystem = this.mApplication.getPMSubsystem();
            }
            catch (UnsupportedSubsystemException e) {
                throw new ResourceException(e);
            }
            RepoSizeManager repoSizeManager = this.mRepoSizeManager;
            synchronized (repoSizeManager) {
                if (!this.mRepoSizeManager.verifySpaceAvailable(inTotalRsrcSize)) {
                    throw new ResourceException("rsrc.msg0076");
                }
                boolean didSucceed = false;
                try {
                    Object[] theResourceAndDir = (Object[])thePMSubsystem.getTransactionManager().transact(new Transaction(){

                        public Object execute() throws ClassMapException, SQLException, PersistenceManagerException, QueryException {
                            Resource theInnerResource = null;
                            File theFinalTargetDir = null;
                            try {
                                theInnerResource = ResourceSubsysImpl.this.mMetaDbase.grabVersion(inResourceSpec, inTotalRsrcSize, inResourceTypeAndOptions.getResourceType(), inResourceTypeAndOptions.getHostID(), inResourceTypeAndOptions.getAbstractPath(), inConfigurable, inResourceTypeAndOptions.getTypeIsHierarchical(), inResourceTypeAndOptions.getTypeHasPermissions(), inPlatform, inVersionedSaveContext, inCategoryIDSet, inPluginID);
                                theFinalTargetDir = theInnerResource.getInternalRepoFile(ResourceSubsysImpl.this);
                                ResourceFileUtils.moveData(inTmpRsrcDir, theFinalTargetDir);
                                if (PersistenceManager.getInstance().isResettingData()) {
                                    RsrcManifest.tagRsrcFolderAsSys(theFinalTargetDir, theInnerResource.toString());
                                }
                            }
                            catch (ResourceException e) {
                                if (theFinalTargetDir != null) {
                                    ResourceFileUtils.deleteDirectorySnuff(theFinalTargetDir);
                                }
                                throw new PersistenceManagerException(e);
                            }
                            return new Object[]{theInnerResource, theFinalTargetDir};
                        }
                    });
                    didSucceed = true;
                }
                catch (PersistenceManagerException e) {
                    throw new ResourceException("rsrc.msg0481", (Throwable)e, new Object[]{inResourceSpec});
                }
                finally {
                    if (!didSucceed) {
                        ResourceFileUtils.deleteDirectorySnuff(inTmpRsrcDir);
                    }
                }
            }
            CheckinRollback theCheckinRollback = new CheckinRollback((File)var12_12[1], inTotalRsrcSize);
            try {
                PersistenceManager.getInstance().getTransactionManager().registerTopLevelTransactionListener(theCheckinRollback);
            }
            catch (PersistenceManagerException e) {
                if ("pm.qe.NO_TRANSACTION".equals(e.getROXMessage().getKey())) break block16;
                throw new ResourceException(e);
            }
        }
        return new RsrcInfo((Resource)var12_12[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendPush(final PushParams inPushParams, final RouteTree inRouteTree, TimedSequence inTimedSequence) throws ResourceException, RPCException {
        if (this.mPreparingForShutdown) {
            throw new ResourceException("rsrc.msg0191");
        }
        RoxAddress theTargetAddress = inRouteTree.getRootAddress();
        final ResourceMgrUpstreamServices theRemoteEnd = this.getResourceMgrUpstreamServices(theTargetAddress);
        PushID[] theCurPushes = null;
        MetaDbase metaDbase = this.mMetaDbase;
        synchronized (metaDbase) {
            theCurPushes = this.getCurrentPushesOnNode(theTargetAddress);
            if (this.mIsServer) {
                inTimedSequence = new TimedSequence(this.mBootSignature, this.mMasterPushSequenceNumber++);
            }
        }
        final TimedSequence theFinalTS = inTimedSequence;
        final PushID[] theFinalCurPushes = theCurPushes;
        Integer theResult = (Integer)new CallbackClosure(this.mCallbackCallbackDispatcher, theTargetAddress, this.mApplication.getNetSubsystem().getRPC()){
            private int mResult;

            public String getKey() {
                return inPushParams.mPushID.toString();
            }

            public Object run() throws Exception {
                int theResult = theRemoteEnd.receivePush(inPushParams, inRouteTree, theFinalTS, theFinalCurPushes, this.getKey());
                if (theResult == 1) {
                    this.waitForCallbacks();
                    theResult = this.mResult;
                }
                return new Integer(theResult);
            }

            public void callback(CallbackClosure.CBParm inCBObj, RoxAddress inInvokerAddress) throws Exception {
                if (!(inCBObj instanceof PushCallbackRec)) {
                    MiscUtils.throwUPE(5072141L);
                }
                PushCallbackRec theReq = (PushCallbackRec)inCBObj;
                if (theReq.mIsFinal) {
                    if (theReq.mException != null) {
                        throw new ResourceException("rsrc.ERROR_FROM_DOWNSTREAM_SIDE", (Throwable)theReq.mException, new Object[]{inInvokerAddress});
                    }
                    this.mResult = theReq.mFinalResult;
                    this.markAsDone();
                } else {
                    this.asyncSendResource(theReq.mResourceID, theReq.mSendVirtual, inInvokerAddress, theReq.mStreamRcvId);
                }
            }

            private void asyncSendResource(ResourceID inResourceID, boolean inSendVirtual, RoxAddress inInvokerAddress, DataId inStreamRcvID) throws ResourceException {
                File theRsrcDir;
                MultiSendPipe theSendPipe = new MultiSendPipe("SingleResourceSender " + inResourceID, ResourceSubsysImpl.this.getFileMover(), inInvokerAddress, inStreamRcvID);
                if (ResourceSubsysImpl.this.mIsServer || !inSendVirtual) {
                    theRsrcDir = Resource.getInternalRepoFile(inResourceID, ResourceSubsysImpl.this);
                } else {
                    RsrcPushImpl thePushImpl = ResourceSubsysImpl.this.getPush(inPushParams.mPushID);
                    theRsrcDir = thePushImpl.getVirtualRsrcDir(inResourceID);
                }
                File theFinalRsrcDir = theRsrcDir;
                String theRootPathWTrailingSeparator = this.formatRootPath(theFinalRsrcDir.getAbsolutePath());
                new SafeThread(this, theRootPathWTrailingSeparator, inSendVirtual, theSendPipe, inResourceID){
                    private final /* synthetic */ String val$theRootPathWTrailingSeparator;
                    private final /* synthetic */ boolean val$inSendVirtual;
                    private final /* synthetic */ MultiSendPipe val$theSendPipe;
                    private final /* synthetic */ ResourceID val$inResourceID;
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$theRootPathWTrailingSeparator = val$theRootPathWTrailingSeparator;
                        this.val$inSendVirtual = val$inSendVirtual;
                        this.val$theSendPipe = val$theSendPipe;
                        this.val$inResourceID = val$inResourceID;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    public void run() {
                        block13: {
                            File theMetaDataDir = new File(RsrcManifest.getSegMetaDataDirString(Key.sKey, this.val$theRootPathWTrailingSeparator));
                            this.sendFilesInDir(theMetaDataDir);
                            if (!this.val$inSendVirtual) {
                                File theDataDir = new File(RsrcManifest.getSegDataDirString(Key.sKey, this.val$theRootPathWTrailingSeparator));
                                this.sendFilesInDir(theDataDir);
                            }
                            this.sendOneFile(RsrcManifest.getMetaMetaDataLoc(Key.sKey, this.val$theRootPathWTrailingSeparator));
                            this.val$theSendPipe.finish();
                            Object var4_5 = null;
                            try {
                                this.val$theSendPipe.close();
                            }
                            catch (ResourceException e2) {
                                if (Logger.isErrorEnabled(this)) {
                                    Logger.error("Unable to close SendPipe for resource " + this.val$inResourceID, this);
                                }
                                break block13;
                            }
                            {
                                catch (ResourceException e) {
                                    block14: {
                                        try {
                                            this.val$theSendPipe.finishErr(e);
                                        }
                                        catch (ResourceException e1) {
                                            if (!Logger.isErrorEnabled(this)) break block14;
                                            Logger.error("Error from finishErr for resource " + this.val$inResourceID, this);
                                        }
                                    }
                                    Object var4_6 = null;
                                    try {
                                        this.val$theSendPipe.close();
                                    }
                                    catch (ResourceException e2) {
                                        if (Logger.isErrorEnabled(this)) {
                                            Logger.error("Unable to close SendPipe for resource " + this.val$inResourceID, this);
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                block15: {
                                    Object var4_7 = null;
                                    try {
                                        this.val$theSendPipe.close();
                                    }
                                    catch (ResourceException e2) {
                                        if (!Logger.isErrorEnabled(this)) break block15;
                                        Logger.error("Unable to close SendPipe for resource " + this.val$inResourceID, this);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }

                    private void sendFilesInDir(File inDir) throws ResourceException {
                        File[] theSubfiles = inDir.listFiles();
                        if (theSubfiles == null) {
                            return;
                        }
                        for (int i = 0; i < theSubfiles.length; ++i) {
                            this.sendOneFile(theSubfiles[i]);
                        }
                    }

                    private void sendOneFile(File inFile) throws ResourceException {
                        String theFullPath = inFile.getAbsolutePath().replace('\\', '/');
                        if (!theFullPath.startsWith(this.val$theRootPathWTrailingSeparator)) {
                            MiscUtils.throwUPE(5072142L);
                        }
                        String theRelPath = theFullPath.substring(this.val$theRootPathWTrailingSeparator.length());
                        this.val$theSendPipe.addObject((Serializable)((Object)theRelPath));
                        Semaphore theSempahore = new Semaphore();
                        FileInputStream theInputStream = null;
                        try {
                            theInputStream = new FileInputStream(this, inFile, theSempahore){
                                private final /* synthetic */ Semaphore val$theSempahore;
                                private final /* synthetic */ 12 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$theSempahore = val$theSempahore;
                                    super(x0);
                                }

                                public void close() throws IOException {
                                    super.close();
                                    this.val$theSempahore.V();
                                }
                            };
                        }
                        catch (FileNotFoundException e) {
                            throw new ResourceException(e);
                        }
                        this.val$theSendPipe.addStream(theInputStream, inFile.length());
                        try {
                            theSempahore.P();
                        }
                        catch (InterruptedException e) {
                            throw new ResourceException(e);
                        }
                    }
                }.start();
            }

            private String formatRootPath(String inRootPath) {
                String theResult = ResourceStringUtils.coerceSeparators(inRootPath, '/');
                if (!theResult.endsWith("/")) {
                    theResult = theResult + "/";
                }
                return theResult;
            }
        }.start();
        return theResult;
    }

    void sendPushRelease(PushID inPushID, RoxAddress inTargetAddress) throws ResourceException, RPCException {
        ResourceMgrUpstreamServices theRemoteEnd = this.getResourceMgrUpstreamServices(inTargetAddress);
        theRemoteEnd.receivePushRelease(inPushID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void syncToPushIDs(PushID[] inCurrentPushes, TimedSequence inTimedSequence) throws ResourceTransportException, ResourceException {
        if (!inTimedSequence.isGoodForSynch(this.mMostRecentTimedSequence)) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("syncToPushIDs - ignoring push synchronization", this);
            }
            return;
        }
        this.mMostRecentTimedSequence = inTimedSequence;
        if (this.mMetaDbase.getNumPushes() != 0) {
            HashMap<PushID, PushID> theLivePushesHash = new HashMap<PushID, PushID>();
            if (inCurrentPushes != null) {
                for (int i = 0; i < inCurrentPushes.length; ++i) {
                    PushID thePushID = inCurrentPushes[i];
                    theLivePushesHash.put(thePushID, thePushID);
                }
            }
            MetaDbase metaDbase = this.mMetaDbase;
            synchronized (metaDbase) {
                Vector theLocalPushes = this.mMetaDbase.getAllPushes();
                int theLocalPushIdx = theLocalPushes.size();
                while (theLocalPushIdx > 0) {
                    PushID theLocalPushID;
                    if (theLivePushesHash.get(theLocalPushID = ((RsrcPush)theLocalPushes.get(--theLocalPushIdx)).getPushID()) != null) continue;
                    RsrcPushImpl thePush = this.mMetaDbase.get(theLocalPushID);
                    thePush.dispose();
                    if (!Logger.isInfoEnabled(this)) continue;
                    Logger.info("Dropping push: " + theLocalPushID, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receivePush(PushParams inPushParams, RouteTree inRouteTree, TimedSequence inTimedSequence, PushID[] inCurrentPushes, String inClosureKey) throws ResourceException, RPCException {
        this.syncToPushIDs(inCurrentPushes, inTimedSequence);
        if (this.checkForExistingPush(inPushParams.mPushID)) {
            return 2;
        }
        long theRepoSpaceNeeded = 0L;
        PushParams.OneRsrcsIter theIter = inPushParams.getOneRsrcsIter();
        while (theIter.hasNext()) {
            final PushParams.OneRsrc theOneRsrc = theIter.next();
            if (theOneRsrc.isActualDuringActualPush()) {
                Boolean needToPull = (Boolean)this.mArbitrator.execute(theOneRsrc.mResource.getResourceID().toString(), new Executable(){

                    public Object execute() throws ResourceException {
                        if (ResourceSubsysImpl.this.attemptLocalRsrcLock(theOneRsrc.mResource, theOneRsrc.mFullSize, theOneRsrc.mPackingTime)) {
                            ResourceSubsysImpl.this.unlockResource(theOneRsrc.mResource);
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                });
                if (!needToPull.booleanValue()) continue;
                theRepoSpaceNeeded += theOneRsrc.mFullSize;
                continue;
            }
            theRepoSpaceNeeded += theOneRsrc.mMetaDataOnlySize;
        }
        if (!this.mRepoSizeManager.verifySpaceAvailable(theRepoSpaceNeeded)) {
            return -3;
        }
        PushRcvThread thePushRcvThread = new PushRcvThread(inPushParams, inRouteTree, this.getInvokerAddress(), inClosureKey, inTimedSequence);
        Hashtable hashtable = this.mWaitingPushRcvThreads;
        synchronized (hashtable) {
            this.mWaitingPushRcvThreads.put(inPushParams.mPushID, thePushRcvThread);
        }
        thePushRcvThread.start();
        return 1;
    }

    private boolean checkForExistingPush(PushID inPushID) throws ResourceException {
        RsrcPushImpl thePrevPushRepeater = this.mMetaDbase.get(inPushID);
        if (thePrevPushRepeater == null) {
            return false;
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info("We already have this push, so not re-pulling: " + inPushID, this);
        }
        boolean isActive = false;
        try {
            isActive = thePrevPushRepeater.isActive();
        }
        catch (ResourcePushFinishedWithErrorsException e) {
            isActive = false;
        }
        if (!isActive) {
            try {
                thePrevPushRepeater.activate(false);
            }
            catch (ResourcePushFinishedWithErrorsException e) {
                throw new ResourceException("rsrc.msg0207", (Throwable)e);
            }
        }
        return true;
    }

    boolean sendStatusToParent(RoxAddress inPushParentAddrress, PushID inPushID, RoxAddress inAddressForStatus, int inNodePushStatus, ResourceException inException) {
        if (inPushParentAddrress != null) {
            try {
                RemoteResourceMgr theParentRemoteRsrcMgr = (RemoteResourceMgr)this.getApplication().getRPCInterface(inPushParentAddrress, RemoteResourceMgr.class);
                theParentRemoteRsrcMgr.receiveStatusUpdate(inPushID, inAddressForStatus, inNodePushStatus, inException);
            }
            catch (Throwable t) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(ROXMessageManager.messageAsString("rsrc.PARENT_UPDATE_FAILED", new Object[]{inAddressForStatus}), t, this);
                }
                return false;
            }
        }
        return true;
    }

    private boolean attemptLocalRsrcLock(Resource inResource, long inMSResourceSize, long inMSPackingTime) throws ResourceException {
        boolean isLocal = false;
        try {
            this.mMetaDbase.lockResource(inResource, true);
            isLocal = true;
        }
        catch (ResourceNotLocalException e) {
            isLocal = false;
        }
        if (isLocal) {
            VersionedPersistentObject thePrevRsrc = null;
            try {
                thePrevRsrc = this.mMetaDbase.get(inResource.getResourceSpec(), inResource.getVersionNumber(), null);
            }
            catch (ResourceNotLocalException e) {
                // empty catch block
            }
            if (thePrevRsrc != null && !thePrevRsrc.getObjectID().equals(inResource.getObjectID())) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Detected resource ID change for " + inResource.toString() + " :  MS ID=" + inResource.getResourceID() + " , local ID=" + ((Resource)thePrevRsrc).getResourceID() + "; flushing local copy", this);
                }
                this.mMetaDbase.unlockResource(inResource);
                this.removeResource((Resource)thePrevRsrc);
                this.removeResource(inResource);
                isLocal = false;
            }
            if (isLocal) {
                File theRsrcFile = inResource.toFile(this);
                boolean doesExist = theRsrcFile.exists();
                long theInternalLength = inResource.getSize(this);
                long theInternalPackingTime = inResource.getPackingTime(this);
                if (theInternalLength != inMSResourceSize || theInternalPackingTime != inMSPackingTime) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Detected " + (theInternalLength != inMSResourceSize ? "resource size" : "packing time") + " mismatch for " + inResource.toString() + "   MS size=" + inMSResourceSize + " , local size=" + theInternalLength + "   MS packing time=" + inMSPackingTime + " , local packing time=" + theInternalPackingTime + ", " + theRsrcFile + " does " + (doesExist ? "" : "NOT ") + "exist" + "; flushing local copy", this);
                    }
                    this.mMetaDbase.unlockResource(inResource);
                    this.removeResource(inResource);
                    isLocal = false;
                }
            }
        }
        return isLocal;
    }

    public void receivePushRelease(PushID inPushID) throws ResourceException, RPCException {
        if (!this.mPushDropReception) {
            return;
        }
        if (inPushID != null) {
            RsrcPushImpl thePushImpl = this.mMetaDbase.get(inPushID);
            if (thePushImpl != null) {
                thePushImpl.dispose();
            } else if (Logger.isInfoEnabled(this)) {
                Logger.info("We were asked to drop a push we don't know about: " + inPushID, this);
            }
        }
    }

    private void unlockRsrcGroup(Resource[] inResources) throws ResourceException {
        Throwable theThrowable = null;
        for (int i = 0; i < inResources.length; ++i) {
            Resource theResource = inResources[i];
            try {
                this.mMetaDbase.unlockResource(theResource);
                continue;
            }
            catch (Throwable t) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Error unlocking resource " + theResource, t, this);
                }
                if (theThrowable != null) continue;
                theThrowable = t;
            }
        }
        if (theThrowable != null) {
            MiscUtils.resourceThrow(theThrowable);
        }
    }

    public void lockResource(Resource inResource, PushID inPushID, boolean inHonorDeleteLockMutex) throws ResourceException {
        this.mMetaDbase.lockResource(inResource, inHonorDeleteLockMutex);
    }

    public void unlockResource(Resource inResource) throws ResourceException {
        this.mMetaDbase.unlockResource(inResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long removeResource(Resource inResource) throws ResourceException {
        MetaDbase metaDbase = this.mMetaDbase;
        synchronized (metaDbase) {
            RepoSizeManager repoSizeManager = this.mRepoSizeManager;
            synchronized (repoSizeManager) {
                long theNumBytes = 0L;
                File theFile = inResource.toFile(this);
                if (theFile.exists()) {
                    theNumBytes = inResource.getSize(this);
                    ResourceFileUtils.deleteDirectory(theFile);
                    this.mRepoSizeManager.informNonMSSizeChange(-theNumBytes);
                }
                this.mMetaDbase.remove(inResource);
                Resource.resetCachedSize(inResource.getResourceID(), this);
                return theNumBytes;
            }
        }
    }

    public ResourceID forTestOnly_CreateRandomResource(ResourceSpec inSpec, String inType, boolean inConfigurable, boolean inHasPermissions) throws ResourceException, IOException {
        ResourceSpec theResourceSpec = inSpec;
        if (theResourceSpec == null) {
            int theRandStringLen = 8;
            String theFileName = ResourceRandomUtils.createRandomString(this.mRandom, theRandStringLen) + File.separator + ResourceRandomUtils.createRandomString(this.mRandom, theRandStringLen) + File.separator + ResourceRandomUtils.createRandomString(this.mRandom, theRandStringLen);
            theResourceSpec = new ResourceSpec(theFileName);
        }
        PermOptions thePermOptions = inHasPermissions ? new PosixPermOptions(true, true) : PermOptions.makeSuppress();
        File theTmpFile = File.createTempFile("tmp_", null);
        File theTmpCompressedFile = File.createTempFile("tmp_", null);
        byte[] theCompressedMd5 = MiscUtils.compressAndGetMD5(theTmpFile, theTmpCompressedFile);
        NodePerms theNodePerms = PlatformPermissionFactory.getInstance().createNodePerms(theTmpFile, thePermOptions);
        RsrcPacker theRsrcPacker = new RsrcPacker(null, ResourceRandomUtils.createRandomString(this.mRandom, 8));
        theRsrcPacker.packEntryCluster("root", theTmpFile.length(), theTmpCompressedFile.length(), theTmpFile.lastModified(), SubnodeType.FILE, theNodePerms, null, theCompressedMd5, true, (VersionNumber)null);
        theRsrcPacker.packThenCloseDataStream(new FileInputStream(theTmpCompressedFile), theTmpCompressedFile.length());
        long theFinalTotalRsrcSize = theRsrcPacker.finish();
        theTmpFile.delete();
        theTmpCompressedFile.delete();
        ResourceTypeAndOptions theResourceTypeAndOptions = ResourceTypeAndOptions.makeCheckIn(inType, new File(ResourceRandomUtils.createRandomString(this.mRandom, 8)), null, thePermOptions, CheckInMode.REPLACE);
        return this.finalizeCheckIn(theRsrcPacker.getWorkspaceDir(), theResourceTypeAndOptions, inConfigurable, theResourceSpec, null, null, null, null, theFinalTotalRsrcSize).getResourceID();
    }

    Object getRepoContentSyncObj() {
        return this.mRepoSizeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustTotalRepoSize(long inBytes) {
        RepoSizeManager repoSizeManager = this.mRepoSizeManager;
        synchronized (repoSizeManager) {
            this.mRepoSizeManager.informNonMSSizeChange(inBytes);
            if (this.mRepoSizeManager.getNonMSTotalRepoSize() < 0L && Logger.isWarnEnabled(this)) {
                Logger.warn("Repo size is negative: " + this.mRepoSizeManager.getNonMSTotalRepoSize(), this);
            }
        }
    }

    public RsrcInfo serverGetRsrcInfo(ResourceID inResourceID) throws ResourceException, RPCException {
        if (this.mIsServer) {
            return this.getRsrcInfo(inResourceID, null);
        }
        return this.getMSRsrcMgr().serverGetRsrcInfo(inResourceID);
    }

    static /* synthetic */ void access$1600(ResourceSubsysImpl x0, Resource[] x1) throws ResourceException {
        x0.unlockRsrcGroup(x1);
    }

    static {
        sPushIDTypeDummy = new PushID[0];
        sMaxDownloadableArchiveSize = 2040109000L;
        sMaxDownloadableFileCount = 65535L;
    }

    class PushRcvThread
    extends SafeThread {
        private PushParams mPushParams;
        private RouteTree mRouteTree;
        private volatile boolean mHalted = false;
        private String mClosureKey;
        private TimedSequence mTimedSequence;
        private Vector mLockedResources = new Vector();
        private RoxAddress mSrcAddress;
        private CallbackDispatcherInterface mRemoteCBDispatch;
        private String mNextRelPath = null;
        private Object mPipeSyncObj = new Object();
        private MultiReceivePipe mCurRsrcRcvPipe = null;
        private File mCurRsrcDir = null;

        PushRcvThread(PushParams inPushParams, RouteTree inRouteTree, RoxAddress inSrcAddress, String inClosureKey, TimedSequence inTimedSequence) throws ResourceException {
            this.mPushParams = inPushParams;
            this.mRouteTree = inRouteTree;
            this.mClosureKey = inClosureKey;
            this.mSrcAddress = inSrcAddress;
            this.mTimedSequence = inTimedSequence;
            try {
                this.mRemoteCBDispatch = (CallbackDispatcherInterface)ResourceSubsysImpl.this.mApplication.getRPCInterface(inSrcAddress, class$com$raplix$rolloutexpress$resource$util$CallbackDispatcherInterface == null ? (class$com$raplix$rolloutexpress$resource$util$CallbackDispatcherInterface = ResourceSubsysImpl.class$("com.raplix.rolloutexpress.resource.util.CallbackDispatcherInterface")) : class$com$raplix$rolloutexpress$resource$util$CallbackDispatcherInterface);
            }
            catch (RPCException e) {
                throw new ResourceException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean succeeded;
            RsrcPushImpl theRepeaterPush;
            block13: {
                block12: {
                    RsrcPushImpl theFinalRepeaterPush2;
                    boolean theFinalSucceeded2;
                    block11: {
                        theRepeaterPush = null;
                        succeeded = false;
                        try {
                            try {
                                PushParams.OneRsrcsIter theIter = this.mPushParams.getOneRsrcsIter();
                                while (theIter.hasNext()) {
                                    if (this.mHalted) {
                                        Object var7_7 = null;
                                        theFinalSucceeded2 = succeeded;
                                        theFinalRepeaterPush2 = theRepeaterPush;
                                        break block11;
                                    }
                                    PushParams.OneRsrc theOneRsrc = theIter.next();
                                    this.pullResource(theOneRsrc);
                                }
                                if (this.mHalted) {
                                    break block12;
                                }
                                theRepeaterPush = this.makeRepeaterPush();
                                succeeded = true;
                                break block13;
                            }
                            catch (Throwable t) {
                                block14: {
                                    if (Logger.isErrorEnabled(this)) {
                                        Logger.error("Unable to pull resources " + this.mPushParams.mPushID, t, this);
                                    }
                                    PushCallbackRec theCBRec = new PushCallbackRec(this.mClosureKey, MiscUtils.resourceWrap(t));
                                    try {
                                        this.mRemoteCBDispatch.dispatch(theCBRec);
                                    }
                                    catch (Exception e) {
                                        if (!Logger.isErrorEnabled(this)) break block14;
                                        Logger.error("Unable to notify upstream node of error: " + t.getMessage(), e, this);
                                    }
                                }
                                Object var7_10 = null;
                                boolean theFinalSucceeded2 = succeeded;
                                RsrcPushImpl theFinalRepeaterPush2 = theRepeaterPush;
                                new Sequence(this, succeeded, theFinalSucceeded2, theFinalRepeaterPush2){
                                    private final /* synthetic */ boolean val$theFinalSucceeded;
                                    private final /* synthetic */ RsrcPushImpl val$theFinalRepeaterPush;
                                    private final /* synthetic */ PushRcvThread this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$theFinalSucceeded = val$theFinalSucceeded;
                                        this.val$theFinalRepeaterPush = val$theFinalRepeaterPush;
                                        super(x0);
                                    }

                                    public void populateActions() {
                                        this.addAction(new Sequence.Action(this){
                                            private final /* synthetic */ 15 this$2;
                                            {
                                                this.this$2 = this$2;
                                            }

                                            public void exec() throws ResourceException {
                                                ResourceSubsysImpl.access$1600(PushRcvThread.access$1500(15.access$1300(this.this$2)), PushRcvThread.access$1400(15.access$1300(this.this$2)).toArray(new Resource[0]));
                                            }
                                        });
                                        this.addAction(new Sequence.Action(this){
                                            private final /* synthetic */ 15 this$2;
                                            {
                                                this.this$2 = this$2;
                                            }

                                            public void exec() throws RPCException, ResourceException {
                                                PushCallbackRec theCBRec = new PushCallbackRec(PushRcvThread.access$1700(15.access$1300(this.this$2)), 2);
                                                PushRcvThread.access$1800(15.access$1300(this.this$2)).dispatch(theCBRec);
                                            }
                                        });
                                        if (!this.val$theFinalSucceeded) {
                                            this.addAction(new Sequence.Action(this){
                                                private final /* synthetic */ 15 this$2;
                                                {
                                                    this.this$2 = this$2;
                                                }

                                                public void exec() throws ResourceException {
                                                    if (15.access$1900(this.this$2) != null) {
                                                        15.access$1900(this.this$2).dispose();
                                                    } else {
                                                        File theVirtualRsrcDir = RsrcPushImpl.calcPushVirtualDir(PushRcvThread.access$2000((PushRcvThread)15.access$1300(this.this$2)).mPushID, PushRcvThread.access$1500(15.access$1300(this.this$2)));
                                                        ResourceFileUtils.deleteDirectory(theVirtualRsrcDir);
                                                    }
                                                }
                                            });
                                        }
                                    }

                                    static /* synthetic */ PushRcvThread access$1300(15 x0) {
                                        return x0.this$1;
                                    }

                                    static /* synthetic */ RsrcPushImpl access$1900(15 x0) {
                                        return x0.val$theFinalRepeaterPush;
                                    }
                                }.execSafe();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            boolean theFinalSucceeded2 = succeeded;
                            RsrcPushImpl theFinalRepeaterPush2 = theRepeaterPush;
                            new /* invalid duplicate definition of identical inner class */.execSafe();
                            throw throwable;
                        }
                    }
                    new /* invalid duplicate definition of identical inner class */.execSafe();
                    return;
                }
                Object var7_8 = null;
                boolean theFinalSucceeded2 = succeeded;
                RsrcPushImpl theFinalRepeaterPush2 = theRepeaterPush;
                new /* invalid duplicate definition of identical inner class */.execSafe();
                return;
            }
            Object var7_9 = null;
            boolean theFinalSucceeded2 = succeeded;
            RsrcPushImpl theFinalRepeaterPush2 = theRepeaterPush;
            new /* invalid duplicate definition of identical inner class */.execSafe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void halt() throws ResourceException {
            MultiReceivePipe theRcvPipe = null;
            Object object = this.mPipeSyncObj;
            synchronized (object) {
                this.mHalted = true;
                theRcvPipe = this.mCurRsrcRcvPipe;
                this.mCurRsrcRcvPipe = null;
            }
            if (theRcvPipe != null) {
                ResourceException theEx = new ResourceException("rsrc.OPERATION_ABORTED");
                this.mCurRsrcRcvPipe.senderFinishedWithError(theEx);
                this.mCurRsrcRcvPipe.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pullSingleResource(PushParams.OneRsrc inOneRsrc) throws ResourceException {
            block38: {
                boolean isVirtual;
                block37: {
                    isVirtual = this.shouldPullVirtually(inOneRsrc);
                    FinishStatus theFinishStatus = new FinishStatus();
                    this.mCurRsrcDir = isVirtual ? RsrcPushImpl.calcRsrcVirtualDir(this.mPushParams.mPushID, ResourceSubsysImpl.this, inOneRsrc.mResource.getResourceID()) : inOneRsrc.mResource.getInternalRepoFile(ResourceSubsysImpl.this);
                    long theResourceSize = isVirtual ? inOneRsrc.mMetaDataOnlySize : inOneRsrc.mFullSize;
                    RepoSizeManager repoSizeManager = ResourceSubsysImpl.this.mRepoSizeManager;
                    synchronized (repoSizeManager) {
                        if (!ResourceSubsysImpl.this.mRepoSizeManager.verifySpaceAvailable(theResourceSize)) {
                            throw new ResourceException("rsrc.CACHE_FULL");
                        }
                        ResourceSubsysImpl.this.mRepoSizeManager.informNonMSSizeChange(theResourceSize);
                    }
                    boolean success = false;
                    try {
                        Object object;
                        DataId theRcvPipeDataID = null;
                        Object object2 = this.mPipeSyncObj;
                        synchronized (object2) {
                            if (this.mHalted) {
                                throw new ResourceException("rsrc.CONNECTION_CLOSED");
                            }
                            this.mCurRsrcRcvPipe = new MultiReceivePipe(this, "Rcv rsrc " + inOneRsrc.mResource, ResourceSubsysImpl.this.getFileMover(), theFinishStatus){
                                private final /* synthetic */ FinishStatus val$theFinishStatus;
                                private final /* synthetic */ PushRcvThread this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$theFinishStatus = val$theFinishStatus;
                                    super(x0, x1);
                                }

                                public void processObject(Object inObject) throws ResourceException {
                                    if (!(inObject instanceof String)) {
                                        MiscUtils.throwUPE(5072143L);
                                    }
                                    if (PushRcvThread.access$2300(this.this$1) != null) {
                                        MiscUtils.throwUPE(5072144L);
                                    }
                                    PushRcvThread.access$2302(this.this$1, (String)inObject);
                                }

                                public void processStream(InputStream inStream, long inNumBytes) throws ResourceException {
                                    if (PushRcvThread.access$2300(this.this$1) == null) {
                                        MiscUtils.throwUPE(5072145L);
                                    }
                                    File theFile = new File(PushRcvThread.access$2400(this.this$1), PushRcvThread.access$2300(this.this$1));
                                    PushRcvThread.access$2302(this.this$1, null);
                                    theFile.getParentFile().mkdirs();
                                    ResourceFileUtils.writeStreamToFile(theFile, System.currentTimeMillis(), inStream);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void senderFinished() {
                                    FinishStatus finishStatus = this.val$theFinishStatus;
                                    synchronized (finishStatus) {
                                        this.val$theFinishStatus.mFinished = true;
                                        this.val$theFinishStatus.notifyAll();
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void senderFinishedWithError(CommandException inError) throws ResourceException {
                                    FinishStatus finishStatus = this.val$theFinishStatus;
                                    synchronized (finishStatus) {
                                        this.val$theFinishStatus.mErr = inError != null ? inError : new ResourceException("rsrc.UNKNOWN_ERROR");
                                        this.val$theFinishStatus.mFinished = true;
                                        this.val$theFinishStatus.notifyAll();
                                    }
                                }
                            };
                            theRcvPipeDataID = this.mCurRsrcRcvPipe.getDataId();
                        }
                        try {
                            PushCallbackRec theCBRec = new PushCallbackRec(this.mClosureKey, inOneRsrc.mResource.getResourceID(), isVirtual, theRcvPipeDataID);
                            try {
                                this.mRemoteCBDispatch.dispatch(theCBRec);
                            }
                            catch (RPCException e) {
                                throw new ResourceException(e);
                            }
                            FinishStatus finishStatus = theFinishStatus;
                            synchronized (finishStatus) {
                                while (!theFinishStatus.mFinished) {
                                    try {
                                        theFinishStatus.wait();
                                    }
                                    catch (InterruptedException e) {
                                        throw new ResourceException(e);
                                    }
                                }
                            }
                            Object var13_15 = null;
                            object = this.mPipeSyncObj;
                        }
                        catch (Throwable throwable) {
                            Object var13_16 = null;
                            Object object3 = this.mPipeSyncObj;
                            synchronized (object3) {
                                if (this.mCurRsrcRcvPipe != null) {
                                    this.mCurRsrcRcvPipe.close();
                                    this.mCurRsrcRcvPipe = null;
                                }
                            }
                            throw throwable;
                        }
                        synchronized (object) {
                            if (this.mCurRsrcRcvPipe != null) {
                                this.mCurRsrcRcvPipe.close();
                                this.mCurRsrcRcvPipe = null;
                            }
                        }
                        if (theFinishStatus.mErr != null) {
                            MiscUtils.resourceThrow(theFinishStatus.mErr);
                        }
                        success = true;
                        Object var17_22 = null;
                        if (success) break block37;
                        ResourceSubsysImpl.this.mRepoSizeManager.informNonMSSizeChange(-theResourceSize);
                    }
                    catch (Throwable throwable) {
                        Object var17_23 = null;
                        if (!success) {
                            ResourceSubsysImpl.this.mRepoSizeManager.informNonMSSizeChange(-theResourceSize);
                            try {
                                ResourceFileUtils.deleteDirectory(this.mCurRsrcDir);
                            }
                            catch (Throwable t) {
                                if (Logger.isErrorEnabled(this)) {
                                    Logger.error("Unable to delete aborted resource dir " + this.mCurRsrcDir, t, this);
                                }
                            }
                        } else if (!isVirtual) {
                            ResourceSubsysImpl.this.mMetaDbase.add(inOneRsrc.mResource, null);
                        }
                        throw throwable;
                    }
                    try {
                        ResourceFileUtils.deleteDirectory(this.mCurRsrcDir);
                    }
                    catch (Throwable t) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Unable to delete aborted resource dir " + this.mCurRsrcDir, t, this);
                        }
                        break block38;
                    }
                }
                if (!isVirtual) {
                    ResourceSubsysImpl.this.mMetaDbase.add(inOneRsrc.mResource, null);
                }
            }
        }

        private boolean shouldPullVirtually(PushParams.OneRsrc inOneRsrc) {
            return this.mPushParams.mIsSimulated || !inOneRsrc.isActualDuringActualPush();
        }

        private void pullResource(PushParams.OneRsrc inOneRsrc) throws ResourceException {
            if (this.shouldPullVirtually(inOneRsrc)) {
                this.pullSingleResource(inOneRsrc);
            } else {
                ResourceSubsysImpl.this.mArbitrator.execute(inOneRsrc.mResource.getResourceID().toString(), new Executable(this, inOneRsrc){
                    private final /* synthetic */ PushParams.OneRsrc val$inOneRsrc;
                    private final /* synthetic */ PushRcvThread this$1;
                    {
                        this.this$1 = this$1;
                        this.val$inOneRsrc = val$inOneRsrc;
                    }

                    public Object execute() throws ResourceException {
                        if (!ResourceSubsysImpl.access$1100(PushRcvThread.access$1500(this.this$1), this.val$inOneRsrc.mResource, this.val$inOneRsrc.mFullSize, this.val$inOneRsrc.mPackingTime)) {
                            PushRcvThread.access$2500(this.this$1, this.val$inOneRsrc);
                            ResourceSubsysImpl.access$100(PushRcvThread.access$1500(this.this$1)).lockResource(this.val$inOneRsrc.mResource, true);
                        }
                        PushRcvThread.access$1400(this.this$1).add(this.val$inOneRsrc.mResource);
                        return null;
                    }
                });
            }
        }

        private RsrcPushImpl makeRepeaterPush() throws ResourceException, ResourcePushFinishedWithErrorsException {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Constructing repeater push", this);
            }
            RsrcPushImpl thePushRepeater = RsrcPushImpl.makeRepeater(this.mSrcAddress, this.mPushParams, this.mRouteTree, ResourceSubsysImpl.this, this.mTimedSequence);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Activating repeater push", this);
            }
            thePushRepeater.activate(false);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Finished activating repeater push", this);
            }
            return thePushRepeater;
        }

        static /* synthetic */ Vector access$1400(PushRcvThread x0) {
            return x0.mLockedResources;
        }

        static /* synthetic */ ResourceSubsysImpl access$1500(PushRcvThread x0) {
            return x0.ResourceSubsysImpl.this;
        }

        static /* synthetic */ String access$1700(PushRcvThread x0) {
            return x0.mClosureKey;
        }

        static /* synthetic */ CallbackDispatcherInterface access$1800(PushRcvThread x0) {
            return x0.mRemoteCBDispatch;
        }

        static /* synthetic */ PushParams access$2000(PushRcvThread x0) {
            return x0.mPushParams;
        }

        static /* synthetic */ String access$2300(PushRcvThread x0) {
            return x0.mNextRelPath;
        }

        static /* synthetic */ String access$2302(PushRcvThread x0, String x1) {
            x0.mNextRelPath = x1;
            return x0.mNextRelPath;
        }

        static /* synthetic */ File access$2400(PushRcvThread x0) {
            return x0.mCurRsrcDir;
        }

        static /* synthetic */ void access$2500(PushRcvThread x0, PushParams.OneRsrc x1) throws ResourceException {
            x0.pullSingleResource(x1);
        }
    }

    private static class FinishStatus {
        boolean mFinished;
        CommandException mErr;

        private FinishStatus() {
        }
    }

    public static class PushCallbackRec
    implements CallbackClosure.CBParm {
        final String mCBDispatchKey;
        final boolean mIsFinal;
        final ResourceID mResourceID;
        final boolean mSendVirtual;
        final DataId mStreamRcvId;
        public final int mFinalResult;
        public final ResourceException mException;

        public String getKey() {
            return this.mCBDispatchKey;
        }

        public PushCallbackRec(String inDispatchKey, ResourceID inResourceID, boolean inSendVirtual, DataId inStreamRcvId) {
            this.mIsFinal = false;
            this.mCBDispatchKey = inDispatchKey;
            this.mResourceID = inResourceID;
            this.mSendVirtual = inSendVirtual;
            this.mStreamRcvId = inStreamRcvId;
            this.mException = null;
            this.mFinalResult = 0;
        }

        public PushCallbackRec(String inDispatchKey, int inFinalResult) {
            this.mCBDispatchKey = inDispatchKey;
            this.mIsFinal = true;
            this.mResourceID = null;
            this.mSendVirtual = false;
            this.mStreamRcvId = null;
            this.mException = null;
            this.mFinalResult = inFinalResult;
        }

        public PushCallbackRec(String inDispatchKey, ResourceException inException) {
            this.mCBDispatchKey = inDispatchKey;
            this.mIsFinal = true;
            this.mResourceID = null;
            this.mSendVirtual = false;
            this.mStreamRcvId = null;
            this.mFinalResult = 0;
            this.mException = inException;
        }
    }

    class CheckinRollback
    implements TopLevelTransactionListener {
        private File mRepoRsrcDir;
        private long mDirContentSize;

        CheckinRollback(File inRepoDir, long inDirContentSize) {
            if (inRepoDir == null) {
                throw new NullPointerException();
            }
            this.mRepoRsrcDir = inRepoDir;
            this.mDirContentSize = inDirContentSize;
        }

        public void aboutToComplete(boolean isCommitable) throws PreCommitException {
        }

        public void transactionComplete(boolean isCommitted) throws PostTransactionException {
            if (!isCommitted) {
                try {
                    ResourceFileUtils.deleteDirectory(this.mRepoRsrcDir);
                }
                catch (ResourceException e) {
                    throw new PostTransactionException(e);
                }
            }
        }
    }

    class SynchCounter {
        private int mCount = 0;

        SynchCounter() {
        }

        void increment() {
            ++this.mCount;
        }

        int decrement() {
            return --this.mCount;
        }
    }

    class RepoSizeManager {
        private long mNonMSCurrentCacheBytes = 0L;
        private boolean mInited = false;
        private long mNonMSMaxBytesToOccupy;
        private long mMSMinBytesToLeaveFree;

        RepoSizeManager(ResourceSubsystem inResourceSubsystem, boolean inIsServer) throws ConfigurationException {
            if (inIsServer) {
                this.mNonMSMaxBytesToOccupy = 0L;
                this.mMSMinBytesToLeaveFree = inResourceSubsystem.getConfigurationAsALong("minMSRepoVolFreeSpace");
            } else {
                this.mNonMSMaxBytesToOccupy = inResourceSubsystem.getConfigurationAsALong("maxTransientRepoSize");
                this.mMSMinBytesToLeaveFree = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean getIsInited() {
            RepoSizeManager repoSizeManager = this;
            synchronized (repoSizeManager) {
                return this.mInited;
            }
        }

        synchronized long getNonMSTotalRepoSize(boolean inForceInit) {
            if (!this.mInited || inForceInit) {
                this.mInited = true;
                if (!ResourceSubsysImpl.this.mIsServer) {
                    this.mNonMSCurrentCacheBytes = 0L;
                    File theTopLevelRsrcDir = new File(RsrcManifest.getSuvaResourcesDirWTrailingSeparator(ResourceSubsysImpl.this.getAbsRepoRootString()).toString());
                    this.mNonMSCurrentCacheBytes += ResourceSubsysImpl.this.mMetaDbase.getResourceDataBytesInDir(theTopLevelRsrcDir);
                    this.mNonMSCurrentCacheBytes += ResourceSubsysImpl.this.mMetaDbase.getResourceDataBytesInDir(RsrcDirLayout.getVirtualResourceDir(ResourceSubsysImpl.this));
                }
            }
            return this.mNonMSCurrentCacheBytes;
        }

        public long getNonMSTotalRepoSize() {
            return this.getNonMSTotalRepoSize(false);
        }

        public synchronized void informNonMSSizeChange(long inByteAdjustment) {
            if (!ResourceSubsysImpl.this.mIsServer) {
                this.getNonMSTotalRepoSize(false);
                this.mNonMSCurrentCacheBytes += inByteAdjustment;
            }
        }

        public long getNonMSMaxCacheSize() {
            return this.mNonMSMaxBytesToOccupy;
        }

        public synchronized boolean verifySpaceAvailable(long inIncomingSize) throws ResourceException {
            if (ResourceSubsysImpl.this.mIsServer) {
                return ResourceFileUtils.getBytesFreeOnVolume(new File(ResourceSubsysImpl.this.mAbsRepoRootString)) - inIncomingSize >= this.mMSMinBytesToLeaveFree;
            }
            if (inIncomingSize > this.mNonMSMaxBytesToOccupy) {
                return false;
            }
            long theMaxOccupiableDiskSpace = this.mNonMSMaxBytesToOccupy;
            long theCurFreeBytes = ResourceFileUtils.getBytesFreeOnVolume(new File(ResourceSubsysImpl.this.mAbsRepoRoot.toLocal()));
            long theAvailableDiskSpace = this.getNonMSTotalRepoSize() + theCurFreeBytes;
            if (theAvailableDiskSpace < theMaxOccupiableDiskSpace) {
                theMaxOccupiableDiskSpace = theAvailableDiskSpace;
            }
            return ResourceSubsysImpl.this.mMetaDbase.clearSpace(this.getNonMSTotalRepoSize() + inIncomingSize - theMaxOccupiableDiskSpace);
        }

        public synchronized void setNonMSMaxRepoSize(long inMaxCacheBytes) throws ResourceException {
            if (ResourceSubsysImpl.this.mIsServer) {
                return;
            }
            if (inMaxCacheBytes < 0L) {
                throw new ResourceException("rsrc.msg0292");
            }
            if (inMaxCacheBytes < this.getNonMSTotalRepoSize() && !this.verifySpaceAvailable(this.mNonMSMaxBytesToOccupy - inMaxCacheBytes)) {
                throw new ResourceException("rsrc.msg0294");
            }
            this.mNonMSMaxBytesToOccupy = inMaxCacheBytes;
        }

        public void flushUnlockedResources() throws ResourceException {
            if (!ResourceSubsysImpl.this.mIsServer) {
                this.verifySpaceAvailable(this.mNonMSMaxBytesToOccupy);
            }
        }

        public synchronized long getMinMSVolFreeSpace() throws ResourceException {
            return this.mMSMinBytesToLeaveFree;
        }

        public synchronized void setMinMSVolFreeSpace(long inMinMSVolFreeSpace) throws ResourceException {
            this.mMSMinBytesToLeaveFree = inMinMSVolFreeSpace;
        }
    }
}

