/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.exception.ResourceSpecException;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.util.Validate;

public class ResourceSpec
implements RPCSerializable {
    private static final String sDoubleFileSeparators = "//";
    private String mName = null;
    private ResourceID mCustomParentID = null;
    private static final ResourceID sDummyParentID = new ResourceID("DummyID");

    public ResourceSpec() {
    }

    void setName(String inName) throws ResourceSpecException {
        if ((inName = FileSpec.convertPathSeparatorToUniversal(inName)).indexOf(sDoubleFileSeparators) != -1) {
            throw new ResourceSpecException("rsrc.msg0212", new Object[]{inName});
        }
        if (ResourceStringUtils.endsInSeparator(inName)) {
            throw new ResourceSpecException("rsrc.msg0213", new Object[]{inName});
        }
        if (inName.length() == 0) {
            throw new ResourceSpecException("rsrc.msg0214");
        }
        int theInvalidIdx = ResourceSpec.indexOfInvalidChar(inName);
        if (theInvalidIdx != -1) {
            throw new ResourceSpecException("rsrc.msg0242", new Object[]{inName.substring(theInvalidIdx, theInvalidIdx + 1)});
        }
        this.mName = inName;
    }

    public static int indexOfInvalidChar(String inName) {
        if (inName == null) {
            throw new NullPointerException("ValidatePath must receive a non-null string");
        }
        for (int i = 0; i < inName.length(); ++i) {
            char theChar = inName.charAt(i);
            if (Validate.isValidNameChar(theChar) || theChar == "/".charAt(0)) continue;
            return i;
        }
        return -1;
    }

    public String getName() {
        return this.mName;
    }

    String getLocalName() {
        return FileSpec.convertPathSeparatorToLocal(this.mName);
    }

    public ResourceSpec(String inName) throws ResourceSpecException {
        this.setName(inName);
    }

    public ResourceSpec(String inName, ResourceID inCustomParentID) throws ResourceSpecException {
        this.setName(inName);
        this.mCustomParentID = inCustomParentID;
    }

    public ResourceSpec makeCustomSpec(ResourceID inCustomParentID) throws ResourceSpecException {
        return new ResourceSpec(this.mName, inCustomParentID);
    }

    public ResourceID getCustomParentID() {
        return this.mCustomParentID;
    }

    void setCustomParentID(ResourceID inResourceID) {
        this.mCustomParentID = inResourceID;
    }

    public String toString() {
        return this.mName + (this.mCustomParentID != null ? " (custom)" : "");
    }

    public boolean equals(Object inObj) {
        if (inObj == null || !(inObj instanceof ResourceSpec)) {
            return false;
        }
        ResourceSpec theOther = (ResourceSpec)inObj;
        if (!this.mName.equals(theOther.mName)) {
            return false;
        }
        if (this.mCustomParentID == null != (theOther.mCustomParentID == null)) {
            return false;
        }
        return this.mCustomParentID == null || this.mCustomParentID.equals(theOther.mCustomParentID);
    }

    public int hashCode() {
        return this.mName.hashCode() + (this.mCustomParentID == null ? 0 : this.mCustomParentID.hashCode());
    }
}

