/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleVersionedObjectByFullNameCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.resource.DeferredDeleteTable;
import com.raplix.rolloutexpress.resource.MultiRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceIDSet;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.ResourceToCategoryLinkTable;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.SingleRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledResourceQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import java.security.AccessControlException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class ResourceID
extends VersionedObjectID
implements RPCSerializable {
    private static IDFactory idFactory = new IDFactory();

    private ResourceID() {
    }

    public ResourceID(String inID) {
        super(inID);
    }

    public static ResourceID generateResourceID() {
        return (ResourceID)idFactory.generateObjectID();
    }

    public void updateVisibility(Visibility inVisibility) throws PersistenceManagerException, RPCException {
        this.updateVisibilityRPC(inVisibility, null);
    }

    public void updateVisibilityAllVersions(Visibility inVisibility) throws PersistenceManagerException, RPCException {
        this.updateVisibilityAllVersionsRPC(inVisibility, null);
    }

    public int updateCategories(CategoryUpdateContext ctx) throws RPCException, PersistenceManagerException {
        return ResourceToCategoryLinkTable.DEFAULT.updateCategories(this, ctx);
    }

    public SingleRsrcInfoQuery getByIDQuery() {
        return new SingleRsrcInfoQuery(this);
    }

    public RsrcInfo forTestOnly_retrieveMSRsrcInfo() throws PersistenceManagerException {
        PersistentBean theBean = this.retrieveMS();
        return new RsrcInfo((Resource)theBean);
    }

    public SummaryComponent[] getReferringComps() throws PersistenceManagerException {
        final Vector theSummaryCompsVector = new Vector();
        final ComponentImplTable ctbl = ComponentImplTable.DEFAULT;
        QueryBuilder.execute(ctbl.select(ComponentImplTable.where(ComponentImplTable.equals(ctbl.LocalResourceID, this))), new ResultSetProcessor(){

            public void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
                while (inResultSet.next()) {
                    SummaryComponent theSummaryComp = SummaryComponent.createFromResultSet(ctbl, inResultSet);
                    theSummaryCompsVector.add(theSummaryComp);
                }
            }
        });
        SummaryComponent[] theSummaryComps = theSummaryCompsVector.toArray(new SummaryComponent[0]);
        return theSummaryComps;
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            RsrcInfo theRsrc = this.getByIDQuery().select();
            try {
                Plugin.checkWritePermissions(theRsrc);
            }
            catch (AccessControlException e) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{theRsrc.getPluginID().getByIDQuery().selectSummaryView()});
            }
            SummaryComponent[] theSummaryComps = this.getReferringComps();
            for (int i = 0; i < theSummaryComps.length; ++i) {
                if (inContext.objectWillBeDeletedPriorTo(theSummaryComps[i].getID(), this)) continue;
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{theSummaryComps[i]});
            }
            this.checkVersionedObjectInUse(inContext);
            ResourceSpec theResourceSpec = ((Resource)this.retrieveMS()).getResourceSpec();
            if (!DeferredDeleteTable.isCurrentlyOkForDeletion(theResourceSpec)) {
                throw new ObjectNotDeletableException(new ROXMessage("pm.OBJECT_IN_USE"));
            }
            ResourceSpec theSpec = theRsrc.getResourceSpec();
            if (theRsrc.getConfigurable() && theSpec.getCustomParentID() == null) {
                MultiRsrcInfoQuery theQuery = MultiRsrcInfoQuery.allVersionsOfOne(theSpec);
                theQuery.setCustomFilter(Boolean.TRUE);
                RsrcInfo[] theRsrcs = theQuery.select();
                for (int index = 0; index < theRsrcs.length; ++index) {
                    RsrcInfo info = theRsrcs[index];
                    if (!info.getResourceSpec().getCustomParentID().equals(this)) continue;
                    inDependentContainer.addDependentObject(info);
                }
            }
            inDependentContainer.addAllDependentObjects(MultiInstalledResourceQuery.byResourceID(this).selectObjects());
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        ResourceIDSet idset = new ResourceIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext inContext) throws PersistenceManagerException {
        try {
            DeferredDeleteTable.beginDelete(this, inContext);
        }
        catch (ResourceException e) {
            throw new PersistenceManagerException(e);
        }
    }

    void sqlDeleteMS(final PersistContext inContext, TransactionManager inTransactionManager) throws ResourceException {
        try {
            inTransactionManager.transact(new Transaction(){

                public Object execute() throws ClassMapException, SQLException, PersistenceManagerException, QueryException {
                    ResourceToCategoryLinkTable.DEFAULT.removeByChildID(ResourceID.this);
                    ResourceID.super.deleteMS(inContext);
                    return null;
                }
            });
        }
        catch (PersistenceManagerException e) {
            throw new ResourceException("rsrc.msg0480", (Throwable)e, new Object[]{this});
        }
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new ResourceID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            ResourceTable t = ResourceTable.DEFAULT;
            SingleVersionedObjectByFullNameCache cache = new SingleVersionedObjectByFullNameCache(objectCache, t.CustomParentID, t.Name, t.Version);
            classMap.addSingleObjectCache(cache);
        }
    }
}

