/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;
import com.raplix.rolloutexpress.persist.VersionedPersistentObject;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.Key;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceToCategoryLinkTable;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceSpecException;
import com.raplix.rolloutexpress.resource.packageformat.MetaMetaData;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.repopaths.PathLogicIdx;
import com.raplix.rolloutexpress.resource.repopaths.RepoPathLogic;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;

public class Resource
extends VersionedPersistentObject
implements StandardObject,
RPCSerializable {
    private static int MAX_CACHED_SIZES = 250;
    private static final Hashtable sCachesByAddr = new Hashtable();
    private ResourceSpec mResourceSpec = new ResourceSpec();
    private String mType;
    private boolean mIsConfigurable;
    private boolean mIsHierarchical;
    private boolean mHasPermissions;
    private String mSourcePath;
    private HostID mSourceHostID;
    private HostSetID mPlatform;
    private PathLogicIdx mPathLogicIdx;
    private PluginID mPluginID;
    private CategoryIDSet mCategories;

    public static void setMaxCachedSizes(int inMaxCachedSizes) {
        MAX_CACHED_SIZES = inMaxCachedSizes;
    }

    public Resource() {
    }

    Resource(ResourceSpec inResourceSpec, long inSize, String inType, HostID inSourceHostID, String inSourcePath, boolean inConfigurable, boolean inHierarchical, boolean inHasPermissions, HostSetID inPlatform, PluginID inPluginID) {
        if (inResourceSpec == null || inSize < 0L) {
            throw new IllegalStateException("Illegal parameters");
        }
        this.mResourceSpec = inResourceSpec;
        this.adjust(inType, inSourceHostID, inSourcePath, inConfigurable, inHierarchical, inHasPermissions, inPlatform, inPluginID);
    }

    void adjust(String inType, HostID inSourceHostID, String inSourcePath, boolean inConfigurable, boolean inHierarchical, boolean inHasPermissions, HostSetID inPlatform, PluginID inPluginID) {
        this.mType = inType;
        this.mSourceHostID = inSourceHostID;
        this.mSourcePath = inSourcePath;
        this.mIsConfigurable = inConfigurable;
        this.mIsHierarchical = inHierarchical;
        this.mHasPermissions = inHasPermissions;
        this.mPlatform = inPlatform;
        this.mPluginID = inPluginID;
        this.mPathLogicIdx = PathLogicIdx.SUVA;
        this.setVisibility(Visibility.VISIBLE);
    }

    public ResourceID getResourceID() {
        return (ResourceID)this.getObjectID();
    }

    public ResourceSpec getResourceSpec() {
        return this.mResourceSpec;
    }

    public String getVersionString() {
        return this.getVersionNumber().getAsString();
    }

    public long getSize(ResourceSubsysImpl inCtx) throws ResourceException {
        return Resource.cacheSizes((ResourceID)this.getResourceID(), (ResourceSubsysImpl)inCtx).mFullSize;
    }

    public long getMetaOnlySize(ResourceSubsysImpl inCtx) throws ResourceException {
        return Resource.cacheSizes((ResourceID)this.getResourceID(), (ResourceSubsysImpl)inCtx).mMetaSize;
    }

    public long getPackingTime(ResourceSubsysImpl inCtx) throws ResourceException {
        return Resource.cacheSizes((ResourceID)this.getResourceID(), (ResourceSubsysImpl)inCtx).mPackingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCachedSize(ResourceID inResourceID, ResourceSubsysImpl inCtx) {
        Hashtable hashtable = sCachesByAddr;
        synchronized (hashtable) {
            Resource.getSizeCache(inCtx).remove(inResourceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getSizeCache(ResourceSubsysImpl inCtx) {
        Hashtable hashtable = sCachesByAddr;
        synchronized (hashtable) {
            RoxAddress theAddress = inCtx.getApplication().getLocalNodeAddress();
            Map theSizeCache = (Map)sCachesByAddr.get(theAddress);
            if (theSizeCache == null) {
                theSizeCache = new LinkedHashMap(MAX_CACHED_SIZES + 1, 0.75f, true){

                    public boolean removeEldestEntry(Map.Entry eldest) {
                        return this.size() > MAX_CACHED_SIZES;
                    }
                };
                sCachesByAddr.put(theAddress, theSizeCache);
            }
            return theSizeCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Sizes cacheSizes(final ResourceID inResourceID, ResourceSubsysImpl inCtx) throws ResourceException {
        Hashtable hashtable = sCachesByAddr;
        synchronized (hashtable) {
            Map theSizeCache = Resource.getSizeCache(inCtx);
            Sizes theResult = (Sizes)theSizeCache.get(inResourceID);
            if (theResult == null) {
                theResult = (Sizes)new ResourceAccessor(inCtx, null){

                    public Object innerAccess() throws ResourceException {
                        RsrcManifest theManifest = this.getManifest(inResourceID, null);
                        MetaMetaData theMetaMetaData = theManifest.getMetaMetaData(Key.sKey);
                        if (theMetaMetaData.mMetaMetaSize == 0L) {
                            MiscUtils.throwUPE(5072140L);
                        }
                        long theMetaSize = theMetaMetaData.mMetaSizeSansMetaMeta + theMetaMetaData.mMetaMetaSize;
                        long theFullSize = theMetaSize + theMetaMetaData.mDataSizeSansAnyMeta;
                        return new Sizes(theFullSize, theMetaSize, theMetaMetaData.mPackingTime);
                    }
                }.access();
                theSizeCache.put(inResourceID, theResult);
            }
            return theResult;
        }
    }

    private void setSize(long inIgnored) {
    }

    public boolean dataExists(ResourceSubsysImpl inResourceSubsysImpl) {
        return this.toFile(inResourceSubsysImpl).exists();
    }

    private long getSize() {
        return -1L;
    }

    public String getType() {
        return this.mType;
    }

    public String getDescription() {
        return null;
    }

    public Date getCheckInTime() {
        return this.getTimeStamp();
    }

    public UserID getCheckInUserID() {
        return this.getUserID();
    }

    public File toFile(ResourceSubsysImpl inResourceSubsysImpl) {
        return this.getInternalRepoFile(inResourceSubsysImpl);
    }

    public String toString() {
        return this.mResourceSpec.toString() + File.separator + this.getVersionNumber().getAsString();
    }

    public File getInternalRepoFile(ResourceSubsysImpl inResourceSubsysImpl) {
        return Resource.getInternalRepoFile(this.getResourceID(), inResourceSubsysImpl);
    }

    public static File getInternalRepoFile(ResourceID inResourceID, ResourceSubsysImpl inResourceSubsysImpl) {
        return new File(RsrcManifest.getResourceIDDirWTrailingSeparator(Key.sKey, inResourceSubsysImpl.getAbsRepoRootString(), inResourceID));
    }

    public static File getInternalRepoFile(ResourceSubsysImpl inResourceSubsysImpl, PathLogicIdx inPathLogicIdx, ResourceSpec inResourceSpec, VersionNumber inVersionNumber) {
        String theRepoRoot = inResourceSubsysImpl.getAbsRepoRoot().toLocal();
        return Resource.getInternalRepoFile(theRepoRoot, inPathLogicIdx, inResourceSpec, inVersionNumber);
    }

    private static File getInternalRepoFile(String inRepoRoot, PathLogicIdx inPathLogicIdx, ResourceSpec inResourceSpec, VersionNumber inVersionNumber) {
        String theRepoRelDir = RepoPathLogic.getSpecRepoRelDir(inPathLogicIdx, inResourceSpec);
        StringBuffer theStringBuff = new StringBuffer(inRepoRoot);
        theStringBuff.append(theRepoRelDir);
        theStringBuff.append(inVersionNumber.getAsString());
        theStringBuff.append(".zip");
        return new File(theStringBuff.toString());
    }

    public boolean getIsConfigurable() {
        return this.mIsConfigurable;
    }

    public boolean getIsHierarchical() {
        return this.mIsHierarchical;
    }

    public String getSourcePath() {
        return this.mSourcePath;
    }

    public HostID getSourceHostID() {
        return this.mSourceHostID;
    }

    public HostSetID getPlatform() {
        return this.mPlatform;
    }

    public String getPathLogicIdx() {
        return this.mPathLogicIdx.toString();
    }

    public PluginID getPluginID() {
        return this.mPluginID;
    }

    public boolean equals(Object inObj) {
        if (inObj == null || !(inObj instanceof Resource)) {
            return false;
        }
        Resource theOther = (Resource)inObj;
        return this.getObjectID().equals(theOther.getObjectID());
    }

    public int hashCode() {
        return this.getObjectID().hashCode();
    }

    public void setType(String inType) {
        this.mType = inType;
    }

    public void setDescription(String inDescription) {
    }

    void setName(String inName) throws ResourceSpecException {
        this.mResourceSpec.setName(inName);
    }

    public String getName() {
        return this.mResourceSpec.getName();
    }

    public void setCustomParentID(ResourceID inCustomParentID) {
        this.mResourceSpec.setCustomParentID(inCustomParentID);
    }

    public ResourceID getCustomParentID() {
        return this.mResourceSpec.getCustomParentID();
    }

    public void setIsConfigurable(boolean inIsConfigurable) {
        this.mIsConfigurable = inIsConfigurable;
    }

    public void setIsHierarchical(boolean inIsHierarchical) {
        this.mIsHierarchical = inIsHierarchical;
    }

    private void setHasPermissions(boolean inHasPermissions) {
        this.mHasPermissions = inHasPermissions;
    }

    public void setSourcePath(String inSourcePath) {
        this.mSourcePath = inSourcePath;
    }

    public void setSourceHostID(HostID inSourceHostID) {
        this.mSourceHostID = inSourceHostID;
    }

    public void setPlatform(HostSetID inPlatform) {
        this.mPlatform = inPlatform;
    }

    void setPathLogicIdx(String inPathLogicIdxString) {
        this.mPathLogicIdx = PathLogicIdx.FACTORY.get(inPathLogicIdxString);
    }

    public static short getStringMajor(String inVersion) {
        int thePointIdx = inVersion.indexOf(46);
        return (short)Integer.valueOf(inVersion.substring(0, thePointIdx)).intValue();
    }

    public static short getStringMinor(String inVersion) {
        int thePointIdx = inVersion.indexOf(46);
        return (short)Integer.valueOf(inVersion.substring(thePointIdx + 1, inVersion.length())).intValue();
    }

    CategoryIDSet getCategories() throws PersistenceManagerException, RPCException {
        if (this.mCategories == null) {
            this.setCategories(ResourceToCategoryLinkTable.DEFAULT.getCategories(this.getResourceID()));
        }
        return this.mCategories;
    }

    void setCategories(CategoryIDSet inCategories) {
        this.mCategories = inCategories;
    }

    protected void trSaveMS(VersionedPersistentBean latest, VersionedSaveContext ctx) throws PersistenceManagerException {
        try {
            Plugin.checkWritePermissions(new RsrcInfo(this));
            Resource previousVersion = (Resource)latest;
            if (previousVersion != null) {
                if (previousVersion.getPluginID() != null && !previousVersion.getPluginID().equals(this.mPluginID)) {
                    throw new PersistenceManagerException(new ROXMessage("rsrc.CANT_UPDATE_PLUGIN_RESOURCE", new String[]{this.mResourceSpec.getName()}));
                }
                if (previousVersion.getPluginID() == null && this.mPluginID != null) {
                    throw new PersistenceManagerException(new ROXMessage("rsrc.PLUGIN_CANT_UPDATE_RESOURCE", new String[]{this.mResourceSpec.getName()}));
                }
            }
            CategoryIDSet cats = this.getCategories();
            super.trSaveMS(latest, ctx);
            this.updateCategories(cats);
            this.incrementUpdateCountInSave();
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    private void updateCategories(CategoryIDSet cats) throws PersistenceManagerException, RPCException {
        ResourceToCategoryLinkTable.DEFAULT.updateCategoriesMS(this.getResourceID(), new CategoryUpdateContext(cats), this.getResourceID().equals(this.getRootID()));
    }

    protected ObjectID getRootObjectID() {
        return super.getRootObjectID();
    }

    private static class Sizes {
        long mFullSize;
        long mMetaSize;
        long mPackingTime;

        Sizes(long inFullSize, long inMetaSize, long inPackingTime) {
            this.mFullSize = inFullSize;
            this.mMetaSize = inMetaSize;
            this.mPackingTime = inPackingTime;
        }
    }
}

