/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.VersionMap;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class PushParams
implements RPCSerializable {
    final PushID mPushID;
    final boolean mIsSimulated;
    final VersionMap mFwdDeletionMap;
    private final Hashtable mOneRsrcHashByResourceID;
    boolean mForTestOnly_DisposeSync = false;
    private VersionNumber mPreviousRsrcVers;

    private PushParams() {
        this.mPushID = null;
        this.mIsSimulated = false;
        this.mFwdDeletionMap = null;
        this.mOneRsrcHashByResourceID = null;
    }

    public PushParams(boolean inIsSimulated) {
        this.mPushID = PushID.generatePushID();
        this.mIsSimulated = inIsSimulated;
        this.mOneRsrcHashByResourceID = new Hashtable();
        this.mFwdDeletionMap = new VersionMap();
    }

    void add(Resource inResource, String inKnownPreviousDeployPath, VersionNumber inPrevVersion, ResourceSubsysImpl inCtx) throws ResourceException {
        if (!inCtx.isServer()) {
            throw new IllegalStateException("Operation only allowed on server");
        }
        long theMetaOnlySize = inResource.getMetaOnlySize(inCtx);
        long theFullSize = inResource.getSize(inCtx);
        long thePackingTime = inResource.getPackingTime(inCtx);
        this.mOneRsrcHashByResourceID.put(inResource.getResourceID(), new OneRsrc(inResource, theFullSize, theMetaOnlySize, thePackingTime, inKnownPreviousDeployPath, inPrevVersion));
    }

    void add(Resource inResource, ResourceSubsysImpl inCtx) throws ResourceException {
        this.add(inResource, null, null, inCtx);
    }

    OneRsrc getOneRsrc(ResourceID inResourceID) {
        return (OneRsrc)this.mOneRsrcHashByResourceID.get(inResourceID);
    }

    public OneRsrcsIter getOneRsrcsIter() {
        return new OneRsrcsIter(this);
    }

    public VersionNumber getPreviousResourceVersion() {
        return this.mPreviousRsrcVers;
    }

    public long getVirtualResourceSize() {
        long theTotal = 0L;
        OneRsrcsIter theIter = this.getOneRsrcsIter();
        while (theIter.hasNext()) {
            OneRsrc theOneRsrc = theIter.next();
            if (!this.mIsSimulated && theOneRsrc.isActualDuringActualPush()) continue;
            theTotal += theOneRsrc.mMetaDataOnlySize;
        }
        return theTotal;
    }

    static class OneRsrcsIter {
        private Iterator mIter;

        OneRsrcsIter(PushParams inPushParams) {
            this.mIter = inPushParams.mOneRsrcHashByResourceID.entrySet().iterator();
        }

        boolean hasNext() {
            return this.mIter.hasNext();
        }

        OneRsrc next() {
            return (OneRsrc)((Map.Entry)this.mIter.next()).getValue();
        }
    }

    static class OneRsrc
    implements RPCSerializable {
        Resource mResource;
        long mFullSize;
        long mMetaDataOnlySize;
        long mPackingTime;
        private String mKnownPreviousDeployPath;
        private VersionNumber mPrevVersion;

        private OneRsrc() {
        }

        OneRsrc(Resource inResource, long inFullSize, long inMetaDataOnlySize, long inPackingTime, String inKnownPreviousDeployPath, VersionNumber inPrevVersion) {
            this.mResource = inResource;
            this.mFullSize = inFullSize;
            this.mMetaDataOnlySize = inMetaDataOnlySize;
            this.mPackingTime = inPackingTime;
            this.mKnownPreviousDeployPath = inKnownPreviousDeployPath;
            this.mPrevVersion = inPrevVersion;
        }

        boolean isActualDuringActualPush() {
            return this.mKnownPreviousDeployPath == null;
        }

        public String getKnownPreviousDeployPath() {
            return this.mKnownPreviousDeployPath;
        }

        public VersionNumber getPrevVersion() {
            return this.mPrevVersion;
        }
    }
}

