/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.Comparison;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.ResourceToCategoryLinkTable;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.RsrcInfoOrder;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;

public class MultiRsrcInfoQuery
extends MultiStandardObjectQueryImpl
implements MultiSelectableObjectQuery {
    private ResourceSpec mVersionsOfOneSpec = null;
    private static final ResourceToCategoryLinkTable LINK_T = ResourceToCategoryLinkTable.DEFAULT;
    private VersionRange mVersionFilter;
    private Boolean mCustomFilter;
    private CategoryID mCategoryFilter;

    public static MultiRsrcInfoQuery all() {
        MultiRsrcInfoQuery theQuery = new MultiRsrcInfoQuery(ResourceTable.DEFAULT, (ConditionalExpression)null, null);
        theQuery.setObjectOrder(RsrcInfoOrder.BY_NAME_ASC);
        theQuery.setVisibilityFilter(Visibility.VISIBLE);
        theQuery.setCustomFilter(Boolean.FALSE);
        return theQuery;
    }

    public static MultiRsrcInfoQuery allVersionsOfOne(ResourceSpec inResourceSpec) {
        Comparison isVersionOf = ResourceTable.equals(ResourceTable.DEFAULT.Name, inResourceSpec.getName());
        MultiRsrcInfoQuery theQuery = new MultiRsrcInfoQuery(ResourceTable.DEFAULT, (ConditionalExpression)isVersionOf, inResourceSpec);
        theQuery.setObjectOrder(RsrcInfoOrder.BY_VERSION_DESC);
        theQuery.setCustomFilter(Boolean.FALSE);
        return theQuery;
    }

    public static MultiRsrcInfoQuery byIDsNoFilter(ResourceID[] IDs) {
        return new MultiRsrcInfoQuery(ResourceTable.DEFAULT, IDs);
    }

    public static MultiRsrcInfoQuery byIDs(ResourceID[] IDs) {
        MultiRsrcInfoQuery theQuery = MultiRsrcInfoQuery.byIDsNoFilter(IDs);
        theQuery.setObjectOrder(RsrcInfoOrder.BY_VERSION_DESC);
        return theQuery;
    }

    MultiRsrcInfoQuery(ResourceTable table, ConditionalExpression whereClause, ResourceSpec inVersionsOfOneSpec) {
        super((Table)table, whereClause, RsrcInfoOrder.FACTORY);
        this.mVersionsOfOneSpec = inVersionsOfOneSpec;
    }

    MultiRsrcInfoQuery(ResourceTable table, ResourceID[] IDs) {
        super((Table)table, IDs, RsrcInfoOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder inRsrcInfoOrder) {
        super.setObjectOrder((RsrcInfoOrder)inRsrcInfoOrder);
    }

    public VersionRange getVersionFilter() {
        return this.mVersionFilter;
    }

    public void setVersionFilter(VersionRange versionFilter) {
        this.mVersionFilter = versionFilter;
    }

    public ResourceSpec getVersionsOfOneSpec() {
        return this.mVersionsOfOneSpec;
    }

    public Boolean getCustomFilter() {
        return this.mCustomFilter;
    }

    public void setCustomFilter(Boolean customFilter) {
        this.mCustomFilter = customFilter;
    }

    protected ConditionalExpression getFilterCondition(Table table) {
        ResourceTable t = (ResourceTable)table;
        ConditionalExpression mainFilter = super.getFilterCondition(t);
        if (mainFilter == null && this.getVersionFilter() == null && this.getCustomFilter() == null && this.getCategoryFilter() == null) {
            return null;
        }
        AndExp result = t.and();
        if (mainFilter != null) {
            result.add(mainFilter);
        }
        if (this.getVersionFilter() != null) {
            result.add(this.getVersionFilter().getConditional(t.Version));
        }
        if (this.getCategoryFilter() != null) {
            result.add(LINK_T.matchesCategoryID(this.getCategoryFilter(), t.ID));
        }
        if (this.getCustomFilter() != null) {
            if (this.getCustomFilter().booleanValue()) {
                result.add(ResourceTable.not(ResourceTable.isNull(t.CustomParentID)));
            } else {
                result.add(ResourceTable.isNull(t.CustomParentID));
            }
        }
        return result;
    }

    public StandardObject[] selectStandardObjectView() throws RPCException, PersistenceManagerException {
        return this.select();
    }

    public RsrcInfo[] select() throws RPCException, PersistenceManagerException {
        return this.selectVariant1();
    }

    public RsrcInfo[] selectVariant1() throws RPCException, PersistenceManagerException {
        Resource[] resources = (Resource[])this.selectBeans(Resource.class);
        RsrcInfo[] result = new RsrcInfo[resources.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new RsrcInfo(resources[i]);
        }
        return result;
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public void setCategoryFilter(CategoryID categoryFilter) {
        this.mCategoryFilter = categoryFilter;
    }

    public int updateCategories(CategoryUpdateContext ctx) throws PersistenceManagerException, RPCException {
        return LINK_T.updateCategories(this.selectIDs(), ctx);
    }

    public CategoryIDSet selectSharedCategories() throws PersistenceManagerException, RPCException {
        return LINK_T.getSharedCategories(this.selectIDs());
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        Resource[] resources = (Resource[])this.selectBeans(Resource.class);
        HasObjectID[] infos = new RsrcInfo[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            infos[i] = new RsrcInfo(resources[i]);
        }
        return infos;
    }
}

