/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.resource.DeferredDeleteTable;
import com.raplix.rolloutexpress.resource.DirPath;
import com.raplix.rolloutexpress.resource.Key;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.RsrcPush;
import com.raplix.rolloutexpress.resource.RsrcPushImpl;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.exception.ResourcePersistenceException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

abstract class MetaDbase
implements Messages {
    protected ResourceSubsysImpl mRsrcCtx = null;
    protected HashMap mPushHashMap = new HashMap();
    protected DirPath mAbsRepoRoot = null;
    protected Application mApplication = null;
    private LockMap mLockMap = new LockMap();

    public abstract long getResourceDataBytesInDir(File var1);

    MetaDbase(ResourceSubsysImpl inRsrcCtx, Application inApplication, DirPath inAbsRepoRoot) throws ResourceException {
        this.mRsrcCtx = inRsrcCtx;
        this.mApplication = inApplication;
        this.mAbsRepoRoot = inAbsRepoRoot;
    }

    abstract void removeFromLRU(Resource var1) throws ResourceException;

    abstract void setAsLRU(Resource var1) throws ResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void lockResource(Resource inResource, boolean inHonorDeleteLockMutex) throws ResourceException {
        DeferredDeleteTable.enterLockWithinTree(inResource.getResourceSpec(), inHonorDeleteLockMutex);
        boolean didSucceed = false;
        try {
            LockCount theLockCount = this.mLockMap.get(inResource.getResourceID());
            if (theLockCount == null) {
                File theInternalRepoFile = inResource.getInternalRepoFile(this.mRsrcCtx);
                if (!theInternalRepoFile.exists()) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Resource data is not found: " + inResource + " file=" + theInternalRepoFile, this);
                    }
                    throw new ResourceNotLocalException("rsrc.msg0478", new Object[]{inResource});
                }
                theLockCount = new LockCount(this, inResource);
                this.mLockMap.put(theLockCount);
            }
            theLockCount.increment();
            didSucceed = true;
        }
        finally {
            if (!didSucceed) {
                DeferredDeleteTable.leaveLockWithinTree(inResource.getResourceSpec());
            }
        }
    }

    public synchronized void unlockResource(Resource inResource) throws ResourceException {
        LockCount theLockCount = this.mLockMap.get(inResource.getResourceID());
        if (theLockCount == null) {
            throw new ResourceNotLocalException("rsrc.msg0174", new Object[]{inResource});
        }
        if (theLockCount.decrement() == 0) {
            this.mLockMap.remove(inResource.getResourceID());
        }
        DeferredDeleteTable.leaveLockWithinTree(inResource.getResourceSpec());
    }

    public synchronized int getLockCount(ResourceID inResourceID) {
        LockCount theLockCount = this.mLockMap.get(inResourceID);
        if (theLockCount == null) {
            return 0;
        }
        return theLockCount.getCount();
    }

    public void inflate() throws ResourceException {
        this.startupResources();
    }

    protected boolean verifyDataExists(Resource inResource) {
        return inResource.getInternalRepoFile(this.mRsrcCtx).exists();
    }

    abstract void startupResources() throws ResourceException;

    public abstract Resource get(ResourceSpec var1, VersionNumber var2, PushID var3) throws ResourcePersistenceException, ResourceNotLocalException;

    public abstract Resource get(ResourceID var1, PushID var2) throws ResourcePersistenceException, ResourceNotLocalException;

    public abstract void add(Resource var1, VersionedSaveContext var2) throws ResourcePersistenceException;

    abstract void removeMetaData(Resource var1) throws ResourceException, ResourcePersistenceException;

    public synchronized void remove(Resource inResource) throws ResourcePersistenceException, ResourceException {
        if (this.getLockCount(inResource.getResourceID()) > 0) {
            throw new ResourceException("rsrc.msg0447", new Object[]{inResource});
        }
        this.removeFromLRU(inResource);
        this.removeMetaData(inResource);
    }

    abstract Resource getMostRecentVersionOnMS(ResourceSpec var1) throws ResourcePersistenceException;

    abstract Resource grabVersion(ResourceSpec var1, long var2, String var4, HostID var5, String var6, boolean var7, boolean var8, boolean var9, HostSetID var10, VersionedSaveContext var11, CategoryIDSet var12, PluginID var13) throws ResourceException;

    synchronized void put(RsrcPushImpl inRsrcPushImpl) throws ResourcePersistenceException {
        this.mPushHashMap.put(inRsrcPushImpl.getPushID(), inRsrcPushImpl);
    }

    void remove(PushID inPushID) throws ResourcePersistenceException {
        RsrcPushImpl theRsrcPushImpl = (RsrcPushImpl)this.mPushHashMap.get(inPushID);
        if (theRsrcPushImpl != null) {
            this.mPushHashMap.remove(inPushID);
        } else if (Logger.isWarnEnabled(this)) {
            Logger.warn(ROXMessageManager.messageAsString("rsrc.PUSH_NOT_FOUND"), this);
        }
    }

    RsrcPushImpl get(PushID inPushID) {
        return (RsrcPushImpl)this.mPushHashMap.get(inPushID);
    }

    int getNumPushes() {
        return this.mPushHashMap.size();
    }

    public RsrcPush getRsrcPush(PushID inPushID) throws ResourceException {
        Collection theRsrcPushCollection = this.mPushHashMap.values();
        Iterator theImplIter = theRsrcPushCollection.iterator();
        while (theImplIter.hasNext()) {
            RsrcPush theRsrcPush = new RsrcPush((RsrcPushImpl)theImplIter.next());
            if (!theRsrcPush.getPushID().equals(inPushID)) continue;
            return theRsrcPush;
        }
        throw new ResourceException("rsrc.msg0246", new Object[]{inPushID});
    }

    synchronized Vector getAllPushes() {
        Vector<RsrcPush> thePushVector = new Vector<RsrcPush>();
        Collection theRsrcPushCollection = this.mPushHashMap.values();
        Iterator theImplIter = theRsrcPushCollection.iterator();
        while (theImplIter.hasNext()) {
            RsrcPush theRsrcPush = new RsrcPush((RsrcPushImpl)theImplIter.next());
            thePushVector.add(theRsrcPush);
        }
        return thePushVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void object2File(RPCSerializable inRPCSerializable, File inFile) throws ResourcePersistenceException {
        try {
            inFile.getParentFile().mkdirs();
            inFile.createNewFile();
            FileWriter theWriter = new FileWriter(inFile);
            try {
                this.mApplication.getNetSubsystem().getRPC().serializeObject(null, inRPCSerializable, theWriter);
            }
            finally {
                theWriter.close();
            }
        }
        catch (Exception e) {
            inFile.delete();
            Object[] theSubs = new Object[]{inFile};
            throw new ResourcePersistenceException("rsrc.msg0026", (Throwable)e, theSubs);
        }
    }

    Object file2Object(File inFile) throws ResourcePersistenceException {
        Object theObject = null;
        try {
            FileReader theFileReader = new FileReader(inFile);
            theObject = this.mApplication.getNetSubsystem().getRPC().deSerializeObject(null, theFileReader);
            theFileReader.close();
        }
        catch (Exception e) {
            Object[] theSubs = new Object[]{inFile.getAbsolutePath()};
            throw new ResourcePersistenceException("rsrc.msg0027", (Throwable)e, theSubs);
        }
        return theObject;
    }

    void forTestOnly_verifyEquivalent(MetaDbase inOther) throws ResourcePersistenceException {
        ArrayList theResources = this.getAllResIDs();
        ArrayList theOtherResources = inOther.getAllResIDs();
        int theNumResources = theResources.size();
        if (theNumResources != theOtherResources.size()) {
            throw new ResourcePersistenceException("rsrc.msg0175");
        }
        for (int i = 0; i < theNumResources; ++i) {
            ResourceID theResID = (ResourceID)theResources.get(i);
            if (!theOtherResources.contains(theResID)) {
                throw new ResourcePersistenceException("rsrc.msg0176", new Object[]{theResID});
            }
            File theRsrcDir = null;
            try {
                theRsrcDir = theResID.getByIDQuery().select().getResource(Key.sKey).toFile(this.mRsrcCtx);
            }
            catch (Throwable t) {
                throw new ResourcePersistenceException(t);
            }
            if (theRsrcDir.exists()) continue;
            throw new ResourcePersistenceException(new Exception("Resource file does not exist: " + theRsrcDir));
        }
    }

    abstract boolean clearSpace(long var1) throws ResourceException;

    public abstract ArrayList getAllResIDs() throws ResourcePersistenceException;

    public abstract Resource getNextHighestVersion(ResourceSpec var1, VersionNumber var2) throws ResourceException;

    public abstract Resource getNextLowestVersion(ResourceSpec var1, VersionNumber var2) throws ResourceException;

    private class LockCount {
        private int mCount = 0;
        private MetaDbase mMetaDbase;
        private Resource mResource;

        LockCount(MetaDbase inMetaDbase, Resource inResource) {
            this.mMetaDbase = inMetaDbase;
            this.mResource = inResource;
        }

        ResourceID getResourceID() {
            return this.mResource.getResourceID();
        }

        public synchronized void increment() throws ResourceException {
            ++this.mCount;
            if (this.mCount == 1) {
                this.mMetaDbase.removeFromLRU(this.mResource);
            }
        }

        public synchronized int decrement() throws ResourceException {
            if (this.mCount == 0) {
                throw new ResourceException("rsrc.msg0062");
            }
            --this.mCount;
            if (this.mCount == 0) {
                this.mMetaDbase.setAsLRU(this.mResource);
            }
            return this.mCount;
        }

        public int getCount() {
            return this.mCount;
        }
    }

    private class LockMap {
        private HashMap mHashMap = new HashMap();

        private LockMap() {
        }

        void put(LockCount inLockCount) {
            this.mHashMap.put(inLockCount.getResourceID(), inLockCount);
        }

        LockCount get(ResourceID inResourceID) {
            return (LockCount)this.mHashMap.get(inResourceID);
        }

        void remove(ResourceID inResourceID) {
            this.mHashMap.remove(inResourceID);
        }

        void removeAllLocks() {
            this.mHashMap.clear();
        }
    }
}

