/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.ft.FileHandlerException;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.FileTransferHandler;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.ServiceUnavailableException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.resource.AbsoluteFileSpec;
import com.raplix.rolloutexpress.resource.CLIFileMoverInterface;
import com.raplix.rolloutexpress.resource.FileMoverInterface;
import com.raplix.rolloutexpress.resource.FileSiphonInterface;
import com.raplix.rolloutexpress.resource.GetRemoteFileListener;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceIOException;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.ui.clui.CLUI;
import com.raplix.util.iowrappers.TempFile;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Stat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class FileMover
extends FileTransferHandler
implements CLIFileMoverInterface,
Messages,
FileSiphonInterface {
    public static final int BITS_TAKEN_BY_PORT = 17;
    static final long FTM_VISIBLE_LOW_BIT_MAX_VALUE = 32768L;
    static final long LOW_BIT_MASK = 32767L;
    static final long HIGH_BIT_MASK = -32768L;
    final long mHighLongFixedBits;
    private DataIdToMappedInputStream mDataIdToMappedInputStream = new DataIdToMappedInputStream();
    private DataIdToOutputStream mDataIdToOutStream = new DataIdToOutputStream();
    private long mNextLowLong = 0L;
    private Application mApp = null;
    private byte mHandlerID = 0;
    private GetRemoteFileListener mGetRequestListener = null;

    public FileMover(byte inID, Application inApp) throws ResourceException, RPCException {
        this.mHandlerID = inID;
        this.mApp = inApp;
        RoxAddress theLocalAddress = this.mApp.getLocalNodeAddress();
        this.mHighLongFixedBits = (theLocalAddress.getIPAddress() << 32) + (theLocalAddress.getPort() << 15);
        try {
            this.mApp.getNetSubsystem().getFTManager().registerHandler(this);
        }
        catch (FileTransferException ex) {
            throw new ResourceException("rsrc.msg0015", (Throwable)ex);
        }
        if (inApp instanceof CLUI) {
            this.mApp.getNetSubsystem().getRPC().registerService(CLIFileMoverInterface.class, this);
        } else {
            this.mApp.getNetSubsystem().getRPC().registerService(FileMoverInterface.class, this);
        }
        if (inApp instanceof Server) {
            this.mApp.getNetSubsystem().getRPC().registerService(FileSiphonInterface.class, this);
        }
    }

    public long getBytesStreamed(Object inKeyObject) {
        return this.mDataIdToMappedInputStream.getBytesStreamed(inKeyObject);
    }

    public void abortKeys(Object inKeyObject) {
        this.mDataIdToMappedInputStream.abortKeys(inKeyObject);
    }

    public void getRemoteFile(AbsoluteFileSpec inRemoteSrc, AbsoluteFileSpec inLocalDst, RoxAddress inRemoteAddress, RoxAddress inMSAddress, ObjectID inJobID) throws ResourceException, RPCException {
        this.getRemoteFile(inRemoteSrc, inLocalDst, inRemoteAddress, inMSAddress, 0, inJobID);
    }

    private void processMode(int inMode, File inFile) throws ResourceIOException {
        block17: {
            try {
                block18: {
                    if (!(this.mApp instanceof Server)) break block17;
                    if (!inFile.isAbsolute()) {
                        throw new ResourceIOException("rsrc.msg0499", new Object[]{inFile});
                    }
                    if (PlatformUtil.isPOSIX()) {
                        try {
                            Stat testLink = new Stat(inFile.getAbsolutePath());
                            if (testLink.isLink()) {
                                throw new ResourceIOException("rsrc.msg0498", new Object[]{inFile});
                            }
                        }
                        catch (IllegalArgumentException e) {
                            String fileNotFoundMessage = PlatformUtil.isAix() ? "A file or directory in the path name does not exist. [2]" : "No such file or directory [2]";
                            if (e.getMessage() != null && e.getMessage().toUpperCase().indexOf(fileNotFoundMessage.toUpperCase()) >= 0) break block18;
                            throw new ResourceIOException("rsrc.msg0498", (Throwable)e, new Object[]{inFile});
                        }
                    }
                }
                String tmpFileString = ResourceStringUtils.coerceSeparators(inFile.getCanonicalPath(), File.separatorChar);
                File theTmpDirFile = new File(this.mApp.getTmpDirAbsPath());
                String theTmpDirPath = theTmpDirFile.getCanonicalPath();
                File theDataDirFile = new File(this.mApp.getDataDirAbsPath());
                String msResourceRepository = theDataDirFile.getCanonicalPath() + File.separator + "rsrcMgr" + File.separator;
                if (tmpFileString.indexOf(msResourceRepository) < 0 && tmpFileString.indexOf(theTmpDirPath) < 0) {
                    throw new ResourceIOException("rsrc.msg0497", new Object[]{inFile});
                }
            }
            catch (IOException e) {
                throw new ResourceIOException("rsrc.msg0498", (Throwable)e, new Object[]{inFile});
            }
        }
        if (inMode == 1) {
            if (!inFile.exists()) {
                throw new ResourceIOException("rsrc.msg0140", new Object[]{inFile});
            }
            if (inFile.length() != 0L) {
                throw new ResourceIOException("rsrc.msg0141", new Object[]{inFile});
            }
        } else if (inMode == 0) {
            if (inFile.exists()) {
                ResourceFileUtils.deleteDirectorySnuff(inFile);
            }
            try {
                inFile.getParentFile().mkdirs();
                inFile.createNewFile();
            }
            catch (IOException e) {
                throw new ResourceIOException("rsrc.msg0143", (Throwable)e, new Object[]{inFile});
            }
        } else {
            throw new ResourceIOException("rsrc.msg0144");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRemoteFile(AbsoluteFileSpec inRemoteSrc, AbsoluteFileSpec inLocalDst, RoxAddress inRemoteAddress, RoxAddress inMSAddress, int inMode, ObjectID inJobID) throws ResourceException, RPCException {
        if (this.mApp.getNetSubsystem().getTransport().isLocal(inRemoteAddress)) {
            ResourceFileUtils.copyData(inRemoteSrc.toFile(), inLocalDst.toFile());
            return;
        }
        FileSiphonInterface theRemoteFileSiphon = this.getRemoteFileSiphon(inMSAddress);
        File theLocalDstFile = inLocalDst.toFile();
        this.processMode(inMode, theLocalDstFile);
        FileOutputStream theFileOutputStream = null;
        try {
            theFileOutputStream = new FileOutputStream(theLocalDstFile);
        }
        catch (FileNotFoundException e) {
            throw new ResourceIOException("rsrc.msg0145", (Throwable)e, new Object[]{theLocalDstFile});
        }
        DataId theDataId = this.registerOutStream(theFileOutputStream);
        try {
            theRemoteFileSiphon.pullAndPushDataId(inRemoteAddress, inRemoteSrc, theDataId, inJobID);
            Object var12_12 = null;
            this.removeOutStream(theDataId);
        }
        catch (Throwable throwable) {
            block10: {
                Object var12_13 = null;
                this.removeOutStream(theDataId);
                try {
                    theFileOutputStream.close();
                }
                catch (IOException e) {
                    if (!Logger.isWarnEnabled(this)) break block10;
                    Logger.warn(ROXMessageManager.messageAsString("rsrc.OUT_STREAM_CLOSE_ERROR"), this);
                }
            }
            throw throwable;
        }
        try {
            theFileOutputStream.close();
        }
        catch (IOException e) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn(ROXMessageManager.messageAsString("rsrc.OUT_STREAM_CLOSE_ERROR"), this);
            }
        }
    }

    public void sendLocalFile(AbsoluteFileSpec inLocalSrc, AbsoluteFileSpec inRemoteDst, RoxAddress inRemoteAddress, Object inKeyObject) throws ResourceException, RPCException, FileNotFoundException {
        this.sendStream(new FileInputStream(inLocalSrc.toFile()), inLocalSrc.toFile().length(), inRemoteDst, inRemoteAddress, inKeyObject);
    }

    public DataId registerOutStream(OutputStream inOutStream) {
        DataId theDataId = this.getNextDataId();
        this.mDataIdToOutStream.put(theDataId, inOutStream);
        return theDataId;
    }

    public void removeOutStream(DataId inDataId) {
        this.mDataIdToOutStream.remove(inDataId);
    }

    DataId registerInStream(InputStream inStream) {
        DataId theDataId = this.getNextDataId();
        this.mDataIdToMappedInputStream.put(theDataId, new MappedInputStream(inStream, null));
        return theDataId;
    }

    void unregisterInStream(DataId inDataId) {
        this.mDataIdToMappedInputStream.remove(inDataId);
    }

    void getRemoteStream(AbsoluteFileSpec inLocalDst, DataId inRemoteDataId, int inMode) throws ResourceException, RPCException {
        this.pullDataId(inLocalDst, inRemoteDataId, inMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStream(InputStream inInputStream, long inStreamSize, AbsoluteFileSpec inAbsDstSpec, RoxAddress inRemoteAddress, Object inKeyObject) throws ResourceException, RPCException {
        if (inRemoteAddress == null) {
            inRemoteAddress = this.mApp.getNetSubsystem().getRPC().getInvokerAddress();
        }
        FileMoverInterface theRemoteFileMover = this.getRemoteFileMover(inRemoteAddress);
        MappedInputStream theMappedInputStream = new MappedInputStream(inInputStream, inKeyObject);
        DataId theDataId = this.getNextDataId();
        this.mDataIdToMappedInputStream.put(theDataId, theMappedInputStream);
        try {
            theRemoteFileMover.pullDataId(inAbsDstSpec, theDataId, 0);
            Object var11_9 = null;
            this.mDataIdToMappedInputStream.remove(theDataId);
        }
        catch (Throwable throwable) {
            block8: {
                Object var11_10 = null;
                this.mDataIdToMappedInputStream.remove(theDataId);
                try {
                    theMappedInputStream.getInputStream().close();
                }
                catch (IOException e) {
                    if (!Logger.isWarnEnabled(this)) break block8;
                    Logger.warn(ROXMessageManager.messageAsString("rsrc.IN_STREAM_CLOSE_ERROR"), e, this);
                }
            }
            throw throwable;
        }
        try {
            theMappedInputStream.getInputStream().close();
        }
        catch (IOException e) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn(ROXMessageManager.messageAsString("rsrc.IN_STREAM_CLOSE_ERROR"), e, this);
            }
        }
    }

    /*
     * Loose catch block
     */
    public void pullDataId(AbsoluteFileSpec inLocalDst, DataId inRemoteDataId, int inMode) throws ResourceException, RPCException {
        block13: {
            boolean didGetFile;
            FileOutputStream theFileOutputStream;
            File theOutputFile;
            block11: {
                theOutputFile = inLocalDst.toFile();
                this.processMode(inMode, theOutputFile);
                theFileOutputStream = null;
                try {
                    theFileOutputStream = new FileOutputStream(theOutputFile);
                }
                catch (FileNotFoundException e) {
                    throw new ResourceIOException("rsrc.msg0147", (Throwable)e, new Object[]{theOutputFile});
                }
                didGetFile = false;
                this.getFile(this.mApp.getNetSubsystem().getRPC().getInvokerAddress(), theFileOutputStream, inRemoteDataId);
                didGetFile = true;
                Object var9_8 = null;
                try {
                    theFileOutputStream.close();
                }
                catch (IOException e) {
                    if (!Logger.isWarnEnabled(this)) break block11;
                    Logger.warn(ROXMessageManager.messageAsString("rsrc.OUT_STREAM_CLOSE_ERROR"), this);
                }
            }
            if (!didGetFile) {
                theOutputFile.delete();
            }
            break block13;
            {
                catch (FileTransferException e) {
                    theOutputFile.delete();
                    throw new ResourceException("rsrc.msg0148", (Throwable)e, new Object[]{theOutputFile});
                }
            }
            catch (Throwable throwable) {
                block12: {
                    Object var9_9 = null;
                    try {
                        theFileOutputStream.close();
                    }
                    catch (IOException e) {
                        if (!Logger.isWarnEnabled(this)) break block12;
                        Logger.warn(ROXMessageManager.messageAsString("rsrc.OUT_STREAM_CLOSE_ERROR"), this);
                    }
                }
                if (!didGetFile) {
                    theOutputFile.delete();
                }
                throw throwable;
            }
        }
    }

    public GetRemoteFileListener getGetRequestListener() {
        return this.mGetRequestListener;
    }

    public void setGetRequestListener(GetRemoteFileListener inGetRequestListener) {
        this.mGetRequestListener = inGetRequestListener;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pullAndPushDataId(RoxAddress inRemoteAddress, AbsoluteFileSpec inRemoteSrc, DataId inTheDataId, ObjectID inJobID) throws ResourceException, RPCException {
        if (this.mGetRequestListener != null) {
            this.mGetRequestListener.receivedRequest(inRemoteAddress, inRemoteSrc, inJobID);
        }
        FileMoverInterface fileMover = this.getRemoteFileMover(inRemoteAddress);
        TempFile tempFile = null;
        tempFile = new TempFile("rsrc", ".tmp");
        DataId dataId = this.registerOutStream(new FileOutputStream(tempFile.getFile()));
        fileMover.pushDataId(inRemoteSrc, dataId);
        this.pushDataId(new FileInputStream(tempFile.getFile()), inTheDataId, this.mApp.getNetSubsystem().getRPC().getInvokerAddress());
        Object var9_10 = null;
        if (tempFile == null) return;
        try {
            tempFile.close();
            return;
        }
        catch (IOException e) {
            if (!Logger.isWarnEnabled(this)) return;
            Logger.warn("Unable to remove temp file:" + tempFile.getFile(), e, this);
        }
        return;
        {
            catch (IOException e) {
                throw new ResourceException("rsrc.msg0150", (Throwable)e, new Object[]{inRemoteSrc.getFileName()});
            }
            catch (FileTransferException e) {
                throw new ResourceException("rsrc.msg0150", (Throwable)e, new Object[]{inRemoteSrc.getFileName()});
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (tempFile == null) throw throwable;
            try {
                tempFile.close();
                throw throwable;
            }
            catch (IOException e) {
                if (!Logger.isWarnEnabled(this)) throw throwable;
                Logger.warn("Unable to remove temp file:" + tempFile.getFile(), e, this);
            }
            throw throwable;
        }
    }

    public void pushDataId(AbsoluteFileSpec inLocalSrc, DataId inRemoteDataId) throws ResourceException, RPCException {
        File theInputFile = inLocalSrc.toFile();
        FileInputStream theFileInputStream = null;
        try {
            theFileInputStream = new FileInputStream(theInputFile);
        }
        catch (FileNotFoundException e) {
            throw new ResourceIOException("rsrc.msg0149", (Throwable)e, new Object[]{theInputFile});
        }
        try {
            this.pushDataId(theFileInputStream, inRemoteDataId, this.mApp.getNetSubsystem().getRPC().getInvokerAddress());
        }
        catch (FileTransferException e) {
            throw new ResourceException("rsrc.msg0150", (Throwable)e, new Object[]{theInputFile});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDataId(InputStream inInputStream, DataId inRemoteDataId, RoxAddress inRemoteAddress) throws FileTransferException {
        try {
            this.sendFile(inRemoteAddress, inInputStream, inRemoteDataId);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                try {
                    inInputStream.close();
                }
                catch (IOException e) {
                    if (!Logger.isWarnEnabled(this)) break block7;
                    Logger.warn(ROXMessageManager.messageAsString("rsrc.IN_STREAM_CLOSE_ERROR"), this);
                }
            }
            throw throwable;
        }
        try {
            inInputStream.close();
        }
        catch (IOException e) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn(ROXMessageManager.messageAsString("rsrc.IN_STREAM_CLOSE_ERROR"), this);
            }
        }
    }

    private FileMoverInterface getRemoteFileMover(RoxAddress inRemoteAddress) throws ResourceException {
        FileMoverInterface theRemoteFileMoverInterface = null;
        try {
            theRemoteFileMoverInterface = (FileMoverInterface)this.mApp.getNetSubsystem().getRPC().getLocalService(inRemoteAddress, FileMoverInterface.class);
        }
        catch (ServiceUnavailableException sue) {
            try {
                theRemoteFileMoverInterface = (FileMoverInterface)this.mApp.getNetSubsystem().getRPC().getLocalService(inRemoteAddress, CLIFileMoverInterface.class);
            }
            catch (RPCException e) {
                throw new ResourceException("rsrc.msg0014", (Throwable)e);
            }
        }
        catch (RPCException ex) {
            throw new ResourceException("rsrc.msg0014", (Throwable)ex);
        }
        return theRemoteFileMoverInterface;
    }

    private FileSiphonInterface getRemoteFileSiphon(RoxAddress inRemoteAddress) throws ResourceException {
        FileSiphonInterface theRemoteFileSiphonInterface = null;
        try {
            theRemoteFileSiphonInterface = (FileSiphonInterface)this.mApp.getNetSubsystem().getRPC().getLocalService(inRemoteAddress, FileSiphonInterface.class);
        }
        catch (RPCException ex) {
            throw new ResourceException("rsrc.msg0014", (Throwable)ex);
        }
        return theRemoteFileSiphonInterface;
    }

    synchronized DataId getNextDataId() {
        return new DataId(this.mHighLongFixedBits, this.mNextLowLong++);
    }

    public static DataId getNextFTMNonDifferentDataId(DataId inPredecessor) {
        long theLowBitValue = inPredecessor.getId1() & 0x7FFFL;
        if (++theLowBitValue == 32768L) {
            theLowBitValue = 0L;
        }
        return new DataId(inPredecessor.getId1() & 0xFFFFFFFFFFFF8000L | theLowBitValue, inPredecessor.getId2());
    }

    private static DataId getMaskedKey(DataId inDataId) {
        return new DataId(inDataId.getId1() & 0xFFFFFFFFFFFF8000L, inDataId.getId2());
    }

    protected OutputStream storeData(RoxAddress from, TransportInfo fromInfo, DataId inDataId) throws FileHandlerException {
        OutputStream theOutputStream = this.mDataIdToOutStream.get(inDataId);
        if (theOutputStream == null) {
            throw new FileHandlerException(NetMessageCode.FT_CANNOT_STORE_FILE);
        }
        return theOutputStream;
    }

    protected InputStream fetchData(RoxAddress from, DataId inDataId, TransportInfo requestorInfo) throws FileHandlerException {
        return this.mDataIdToMappedInputStream.getInputStream(inDataId);
    }

    protected void sendFile(RoxAddress to, InputStream source, DataId inDataId) throws FileTransferException {
        this.sendData(to, source, inDataId);
    }

    protected void getFile(RoxAddress from, OutputStream sink, DataId inDataId) throws FileTransferException {
        this.getData(from, sink, inDataId);
    }

    public byte getHandlerId() {
        return this.mHandlerID;
    }

    class MappedInputStream
    extends InputStream {
        private InputStream mInputStream = null;
        private Object mKeyObject = null;
        private long mBytesStreamed = 0L;

        MappedInputStream(InputStream inInputStream, Object inKeyObject) {
            if (inInputStream == null) {
                throw new NullPointerException();
            }
            this.mInputStream = inInputStream;
            this.mKeyObject = inKeyObject;
        }

        InputStream getInputStream() {
            return this;
        }

        private boolean isKeyedBy(Object inKeyObject) {
            return this.mKeyObject != null && this.mKeyObject.equals(inKeyObject);
        }

        long getBytesStreamed(Object inKeyObject) {
            if (!this.isKeyedBy(inKeyObject)) {
                return 0L;
            }
            return this.mBytesStreamed;
        }

        void abortKey(Object inKeyObject) {
            block3: {
                if (this.isKeyedBy(inKeyObject)) {
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        if (!Logger.isErrorEnabled(this)) break block3;
                        Logger.error(ROXMessageManager.messageAsString("rsrc.IN_STREAM_CLOSE_ERROR"), this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            MappedInputStream mappedInputStream = this;
            synchronized (mappedInputStream) {
                if (this.mInputStream == null) {
                    return;
                }
                this.mInputStream.close();
                this.mInputStream = null;
            }
        }

        private void verifyOpen() throws IOException {
            if (this.mInputStream == null) {
                throw new IOException("Stream is unavailable");
            }
        }

        public int available() throws IOException {
            this.verifyOpen();
            return this.mInputStream.available();
        }

        public synchronized void mark(int readlimit) {
            if (this.mInputStream == null) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(ROXMessageManager.messageAsString("rsrc.MARK_NULL_STREAM"), this);
                }
                return;
            }
            this.mInputStream.mark(readlimit);
        }

        public boolean markSupported() {
            if (this.mInputStream == null) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(ROXMessageManager.messageAsString("rsrc.MARKSUPT_NULL_STREAM"), this);
                }
                return false;
            }
            return this.mInputStream.markSupported();
        }

        public int read() throws IOException {
            this.verifyOpen();
            int theReadInt = this.mInputStream.read();
            if (theReadInt != -1) {
                ++this.mBytesStreamed;
            }
            return theReadInt;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.verifyOpen();
            int theReadInt = this.mInputStream.read(b, off, len);
            if (theReadInt != -1) {
                this.mBytesStreamed += (long)theReadInt;
            }
            return theReadInt;
        }

        public synchronized void reset() throws IOException {
            this.verifyOpen();
            this.mInputStream.reset();
        }
    }

    public static interface Mode {
        public static final int CREATE_NEW_TARGET = 0;
        public static final int FILL_EMPTY_TARGET = 1;
    }

    class DataIdToMappedInputStream {
        private HashMap mHashMap = new HashMap();

        DataIdToMappedInputStream() {
        }

        synchronized void put(DataId inDataId, MappedInputStream inMappedInputStream) {
            this.mHashMap.put(FileMover.getMaskedKey(inDataId), inMappedInputStream);
        }

        synchronized void remove(DataId inDataId) {
            this.mHashMap.remove(FileMover.getMaskedKey(inDataId));
        }

        synchronized InputStream getInputStream(DataId inDataId) {
            MappedInputStream theMappedInputStream = (MappedInputStream)this.mHashMap.get(FileMover.getMaskedKey(inDataId));
            if (theMappedInputStream == null) {
                return null;
            }
            return theMappedInputStream.getInputStream();
        }

        synchronized void abortKeys(Object inKeyObject) {
            Object[] theKeys = this.mHashMap.entrySet().toArray();
            for (int i = 0; i < theKeys.length; ++i) {
                MappedInputStream theMappedInputStream = (MappedInputStream)((Map.Entry)theKeys[i]).getValue();
                theMappedInputStream.abortKey(inKeyObject);
            }
        }

        synchronized long getBytesStreamed(Object inKeyObject) {
            long theNumBytesStreamed = 0L;
            Object[] theKeys = this.mHashMap.entrySet().toArray();
            for (int i = 0; i < theKeys.length; ++i) {
                MappedInputStream theMappedInputStream = (MappedInputStream)((Map.Entry)theKeys[i]).getValue();
                theNumBytesStreamed += theMappedInputStream.getBytesStreamed(inKeyObject);
            }
            return theNumBytesStreamed;
        }
    }

    class DataIdToOutputStream {
        private HashMap mHashMap = new HashMap();

        DataIdToOutputStream() {
        }

        synchronized void put(DataId inDataId, OutputStream inMappedInputStream) {
            this.mHashMap.put(FileMover.getMaskedKey(inDataId), inMappedInputStream);
        }

        synchronized OutputStream remove(DataId inDataId) {
            if (inDataId == null) {
                return null;
            }
            return (OutputStream)this.mHashMap.remove(FileMover.getMaskedKey(inDataId));
        }

        synchronized OutputStream get(DataId inDataId) {
            return (OutputStream)this.mHashMap.get(FileMover.getMaskedKey(inDataId));
        }
    }
}

