/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.resource.DirPath;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.MetaDbase;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.RsrcDirLayout;
import com.raplix.rolloutexpress.resource.RsrcPushImpl;
import com.raplix.rolloutexpress.resource.VersionedSpec;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.exception.ResourcePersistenceException;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.repopaths.PathLogicIdx;
import com.raplix.rolloutexpress.resource.repopaths.RepoPathLogic;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.TreeMap;

class DiskMetaDbase
extends MetaDbase
implements Messages {
    private static final String sRsrcMetaDataExt = "_SerializedResource_";
    private InnerDbase mInnerDbase = new InnerDbase();
    private boolean mDirIsTraversed = false;
    private static long sLastGrain = 0L;

    boolean forTestOnly_DidDirTraversalOccur() {
        return this.mDirIsTraversed || this.mInnerDbase.getInited();
    }

    DiskMetaDbase(ResourceSubsysImpl inRsrcCtx, Application inApplication, DirPath inAbsRepoRoot) throws ResourceException {
        super(inRsrcCtx, inApplication, inAbsRepoRoot);
    }

    public long getResourceDataBytesInDir(File inDir) {
        this.mDirIsTraversed = true;
        if (!inDir.isDirectory()) {
            return inDir.length();
        }
        File[] theSubs = inDir.listFiles();
        if (theSubs == null) {
            return 0L;
        }
        long theTotal = 0L;
        for (int i = 0; i < theSubs.length; ++i) {
            File theSub = theSubs[i];
            if (theSub.isDirectory()) {
                theTotal += this.getResourceDataBytesInDir(theSub);
                continue;
            }
            if (this.isSerializedRoxResourceRecord(theSub)) continue;
            theTotal += theSub.length();
        }
        return theTotal;
    }

    public void removeFromLRU(Resource inResource) throws ResourceException {
        this.mInnerDbase.getLRUDatabase().remove(inResource);
    }

    public void setAsLRU(Resource inResource) {
        this.mInnerDbase.getLRUDatabase().markUnlocked(inResource, 1);
    }

    public void startupReadIntoLRU(Resource inResource) {
        this.mInnerDbase.getLRUDatabase().markUnlocked(inResource, 0);
    }

    public Resource get(ResourceSpec inResourceSpec, VersionNumber inVersion, PushID inPushID) throws ResourcePersistenceException, ResourceNotLocalException {
        RsrcPushImpl thePush;
        Resource theResource = this.mInnerDbase.getByVersionedSpec().get(new VersionedSpec(inResourceSpec, inVersion));
        if (theResource == null && inPushID != null && (thePush = this.get(inPushID)) != null) {
            theResource = thePush.getResourceIfVirtual(inResourceSpec, inVersion);
        }
        if (theResource == null) {
            Object[] theSubs = new Object[]{inResourceSpec, inVersion};
            throw new ResourceNotLocalException("rsrc.msg0019", theSubs);
        }
        return theResource;
    }

    public Resource get(ResourceID inResourceID, PushID inPushID) throws ResourcePersistenceException, ResourceNotLocalException {
        RsrcPushImpl thePush;
        Resource theResource = this.mInnerDbase.getByID().get(inResourceID);
        if (theResource == null && inPushID != null && (thePush = this.get(inPushID)) != null) {
            theResource = thePush.getResourceIfVirtual(inResourceID);
        }
        if (theResource == null) {
            Object[] theSubs = new Object[]{inResourceID};
            throw new ResourceNotLocalException("rsrc.msg0020", theSubs);
        }
        return theResource;
    }

    private synchronized void addMappings(Resource inResource) {
        this.mInnerDbase.getByID().put(inResource.getResourceID(), inResource);
        this.mInnerDbase.getByVersionedSpec().put(new VersionedSpec(inResource.getResourceSpec(), inResource.getVersionNumber()), inResource);
    }

    private synchronized void removeMappings(Resource inResource) {
        this.mInnerDbase.getByID().remove(inResource.getResourceID());
        this.mInnerDbase.getByVersionedSpec().remove(new VersionedSpec(inResource.getResourceSpec(), inResource.getVersionNumber()));
    }

    static synchronized long getNextGrain() {
        return sLastGrain++;
    }

    private File getSerializedResourceFile(Resource inResource) {
        return new File(inResource.getInternalRepoFile(this.mRsrcCtx), sRsrcMetaDataExt);
    }

    private boolean isSerializedRoxResourceRecord(File inFile) {
        return inFile.getName().equals(sRsrcMetaDataExt);
    }

    private File getRsrcDirForSerializedRsrcRec(File inSerializedRsrcRec) {
        if (!this.isSerializedRoxResourceRecord(inSerializedRsrcRec)) {
            throw new IllegalArgumentException();
        }
        return inSerializedRsrcRec.getAbsoluteFile().getParentFile();
    }

    public synchronized void add(Resource inResource, VersionedSaveContext inVersionedSaveContext_Ignored) throws ResourcePersistenceException {
        ResourceID theResourceID = inResource.getResourceID();
        if (theResourceID == null) {
            throw new ResourcePersistenceException("rsrc.msg0021");
        }
        this.object2File(inResource, this.getSerializedResourceFile(inResource));
        this.addMappings(inResource);
    }

    public synchronized void removeMetaData(Resource inResource) throws ResourcePersistenceException {
        this.removeMappings(inResource);
        File theMetaDataFile = this.getSerializedResourceFile(inResource);
        if (theMetaDataFile.exists() && !theMetaDataFile.delete()) {
            Object[] theSubs = new Object[]{theMetaDataFile};
            throw new ResourcePersistenceException("rsrc.msg0022", theSubs);
        }
    }

    Resource getMostRecentVersionOnMS(ResourceSpec inResourceSpec) throws ResourcePersistenceException {
        throw new ResourcePersistenceException("rsrc.msg0023");
    }

    Resource grabVersion(ResourceSpec inResourceSpec, long inSize, String inType, HostID inSourceHostID, String inSourcePath, boolean inConfigurable, boolean inHierarchical, boolean inHasPermissions, HostSetID inPlatform, VersionedSaveContext inVersionedSaveContext, CategoryIDSet inCategoryIDSet, PluginID pluginID) throws ResourceException {
        throw new ResourceException("rsrc.msg0023");
    }

    void startupResources() throws ResourceException {
        File theClassicDir = RepoPathLogic.getPathLogicSubDir(PathLogicIdx.CLASSIC, this.mRsrcCtx);
        ResourceFileUtils.deleteDirectory(theClassicDir);
        File thePushDir = new File(RsrcDirLayout.getPushDir(this.mRsrcCtx).toLocal());
        ResourceFileUtils.deleteDirectory(thePushDir);
        File theRedmondDir = RepoPathLogic.getPathLogicSubDir(PathLogicIdx.REDMOND, this.mRsrcCtx);
        ResourceFileUtils.deleteDirectory(theRedmondDir);
        File theResourceTopLevelDir = new File(RsrcManifest.getSuvaResourcesDirWTrailingSeparator(this.mRsrcCtx.getAbsRepoRootString()).toString());
        this.startupResources(theResourceTopLevelDir);
    }

    private void startupResources(File inDir) throws ResourceException {
        this.mInnerDbase.setDir(inDir);
    }

    public ArrayList getAllResIDs() throws ResourcePersistenceException {
        return this.mInnerDbase.getByID().getAllResourceIDs();
    }

    boolean clearSpace(long inIncrAmountNeeded) throws ResourceException {
        long theSize;
        for (long theRemainingAmtNeeded = inIncrAmountNeeded; theRemainingAmtNeeded > 0L; theRemainingAmtNeeded -= theSize) {
            Resource theLRUCandidate = this.mInnerDbase.getLRUDatabase().getLRU();
            if (theLRUCandidate == null) {
                return false;
            }
            theSize = 0L;
            try {
                theSize = this.mRsrcCtx.removeResource(theLRUCandidate);
                continue;
            }
            catch (ResourceException e) {
                throw new ResourcePersistenceException("rsrc.msg0196", (Throwable)e, new Object[]{theLRUCandidate});
            }
        }
        return true;
    }

    public Resource getNextHighestVersion(ResourceSpec inResourceSpec, VersionNumber inVersionNumber) throws ResourceException {
        throw new ResourceException("rsrc.msg0476");
    }

    public Resource getNextLowestVersion(ResourceSpec inResourceSpec, VersionNumber inVersionNumber) throws ResourceException {
        throw new ResourceException("rsrc.msg0476");
    }

    private class LRUDatabase {
        private TreeMap mGranularTimeToResourceMap;
        private HashMap mResourceToGranularTimeMap;
        private MetaDbase mMetaDbase;

        LRUDatabase(MetaDbase inMetaDbase) {
            this.mGranularTimeToResourceMap = new TreeMap(new GranularTimeComparator());
            this.mResourceToGranularTimeMap = new HashMap();
            this.mMetaDbase = inMetaDbase;
        }

        synchronized void markUnlocked(Resource inResource, int inMode) {
            this.remove(inResource);
            File theFile = inResource.getInternalRepoFile(DiskMetaDbase.this.mRsrcCtx);
            if (!theFile.exists()) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(ROXMessageManager.messageAsString("rsrc.DATA_MISSING", new Object[]{inResource}), this);
                }
                return;
            }
            GranularTime theGranularTime = new GranularTime(theFile, inMode);
            this.mResourceToGranularTimeMap.put(inResource, theGranularTime);
            this.mGranularTimeToResourceMap.put(theGranularTime, inResource);
        }

        synchronized void remove(Resource inResource) {
            GranularTime theGranularTime = (GranularTime)this.mResourceToGranularTimeMap.get(inResource);
            if (theGranularTime != null) {
                this.mResourceToGranularTimeMap.remove(inResource);
                this.mGranularTimeToResourceMap.remove(theGranularTime);
            }
        }

        synchronized Resource getLRU() {
            Resource theResource = null;
            while (true) {
                GranularTime theEarliestGranularTime;
                try {
                    theEarliestGranularTime = (GranularTime)this.mGranularTimeToResourceMap.firstKey();
                    if (theEarliestGranularTime == null) {
                        return null;
                    }
                }
                catch (NoSuchElementException e) {
                    return null;
                }
                theResource = (Resource)this.mGranularTimeToResourceMap.get(theEarliestGranularTime);
                if (this.mMetaDbase.getLockCount(theResource.getResourceID()) == 0) break;
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(ROXMessageManager.messageAsString("rsrc.LOCKED_LRU_RSRC", new Object[]{theResource}), this);
                }
                this.remove(theResource);
            }
            return theResource;
        }
    }

    class GranularTimeComparator
    implements Comparator {
        GranularTimeComparator() {
        }

        public int compare(Object inA, Object inB) {
            long theGrainB;
            long theTimeB;
            GranularTime theGranularTimeA = (GranularTime)inA;
            GranularTime theGranularTimeB = (GranularTime)inB;
            long theTimeA = theGranularTimeA.getTime();
            if (theTimeA < (theTimeB = theGranularTimeB.getTime())) {
                return -1;
            }
            if (theTimeA > theTimeB) {
                return 1;
            }
            long theGrainA = theGranularTimeA.getGrain();
            if (theGrainA < (theGrainB = theGranularTimeB.getGrain())) {
                return -1;
            }
            if (theGrainA > theGrainB) {
                return 1;
            }
            return 0;
        }
    }

    private class GranularTime {
        private long mTime = 0L;
        private long mGrain = 0L;

        GranularTime(File inFile, int inMode) {
            if (inMode == 1) {
                this.mTime = new Date().getTime();
                this.mGrain = DiskMetaDbase.getNextGrain();
                inFile.setLastModified(this.mTime);
            } else if (inMode == 0) {
                this.mTime = inFile.lastModified();
                this.mGrain = DiskMetaDbase.getNextGrain();
            } else {
                throw new IllegalStateException();
            }
        }

        long getTime() {
            return this.mTime;
        }

        long getGrain() {
            return this.mGrain;
        }
    }

    public static interface GranularTimeMode {
        public static final int READ_FILE_TIME = 0;
        public static final int SET_FILE_TIME = 1;
    }

    private class ResourcesByID {
        private HashMap mHashMap = new HashMap();

        private ResourcesByID() {
        }

        synchronized void put(ResourceID inResourceID, Resource inResource) {
            this.mHashMap.put(inResourceID, inResource);
        }

        synchronized Resource get(ResourceID inResourceID) {
            return (Resource)this.mHashMap.get(inResourceID);
        }

        synchronized void remove(ResourceID inResourceID) {
            this.mHashMap.remove(inResourceID);
        }

        synchronized ArrayList getAllResourceIDs() {
            return new ArrayList(this.mHashMap.keySet());
        }
    }

    private class ResourcesByVersionedSpec {
        private HashMap mHashMap = new HashMap();

        private ResourcesByVersionedSpec() {
        }

        synchronized void put(VersionedSpec inVersionedSpec, Resource inResource) {
            this.mHashMap.put(inVersionedSpec, inResource);
        }

        synchronized Resource get(VersionedSpec inVersionedSpec) {
            return (Resource)this.mHashMap.get(inVersionedSpec);
        }

        synchronized void remove(VersionedSpec inVersionedSpec) {
            this.mHashMap.remove(inVersionedSpec);
        }
    }

    class InnerDbase {
        private ResourcesByVersionedSpec mByVersionedSpec;
        private ResourcesByID mByID;
        private LRUDatabase mLRUDatabase;
        private boolean mInited;
        private File mDir;

        InnerDbase() {
            this.mByVersionedSpec = new ResourcesByVersionedSpec();
            this.mByID = new ResourcesByID();
            this.mLRUDatabase = new LRUDatabase(DiskMetaDbase.this);
            this.mInited = false;
            this.mDir = null;
        }

        boolean getInited() {
            return this.mInited;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            InnerDbase innerDbase = this;
            synchronized (innerDbase) {
                if (this.mInited) {
                    return;
                }
                this.mInited = true;
                this.startupResources(this.mDir);
            }
        }

        ResourcesByVersionedSpec getByVersionedSpec() {
            this.init();
            return this.mByVersionedSpec;
        }

        ResourcesByID getByID() {
            this.init();
            return this.mByID;
        }

        LRUDatabase getLRUDatabase() {
            this.init();
            return this.mLRUDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDir(File inDir) {
            InnerDbase innerDbase = this;
            synchronized (innerDbase) {
                this.mDir = inDir;
                this.mInited = false;
            }
        }

        private void startupResources(File inDir) {
            File[] theSubFiles = inDir.listFiles();
            if (theSubFiles == null) {
                return;
            }
            for (int i = 0; i < theSubFiles.length; ++i) {
                File theSubFile = theSubFiles[i];
                if (theSubFile.isDirectory()) {
                    this.startupResources(theSubFile);
                    continue;
                }
                if (!DiskMetaDbase.this.isSerializedRoxResourceRecord(theSubFile)) continue;
                Resource theResource = null;
                try {
                    theResource = (Resource)DiskMetaDbase.this.file2Object(theSubFile);
                    if (!DiskMetaDbase.this.verifyDataExists(theResource)) {
                        throw new ResourceException("rsrc.RECORD_NO_FILE");
                    }
                    DiskMetaDbase.this.addMappings(theResource);
                    DiskMetaDbase.this.startupReadIntoLRU(theResource);
                    continue;
                }
                catch (Throwable t) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error(ROXMessageManager.messageAsString("rsrc.INFLATE_ERROR", new Object[]{theSubFile.getAbsolutePath()}), t, this);
                    }
                    ResourceFileUtils.deleteDirectorySnuff(DiskMetaDbase.this.getRsrcDirForSerializedRsrcRec(theSubFile));
                }
            }
        }
    }
}

