/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.exception.ResourceIOException;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.util.logger.Logger;
import java.io.File;

public class DirPath
implements RPCSerializable,
Messages {
    private String mUniversalString = null;
    private boolean mIsAbsolute = false;

    private DirPath() {
    }

    public DirPath(String inString) {
        this.mUniversalString = FileSpec.convertPathSeparatorToUniversal(inString);
        if (!ResourceStringUtils.endsInSeparator(this.mUniversalString)) {
            this.mUniversalString = this.mUniversalString + FileSpec.UNIVERSAL_FILE_SEPARATOR;
        }
        File theAbsTestFile = new File(this.toLocal());
        this.mIsAbsolute = theAbsTestFile.isAbsolute();
    }

    public String toLocal() {
        return FileSpec.convertPathSeparatorToLocal(this.mUniversalString);
    }

    public String toDbase() {
        return this.mUniversalString.replace('\\', '/');
    }

    public void mkdirs() throws ResourceIOException {
        File theDir = new File(this.toLocal());
        if (!theDir.mkdirs() && !theDir.exists()) {
            Object[] theSubs = new Object[]{theDir};
            throw new ResourceIOException("rsrc.msg0018", theSubs);
        }
    }

    public String toString() {
        return this.toLocal();
    }

    public DirPath duplicate() {
        return new DirPath(this.mUniversalString);
    }

    public boolean isAbsolute() {
        return this.mIsAbsolute;
    }

    public DirPath getAbsoluteLocalPath() {
        if (this.isAbsolute()) {
            return this;
        }
        File theFile = new File(this.toLocal());
        return new DirPath(theFile.getAbsolutePath());
    }

    public boolean containsPath(DirPath inOther) {
        if (this.isAbsolute() != inOther.isAbsolute() && Logger.isWarnEnabled(this)) {
            Logger.warn(ROXMessageManager.messageAsString("rsrc.CONTAINSPATH_RESULTS"), this);
        }
        return inOther.getAbsoluteLocalPath().toLocal().startsWith(this.getAbsoluteLocalPath().toLocal());
    }

    public boolean equals(Object inObj) {
        if (inObj == null) {
            return false;
        }
        if (!(inObj instanceof DirPath)) {
            return false;
        }
        DirPath theOther = (DirPath)inObj;
        return this.mUniversalString.equals(theOther.mUniversalString);
    }

    public int hashCode() {
        return this.mUniversalString.hashCode();
    }

    public int length() {
        return this.mUniversalString.length();
    }

    public DirPath slash(DirPath inOther) {
        if (inOther == null) {
            return new DirPath(this.mUniversalString);
        }
        if (inOther.isAbsolute() && Logger.isWarnEnabled(this)) {
            Logger.warn(ROXMessageManager.messageAsString("rsrc.ABS_PATHS_APPEND"), this);
        }
        return this.slash(inOther.mUniversalString);
    }

    public DirPath slash(String inString) {
        if (inString == null) {
            return new DirPath(this.mUniversalString);
        }
        String theInternalString = this.mUniversalString;
        while (theInternalString.endsWith(FileSpec.UNIVERSAL_FILE_SEPARATOR)) {
            theInternalString = theInternalString.substring(0, theInternalString.length() - FileSpec.UNIVERSAL_FILE_SEPARATOR.length());
        }
        String theExternalString = FileSpec.convertPathSeparatorToUniversal(inString);
        while (theExternalString.startsWith(FileSpec.UNIVERSAL_FILE_SEPARATOR)) {
            theExternalString = theExternalString.substring(FileSpec.UNIVERSAL_FILE_SEPARATOR.length(), theExternalString.length());
        }
        return new DirPath(theInternalString + FileSpec.UNIVERSAL_FILE_SEPARATOR + theExternalString);
    }

    public DirPath subDirPath(int beginIndex, int endIndex) {
        return new DirPath(this.mUniversalString.substring(beginIndex, endIndex));
    }

    public int lastIndexOf(String inString) {
        return this.mUniversalString.lastIndexOf(FileSpec.convertPathSeparatorToUniversal(inString));
    }
}

