/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.resource.DeployMetaDbase;
import com.raplix.rolloutexpress.resource.MultiHostRsrcDbase;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.SingleHostRsrcDbase;
import com.raplix.rolloutexpress.resource.exception.ResourceCallbackException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

public abstract class DeploymentScope {
    private static final DeployMetaDbase mDeployMetaDbase = new DeployMetaDbase();
    private ResourceSubsysImpl mRsrcCtx;
    private Host[] mHosts;
    private RsrcInfo[] mRsrcInfos;

    public DeploymentScope(ResourceSubsystem inRsrcCtx, Host[] inHosts, RsrcInfo[] inRsrcInfos) throws ResourceException {
        if (inHosts == null || inRsrcInfos == null) {
            throw new NullPointerException();
        }
        this.mRsrcCtx = inRsrcCtx.getImpl();
        if (!this.mRsrcCtx.isServer()) {
            throw new ResourceException("rsrc.msg0443");
        }
        this.mHosts = inHosts;
        this.mRsrcInfos = inRsrcInfos;
    }

    public abstract Object innerExec() throws ResourceCallbackException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec() throws ResourceException {
        Object theResult = null;
        boolean didSucceed = false;
        this.beginDeployments();
        try {
            theResult = this.innerExec();
            didSucceed = true;
        }
        finally {
            block8: {
                try {
                    this.endDeployments();
                }
                catch (ResourceException e) {
                    if (!didSucceed) break block8;
                    throw e;
                }
            }
        }
        return theResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginDeployments() throws ResourceException {
        MultiHostRsrcDbase theMultiHostRsrcDbase;
        MultiHostRsrcDbase multiHostRsrcDbase = theMultiHostRsrcDbase = mDeployMetaDbase.get(this.mRsrcCtx);
        synchronized (multiHostRsrcDbase) {
            for (int i = 0; i < this.mHosts.length; ++i) {
                SingleHostRsrcDbase theDbase = theMultiHostRsrcDbase.get(this.mHosts[i].getID());
                for (int j = 0; j < this.mRsrcInfos.length; ++j) {
                    theDbase.add(this.mRsrcInfos[j].getResourceID());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endDeployments() throws ResourceException {
        MultiHostRsrcDbase theMultiHostRsrcDbase;
        MultiHostRsrcDbase multiHostRsrcDbase = theMultiHostRsrcDbase = mDeployMetaDbase.get(this.mRsrcCtx);
        synchronized (multiHostRsrcDbase) {
            for (int i = 0; i < this.mHosts.length; ++i) {
                SingleHostRsrcDbase theDbase = theMultiHostRsrcDbase.get(this.mHosts[i].getID());
                for (int j = 0; j < this.mRsrcInfos.length; ++j) {
                    theDbase.rmv(this.mRsrcInfos[j].getResourceID());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isResourceDeployingOnHost(ResourceSubsysImpl inRsrcCtx, ResourceID inResourceID, HostID inHostID) {
        MultiHostRsrcDbase theMultiHostRsrcDbase;
        MultiHostRsrcDbase multiHostRsrcDbase = theMultiHostRsrcDbase = mDeployMetaDbase.get(inRsrcCtx);
        synchronized (multiHostRsrcDbase) {
            SingleHostRsrcDbase theDbase = theMultiHostRsrcDbase.get(inHostID);
            return theDbase.getUseCount(inResourceID) != 0;
        }
    }
}

