/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PostTransactionException;
import com.raplix.rolloutexpress.persist.PreCommitException;
import com.raplix.rolloutexpress.persist.TopLevelTransactionListener;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.Key;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.MultiRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.RsrcInfoOrder;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.MetaMetaData;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.RsrcPacker;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegIter;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.arbitration.Executable;
import com.raplix.rolloutexpress.resource.util.arbitration.StringArbitrator;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class DeferredDeleteTable
implements TopLevelTransactionListener,
Messages {
    private static ThreadLocal sThreadLocalTable = new ThreadLocal();
    private static StringArbitrator sStringArbitrator = new StringArbitrator();
    private Application mApplication;
    private PersistenceManager mPersistenceManager;
    private TransactionManager mTransactionManager;
    private ResourceSubsystem mResourceSubsystem;
    private ResourceSubsysImpl mResourceSubsysImpl;
    private Vector mResourceSpecsToUnpause = new Vector();
    private Hashtable mDeletedResources = new Hashtable();
    private Vector mScheduledRepoDeletes = new Vector();
    private Vector mScheduledSwaps = new Vector();
    private static SpecExecMap sPostEnterCheckInExec;
    private static SpecExecMap sPostEnterLockExec;
    private static SpecExecMap sPostEnterMoveExec;
    private static SpecExecMap sPostEnterDeleteExec;

    public static synchronized void forTestOnly_setPostEnterCheckInExec(ResourceSpec inSpec, Executable inExec, Object inKey) {
        DeferredDeleteTable.verifyTestKey(inKey);
        if (inExec != null) {
            if (sPostEnterCheckInExec == null) {
                sPostEnterCheckInExec = new SpecExecMap();
            }
            sPostEnterCheckInExec.put(inSpec, inExec);
        } else {
            sPostEnterCheckInExec.put(inSpec, null);
        }
    }

    public static void forTestOnly_setPostLockExec(ResourceSpec inSpec, Executable inExec, Object inKey) {
        DeferredDeleteTable.verifyTestKey(inKey);
        if (inExec != null) {
            if (sPostEnterLockExec == null) {
                sPostEnterLockExec = new SpecExecMap();
            }
            sPostEnterLockExec.put(inSpec, inExec);
        } else {
            sPostEnterLockExec.put(inSpec, null);
        }
    }

    public static void forTestOnly_setPostMoveExec(ResourceSpec inSpec, Executable inExec, Object inKey) {
        DeferredDeleteTable.verifyTestKey(inKey);
        if (inExec != null) {
            if (sPostEnterMoveExec == null) {
                sPostEnterMoveExec = new SpecExecMap();
            }
            sPostEnterMoveExec.put(inSpec, inExec);
        } else {
            sPostEnterMoveExec.put(inSpec, null);
        }
    }

    public static void forTestOnly_setPostEnterDeleteExec(ResourceSpec inSpec, Executable inExec, Object inKey) {
        DeferredDeleteTable.verifyTestKey(inKey);
        if (inExec != null) {
            if (sPostEnterDeleteExec == null) {
                sPostEnterDeleteExec = new SpecExecMap();
            }
            sPostEnterDeleteExec.put(inSpec, inExec);
        } else {
            sPostEnterDeleteExec.put(inSpec, null);
        }
    }

    private static void verifyTestKey(Object inKey) {
        if (inKey == null) {
            throw new IllegalStateException("This routine can only be called from a test");
        }
        String theClassName = inKey.getClass().getName();
        if (theClassName.indexOf("com.raplix.rolloutexpress.resource") == -1 || theClassName.indexOf(".test.") == -1) {
            throw new IllegalStateException("This routine can only be called from a test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void beginDelete(ResourceID inResourceID, PersistContext inContext) throws ResourceException {
        DeferredDeleteTable theLocalTable;
        ThreadLocal threadLocal = sThreadLocalTable;
        synchronized (threadLocal) {
            theLocalTable = (DeferredDeleteTable)sThreadLocalTable.get();
            if (theLocalTable == null) {
                theLocalTable = new DeferredDeleteTable();
                sThreadLocalTable.set(theLocalTable);
            }
        }
        theLocalTable.beginDeleteLocal(inResourceID, inContext);
    }

    private DeferredDeleteTable() throws ResourceException {
        this.mApplication = Server.getApp();
        try {
            this.mPersistenceManager = this.mApplication.getPMSubsystem();
            this.mResourceSubsystem = this.mApplication.getResourceSubsystem();
        }
        catch (UnsupportedSubsystemException e) {
            throw new ResourceException(e);
        }
        this.mTransactionManager = this.mPersistenceManager.getTransactionManager();
        this.mResourceSubsysImpl = this.mResourceSubsystem.getImpl();
        try {
            this.mTransactionManager.registerTopLevelTransactionListener(this);
        }
        catch (PersistenceManagerException e) {
            throw new ResourceException(e);
        }
    }

    private synchronized void beginDeleteLocal(ResourceID inResourceID, PersistContext inContext) throws ResourceException {
        Resource theResource = this.mResourceSubsysImpl.getResource(inResourceID, null);
        ResourceSpec theResourceSpec = theResource.getResourceSpec();
        if (this.mDeletedResources.get(inResourceID) != null) {
            throw new ResourceException("rsrc.msg0468", new Object[]{theResource});
        }
        DeferredDeleteTable.enterDeleteWithinTree(theResourceSpec);
        this.mResourceSpecsToUnpause.add(theResourceSpec);
        inResourceID.sqlDeleteMS(inContext, this.mTransactionManager);
        this.mDeletedResources.put(inResourceID, theResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aboutToComplete(boolean isCommitable) throws PreCommitException {
        ThreadLocal threadLocal = sThreadLocalTable;
        synchronized (threadLocal) {
            if (sThreadLocalTable.get() != this) {
                throw new PreCommitException((ROXMessage)ROXMessageManager.message("rsrc.msg0488"));
            }
        }
        if (isCommitable) {
            Vector<Resource> theConfirmedDeletedResourceIDs = new Vector<Resource>();
            Vector<Resource> theNotDeletedResources = new Vector<Resource>();
            Iterator theIter = this.mDeletedResources.entrySet().iterator();
            while (theIter.hasNext()) {
                boolean doesExist;
                Resource theDeletedResource = (Resource)theIter.next().getValue();
                try {
                    doesExist = theDeletedResource.getResourceID().getByIDQuery().selectExists();
                }
                catch (RPCException e) {
                    throw new PreCommitException((ROXMessage)ROXMessageManager.message("rsrc.msg0465", new Object[]{theDeletedResource}), (Throwable)e);
                }
                catch (PersistenceManagerException e) {
                    throw new PreCommitException((ROXMessage)ROXMessageManager.message("rsrc.msg0465", new Object[]{theDeletedResource}), (Throwable)e);
                }
                if (doesExist) {
                    theNotDeletedResources.add(theDeletedResource);
                    continue;
                }
                theConfirmedDeletedResourceIDs.add(theDeletedResource);
            }
            if (!theNotDeletedResources.isEmpty()) {
                StringBuffer theIDsAsText = new StringBuffer();
                Iterator theUndeletedIter = theNotDeletedResources.iterator();
                while (theUndeletedIter.hasNext()) {
                    theIDsAsText.append(" " + (Resource)theUndeletedIter.next());
                }
                throw new PreCommitException((ROXMessage)ROXMessageManager.message("rsrc.msg0464", new Object[]{theIDsAsText.toString()}));
            }
            try {
                this.prepareDeletes(theConfirmedDeletedResourceIDs.toArray(new Resource[0]));
            }
            catch (ResourceException e) {
                throw new PreCommitException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transactionComplete(boolean isCommitted) throws PostTransactionException {
        Iterator theIter2;
        try {
            ScheduledSwap theSwap;
            Iterator theSwapIter;
            boolean didPassThreadCheck = true;
            ThreadLocal threadLocal = sThreadLocalTable;
            synchronized (threadLocal) {
                boolean bl = didPassThreadCheck = sThreadLocalTable.get() == this;
                if (didPassThreadCheck) {
                    sThreadLocalTable.set(null);
                }
            }
            Vector<Throwable> theThrowables = new Vector<Throwable>();
            boolean isDeployabilityOK = true;
            if (isCommitted) {
                isDeployabilityOK = false;
                theSwapIter = this.mScheduledSwaps.iterator();
                while (theSwapIter.hasNext()) {
                    theSwap = (ScheduledSwap)theSwapIter.next();
                    try {
                        theSwap.commit();
                    }
                    catch (Throwable t) {
                        theThrowables.add(t);
                        if (!Logger.isErrorEnabled(this)) continue;
                        Logger.error("Error while attempting to swap <" + theSwap.mReformulatedRsrcDir + "> out for <" + theSwap.mExistingRsrcDir + "> ResourceID=" + theSwap.mResourceID, t, this);
                    }
                }
                if (theThrowables.isEmpty()) {
                    isDeployabilityOK = true;
                    Iterator theDeleteIter = this.mScheduledRepoDeletes.iterator();
                    while (theDeleteIter.hasNext()) {
                        RsrcToDelete theRsrcToDelete = (RsrcToDelete)theDeleteIter.next();
                        try {
                            Object object = this.mResourceSubsysImpl.getRepoContentSyncObj();
                            synchronized (object) {
                                long theSize = ResourceFileUtils.getBytesInDir(theRsrcToDelete.mRsrcDirToDelete);
                                ResourceFileUtils.deleteDirectory(theRsrcToDelete.mRsrcDirToDelete);
                                if (theRsrcToDelete.mRsrcDirToDelete.exists()) {
                                    throw new ResourceException("rsrc.msg0470", new Object[]{theRsrcToDelete});
                                }
                                this.mResourceSubsysImpl.adjustTotalRepoSize(-theSize);
                                Resource.resetCachedSize(theRsrcToDelete.mResourceID, this.mResourceSubsysImpl);
                            }
                        }
                        catch (Throwable t) {
                            theThrowables.add(t);
                            if (!Logger.isErrorEnabled(this)) continue;
                            Logger.error("Error while attempting to delete repo file " + theRsrcToDelete, t, this);
                        }
                    }
                }
            } else {
                isDeployabilityOK = true;
                theSwapIter = this.mScheduledSwaps.iterator();
                while (theSwapIter.hasNext()) {
                    theSwap = (ScheduledSwap)theSwapIter.next();
                    try {
                        theSwap.rescind();
                    }
                    catch (Throwable t) {
                        theThrowables.add(t);
                        if (!Logger.isErrorEnabled(this)) continue;
                        Logger.error("Error while attempting to rescind swap of <" + theSwap.mReformulatedRsrcDir + "> out for <" + theSwap.mExistingRsrcDir + "> ResourceID=" + theSwap.mResourceID, t, this);
                    }
                }
            }
            if (!theThrowables.isEmpty()) {
                Throwable[] theExceptionArray = theThrowables.toArray(new Throwable[0]);
                if (Logger.isErrorEnabled(this)) {
                    String message = ROXMessageManager.messageAsString(isDeployabilityOK ? "rsrc.DELETION_ERROR_UN" : "rsrc.DELETION_ERROR", new Object[]{this.makeMultiExceptionString(theExceptionArray, System.getProperty("line.separator"))});
                    Logger.error(message, this);
                }
                String theMsgKey = isDeployabilityOK ? "rsrc.msg0489" : "rsrc.msg0490";
                throw new PostTransactionException((ROXMessage)ROXMessageManager.message(theMsgKey, new Object[]{this.makeMultiExceptionString(theExceptionArray, "\n")}));
            }
            if (!didPassThreadCheck) {
                throw new PostTransactionException((ROXMessage)ROXMessageManager.message("rsrc.msg0466"));
            }
            Object var13_15 = null;
            theIter2 = this.mResourceSpecsToUnpause.iterator();
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            Iterator theIter2 = this.mResourceSpecsToUnpause.iterator();
            while (theIter2.hasNext()) {
                DeferredDeleteTable.leaveDeleteWithinTree((ResourceSpec)theIter2.next());
            }
            this.mResourceSpecsToUnpause = null;
            throw throwable;
        }
        while (theIter2.hasNext()) {
            DeferredDeleteTable.leaveDeleteWithinTree((ResourceSpec)theIter2.next());
        }
        {
        }
        this.mResourceSpecsToUnpause = null;
    }

    private String makeMultiExceptionString(Throwable[] inExceptionArray, String inEOL) {
        StringBuffer theMultiErrorString = new StringBuffer();
        for (int i = 0; i < inExceptionArray.length; ++i) {
            String theMsg = inExceptionArray[i].getMessage();
            theMultiErrorString.append(inEOL + (theMsg == null ? "<null>" : theMsg));
        }
        return theMultiErrorString.toString();
    }

    private void prepareDeletes(Resource[] inResources) throws ResourceException {
        HashMap<ResourceSpec, TreeSet> theHash_SpecToResourceHashes = new HashMap<ResourceSpec, TreeSet>();
        for (int i = 0; i < inResources.length; ++i) {
            Resource theResource = inResources[i];
            TreeSet theResourcesByVersion = (TreeSet)theHash_SpecToResourceHashes.get(theResource.getResourceSpec());
            if (theResourcesByVersion == null) {
                theResourcesByVersion = this.makeVersionSortedTree();
                theHash_SpecToResourceHashes.put(theResource.getResourceSpec(), theResourcesByVersion);
            }
            theResourcesByVersion.add(theResource);
        }
        Iterator theIter = theHash_SpecToResourceHashes.entrySet().iterator();
        while (theIter.hasNext()) {
            Map.Entry theEntry = theIter.next();
            TreeSet theResourcesByVersionTree = (TreeSet)theEntry.getValue();
            Resource[] theDeletedResourcesByVers = theResourcesByVersionTree.toArray(new Resource[0]);
            this.prepareSingleTreeDeletes((ResourceSpec)theEntry.getKey(), theDeletedResourcesByVers);
        }
    }

    private TreeSet makeVersionSortedTree() {
        return new TreeSet(new Comparator(){

            public int compare(Object inA, Object inB) {
                VersionNumber theVersB;
                VersionNumber theVersA = ((Resource)inA).getVersionNumber();
                if (theVersA.isLessThan(theVersB = ((Resource)inB).getVersionNumber())) {
                    return -1;
                }
                if (theVersA.isGreaterThan(theVersB)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private synchronized void prepareSingleTreeDeletes(ResourceSpec inResourceSpec, Resource[] inDeletedResourcesByVers) throws ResourceException {
        RsrcInfo[] theExistingResourcesByVers;
        if (inDeletedResourcesByVers.length == 0) {
            return;
        }
        MultiRsrcInfoQuery theQuery = MultiRsrcInfoQuery.allVersionsOfOne(inResourceSpec);
        theQuery.setObjectOrder(RsrcInfoOrder.BY_VERSION_ASC);
        try {
            theExistingResourcesByVers = theQuery.select();
        }
        catch (RPCException e) {
            throw new ResourceException(e);
        }
        catch (PersistenceManagerException e) {
            throw new ResourceException(e);
        }
        RsrcInfo theNextExistingResource = null;
        ResourceID theNextHighestResourceID = null;
        int theExistIdx = theExistingResourcesByVers.length - 1;
        for (int theDelIdx = inDeletedResourcesByVers.length - 1; theDelIdx >= 0; --theDelIdx) {
            Resource theResourceToDelete = inDeletedResourcesByVers[theDelIdx];
            VersionNumber theDelVers = theResourceToDelete.getVersionNumber();
            while (theExistIdx >= 0 && !theExistingResourcesByVers[theExistIdx].getVersionNumber().isLessThan(theDelVers)) {
                theNextExistingResource = theExistingResourcesByVers[theExistIdx];
                theNextHighestResourceID = null;
                --theExistIdx;
            }
            if (theNextExistingResource != null && theNextHighestResourceID == null) {
                theNextHighestResourceID = theNextExistingResource.getResourceID();
            }
            File theRsrcDirToDelete = theResourceToDelete.toFile(this.mResourceSubsysImpl);
            this.transformOneResource(theResourceToDelete, theNextHighestResourceID);
            this.mScheduledRepoDeletes.add(new RsrcToDelete(theResourceToDelete.getResourceID(), theRsrcDirToDelete));
        }
    }

    private void transformOneResource(Resource inResourceToBeDeleted, ResourceID inNextHighestVersionID) throws ResourceException {
        if (inNextHighestVersionID == null) {
            return;
        }
        File theForwardedDataTmpRsrcDir = DeferredDeleteTable.moveDataForwardIfNeeded(this.mResourceSubsysImpl, inResourceToBeDeleted, inNextHighestVersionID);
        if (theForwardedDataTmpRsrcDir != null) {
            File theOutgoingTmpFile = null;
            try {
                theOutgoingTmpFile = File.createTempFile("Outgoing_", null);
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
            Resource theNextResource = this.mResourceSubsysImpl.getResource(inNextHighestVersionID, null);
            File theNextHighestRsrcDir = theNextResource.getInternalRepoFile(this.mResourceSubsysImpl);
            this.mScheduledSwaps.add(new ScheduledSwap(theNextHighestRsrcDir, theForwardedDataTmpRsrcDir, theOutgoingTmpFile, inNextHighestVersionID));
        }
    }

    public static File moveDataForwardIfNeeded(ResourceSubsysImpl inResourceSubsysImpl, final Resource inResourceBeingDeleted, final ResourceID inNextHighestResourceID) throws ResourceException {
        final VersionNumber theDeletedVersion = inResourceBeingDeleted.getVersionNumber();
        File theReformulatedFile = (File)new ResourceAccessor(inResourceSubsysImpl, null){
            private HashSet mExistingVersionSet;
            private HashMap mNextHighestCache;
            private VersionNumber[] mAllVersions;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object innerAccess() throws ResourceException {
                RsrcManifest theNextManifest = this.getManifest(inNextHighestResourceID, null);
                if (!theNextManifest.hasAnyBackRefs()) {
                    return null;
                }
                this.createVersionCaches(inResourceBeingDeleted.getResourceSpec());
                RsrcManifest theDelManifest = new RsrcManifest(Key.sKey, this, inResourceBeingDeleted.getResourceID());
                SegIter theNextHighestEntryIter = SegIter.makeIter(Key.sKey, theNextManifest);
                boolean needReformulation = false;
                while (theNextHighestEntryIter.hasMoreSubfilesWBackRefs()) {
                    SegEntry theNextEntry = theNextHighestEntryIter.getNextSubfileWBackRef();
                    VersionNumber theBackRef = theNextEntry.getBackRef();
                    if (!this.isBackRefRelevant(theBackRef, theDeletedVersion)) continue;
                    needReformulation = true;
                    break;
                }
                if (!needReformulation) {
                    return null;
                }
                MetaMetaData theNextMetaMetaData = theNextManifest.getMetaMetaData(Key.sKey);
                RsrcPacker theRsrcPacker = new RsrcPacker(null, theNextMetaMetaData.mResourceTopLevelName);
                try {
                    SegIter theNextIter = SegIter.makeIter(Key.sKey, theNextManifest);
                    while (theNextIter.hasMoreSubfiles()) {
                        InputStream theInputStream = null;
                        SegEntry theSegEntry = theNextIter.getNextSubfile();
                        VersionNumber theBackRef = theSegEntry.getBackRef();
                        if (this.isBackRefRelevant(theBackRef, theDeletedVersion)) {
                            theBackRef = null;
                            theInputStream = theDelManifest.getRawClusterStream(Key.sKey, theSegEntry.getRelPathWFwdSlashes());
                        } else if (theSegEntry.getType().equals(SubnodeType.FILE) && theBackRef == null) {
                            theInputStream = theNextManifest.getRawClusterStream(Key.sKey, theSegEntry.getRelPathWFwdSlashes());
                        }
                        theRsrcPacker.packEntryCluster(theSegEntry.getRelPathWFwdSlashes(), theSegEntry.getUncompressedFileSize(), theSegEntry.getSizePerCompressionSetting(), theSegEntry.getTime(), theSegEntry.getType(), theSegEntry.getPerms(), theSegEntry.getLinkTarget(), theSegEntry.getFileMd5PerCompressionSetting(), theSegEntry.getCompression(), theBackRef);
                        theRsrcPacker.packThenCloseDataStream(theInputStream, theSegEntry.getSizePerCompressionSetting());
                        Object var12_11 = null;
                        if (theInputStream == null) continue;
                        try {
                            theInputStream.close();
                            continue;
                        }
                        catch (IOException e) {
                            throw new ResourceException("rsrc.msg0473", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            var12_11 = null;
                            if (theInputStream == null) throw throwable;
                            try {
                                theInputStream.close();
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new ResourceException("rsrc.msg0473", (Throwable)e);
                            }
                            return theRsrcPacker.getWorkspaceDir();
                        }
                    }
                }
                finally {
                    theRsrcPacker.finish();
                }
            }

            private boolean isBackRefRelevant(VersionNumber inBackRef, VersionNumber inVersionBeingDeleted) throws ResourceException {
                if (inBackRef == null) {
                    return false;
                }
                if (inBackRef.equals(inVersionBeingDeleted)) {
                    return true;
                }
                if (inBackRef.isGreaterThan(inVersionBeingDeleted)) {
                    throw new ResourceException("rsrc.msg0474");
                }
                if (inBackRef.isLessThan(inVersionBeingDeleted)) {
                    if (this.mExistingVersionSet.contains(inBackRef)) {
                        return false;
                    }
                    VersionNumber theNextHighestVersion = (VersionNumber)this.mNextHighestCache.get(inBackRef);
                    if (theNextHighestVersion == null) {
                        for (int i = 0; i < this.mAllVersions.length; ++i) {
                            VersionNumber theCandidate = this.mAllVersions[i];
                            if (!theCandidate.isGreaterThan(inBackRef)) continue;
                            this.mNextHighestCache.put(inBackRef, theCandidate);
                            theNextHighestVersion = theCandidate;
                            break;
                        }
                    }
                    if (theNextHighestVersion == null) {
                        return false;
                    }
                    if (theNextHighestVersion.isGreaterThan(inVersionBeingDeleted) && inBackRef.isLessThan(inVersionBeingDeleted)) {
                        theNextHighestVersion = inVersionBeingDeleted;
                    }
                    return theNextHighestVersion.equals(inVersionBeingDeleted);
                }
                throw new ResourceException("rsrc.msg0475");
            }

            private void createVersionCaches(ResourceSpec inResourceSpec) throws ResourceException {
                RsrcInfo[] theRsrcInfos;
                MultiRsrcInfoQuery theQuery = MultiRsrcInfoQuery.allVersionsOfOne(inResourceSpec);
                theQuery.setObjectOrder(RsrcInfoOrder.BY_VERSION_ASC);
                try {
                    theRsrcInfos = theQuery.select();
                }
                catch (RPCException e) {
                    throw new ResourceException(e);
                }
                catch (PersistenceManagerException e) {
                    throw new ResourceException(e);
                }
                int theNumRsrcInfos = theRsrcInfos.length;
                this.mAllVersions = new VersionNumber[theNumRsrcInfos];
                this.mExistingVersionSet = new HashSet();
                this.mNextHighestCache = new HashMap();
                for (int i = 0; i < theNumRsrcInfos; ++i) {
                    VersionNumber theVersionNumber;
                    this.mAllVersions[i] = theVersionNumber = theRsrcInfos[i].getVersionNumber();
                    this.mExistingVersionSet.add(theVersionNumber);
                    if (i >= theNumRsrcInfos - 1) continue;
                    this.mNextHighestCache.put(theVersionNumber, theRsrcInfos[i + 1].getVersionNumber());
                }
            }
        }.access();
        return theReformulatedFile;
    }

    private static String makeDeleteKey(ResourceSpec inResourceSpec) {
        return "DELETE " + inResourceSpec.getName();
    }

    private static String makeCheckInKey(ResourceSpec inResourceSpec) {
        return "CHECKIN " + inResourceSpec.getName();
    }

    private static String makeLockKey(ResourceSpec inResourceSpec) {
        return "LOCK " + inResourceSpec.getName();
    }

    private static String makeMoveKey(ResourceSpec inResourceSpec) {
        return "MOVE " + inResourceSpec.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isCurrentlyOkForDeletion(ResourceSpec inResourceSpec) {
        Object object = sStringArbitrator.getSyncObject();
        synchronized (object) {
            if (sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeCheckInKey(inResourceSpec))) {
                return false;
            }
            if (sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeLockKey(inResourceSpec))) {
                return false;
            }
            return !sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeMoveKey(inResourceSpec));
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterDeleteWithinTree(ResourceSpec inResourceSpec) throws ResourceException {
        Object object = sStringArbitrator.getSyncObject();
        synchronized (object) {
            if (!DeferredDeleteTable.isCurrentlyOkForDeletion(inResourceSpec)) {
                throw new ResourceException("rsrc.RESOURCE_DELETE_CONFLICT", new Object[]{inResourceSpec});
            }
            sStringArbitrator.increment(DeferredDeleteTable.makeDeleteKey(inResourceSpec));
        }
        DeferredDeleteTable.postEnterDelete(inResourceSpec);
    }

    private static void leaveDeleteWithinTree(ResourceSpec inResourceSpec) {
        sStringArbitrator.decrement(DeferredDeleteTable.makeDeleteKey(inResourceSpec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enterLockWithinTree(ResourceSpec inResourceSpec, boolean inHonorDeleteLockMutex) throws ResourceException {
        Object object = sStringArbitrator.getSyncObject();
        synchronized (object) {
            if (inHonorDeleteLockMutex && sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeDeleteKey(inResourceSpec))) {
                throw new ResourceException("rsrc.msg0477", new Object[]{inResourceSpec});
            }
            if (sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeMoveKey(inResourceSpec))) {
                throw new ResourceException("rsrc.RESOURCE_MOVING_CONFLICT", new Object[]{inResourceSpec});
            }
            sStringArbitrator.increment(DeferredDeleteTable.makeLockKey(inResourceSpec));
        }
        DeferredDeleteTable.postEnterLock(inResourceSpec);
    }

    static void leaveLockWithinTree(ResourceSpec inResourceSpec) {
        sStringArbitrator.decrement(DeferredDeleteTable.makeLockKey(inResourceSpec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enterMoveWithinTrees(ResourceSpec inSrcSpec, ResourceSpec inDstSpec) throws ResourceException {
        DeferredDeleteTable.enterMoveWithinSingleTree(inSrcSpec);
        boolean didSecondSucceed = false;
        try {
            DeferredDeleteTable.enterMoveWithinSingleTree(inDstSpec);
            didSecondSucceed = true;
            Object var4_3 = null;
            if (!didSecondSucceed) {
                sStringArbitrator.decrement(DeferredDeleteTable.makeMoveKey(inSrcSpec));
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!didSecondSucceed) {
                sStringArbitrator.decrement(DeferredDeleteTable.makeMoveKey(inSrcSpec));
            }
            throw throwable;
        }
        DeferredDeleteTable.postEnterMove(inSrcSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterMoveWithinSingleTree(ResourceSpec inResourceSpec) throws ResourceException {
        Object object = sStringArbitrator.getSyncObject();
        synchronized (object) {
            if (sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeDeleteKey(inResourceSpec))) {
                throw new ResourceException("rsrc.msg0477", new Object[]{inResourceSpec});
            }
            if (sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeCheckInKey(inResourceSpec))) {
                throw new ResourceException("rsrc.RESOURCE_CHECKIN_CONFLICT", new Object[]{inResourceSpec});
            }
            if (sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeLockKey(inResourceSpec))) {
                throw new ResourceException("rsrc.RESOURCE_LOCK_CONFLICT", new Object[]{inResourceSpec});
            }
            sStringArbitrator.increment(DeferredDeleteTable.makeMoveKey(inResourceSpec));
        }
    }

    static void leaveMoveWithinTrees(ResourceSpec[] inSpecs) {
        for (int i = 0; i < inSpecs.length; ++i) {
            sStringArbitrator.decrement(DeferredDeleteTable.makeMoveKey(inSpecs[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterCheckInWithinTree(ResourceSpec inResourceSpec) throws ResourceException {
        Object object = sStringArbitrator.getSyncObject();
        synchronized (object) {
            if (sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeDeleteKey(inResourceSpec))) {
                throw new ResourceException("rsrc.msg0467", new Object[]{inResourceSpec});
            }
            if (sStringArbitrator.isNonZeroCount(DeferredDeleteTable.makeMoveKey(inResourceSpec))) {
                throw new ResourceException("rsrc.RESOURCE_MOVING_CONFLICT", new Object[]{inResourceSpec});
            }
            sStringArbitrator.increment(DeferredDeleteTable.makeCheckInKey(inResourceSpec));
        }
        DeferredDeleteTable.postEnterCheckIn(inResourceSpec);
    }

    private static void postEnterCheckIn(ResourceSpec inSpec) throws ResourceException {
        Executable theExec;
        if (sPostEnterCheckInExec != null && (theExec = sPostEnterCheckInExec.get(inSpec)) != null) {
            theExec.execute();
        }
    }

    private static void postEnterDelete(ResourceSpec inSpec) throws ResourceException {
        Executable theExec;
        if (sPostEnterDeleteExec != null && (theExec = sPostEnterDeleteExec.get(inSpec)) != null) {
            theExec.execute();
        }
    }

    private static void postEnterLock(ResourceSpec inSpec) throws ResourceException {
        Executable theExec;
        if (sPostEnterLockExec != null && (theExec = sPostEnterLockExec.get(inSpec)) != null) {
            theExec.execute();
        }
    }

    private static void postEnterMove(ResourceSpec inSpec) throws ResourceException {
        Executable theExec;
        if (sPostEnterMoveExec != null && (theExec = sPostEnterMoveExec.get(inSpec)) != null) {
            theExec.execute();
        }
    }

    public static void leaveCheckInWithinTree(ResourceSpec inResourceSpec) {
        sStringArbitrator.decrement(DeferredDeleteTable.makeCheckInKey(inResourceSpec));
    }

    static /* synthetic */ ResourceSubsysImpl access$000(DeferredDeleteTable x0) {
        return x0.mResourceSubsysImpl;
    }

    class ScheduledSwap {
        File mExistingRsrcDir;
        File mReformulatedRsrcDir;
        File mOutgoingTmpFile;
        ResourceID mResourceID;

        public ScheduledSwap(File inExistingRsrcDir, File inReformulatedRsrcDir, File inOutgoingTmpFile, ResourceID inResourceID) {
            this.mExistingRsrcDir = inExistingRsrcDir;
            this.mReformulatedRsrcDir = inReformulatedRsrcDir;
            this.mOutgoingTmpFile = inOutgoingTmpFile;
            this.mResourceID = inResourceID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void commit() throws ResourceException {
            var1_1 = DeferredDeleteTable.access$000(DeferredDeleteTable.this).getRepoContentSyncObj();
            synchronized (var1_1) {
                theSizeDiff = ResourceFileUtils.getBytesInDir(this.mReformulatedRsrcDir) - ResourceFileUtils.getBytesInDir(this.mExistingRsrcDir);
                ResourceFileUtils.deleteDirectory(this.mOutgoingTmpFile);
                ResourceFileUtils.moveData(this.mExistingRsrcDir, this.mOutgoingTmpFile);
                didMoveFile = false;
                try {
                    ResourceFileUtils.moveData(this.mReformulatedRsrcDir, this.mExistingRsrcDir);
                    didMoveFile = true;
                    var6_4 = null;
                    ** if (didMoveFile) goto lbl-1000
                }
                catch (Throwable var5_8) {
                    block11: {
                        var6_5 = null;
                        if (!didMoveFile) {
                            try {
                                ResourceFileUtils.deleteDirectory(this.mExistingRsrcDir);
                                ResourceFileUtils.moveData(this.mOutgoingTmpFile, this.mExistingRsrcDir);
                                ResourceFileUtils.deleteDirectory(this.mReformulatedRsrcDir);
                            }
                            catch (Throwable t) {
                                if (!Logger.isErrorEnabled(this)) break block11;
                                Logger.error("Unable to recover from failed data move", t, this);
                            }
                        }
                    }
                    throw var5_8;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        ResourceFileUtils.deleteDirectory(this.mExistingRsrcDir);
                        ResourceFileUtils.moveData(this.mOutgoingTmpFile, this.mExistingRsrcDir);
                        ResourceFileUtils.deleteDirectory(this.mReformulatedRsrcDir);
                    }
                    catch (Throwable t) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Unable to recover from failed data move", t, this);
                        }
                    }
                }
lbl-1000:
                // 4 sources

                {
                }
                DeferredDeleteTable.access$000(DeferredDeleteTable.this).adjustTotalRepoSize(theSizeDiff);
                Resource.resetCachedSize(this.mResourceID, DeferredDeleteTable.access$000(DeferredDeleteTable.this));
            }
        }

        public void rescind() throws ResourceException {
            ResourceFileUtils.deleteDirectory(this.mReformulatedRsrcDir);
            ResourceFileUtils.deleteDirectory(this.mOutgoingTmpFile);
        }
    }

    static class RsrcToDelete {
        public final ResourceID mResourceID;
        public final File mRsrcDirToDelete;

        RsrcToDelete(ResourceID inResourceID, File inRsrcDirToDelete) {
            this.mResourceID = inResourceID;
            this.mRsrcDirToDelete = inRsrcDirToDelete;
        }

        public String toString() {
            return "ResourceID=" + this.mResourceID + " dir=" + this.mRsrcDirToDelete;
        }
    }

    static class SpecExecMap {
        private HashMap mHashMap = new HashMap();

        SpecExecMap() {
        }

        public int size() {
            return this.mHashMap.size();
        }

        public synchronized void put(ResourceSpec inSpec, Executable inExec) {
            if (inExec == null) {
                this.mHashMap.remove(inSpec);
            } else {
                this.mHashMap.put(inSpec, inExec);
            }
        }

        public synchronized Executable get(ResourceSpec inSpec) {
            return (Executable)this.mHashMap.get(inSpec);
        }
    }
}

