/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.FileMover;
import com.raplix.rolloutexpress.resource.RemoteResourceMgr;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.checkInJob.CLIRemoteCheckInInterface;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInInterface;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.ui.Context;

public class CliRsrcData {
    private RemoteResourceMgr mRemoteResourceMgr = null;
    private FileMover mFileMover = null;
    private RoxAddress mServerAddress = null;
    private Application mApp = null;
    private CheckInInterface mCheckInInterface = null;

    public CliRsrcData(RoxAddress inServerAddress, Application inApplication, FileMover inFileMover) throws ResourceException, RPCException {
        this.mServerAddress = inServerAddress;
        this.mApp = inApplication;
        NetSubsystem theNetSubsystem = this.mApp.getNetSubsystem();
        try {
            this.mRemoteResourceMgr = (RemoteResourceMgr)theNetSubsystem.getRPC().getLocalService(this.mServerAddress, RemoteResourceMgr.class);
        }
        catch (RPCException ex) {
            throw new ResourceException("rsrc.msg0014", (Throwable)ex);
        }
        this.mFileMover = inFileMover;
        this.mCheckInInterface = new CLICheckInInterface(this.mFileMover, theNetSubsystem);
        inApplication.getNetSubsystem().getRPC().registerService(CLIRemoteCheckInInterface.class, this.mCheckInInterface);
    }

    public CliRsrcData() throws ResourceException, RPCException {
        this(Context.getServerAddress(), Context.getApp(), new FileMover(23, Context.getApp()));
    }

    public RsrcInfo getRsrcInfo(String inResourceName, VersionNumber inVersionNumber) throws RPCException, ResourceException {
        ResourceSpec theResourceSpec = new ResourceSpec(inResourceName);
        if (inVersionNumber == null) {
            RsrcInfo theRsrcInfo = this.mRemoteResourceMgr.checkForMostRecentVersion(theResourceSpec);
            if (theRsrcInfo == null) {
                throw new ResourceNotLocalException("rsrc.msg0020", new Object[]{inResourceName});
            }
            return theRsrcInfo;
        }
        return new RsrcInfo(this.mRemoteResourceMgr.getResource(theResourceSpec, inVersionNumber, null));
    }

    public ResourceEntry getTopResourceEntry(ResourceID inResourceID) throws RPCException, ResourceException {
        return this.mRemoteResourceMgr.getTopResourceEntry(inResourceID);
    }

    public RemoteResourceMgr getRemoteResourceMgr() {
        return this.mRemoteResourceMgr;
    }

    public RsrcInfo getRsrcInfo(ResourceID inResourceID) throws ResourceException, RPCException {
        return new RsrcInfo(this.mRemoteResourceMgr.getResource(inResourceID, null));
    }

    class CLICheckInInterface
    extends CheckInInterface
    implements CLIRemoteCheckInInterface {
        CLICheckInInterface(FileMover inFileMover, NetSubsystem inNetworkSubsys) {
            super(inFileMover, inNetworkSubsys);
        }

        public RemoteResourceMgr getMSRsrcMgr() throws ResourceException {
            return CliRsrcData.this.mRemoteResourceMgr;
        }
    }
}

