/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.resource.DirPath;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceIOException;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import java.io.File;

public class AbsoluteFileSpec
implements RPCSerializable {
    private DirPath mAbsDirPath;
    private String mFileName;

    private AbsoluteFileSpec() {
    }

    public AbsoluteFileSpec(DirPath inAbsDirPath, String inFileName) throws ResourceException {
        if (inAbsDirPath == null || inFileName == null) {
            throw new ResourceException("rsrc.msg0001");
        }
        this.mAbsDirPath = inAbsDirPath;
        this.mFileName = inFileName;
        if (!this.mAbsDirPath.isAbsolute()) {
            throw new ResourceException("rsrc.msg0002");
        }
    }

    public AbsoluteFileSpec(String inFilePathAndName) throws ResourceException {
        if (inFilePathAndName.length() == 0) {
            throw new ResourceException("rsrc.msg0003");
        }
        String theUniversalString = FileSpec.convertPathSeparatorToUniversal(inFilePathAndName);
        if (ResourceStringUtils.endsInSeparator(theUniversalString)) {
            throw new ResourceException("rsrc.msg0004", (Object[])new String[]{inFilePathAndName});
        }
        File theAbsFile = new File(inFilePathAndName).getAbsoluteFile();
        this.mAbsDirPath = new DirPath(theAbsFile.getParentFile().getAbsolutePath());
        this.mFileName = theAbsFile.getName();
        if (!this.mAbsDirPath.isAbsolute()) {
            throw new ResourceException("rsrc.msg0005");
        }
    }

    public AbsoluteFileSpec(File inFile) throws ResourceException {
        this(inFile.toString());
    }

    public DirPath getAbsDirPath() {
        return this.mAbsDirPath;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public File toFile() {
        return new File(this.mAbsDirPath.toLocal() + this.mFileName);
    }

    public void mkdirs() throws ResourceIOException {
        this.mAbsDirPath.mkdirs();
    }

    public boolean equals(Object inObj) {
        if (inObj == null || !(inObj instanceof AbsoluteFileSpec)) {
            return false;
        }
        AbsoluteFileSpec theOther = (AbsoluteFileSpec)inObj;
        return this.mFileName.equals(theOther.mFileName) && this.mAbsDirPath.equals(theOther.mAbsDirPath);
    }

    public int hashCode() {
        return this.mAbsDirPath.hashCode() + this.mFileName.hashCode();
    }
}

