/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.plugin;

import com.raplix.rolloutexpress.plugin.PluginMessage;
import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PluginMessageHelper {
    private static PluginMessageHelper sHelper = new PluginMessageHelper();
    private InheritableThreadLocal mCurrentBundle = new InheritableThreadLocal();
    private static final String MESSAGE_RESOURCE = "resources/messages";
    public static final String MESSAGE_NOT_FOUND = "The proper message could not be displayed.";

    public String getMessageValue(String key) {
        ResourceBundle bundle = (ResourceBundle)this.mCurrentBundle.get();
        if (bundle == null) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("No message bundle for key:" + key, this);
            }
            return null;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("No message for key:" + key, mre, this);
            }
            return null;
        }
    }

    public void init(ClassLoader inCurrentLoader) {
        block2: {
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(MESSAGE_RESOURCE, MessageManager.getDefaultLocale(), inCurrentLoader);
                this.mCurrentBundle.set(bundle);
            }
            catch (MissingResourceException mre) {
                if (!Logger.isWarnEnabled(PluginMessage.class)) break block2;
                Logger.warn("No messages file found:", mre, PluginMessage.class);
            }
        }
    }

    public void initTest(ResourceBundle inBundle) {
        this.mCurrentBundle.set(inBundle);
    }

    public void done() {
        this.mCurrentBundle.set(null);
    }

    public static PluginMessageHelper getInstance() {
        return sHelper;
    }

    private PluginMessageHelper() {
    }
}

