/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.plugin;

import com.raplix.util.file.CopyUtil;
import com.raplix.util.filecache.Resolver;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class PluginClassLoader
extends URLClassLoader {
    private Resolver mResolver;
    static final String NATIVE_LIB_LOADER = "com.raplix.rolloutexpress.plugin.NativeLibLoader";

    PluginClassLoader(URL[] urls, ClassLoader parent, Resolver inResolver) {
        super(urls, parent);
        this.mResolver = inResolver;
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        if (NATIVE_LIB_LOADER.equals(name)) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String fileName = name.replace('.', '/') + ".bin";
                        byte[] classBytes = null;
                        InputStream is = PluginClassLoader.this.getResourceAsStream(fileName);
                        classBytes = CopyUtil.readBinary(is);
                        return PluginClassLoader.this.defineClass(name, classBytes, 0, classBytes.length, this.getClass().getProtectionDomain());
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new ClassNotFoundException(name, e.getCause());
            }
        }
        return super.findClass(name);
    }

    Resolver getResolver() {
        return this.mResolver;
    }
}

