/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.plugin;

import com.raplix.rolloutexpress.plugin.NativeLibLoadException;
import com.raplix.rolloutexpress.plugin.PluginClassLoader;
import com.raplix.util.logger.Logger;
import com.sun.n1.sps.plugin.AgentContext;
import com.sun.n1.sps.plugin.execjava.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LocalAgentContext
implements AgentContext {
    private ClassLoader mClassLoader;

    public void loadLibrary(String libraryPath) throws ExecutionException {
        try {
            PluginClassLoader classLoader = (PluginClassLoader)this.mClassLoader;
            String file = this.getCachedFile(libraryPath);
            Class<?> loaderClass = classLoader.loadClass("com.raplix.rolloutexpress.plugin.NativeLibLoader");
            Method method = loaderClass.getDeclaredMethod("loadLibrary", String.class);
            method.setAccessible(true);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Loading native library:" + file, this);
            }
            method.invoke(null, file);
        }
        catch (IllegalArgumentException e) {
            throw new NativeLibLoadException(libraryPath, (Throwable)e);
        }
        catch (IOException e) {
            throw new NativeLibLoadException(libraryPath, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new NativeLibLoadException(libraryPath, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new NativeLibLoadException(libraryPath, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NativeLibLoadException(libraryPath, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new NativeLibLoadException(libraryPath, e.getCause());
        }
    }

    public String loadResource(String resourcePath) throws ExecutionException {
        try {
            return this.getCachedFile(resourcePath);
        }
        catch (Exception e) {
            throw new NativeLibLoadException(resourcePath, (Throwable)e);
        }
    }

    private String getCachedFile(String resourcePath) throws IOException {
        File file = new File(resourcePath);
        PluginClassLoader classLoader = (PluginClassLoader)this.mClassLoader;
        if (classLoader.getResolver() != null) {
            file = classLoader.getResolver().getCachedDirResource(file);
        }
        return file.getAbsolutePath();
    }

    public LocalAgentContext(ClassLoader inClassLoader) {
        this.mClassLoader = inClassLoader;
    }
}

