/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.plugin;

import com.raplix.rolloutexpress.command.CommandMessages;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.plugin.PluginClassLoader;
import com.raplix.util.cache.Cache;
import com.raplix.util.cache.DelegatingRefWrapper;
import com.raplix.util.cache.RefWrapper;
import com.raplix.util.cache.RefWrapperFactory;
import com.raplix.util.cache.ValueFactory;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Compare;
import com.raplix.util.exceptions.WrapperRuntimeException;
import com.raplix.util.filecache.FileCache;
import com.raplix.util.filecache.Resolver;
import com.raplix.util.filecache.SerializableKey;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class LoaderCache
implements CommandMessages {
    private Cache mCache;

    public LoaderCache(Cache cache) {
        this.mCache = cache;
    }

    public URLClassLoader get(FileCache fileCache, File[] jars) throws CommandExecutionErrorException {
        try {
            return (URLClassLoader)this.mCache.get(new Key(jars), new LoaderFactory(fileCache, jars));
        }
        catch (LoaderException ex) {
            throw (CommandExecutionErrorException)ex.getRaw();
        }
    }

    public void clear() {
        this.mCache.clear();
    }

    public int getSize() {
        return this.mCache.getSize();
    }

    private class LoaderFactory
    implements RefWrapperFactory,
    ValueFactory {
        private FileCache mFileCache;
        private File[] mJars;
        private Resolver mResolver;

        LoaderFactory(FileCache fileCache, File[] jars) {
            this.mFileCache = fileCache;
            this.mJars = jars;
        }

        public Object createValue(Object key) {
            ClassLoader parent;
            if (this.mFileCache == null) {
                this.mResolver = null;
                parent = this.getClass().getClassLoader();
            } else {
                this.mResolver = this.mFileCache.createResolver(key);
                parent = this.mResolver.getClass().getClassLoader();
            }
            URL[] urls = new URL[this.mJars.length];
            for (int i = 0; i < this.mJars.length; ++i) {
                File file = this.mJars[i];
                if (this.mResolver != null) {
                    try {
                        file = this.mResolver.getCachedFile(file);
                    }
                    catch (IOException ex) {
                        throw new LoaderException(new CommandExecutionErrorException(new ROXMessage("cmd.ERR_EJAVA_CLASSPATH_CACHE_ERROR", file.getName()), (Throwable)ex));
                    }
                }
                try {
                    urls[i] = file.toURL();
                    continue;
                }
                catch (MalformedURLException ex) {
                    throw new LoaderException(new CommandExecutionErrorException(new ROXMessage("cmd.ERR_EJAVA_CLASSPATH_INCORRECT_ENTRY", file.getName()), (Throwable)ex));
                }
            }
            LoaderCache.this.mCache.reclaim();
            return new PluginClassLoader(urls, parent, this.mResolver);
        }

        public RefWrapper createWrapper(RefWrapperFactory factory, Object key, Object value, ReferenceQueue queue) {
            return new Wrapper(factory.createWrapper(null, key, value, queue), this.mResolver);
        }
    }

    private static class Wrapper
    extends DelegatingRefWrapper {
        private Resolver mResolver;

        Wrapper(RefWrapper wrapper, Resolver resolver) {
            super(wrapper);
            this.mResolver = resolver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.mResolver != null) {
                    this.mResolver.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }

    private static class LoaderException
    extends WrapperRuntimeException {
        LoaderException(CommandExecutionErrorException ex) {
            super(ex);
        }
    }

    private static class Key
    implements SerializableKey {
        private FileSignature[] mJars;

        Key(File[] jars) {
            this.mJars = new FileSignature[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                this.mJars[i] = new FileSignature(jars[i]);
            }
        }

        FileSignature[] getJars() {
            return this.mJars;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            return Compare.isEqual(this.getJars(), ((Key)o).getJars());
        }

        public int hashCode() {
            return CollectionUtil.hashCode(this.getJars());
        }

        public String toString() {
            return CollectionUtil.toString(this.getJars());
        }

        public boolean isCurrent() {
            File[] files = new File[this.mJars.length];
            for (int i = 0; i < files.length; ++i) {
                files[i] = this.mJars[i].getFile();
            }
            return this.equals(new Key(files));
        }
    }

    private static class FileSignature
    implements Serializable {
        private File mFile;
        private long mLastModified;
        private long mLength;

        FileSignature(File file) {
            this.mFile = file;
            this.mLastModified = file.lastModified();
            this.mLength = file.length();
        }

        File getFile() {
            return this.mFile;
        }

        long getLastModified() {
            return this.mLastModified;
        }

        long getLength() {
            return this.mLength;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            FileSignature f = (FileSignature)o;
            return this.getLength() == f.getLength() && this.getLastModified() == f.getLastModified() && this.getFile().equals(f.getFile());
        }

        public int hashCode() {
            return (int)(this.getLength() + this.getLastModified() + (long)this.getFile().hashCode());
        }

        public String toString() {
            return "(" + this.getFile().getName() + "," + this.getLength() + "," + this.getLastModified() + ")";
        }
    }
}

