/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.plugin;

import java.io.IOException;
import java.io.OutputStream;

public class FixedSizeByteArrayOutputStream
extends OutputStream {
    private int mOffset = 0;
    private int mTotalSize = 0;
    private boolean mWrapped = false;
    private final int mMaxSize;
    private byte[] mBuffer = null;

    public FixedSizeByteArrayOutputStream(int inMaxSize) {
        this.mMaxSize = inMaxSize;
        this.mBuffer = new byte[Math.min(inMaxSize, 32)];
    }

    public void write(int b) throws IOException {
        byte[] ba = new byte[]{(byte)b};
        this.write(ba, 0, ba.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int available;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.mTotalSize += len;
        if (len > this.mMaxSize) {
            off += len - this.mMaxSize;
            len = this.mMaxSize;
        }
        if (len <= (available = this.mBuffer.length - this.mOffset)) {
            System.arraycopy(b, off, this.mBuffer, this.mOffset, len);
            this.mOffset += len;
        } else {
            if (this.mBuffer.length < this.mMaxSize) {
                int newBufSz;
                if (len < this.mMaxSize - this.mOffset) {
                    int spaceNeeded = this.mOffset + len;
                    for (newBufSz = this.mBuffer.length; newBufSz < spaceNeeded; newBufSz <<= 1) {
                    }
                    newBufSz = Math.min(newBufSz, this.mMaxSize);
                } else {
                    newBufSz = this.mMaxSize;
                }
                byte[] newbuf = new byte[this.mMaxSize];
                System.arraycopy(this.mBuffer, 0, newbuf, 0, this.mOffset);
                this.mBuffer = newbuf;
            }
            if (len <= (available = this.mBuffer.length - this.mOffset)) {
                System.arraycopy(b, off, this.mBuffer, this.mOffset, len);
                this.mOffset += len;
            } else {
                System.arraycopy(b, off, this.mBuffer, this.mOffset, available);
                this.mOffset = len - available;
                System.arraycopy(b, off + available, this.mBuffer, 0, this.mOffset);
                this.mWrapped = true;
            }
        }
    }

    public int getTotalSize() {
        return this.mTotalSize;
    }

    public synchronized byte[] toByteArray() {
        byte[] bArray;
        if (this.mWrapped) {
            bArray = new byte[this.mMaxSize];
            System.arraycopy(this.mBuffer, this.mOffset, bArray, 0, this.mMaxSize - this.mOffset);
            System.arraycopy(this.mBuffer, 0, bArray, this.mMaxSize - this.mOffset, this.mOffset);
        } else {
            bArray = new byte[this.mOffset];
            System.arraycopy(this.mBuffer, 0, bArray, 0, this.mOffset);
        }
        return bArray;
    }
}

