/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.plugin;

import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.plugin.PluginMessage;

public class ExecutionException
extends CommandExecutionErrorException {
    private Severity mSeverity = Severity.ERROR;
    private boolean mNestedInterrupted = false;

    public ExecutionException(PluginMessage inMessage) {
        super(ExecutionException.getROXMessage(inMessage));
    }

    public ExecutionException(PluginMessage inMessage, Severity inSeverity) {
        super(ExecutionException.getROXMessage(inMessage));
        this.mSeverity = inSeverity;
    }

    public ExecutionException(PluginMessage inMessage, Throwable inThrowable) {
        super(ExecutionException.getROXMessage(inMessage), inThrowable);
    }

    public ExecutionException(PluginMessage inMessage, Throwable inThrowable, Severity inSeverity) {
        this(inMessage, inThrowable);
        this.mSeverity = inSeverity;
    }

    ExecutionException(com.sun.n1.sps.plugin.execjava.ExecutionException inCause) {
        super(new ROXMessage("cmd.MSG_EJAVA_ERROR"), (Throwable)inCause, 2);
        this.mSeverity = (Severity)inCause.getSeverity();
        Throwable nested = inCause.getCause();
        if (nested != null && ExecutionException.isInterruptedException(nested)) {
            this.mNestedInterrupted = true;
        }
    }

    public Severity getSeverity() {
        return this.mSeverity;
    }

    public boolean getIsInterrupted() {
        return super.getIsInterrupted() || this.mNestedInterrupted;
    }

    ExecutionException(ROXMessage msg) {
        super(msg);
    }

    protected ExecutionException() {
    }

    private static ROXMessage getROXMessage(PluginMessage inMsg) {
        return new ROXMessage("cmd.MSG_EJAVA_ERROR", inMsg.toString());
    }
}

