/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.plugin;

import [Ljava.io.File;;
import com.raplix.rolloutexpress.Agent;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.CommandMessages;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.rpcinterfaces.ExecJavaStepDescriptor;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.task.ExecJavaTaskExecutor;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.OutputGeneratorStep;
import com.raplix.rolloutexpress.executor.task.OutputGeneratorStepExecManager;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.plugin.ActualAgentContext;
import com.raplix.rolloutexpress.plugin.ClassLoadingException;
import com.raplix.rolloutexpress.plugin.ExecutionException;
import com.raplix.rolloutexpress.plugin.Executor;
import com.raplix.rolloutexpress.plugin.ExecutorFactory;
import com.raplix.rolloutexpress.plugin.LoaderCache;
import com.raplix.rolloutexpress.plugin.LocalAgentContext;
import com.raplix.rolloutexpress.plugin.PluginMessageHelper;
import com.raplix.rolloutexpress.plugin.PreflightAgentContext;
import com.raplix.util.cache.Cache;
import com.raplix.util.cache.SoftRefWrapper;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.filecache.FileCache;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExecJavaExecutor
implements OutputGeneratorStep,
CommandMessages {
    private ExecNativeOutput mFinalOutput;
    private ExecJavaStepDescriptor mJava;
    private ActualAgentContext mActualContext;
    private Application mAgent;
    private FileCache mFileCache;
    private static LoaderCache sLoaderCache;
    public static final String CLASSPATH_DELIMITER = ";";

    public ExecJavaExecutor(Application inAgent, ExecJavaStepDescriptor inJava) {
        this.mAgent = inAgent;
        this.mJava = inJava;
        if (inAgent instanceof Agent) {
            this.mFileCache = ((Agent)inAgent).getExecJavaFileCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws CommandExecutionErrorException {
        ExecutorHandler handler = null;
        Class factoryClass = null;
        try {
            try {
                try {
                    factoryClass = ExecJavaExecutor.loadClass(this.mJava.getClasspath(), this.mJava.getFactoryName(), true, this.mFileCache);
                    handler = ExecutorHandler.createInstance(factoryClass.newInstance());
                }
                catch (ClassCastException se) {
                    throw new ClassLoadingException(this.mJava.getClasspath(), (Throwable)se);
                }
                catch (ClassNotFoundException se) {
                    throw new ClassLoadingException(this.mJava.getClasspath(), (Throwable)se);
                }
                catch (LinkageError le) {
                    throw new ClassLoadingException(this.mJava.getClasspath(), (Throwable)le);
                }
                catch (InstantiationException se) {
                    throw new ClassLoadingException(this.mJava.getClasspath(), (Throwable)se);
                }
                catch (SecurityException se) {
                    throw new ClassLoadingException(this.mJava.getClasspath(), (Throwable)se);
                }
                catch (IllegalAccessException se) {
                    throw new ClassLoadingException(this.mJava.getClasspath(), (Throwable)se);
                }
                Thread.currentThread().setContextClassLoader(factoryClass.getClassLoader());
                VariableSettingsSource arguments = handler.verifyParms(this.mJava.getArgValues());
                LocalAgentContext agentContext = new LocalAgentContext(factoryClass.getClassLoader());
                if (RunLevel.ACTUAL.equals(this.mJava.getRunLevel())) {
                    try {
                        OutputGeneratorStepExecManager ogsem = this.mAgent.getNativeSubsystem().getOGStepManager();
                        this.mActualContext = new ActualAgentContext(arguments, this.mJava.getMaxSnapshotBytes());
                        if (!handler.initActual(this.mActualContext, agentContext)) {
                            throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_EJAVA_NULL_EXECUTOR", this.mJava.getRunLevel().toString()));
                        }
                        ExecutionException errors = null;
                        try {
                            try {
                                ExecJavaTaskExecutor.stepStarted(ogsem, this);
                                ActualAgentContext.execJavaStarted(this.mJava);
                                handler.execute();
                            }
                            catch (ExecutionException ee) {
                                errors = ee;
                                Object var9_18 = null;
                                ExecJavaExecutor execJavaExecutor = this;
                                execJavaExecutor.mActualContext.execJavaDone();
                                ExecJavaTaskExecutor.stepCompleted(ogsem, this);
                                this.mActualContext.appendError(errors);
                                this.mFinalOutput = this.snapshotStreams();
                                ExecJavaTaskExecutor.stepFailed(this.mFinalOutput, errors);
                            }
                            Object var9_17 = null;
                            ExecJavaExecutor execJavaExecutor = this;
                        }
                        catch (Throwable throwable) {
                            Object var9_19 = null;
                            ExecJavaExecutor execJavaExecutor = this;
                            execJavaExecutor.mActualContext.execJavaDone();
                            ExecJavaTaskExecutor.stepCompleted(ogsem, this);
                            this.mActualContext.appendError(errors);
                            this.mFinalOutput = this.snapshotStreams();
                            ExecJavaTaskExecutor.stepFailed(this.mFinalOutput, errors);
                            throw throwable;
                        }
                        execJavaExecutor.mActualContext.execJavaDone();
                        ExecJavaTaskExecutor.stepCompleted(ogsem, this);
                        this.mActualContext.appendError(errors);
                        this.mFinalOutput = this.snapshotStreams();
                        ExecJavaTaskExecutor.stepFailed(this.mFinalOutput, errors);
                    }
                    catch (UnsupportedSubsystemException use) {
                        throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_EJAVA_SYSTEM"), (Throwable)use);
                    }
                } else {
                    if (!RunLevel.PREFLIGHT.equals(this.mJava.getRunLevel())) throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_EJAVA_RUNLEVEL_UNKNOWN", this.mJava.getRunLevel().toString()));
                    PreflightAgentContext ctx = new PreflightAgentContext(arguments);
                    if (!handler.initPreflight(ctx, agentContext)) {
                        throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_EJAVA_NULL_EXECUTOR", this.mJava.getRunLevel().toString()));
                    }
                    try {
                        PreflightAgentContext.execJavaStarted(this.mJava);
                        handler.execute();
                        this.mFinalOutput = new ExecNativeOutput(this.mJava.getTaskID(), this.mJava.getTargetID(), this.mJava.getStepID());
                    }
                    finally {
                        ctx.execJavaDone();
                    }
                }
                Object var12_23 = null;
                PluginMessageHelper.getInstance().done();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                return;
            }
            catch (CommandExecutionErrorException ceee) {
                throw ceee;
            }
            catch (Throwable th) {
                throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_EJAVA_UNEXPECTED_ERR"), th);
            }
        }
        catch (Throwable throwable) {
            Object var12_24 = null;
            PluginMessageHelper.getInstance().done();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            throw throwable;
        }
    }

    public TaskID getTaskID() {
        return this.mJava.getTaskID();
    }

    public StepID getStepID() {
        return this.mJava.getStepID();
    }

    public ExecNativeOutput snapshotStreams() {
        if (this.mActualContext != null) {
            return this.mActualContext.getCurrentOutput(this.mJava.getTaskID(), this.mJava.getTargetID(), this.mJava.getStepID());
        }
        return null;
    }

    public static Class loadClass(String classpath, String className, boolean initPluginMessages, FileCache fileCache) throws ClassNotFoundException, CommandExecutionErrorException {
        ClassLoader loader = ExecJavaExecutor.getClassLoader(classpath, fileCache);
        if (initPluginMessages) {
            PluginMessageHelper.getInstance().init(loader);
        }
        return loader.loadClass(className);
    }

    public static ClassLoader getClassLoader(String classpath, FileCache fileCache) throws CommandExecutionErrorException {
        if (!StringUtil.isEmpty(classpath)) {
            StringTokenizer strTok = new StringTokenizer(classpath, CLASSPATH_DELIMITER);
            Vector<File> files = new Vector<File>();
            while (strTok.hasMoreTokens()) {
                String token = strTok.nextToken();
                File file = ExecJavaExecutor.getJarFile(token);
                if (file == null) continue;
                files.add(file);
            }
            if (!files.isEmpty()) {
                return ExecJavaExecutor.getLoaderCache().get(fileCache, (File[])CollectionUtil.mapClass(files, File;.class));
            }
        }
        return ExecJavaExecutor.class.getClassLoader();
    }

    private static File getJarFile(String jarName) throws CommandExecutionErrorException {
        if (!jarName.endsWith(".jar")) {
            ROXMessage msg = new ROXMessage("cmd.ERR_EJAVA_CLASSPATH_NOT_JAR", jarName);
            throw new CommandExecutionErrorException(msg);
        }
        File file = new File(jarName);
        if (!file.isAbsolute()) {
            ROXMessage msg = new ROXMessage("cmd.ERR_EJAVA_CLASSPATH_NOT_ABS", jarName);
            throw new CommandExecutionErrorException(msg);
        }
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    private static VariableSettingsSource verifyParms(com.sun.n1.util.vars.VariableSettingsSource inDefaultVSS, VariableSettingsSource inActualVSS) throws CommandExecutionErrorException {
        if (inDefaultVSS == null) {
            return new VariableSettingsHolder();
        }
        VariableSettingsHolder args = null;
        String[] parms = inDefaultVSS.getVarNames();
        for (int i = 0; i < parms.length; ++i) {
            if (inActualVSS.containsVarValue(parms[i])) continue;
            if (!inDefaultVSS.containsVarValue(parms[i])) {
                throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_EJAVA_PARAMETER_MISSING", parms[i]));
            }
            if (args == null) {
                args = new VariableSettingsHolder(inActualVSS);
            }
            args.setVarValue(parms[i], inDefaultVSS.getVarValue(parms[i]));
        }
        return args == null ? inActualVSS : args;
    }

    public ExecNativeOutput getFinalOutput() {
        return this.mFinalOutput;
    }

    public static void setLoaderCache(Cache baseCache) {
        sLoaderCache = new LoaderCache(baseCache);
    }

    public static LoaderCache getLoaderCache() {
        return sLoaderCache;
    }

    static {
        ExecJavaExecutor.setLoaderCache(SoftRefWrapper.getCache());
    }

    private static class Pre5_0ExecutorHandler
    extends ExecutorHandler {
        private ExecutorFactory mFactory;
        private Executor mExecutor = null;

        public Pre5_0ExecutorHandler(ExecutorFactory inFactory) {
            this.mFactory = inFactory;
        }

        VariableSettingsSource verifyParms(VariableSettingsSource inActualArgs) throws CommandExecutionErrorException {
            return ExecJavaExecutor.verifyParms(this.mFactory.getParams(), inActualArgs);
        }

        boolean initPreflight(PreflightAgentContext inPreflight, LocalAgentContext inAgentContext) throws ExecutionException {
            this.mExecutor = this.mFactory.getPreflightExecutor(inPreflight);
            return this.mExecutor != null;
        }

        boolean initActual(ActualAgentContext inPreflight, LocalAgentContext inAgentContext) {
            this.mExecutor = this.mFactory.getActualExecutor(inPreflight);
            return this.mExecutor != null;
        }

        void execute() throws ExecutionException {
            this.mExecutor.execute();
        }
    }

    private static class CurrentExecutorHandler
    extends ExecutorHandler {
        private com.sun.n1.sps.plugin.execjava.ExecutorFactory mFactory;
        private com.sun.n1.sps.plugin.execjava.Executor mExecutor = null;

        public CurrentExecutorHandler(com.sun.n1.sps.plugin.execjava.ExecutorFactory inFactory) {
            this.mFactory = inFactory;
        }

        VariableSettingsSource verifyParms(VariableSettingsSource inActualArgs) throws CommandExecutionErrorException {
            return ExecJavaExecutor.verifyParms(this.mFactory.getParams(), inActualArgs);
        }

        boolean initPreflight(PreflightAgentContext inPreflight, LocalAgentContext inAgentContext) {
            this.mExecutor = this.mFactory.getPreflightExecutor(inAgentContext, inPreflight);
            return this.mExecutor != null;
        }

        boolean initActual(ActualAgentContext inPreflight, LocalAgentContext inAgentContext) {
            this.mExecutor = this.mFactory.getActualExecutor(inAgentContext, inPreflight);
            return this.mExecutor != null;
        }

        void execute() throws ExecutionException {
            try {
                this.mExecutor.execute();
            }
            catch (com.sun.n1.sps.plugin.execjava.ExecutionException e) {
                throw new ExecutionException(e);
            }
        }
    }

    private static abstract class ExecutorHandler {
        private ExecutorHandler() {
        }

        abstract VariableSettingsSource verifyParms(VariableSettingsSource var1) throws CommandExecutionErrorException;

        abstract boolean initPreflight(PreflightAgentContext var1, LocalAgentContext var2) throws ExecutionException;

        abstract boolean initActual(ActualAgentContext var1, LocalAgentContext var2);

        abstract void execute() throws ExecutionException;

        static ExecutorHandler createInstance(Object inFactoryInstance) {
            if (inFactoryInstance instanceof ExecutorFactory) {
                return new Pre5_0ExecutorHandler((ExecutorFactory)inFactoryInstance);
            }
            if (inFactoryInstance instanceof com.sun.n1.sps.plugin.execjava.ExecutorFactory) {
                return new CurrentExecutorHandler((com.sun.n1.sps.plugin.execjava.ExecutorFactory)inFactoryInstance);
            }
            return null;
        }
    }
}

