/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.plugin;

import com.raplix.rolloutexpress.command.rpcinterfaces.ExecJavaStepDescriptor;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.plugin.ExecutionTimeoutException;
import com.raplix.util.threads.SafeThread;
import com.sun.n1.sps.plugin.execjava.ExecJavaContext;

public class AgentContext
implements ExecJavaContext {
    private VariableSettingsSource mVariables;
    private static ThreadLocal mTimerThreads = new ThreadLocal();

    AgentContext(VariableSettingsSource inVariables) {
        this.mVariables = inVariables;
    }

    public VariableSettingsSource getVariables() {
        return this.mVariables;
    }

    public com.sun.n1.util.vars.VariableSettingsSource getVariableSettings() {
        return this.mVariables;
    }

    public static void testTimeout() throws ExecutionTimeoutException {
        ExecJavaTimer timer = AgentContext.isTimedOut();
        if (timer != null) {
            throw new ExecutionTimeoutException(timer.getTimeoutSeconds());
        }
    }

    private static ExecJavaTimer isTimedOut() {
        if (Thread.interrupted()) {
            return (ExecJavaTimer)mTimerThreads.get();
        }
        return null;
    }

    public void checkTimeout() throws com.sun.n1.sps.plugin.execjava.ExecutionTimeoutException {
        ExecJavaTimer timer = AgentContext.isTimedOut();
        if (timer != null) {
            throw new com.sun.n1.sps.plugin.execjava.ExecutionTimeoutException(timer.getTimeoutSeconds());
        }
    }

    static void execJavaStarted(ExecJavaStepDescriptor inJava) {
        ExecJavaTimer timer = new ExecJavaTimer(inJava.getTimeoutSeconds());
        mTimerThreads.set(timer);
        timer.start();
    }

    static void execJavaDone() {
        ExecJavaTimer timer = (ExecJavaTimer)mTimerThreads.get();
        if (timer != null) {
            try {
                while (timer.isAlive()) {
                    timer.interruptSafe();
                    timer.join(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            mTimerThreads.set(null);
        }
        Thread.interrupted();
    }

    private static class ExecJavaTimer
    extends SafeThread {
        private Thread mTimedThread = Thread.currentThread();
        private long mTimeout;

        ExecJavaTimer(long timeout) {
            super("ExecJavaTimer");
            this.mTimeout = timeout;
        }

        public void run() {
            try {
                ExecJavaTimer.sleep(this.mTimeout * 1000L);
                SafeThread.interruptSafe(this.mTimedThread);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public long getTimeoutSeconds() {
            return this.mTimeout;
        }
    }
}

