/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.plugin;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.plugin.AgentContext;
import com.raplix.rolloutexpress.plugin.ExecutionException;
import com.raplix.rolloutexpress.plugin.FixedSizeByteArrayOutputStream;
import com.sun.n1.sps.plugin.execjava.ActualExecJavaContext;
import java.io.PrintStream;

public class ActualAgentContext
extends AgentContext
implements ActualExecJavaContext {
    private PrintStream mInfoPrintStream;
    private PrintStream mErrorPrintStream;
    private FixedSizeByteArrayOutputStream mInfoStream;
    private FixedSizeByteArrayOutputStream mErrorStream;
    private final int mMaxStreamSize;

    ActualAgentContext(VariableSettingsSource inArgs, int inMaxStreamSize) {
        super(inArgs);
        this.mMaxStreamSize = inMaxStreamSize;
    }

    public PrintStream getInfoStream() {
        if (this.mInfoPrintStream == null) {
            this.mInfoStream = new FixedSizeByteArrayOutputStream(this.mMaxStreamSize);
            this.mInfoPrintStream = new PrintStream(this.mInfoStream);
        }
        return this.mInfoPrintStream;
    }

    public PrintStream getErrorStream() {
        if (this.mErrorPrintStream == null) {
            this.mErrorStream = new FixedSizeByteArrayOutputStream(this.mMaxStreamSize);
            this.mErrorPrintStream = new PrintStream(this.mErrorStream);
        }
        return this.mErrorPrintStream;
    }

    ExecNativeOutput getCurrentOutput(TaskID inTaskID, TargetID inTargetID, StepID inStepID) {
        String info = null;
        int outIdx = 0;
        String error = null;
        int errIdx = 0;
        boolean wasNoOutput = false;
        boolean wasNoError = false;
        String noInfo = new ROXMessage("cmd.MSG_EJAVA_NO_INFO_OUTPUT").getMessageString();
        String noError = new ROXMessage("cmd.MSG_EJAVA_NO_ERROR_OUTPUT").getMessageString();
        if (this.mInfoPrintStream != null) {
            this.mInfoPrintStream.flush();
        }
        if (this.mErrorPrintStream != null) {
            this.mErrorPrintStream.flush();
        }
        if (this.mMaxStreamSize == 0) {
            wasNoOutput = true;
            wasNoError = true;
            String suppressedMsg = new ROXMessage("cmd.MSG_EJAVA_SUPPRESSED_OUTPUT").getMessageString();
            info = this.mInfoStream == null || this.mInfoStream.getTotalSize() == 0 ? noInfo : suppressedMsg;
            error = this.mErrorStream == null || this.mErrorStream.getTotalSize() == 0 ? noError : suppressedMsg;
        } else {
            if (this.mInfoStream != null) {
                info = new String(this.mInfoStream.toByteArray());
                outIdx = Math.max(0, this.mInfoStream.getTotalSize() - this.mMaxStreamSize);
            }
            if (this.mErrorStream != null) {
                error = new String(this.mErrorStream.toByteArray());
                errIdx = Math.max(0, this.mErrorStream.getTotalSize() - this.mMaxStreamSize);
            }
            if (info == null || info.length() == 0) {
                info = noInfo;
                wasNoOutput = true;
            }
            if (error == null || error.length() == 0) {
                error = noError;
                wasNoError = true;
            }
        }
        ExecNativeOutput eno = new ExecNativeOutput(inTaskID, inTargetID, inStepID, info, outIdx, error, errIdx, null, wasNoOutput, wasNoError);
        return eno;
    }

    void appendError(ExecutionException inE) {
        if (inE != null) {
            inE.printStackTrace(this.getErrorStream());
        }
    }
}

