/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.util;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.util.NameRef;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import java.util.Iterator;

public abstract class NameRefTable
extends Table {
    protected NameRefTable() {
    }

    protected NameRefTable(String alias) {
        super(alias);
    }

    public abstract IDColumn cParentID();

    public abstract StringColumn cChildName();

    public abstract StringColumn cChildPath();

    public NameRef[] getByChildNameAndPath(String name, String path) throws PersistenceManagerException {
        return this.execute(this.select(NameRefTable.where(NameRefTable.and(NameRefTable.equals(this.cChildName(), name), NameRefTable.equals(this.cChildPath(), path)))));
    }

    public NameRef[] getByParentID(ObjectID parentID) throws PersistenceManagerException {
        return this.execute(this.select(NameRefTable.where(NameRefTable.equals(this.cParentID(), parentID))));
    }

    public NameRef[] getByParentIDs(ObjectID[] parentIDs) throws PersistenceManagerException {
        return this.execute(this.select((SelectList)this.allColumns(), NameRefTable.where(NameRefTable.emptyIn(this.cParentID(), NameRefTable.rList(parentIDs))), NameRefTable.oList(NameRefTable.orderByAsc(this.cParentID()))));
    }

    private NameRef[] execute(Select query) throws PersistenceManagerException {
        return (NameRef[])NameRefTable.executeMultiResult(query, this, this.getJavaClass());
    }

    public int removeByParentID(ObjectID parentID) throws PersistenceManagerException {
        return NameRefTable.execute(this.delete(NameRefTable.where(NameRefTable.equals(this.cParentID(), parentID))));
    }

    public int removeByChildNameAndPath(String name, String path) throws PersistenceManagerException {
        return NameRefTable.execute(this.delete(NameRefTable.where(NameRefTable.and(NameRefTable.equals(this.cChildName(), name), NameRefTable.equals(this.cChildPath(), path)))));
    }

    public int removeReference(ObjectID parent, String childName, String childPath) throws PersistenceManagerException {
        return NameRefTable.execute(this.delete(NameRefTable.where(NameRefTable.and(NameRefTable.equals(this.cParentID(), parent), NameRefTable.and(NameRefTable.equals(this.cChildName(), childName), NameRefTable.equals(this.cChildPath(), childPath))))));
    }

    public int addReference(ObjectID parentID, String childName, String childPath) throws PersistenceManagerException {
        return this.addReferences(NameRefTable.anonSelect(this.sList(parentID, childName, childPath)));
    }

    public int addReferences(Select values) throws PersistenceManagerException {
        return NameRefTable.execute(this.insert(NameRefTable.cList(this.cParentID(), this.cChildName(), this.cChildPath()), values));
    }

    public int addReferences(ObjectID parentID, String[] childNames, String[] childPaths) throws PersistenceManagerException {
        if (childNames.length == 0) {
            return 0;
        }
        if (childNames.length != childPaths.length) {
            return 0;
        }
        Select values = null;
        for (int i = 0; i < childNames.length; ++i) {
            values = NameRefTable.anonSelect(this.sList(parentID, childNames[i], childPaths[i]), values);
        }
        return this.addReferences(values);
    }

    public int addReferences(ObjectID[] parentIDs, String childName, String childPath) throws PersistenceManagerException {
        if (parentIDs.length == 0) {
            return 0;
        }
        Select values = null;
        for (int i = 0; i < parentIDs.length; ++i) {
            values = NameRefTable.anonSelect(this.sList(parentIDs[i], childName, childPath), values);
        }
        return this.addReferences(values);
    }

    public int addReferences(ObjectID parentID, NameRefSet refSet) throws PersistenceManagerException {
        if (refSet.size() < 1) {
            return 0;
        }
        Select values = null;
        Iterator iter = refSet.iterator();
        while (iter.hasNext()) {
            NameRefSet.NameRefPair nrp = (NameRefSet.NameRefPair)iter.next();
            values = NameRefTable.anonSelect(this.sList(parentID, nrp.getName(), nrp.getPath()), values);
        }
        return this.addReferences(values);
    }

    private SelectList sList(ObjectID parentID, String childName, String childPath) {
        return NameRefTable.sList(NameRefTable.v(parentID), NameRefTable.v(childName), NameRefTable.v(childPath));
    }

    public int updateNameRefs(String oldChildName, FolderID oldChildPath, String newChildName, SummaryFolder newChildPath) throws PersistenceManagerException {
        String oldPathStr = oldChildPath.getFullPathString();
        String newPathStr = newChildPath.getFullPathString();
        return NameRefTable.execute(this.update(NameRefTable.uList(NameRefTable.set(this.cChildName(), newChildName), NameRefTable.set(this.cChildPath(), newPathStr)), NameRefTable.where(NameRefTable.and(NameRefTable.equals(this.cChildName(), oldChildName), NameRefTable.equals(this.cChildPath(), oldPathStr)))));
    }
}

