/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.util;

import com.raplix.util.ObjectUtil;
import java.util.HashSet;
import java.util.Iterator;

public class NameRefSet {
    private HashSet mNameRefs = new HashSet();

    public void addNameRef(String name, String path) {
        NameRefPair nrp = new NameRefPair(name, path);
        if (this.mNameRefs.contains(nrp)) {
            return;
        }
        if (nrp == null) {
            throw new NullPointerException();
        }
        this.mNameRefs.add(nrp);
    }

    public int size() {
        return this.mNameRefs.size();
    }

    public void clear() {
        if (!this.mNameRefs.isEmpty()) {
            this.mNameRefs.clear();
        }
    }

    public Iterator iterator() {
        return this.mNameRefs.iterator();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof NameRefSet)) {
            return false;
        }
        return this.mNameRefs.equals(((NameRefSet)o).mNameRefs);
    }

    public int hashCode() {
        return this.mNameRefs.hashCode();
    }

    public class NameRefPair {
        private String mName;
        private String mPath;

        public NameRefPair(String name, String path) {
            this.mName = name;
            if (path == null) {
                this.mPath = "/";
            } else {
                this.mPath = path;
                if (!this.mPath.endsWith("/")) {
                    this.mPath = this.mPath + "/";
                }
            }
        }

        public String getName() {
            return this.mName;
        }

        public String getPath() {
            return this.mPath;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof NameRefPair)) {
                return false;
            }
            return ObjectUtil.equals(this.getName(), ((NameRefPair)o).getName()) && ObjectUtil.equals(this.getPath(), ((NameRefPair)o).getPath());
        }

        public int hashCode() {
            int name = this.getName().hashCode();
            return name + (this.getPath() == null ? 0 : this.getPath().hashCode());
        }
    }
}

