/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.util;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnList;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableDependency;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.util.collections.TypedSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class LinkTable
extends Table {
    protected LinkTable() {
    }

    protected LinkTable(String alias) {
        super(alias);
    }

    public abstract IDColumn cParentID();

    public abstract IDColumn cChildID();

    public Link[] getByChildID(ObjectID childID) throws PersistenceManagerException {
        return this.execute(this.select(LinkTable.where(LinkTable.equals(this.cChildID(), childID))));
    }

    public void getByChildID(ObjectID childID, TypedSet results) throws PersistenceManagerException {
        this.executeIDsResult(this.cParentID(), LinkTable.where(LinkTable.equals(this.cChildID(), childID)), results);
    }

    public Link[] getByChildIDs(ObjectID[] childIDs) throws PersistenceManagerException {
        return this.execute(this.select((SelectList)this.allColumns(), LinkTable.where(LinkTable.emptyIn(this.cChildID(), LinkTable.rList(childIDs))), LinkTable.oList(LinkTable.orderByAsc(this.cChildID()))));
    }

    public Link[] getByParentID(ObjectID parentID) throws PersistenceManagerException {
        return this.execute(this.select(LinkTable.where(LinkTable.equals(this.cParentID(), parentID))));
    }

    public void getByParentID(ObjectID parentID, TypedSet results) throws PersistenceManagerException {
        this.executeIDsResult(this.cChildID(), LinkTable.where(LinkTable.equals(this.cParentID(), parentID)), results);
    }

    public Link[] getByParentIDs(ObjectID[] parentIDs) throws PersistenceManagerException {
        return this.execute(this.select((SelectList)this.allColumns(), LinkTable.where(LinkTable.emptyIn(this.cParentID(), LinkTable.rList(parentIDs))), LinkTable.oList(LinkTable.orderByAsc(this.cParentID()))));
    }

    private Link[] execute(Select query) throws PersistenceManagerException {
        return (Link[])LinkTable.executeMultiResult(query, this, this.getJavaClass());
    }

    public int removeByParentID(ObjectID parentID) throws PersistenceManagerException {
        return LinkTable.execute(this.delete(LinkTable.where(LinkTable.equals(this.cParentID(), parentID))));
    }

    public int removeByChildID(ObjectID childID) throws PersistenceManagerException {
        return LinkTable.execute(this.delete(LinkTable.where(LinkTable.equals(this.cChildID(), childID))));
    }

    public int removeLinks(ObjectID objectID) throws PersistenceManagerException {
        return LinkTable.execute(this.delete(LinkTable.where(LinkTable.or(LinkTable.equals(this.cChildID(), objectID), LinkTable.equals(this.cParentID(), objectID)))));
    }

    public int addLink(ObjectID parentID, ObjectID childID) throws PersistenceManagerException {
        return this.addLinks(LinkTable.anonSelect(this.sList(parentID, childID)));
    }

    public int addLinks(Select values) throws PersistenceManagerException {
        return LinkTable.execute(this.insert(this.linkColumns(), values));
    }

    public int addLinks(ObjectID parentID, ObjectID[] childIDs) throws PersistenceManagerException {
        if (childIDs.length == 0) {
            return 0;
        }
        Select values = null;
        for (int i = 0; i < childIDs.length; ++i) {
            values = LinkTable.anonSelect(this.sList(parentID, childIDs[i]), values);
        }
        return this.addLinks(values);
    }

    public int addLinks(ObjectID[] parentIDs, ObjectID childID) throws PersistenceManagerException {
        if (parentIDs.length == 0) {
            return 0;
        }
        Select values = null;
        for (int i = 0; i < parentIDs.length; ++i) {
            values = LinkTable.anonSelect(this.sList(parentIDs[i], childID), values);
        }
        return this.addLinks(values);
    }

    public void resetLinks(ObjectID parentID, ObjectID[] childIDs, boolean removeExisting) throws PersistenceManagerException {
        if (removeExisting) {
            this.removeByParentID(parentID);
        }
        this.addLinks(parentID, childIDs);
    }

    public void resetLinks(ObjectID[] parentIDs, ObjectID childID, boolean removeExisting) throws PersistenceManagerException {
        if (removeExisting) {
            this.removeByChildID(childID);
        }
        this.addLinks(parentIDs, childID);
    }

    private SelectList sList(ObjectID parentID, ObjectID childID) {
        return LinkTable.sList(LinkTable.v(parentID), (ScalarExp)LinkTable.v(childID));
    }

    public ColumnList linkColumns() {
        return LinkTable.cList(this.cParentID(), (ColumnNode)this.cChildID());
    }

    public ConditionalExpression linkExists(ObjectID parentID, IDColumn childID) {
        return LinkTable.exists(this.select(LinkTable.sList(this.cChildID()), LinkTable.where(LinkTable.and(LinkTable.equals((ColumnNode)this.cChildID(), childID), LinkTable.equals(this.cParentID(), parentID)))));
    }

    public Select selectChildIDs(ObjectID parentID) {
        return this.select(LinkTable.sList(this.cChildID()), LinkTable.where(LinkTable.equals(this.cParentID(), parentID)));
    }

    public Select selectChildIDs(ObjectID[] parentIDs) {
        return this.select(LinkTable.sList(this.cChildID()), LinkTable.where(LinkTable.emptyIn(this.cParentID(), LinkTable.rList(parentIDs))));
    }

    public Select selectChildIDs(Select parentIDs) {
        return this.select(LinkTable.sList(this.cChildID()), LinkTable.where(LinkTable.in((ColumnNode)this.cParentID(), parentIDs)));
    }

    public Select selectParentIDs(ObjectID childID) {
        return this.select(LinkTable.sList(this.cParentID()), LinkTable.where(LinkTable.equals(this.cChildID(), childID)));
    }

    public Select selectParentIDs(ObjectID[] childIDs) {
        return this.select(LinkTable.sList(this.cParentID()), LinkTable.where(LinkTable.emptyIn(this.cChildID(), LinkTable.rList(childIDs))));
    }

    public Select selectParentIDs(Select childIDs) {
        return this.select(LinkTable.sList(this.cParentID()), LinkTable.where(LinkTable.in((ColumnNode)this.cChildID(), childIDs)));
    }

    public int incrParentUpdateCounts(Table parentTable, ObjectID childID) throws PersistenceManagerException {
        return LinkTable.execute(parentTable.incrUpdateCountByID(this.selectParentIDs(childID)));
    }

    public int incrChildUpdateCounts(Table childTable, ObjectID parentID) throws PersistenceManagerException {
        return LinkTable.execute(childTable.incrUpdateCountByID(this.selectChildIDs(parentID)));
    }

    public Map mapLinksByParentIDs(ObjectID[] parentIDs) throws PersistenceManagerException {
        Link[] links = this.getByParentIDs(parentIDs);
        List<Link> linkList = Arrays.asList(links);
        HashMap<ObjectID, List<Link>> result = new HashMap<ObjectID, List<Link>>(parentIDs.length);
        int start = 0;
        while (start < links.length) {
            int end;
            ObjectID ID2 = links[start].getParentObjectID();
            for (end = start + 1; end < links.length && ID2.equals(links[end].getParentObjectID()); ++end) {
            }
            result.put(ID2, linkList.subList(start, end));
            start = end;
        }
        return result;
    }

    public Map mapLinksByChildIDs(ObjectID[] childIDs) throws PersistenceManagerException {
        Link[] links = this.getByChildIDs(childIDs);
        List<Link> linkList = Arrays.asList(links);
        HashMap<ObjectID, List<Link>> result = new HashMap<ObjectID, List<Link>>(childIDs.length);
        int start = 0;
        while (start < links.length) {
            int end;
            ObjectID ID2 = links[start].getChildObjectID();
            for (end = start + 1; end < links.length && ID2.equals(links[end].getChildObjectID()); ++end) {
            }
            result.put(ID2, linkList.subList(start, end));
            start = end;
        }
        return result;
    }

    public TableDependency getInvalidateParentDependency(final Table parentTable) {
        return new TableDependency(){

            public void onUpdate(Select childIDs) throws PersistenceManagerException {
                Select parentIDs = LinkTable.this.selectParentIDs(childIDs);
                QueryBuilder.execute(parentTable.incrUpdateCountByID(parentIDs));
            }
        };
    }

    public TableDependency getInvalidateChildDependency(final Table childTable) {
        return new TableDependency(){

            public void onUpdate(Select parentIDs) throws PersistenceManagerException {
                Select childIDs = LinkTable.this.selectChildIDs(parentIDs);
                QueryBuilder.execute(childTable.incrUpdateCountByID(childIDs));
            }
        };
    }
}

