/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.util;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnList;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Comparison;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Set;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.ValueWrapper;
import com.raplix.rolloutexpress.persist.util.LinkTable;

public abstract class GraphLinkTable
extends Table {
    private static final ScalarExp ZERO = GraphLinkTable.v(0);
    private static final ScalarExp ONE = GraphLinkTable.v(1);

    protected GraphLinkTable() {
    }

    protected GraphLinkTable(String alias) {
        super(alias);
    }

    public abstract IDColumn cAncestorID();

    public abstract IDColumn cDescendantID();

    public abstract IntColumn cPathCount();

    public Table getObjectTable() {
        throw new UnsupportedOperationException();
    }

    public LinkTable getLinkTable() {
        throw new UnsupportedOperationException();
    }

    public String getPathCountFunctionName() {
        throw new UnsupportedOperationException();
    }

    public ColumnList graphLinkColumns() {
        return GraphLinkTable.cList(this.cAncestorID(), this.cDescendantID(), this.cPathCount());
    }

    public int insertObject(ObjectID objectID) throws PersistenceManagerException {
        Table objectT = this.getObjectTable();
        ValueWrapper objectExpr = GraphLinkTable.v(objectID);
        Comparison objectNotEqual = GraphLinkTable.notEquals(objectT.ID, objectID);
        Select values = GraphLinkTable.anonSelect(GraphLinkTable.sList(objectExpr, objectExpr, ONE));
        values = objectT.select(GraphLinkTable.sList(objectExpr, objectT.ID, ZERO), GraphLinkTable.where(objectNotEqual), values);
        values = objectT.select(GraphLinkTable.sList(objectT.ID, objectExpr, ZERO), GraphLinkTable.where(objectNotEqual), values);
        return GraphLinkTable.execute(this.insert(this.graphLinkColumns(), values));
    }

    public int deleteObject(ObjectID objectID) throws PersistenceManagerException {
        return GraphLinkTable.execute(this.delete(GraphLinkTable.where(GraphLinkTable.or(GraphLinkTable.equals(this.cAncestorID(), objectID), GraphLinkTable.equals(this.cDescendantID(), objectID)))));
    }

    public int addLink(ObjectID parent, ObjectID child) throws PersistenceManagerException {
        return GraphLinkTable.execute(this.update(GraphLinkTable.uList(this.incrementPathCount(parent, child)), GraphLinkTable.where(this.isReachableVia(parent, child))));
    }

    public int addLinks(ObjectID[] parents, ObjectID child) throws PersistenceManagerException {
        if (parents.length == 0) {
            return 0;
        }
        return GraphLinkTable.execute(this.update(GraphLinkTable.uList(this.incrementPathCount(parents, child)), GraphLinkTable.where(this.isReachableVia(parents, child))));
    }

    public int addLinks(ObjectID parent, ObjectID[] children) throws PersistenceManagerException {
        if (children.length == 0) {
            return 0;
        }
        return GraphLinkTable.execute(this.update(GraphLinkTable.uList(this.incrementPathCount(parent, children)), GraphLinkTable.where(this.isReachableVia(parent, children))));
    }

    public int removeLink(ObjectID parent, ObjectID child) throws PersistenceManagerException {
        return GraphLinkTable.execute(this.update(GraphLinkTable.uList(this.decrementPathCount(parent, child)), GraphLinkTable.where(this.isReachableVia(parent, child))));
    }

    public int removeLinksByChild(ObjectID child) throws PersistenceManagerException {
        return GraphLinkTable.execute(this.update(GraphLinkTable.uList(this.decrementPathCountByParentsOf(child)), GraphLinkTable.where(this.isReachableViaChild(child))));
    }

    public int removeLinksByParent(ObjectID parent) throws PersistenceManagerException {
        return GraphLinkTable.execute(this.update(GraphLinkTable.uList(this.decrementPathCountByChildrenOf(parent)), GraphLinkTable.where(this.isReachableViaParent(parent))));
    }

    public int removeLinks(ObjectID object) throws PersistenceManagerException {
        return GraphLinkTable.execute(this.update(GraphLinkTable.uList(this.decrementPathCount(object)), GraphLinkTable.where(this.isReachableVia(object))));
    }

    public void resetLinks(ObjectID parent, ObjectID[] children, boolean removeExisting) throws PersistenceManagerException {
        if (removeExisting) {
            this.removeLinksByParent(parent);
        }
        this.getLinkTable().resetLinks(parent, children, removeExisting);
        this.addLinks(parent, children);
    }

    public void resetLinks(ObjectID[] parents, ObjectID child, boolean removeExisting) throws PersistenceManagerException {
        if (removeExisting) {
            this.removeLinksByChild(child);
        }
        this.getLinkTable().resetLinks(parents, child, removeExisting);
        this.addLinks(parents, child);
    }

    public void deleteAllLinks(ObjectID objectID) throws PersistenceManagerException {
        this.getLinkTable().removeLinks(objectID);
        this.removeLinks(objectID);
        this.deleteObject(objectID);
    }

    private Set incrementPathCountBy(ScalarExp expr) {
        return GraphLinkTable.set((ColumnNode)this.cPathCount(), GraphLinkTable.plus(this.cPathCount(), expr));
    }

    private Set incrementPathCount(ObjectID parent, ObjectID child) {
        return this.incrementPathCountBy(this.findPathCountVia(parent, child));
    }

    private Set incrementPathCount(ObjectID parent, ObjectID[] children) {
        return this.incrementPathCountBy(this.findPathCountVia(parent, children));
    }

    private Set incrementPathCount(ObjectID[] parents, ObjectID child) {
        return this.incrementPathCountBy(this.findPathCountVia(parents, child));
    }

    private ScalarExp findPathCountVia(ObjectID parent, ObjectID child) {
        return GraphLinkTable.times(this.pathCount(this.cAncestorID(), parent), this.pathCount(child, this.cDescendantID()));
    }

    private ScalarExp findPathCountVia(ObjectID parent, ObjectID[] children) {
        ScalarExp childPathCountSum = null;
        for (int i = 0; i < children.length; ++i) {
            ScalarExp pathCount = this.pathCount(children[i], this.cDescendantID());
            childPathCountSum = childPathCountSum == null ? pathCount : GraphLinkTable.plus(pathCount, childPathCountSum);
        }
        return GraphLinkTable.times(this.pathCount(this.cAncestorID(), parent), childPathCountSum);
    }

    private ScalarExp findPathCountVia(ObjectID[] parents, ObjectID child) {
        ScalarExp parentPathCountSum = null;
        for (int i = 0; i < parents.length; ++i) {
            ScalarExp pathCount = this.pathCount(this.cAncestorID(), parents[i]);
            parentPathCountSum = parentPathCountSum == null ? pathCount : GraphLinkTable.plus(pathCount, parentPathCountSum);
        }
        return GraphLinkTable.times(parentPathCountSum, this.pathCount(child, this.cDescendantID()));
    }

    private ScalarExp pathCount(ObjectID ancestorID, ColumnNode descendantID) {
        return this.pathCount(GraphLinkTable.v(ancestorID), (ScalarExp)descendantID);
    }

    private ScalarExp pathCount(ColumnNode ancestorID, ObjectID descendantID) {
        return this.pathCount((ScalarExp)ancestorID, GraphLinkTable.v(descendantID));
    }

    private ScalarExp pathCount(ScalarExp ancestorID, ScalarExp descendantID) {
        return GraphLinkTable.function(this.getPathCountFunctionName(), GraphLinkTable.rList(ancestorID, descendantID));
    }

    private Set decrementPathCountBy(ScalarExp expr) {
        return GraphLinkTable.set((ColumnNode)this.cPathCount(), GraphLinkTable.minus(this.cPathCount(), expr));
    }

    private Set decrementPathCount(ObjectID parent, ObjectID child) {
        return this.decrementPathCountBy(this.findPathCountVia(parent, child));
    }

    private Set decrementPathCountByChildrenOf(ObjectID parent) {
        return this.decrementPathCountBy(this.findPathCountViaChildrenOf(parent));
    }

    private Set decrementPathCountByParentsOf(ObjectID child) {
        return this.decrementPathCountBy(this.findPathCountViaParentsOf(child));
    }

    private Set decrementPathCount(ObjectID object) {
        return this.decrementPathCountBy(this.findPathCountVia(object));
    }

    private ScalarExp findParentPathCountSum(ObjectID child) {
        LinkTable linkT = (LinkTable)this.getLinkTable().instance("linkT");
        return GraphLinkTable.scalar(linkT.select(GraphLinkTable.sList(GraphLinkTable.sum(this.pathCount((ScalarExp)this.cAncestorID(), (ScalarExp)linkT.cParentID()))), GraphLinkTable.where(GraphLinkTable.equals(linkT.cChildID(), child))));
    }

    private ScalarExp findPathCountViaParentsOf(ObjectID child) {
        return GraphLinkTable.times(this.findParentPathCountSum(child), this.pathCount(child, this.cDescendantID()));
    }

    private ScalarExp findChildPathCountSum(ObjectID parent) {
        LinkTable linkT = (LinkTable)this.getLinkTable().instance("linkT");
        return GraphLinkTable.scalar(linkT.select(GraphLinkTable.sList(GraphLinkTable.sum(this.pathCount((ScalarExp)linkT.cChildID(), (ScalarExp)this.cDescendantID()))), GraphLinkTable.where(GraphLinkTable.equals(linkT.cParentID(), parent))));
    }

    private ScalarExp findPathCountViaChildrenOf(ObjectID parent) {
        return GraphLinkTable.times(this.pathCount(this.cAncestorID(), parent), this.findChildPathCountSum(parent));
    }

    private ScalarExp findPathCountVia(ObjectID object) {
        return GraphLinkTable.times(this.findParentPathCountSum(object), this.findChildPathCountSum(object));
    }

    private ConditionalExpression isReachableVia(ObjectID parent, ObjectID child) {
        return GraphLinkTable.and(GraphLinkTable.in((ColumnNode)this.cAncestorID(), this.selectAncestorsOf(parent)), GraphLinkTable.in((ColumnNode)this.cDescendantID(), this.selectDescendantsOf(child)));
    }

    private ConditionalExpression isReachableVia(ObjectID parent, ObjectID[] children) {
        return GraphLinkTable.and(GraphLinkTable.in((ColumnNode)this.cAncestorID(), this.selectAncestorsOf(parent)), GraphLinkTable.in((ColumnNode)this.cDescendantID(), this.selectDescendantsOf(children)));
    }

    private ConditionalExpression isReachableVia(ObjectID[] parents, ObjectID child) {
        return GraphLinkTable.and(GraphLinkTable.in((ColumnNode)this.cAncestorID(), this.selectAncestorsOf(parents)), GraphLinkTable.in((ColumnNode)this.cDescendantID(), this.selectDescendantsOf(child)));
    }

    private ConditionalExpression isReachableViaChild(ObjectID child) {
        return GraphLinkTable.and(GraphLinkTable.in((ColumnNode)this.cAncestorID(), this.selectAncestorsOf(this.selectParentsOf(child))), GraphLinkTable.in((ColumnNode)this.cDescendantID(), this.selectDescendantsOf(child)));
    }

    private ConditionalExpression isReachableViaParent(ObjectID parent) {
        return GraphLinkTable.and(GraphLinkTable.in((ColumnNode)this.cAncestorID(), this.selectAncestorsOf(parent)), GraphLinkTable.in((ColumnNode)this.cDescendantID(), this.selectDescendantsOf(this.selectChildrenOf(parent))));
    }

    private ConditionalExpression isReachableVia(ObjectID object) {
        return GraphLinkTable.and(GraphLinkTable.in((ColumnNode)this.cAncestorID(), this.selectAncestorsOf(this.selectParentsOf(object))), GraphLinkTable.in((ColumnNode)this.cDescendantID(), this.selectDescendantsOf(this.selectChildrenOf(object))));
    }

    private Select selectParentsOf(ObjectID child) {
        return this.getLinkTable().selectParentIDs(child);
    }

    private Select selectChildrenOf(ObjectID parent) {
        return this.getLinkTable().selectChildIDs(parent);
    }

    public Select selectAncestorsOf(ObjectID object) {
        return this.select(GraphLinkTable.sList(this.cAncestorID()), GraphLinkTable.where(GraphLinkTable.and(GraphLinkTable.equals(this.cDescendantID(), object), this.pathCountIsPositive())));
    }

    public Select selectAncestorsOf(ObjectID[] objects) {
        return this.select(GraphLinkTable.sList(this.cAncestorID()), GraphLinkTable.where(GraphLinkTable.and(GraphLinkTable.emptyIn(this.cDescendantID(), GraphLinkTable.rList(objects)), this.pathCountIsPositive())));
    }

    public Select selectAncestorsOf(Select objects) {
        return this.select(GraphLinkTable.sList(this.cAncestorID()), GraphLinkTable.where(GraphLinkTable.and(GraphLinkTable.in((ColumnNode)this.cDescendantID(), objects), this.pathCountIsPositive())));
    }

    private ConditionalExpression pathCountIsPositive() {
        return GraphLinkTable.greaterThan(this.cPathCount(), 0);
    }

    public Select selectDescendantsOf(ObjectID object) {
        return this.select(GraphLinkTable.sList(this.cDescendantID()), GraphLinkTable.where(GraphLinkTable.and(GraphLinkTable.equals(this.cAncestorID(), object), this.pathCountIsPositive())));
    }

    public Select selectDescendantsOf(ObjectID[] objects) {
        return this.select(GraphLinkTable.sList(this.cDescendantID()), GraphLinkTable.where(GraphLinkTable.and(GraphLinkTable.emptyIn(this.cAncestorID(), GraphLinkTable.rList(objects)), this.pathCountIsPositive())));
    }

    public Select selectDescendantsOf(Select objects) {
        return this.select(GraphLinkTable.sList(this.cDescendantID()), GraphLinkTable.where(GraphLinkTable.and(GraphLinkTable.in((ColumnNode)this.cAncestorID(), objects), this.pathCountIsPositive())));
    }

    public int getPathCountBetween(ObjectID ancestorID, ObjectID descendantID) throws PersistenceManagerException {
        return GraphLinkTable.executeInt(this.selectPathCountBetween(ancestorID, descendantID));
    }

    private Select selectPathCountBetween(ObjectID ancestorID, ObjectID descendantID) {
        return this.select(GraphLinkTable.sList(this.cPathCount()), GraphLinkTable.where(GraphLinkTable.and(GraphLinkTable.equals(this.cAncestorID(), ancestorID), GraphLinkTable.equals(this.cDescendantID(), descendantID))));
    }

    public ConditionalExpression isDescendantOf(ObjectID ancestor, ObjectID descendant) {
        return GraphLinkTable.greaterThan(this.selectPathCountBetween(ancestor, descendant), 0);
    }
}

