/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;

public class SQLParser {
    private StreamTokenizer mTokenizer;
    private StringBuffer mSQL = new StringBuffer();

    public SQLParser(InputStream is) {
        this(new BufferedReader(new InputStreamReader(is)));
    }

    public SQLParser(Reader reader) {
        this.mTokenizer = new StreamTokenizer(reader);
        this.mTokenizer.resetSyntax();
        this.mTokenizer.wordChars(0, 65535);
        this.mTokenizer.ordinaryChar(59);
        this.mTokenizer.ordinaryChar(45);
        this.mTokenizer.ordinaryChar(39);
        this.mTokenizer.whitespaceChars(10, 10);
        this.mTokenizer.whitespaceChars(13, 13);
        this.mTokenizer.eolIsSignificant(true);
    }

    public String getNextStatement() throws IOException {
        while (this.mTokenizer != null) {
            String result;
            this.mSQL.setLength(0);
            if (this.readStatementInto(this.mSQL)) {
                this.mTokenizer = null;
            }
            if ((result = this.mSQL.toString().trim()).length() == 0) continue;
            return result + ";";
        }
        return null;
    }

    private boolean readStatementInto(StringBuffer sql) throws IOException {
        boolean inComment = false;
        boolean inQuote = false;
        block7: while (true) {
            int token = this.mTokenizer.nextToken();
            switch (token) {
                case -1: {
                    return true;
                }
                case 10: {
                    inComment = false;
                    sql.append('\n');
                    break;
                }
                case 59: {
                    if (inQuote) {
                        sql.append(';');
                        break;
                    }
                    if (inComment) continue block7;
                    return false;
                }
                case 39: {
                    if (inComment) continue block7;
                    inQuote = !inQuote;
                    sql.append('\'');
                    break;
                }
                case 45: {
                    if (inQuote) {
                        sql.append('-');
                        break;
                    }
                    if (inComment) continue block7;
                    int nextToken = this.mTokenizer.nextToken();
                    if (nextToken == 45) {
                        inComment = true;
                        break;
                    }
                    sql.append('-');
                    this.mTokenizer.pushBack();
                    break;
                }
                default: {
                    if (inComment) continue block7;
                    sql.append(this.mTokenizer.sval);
                }
            }
        }
    }
}

