/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.sql;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.persist.ConstraintViolationException;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.PMSQLException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.SQLDeadlockException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.PGVersionQuery;
import com.raplix.rolloutexpress.persist.sql.DBConnection;
import com.raplix.rolloutexpress.persist.sql.DBConnectionInfo;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.REUtil;
import com.raplix.util.regex.RegEx;
import com.raplix.util.regex.RegExSyntaxException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class PostgresSQLDatabase
extends Database
implements Messages {
    private int mPGMajorVersion;
    private int mPGMinorVersion;
    private RegEx[] msgMatchers;
    private String messageNotFoundMessage;
    private static final String DEADLOCK_MSG_SUBSTRING_71 = "Deadlock detected";
    private static final String DEADLOCK_MSG_SUBSTRING_72 = "deadlock detected";

    public PostgresSQLDatabase(DBConnectionInfo inDBInfo, int inMaxConnections, int inConnectionCheckoutLimit) throws ConfigurationException {
        super("Postgres", inDBInfo, inMaxConnections, inConnectionCheckoutLimit);
        try {
            Class.forName("org.postgresql.Driver");
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Creating New Postgres Database with URL: " + this.getURL() + " and connectionInfo: " + this.mConnectionInfo, this);
            }
            this.msgMatchers = new RegEx[]{new RegEx("ERROR:  Cannot insert a duplicate key into unique index ([<>\\w]+)\n"), new RegEx("ERROR:  ExecReplace: rejected due to CHECK constraint ([<>\\w]+)\n"), new RegEx("ERROR:  ExecAppend: rejected due to CHECK constraint ([<>\\w]+)\n"), new RegEx("ERROR:  ([<>\\w]+) referential integrity violation - .*")};
        }
        catch (RegExSyntaxException rese) {
            throw new ConfigurationException(new ROXMessage("pm.ERROR_INIT_SQLMESSAGE_MAPPERS"), (Throwable)rese, 1);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException(new ROXMessage("pm.COULD_NOT_LOAD_DB_DRIVER_CLASS"), (Throwable)cnfe, 1);
        }
        this.messageNotFoundMessage = ROXMessageManager.messageAsString("messageNotFound");
        String versionString = null;
        int nRetry = PersistenceManager.getInstance().getConfigDBConnRetryCount();
        nRetry = Math.max(nRetry, 0);
        int sleepTime = PersistenceManager.getInstance().getConfigDBConnRetryInterval() * 1000;
        PersistenceManagerException failure = null;
        for (int i = 0; i <= nRetry; ++i) {
            try {
                PGVersionQuery theVersionQuery = new PGVersionQuery(this);
                versionString = theVersionQuery.getPGVersionString();
                break;
            }
            catch (PersistenceManagerException e) {
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn("Error connecting to the database, attemptCount:" + i, e, this);
                }
                failure = e;
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
        }
        if (versionString == null) {
            throw new ConfigurationException("pm.CANNOT_CONNECT_TO_DB", (Throwable)failure, new String[]{inDBInfo.getHostName(), Integer.toString(inDBInfo.getPort()), inDBInfo.getInstanceName(), inDBInfo.getUsername(), String.valueOf(nRetry), Application.getApp().getDefaultConfigurationFileName()});
        }
        this.setPGVersion(versionString);
    }

    public void setPGVersion(String inVersionString) throws ConfigurationException {
        this.setPGMajorVersion(7);
        if (REUtil.compileWildcard("PostgreSQL 7.2.*").match(inVersionString)) {
            this.setPGMinorVersion(2);
        } else if (REUtil.compileWildcard("PostgreSQL 7.1.*").match(inVersionString)) {
            this.setPGMinorVersion(1);
        } else {
            throw new ConfigurationException("pm.INCOMPATIBLE_DB_VERSION", new String[]{inVersionString});
        }
    }

    public String getDriverName() {
        return "postgresql";
    }

    public DateFormat getDateFormat() {
        SimpleDateFormat theDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        theDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return theDateFormat;
    }

    protected DBConnection getNewConnection() throws SQLException {
        return new DBConnection(DriverManager.getConnection(this.getURL(), this.mConnectionInfo.getUsername(), this.mConnectionInfo.getPassword()));
    }

    public String getIntColumnType() {
        return "INT";
    }

    public String getLongColumnType() {
        return "BIGINT";
    }

    public String getFloatColumnType() {
        return "REAL";
    }

    public String getDoubleColumnType() {
        return "FLOAT8";
    }

    public String getStringColumnType() {
        return "VARCHAR";
    }

    public String getBooleanColumnType() {
        return "BOOLEAN";
    }

    public String getDateColumnType() {
        return "TIMESTAMP";
    }

    public String getColumnNameTableInformationColumnName() {
        return "attname";
    }

    public String getClauseTableInformation(String inTableName) {
        return "select attname from pg_attribute a, pg_class c where c.relname='" + inTableName.toLowerCase() + "' and c.oid = a.attrelid";
    }

    public String getAnonymousSelectClause() {
        return "";
    }

    public String getTimeStampRetrievalString(String columnSpec) {
        StringBuffer sb = new StringBuffer();
        if (this.getPGMinorVersion() == 2) {
            sb.append("to_char(").append(columnSpec);
            sb.append(",'YYYY-MM-DD HH24:MI:SS.MS')");
        } else {
            sb.append("to_char(").append(columnSpec);
            sb.append(",'YYYY-MM-DD HH24:MI:SS')||'.'||to_char(round(date_part('millisecond',");
            sb.append(columnSpec).append(")),'FM000') ");
        }
        return sb.toString();
    }

    public String getUpdateCountSetString(String columnSpec) {
        StringBuffer sb = new StringBuffer();
        sb.append("(case when ").append(columnSpec);
        sb.append(" < ").append(Integer.MAX_VALUE);
        sb.append(" then ").append(columnSpec);
        sb.append(" + 1 else ").append(1);
        sb.append(" end)");
        return sb.toString();
    }

    public void addLimitOffsetClause(SQLStatement stmt, int inLimit, int inOffset) {
        stmt.addSQLClause("LIMIT ");
        if (inLimit < 0 && inOffset > 0) {
            stmt.addSQLClause("ALL ");
        } else {
            stmt.addSQLClause(String.valueOf(inLimit)).addSQLClause(" ");
        }
        if (inOffset > 0) {
            stmt.addSQLClause("OFFSET ").addSQLClause(String.valueOf(inOffset));
        }
    }

    public PersistenceManagerException wrapSQLException(SQLException sqle) {
        String msg = sqle.getMessage();
        if (msg != null) {
            if (msg.indexOf(this.getDeadlockSubstring()) >= 0) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("DEADLOCK DETECTED", this);
                }
                PersistenceManager.getInstance().getTransactionManager().dumpAllTransactions();
                return new SQLDeadlockException(sqle);
            }
            String[] matches = null;
            for (int i = 0; i < this.msgMatchers.length; ++i) {
                matches = this.msgMatchers[i].doMatch(msg);
                if (matches == null || matches.length <= 1) continue;
                String constraint = matches[1];
                if (!this.messageNotFoundMessage.equals(ROXMessageManager.messageAsString("pm.constraint." + constraint))) {
                    return new ConstraintViolationException(constraint, sqle, new ROXMessage("pm.constraint." + constraint));
                }
                return new ConstraintViolationException(constraint, sqle, null);
            }
        }
        return new PMSQLException(sqle);
    }

    public String getIfNullFunctionName() {
        return "coalesce";
    }

    public int getPGMinorVersion() {
        return this.mPGMinorVersion;
    }

    private void setPGMinorVersion(int inPGMinorVersion) {
        this.mPGMinorVersion = inPGMinorVersion;
    }

    public int getPGMajorVersion() {
        return this.mPGMajorVersion;
    }

    private void setPGMajorVersion(int inPGMajorVersion) {
        this.mPGMajorVersion = inPGMajorVersion;
    }

    private String getDeadlockSubstring() {
        if (this.getPGMinorVersion() == 1) {
            return DEADLOCK_MSG_SUBSTRING_71;
        }
        return DEADLOCK_MSG_SUBSTRING_72;
    }
}

