/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.sql;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.sql.ConnectionNotAvailable;
import com.raplix.rolloutexpress.persist.sql.ConnectionPool;
import com.raplix.rolloutexpress.persist.sql.DBConnection;
import com.raplix.rolloutexpress.persist.sql.DBConnectionInfo;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.util.logger.Logger;
import java.sql.SQLException;
import java.text.DateFormat;

public abstract class Database {
    private String mName;
    private String mURL;
    protected DBConnectionInfo mConnectionInfo;
    protected ConnectionPool mConnectionPool;
    private boolean mIsShuttingDown;

    public Database(String inName, DBConnectionInfo inConnectionInfo, int inMaxConnections, int inConnectionCheckoutLimit) {
        this.mName = inName;
        this.mConnectionInfo = inConnectionInfo;
        this.mURL = "jdbc:" + this.getDriverName() + "://" + this.mConnectionInfo.getHostName() + ":" + this.mConnectionInfo.getPort() + "/" + this.mConnectionInfo.getInstanceName();
        this.mConnectionPool = new ConnectionPool(this, inMaxConnections, inConnectionCheckoutLimit);
        this.mIsShuttingDown = false;
    }

    public String getURL() {
        return this.mURL;
    }

    public String getName() {
        return this.mName;
    }

    public DBConnection getConnection() throws ConnectionNotAvailable, SQLException {
        return this.mConnectionPool.getConnection();
    }

    public void returnConnection(DBConnection inConnection) {
        this.mConnectionPool.returnConnection(inConnection);
    }

    public int getNumAllocatedConnections() {
        return this.mConnectionPool.getNumAllocatedConnections();
    }

    public synchronized void shutdown() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Database " + this + " is shutting down ", this);
        }
        this.mConnectionPool.shutdown();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Database " + this + " shutdown complete", this);
        }
    }

    protected synchronized void finalize() throws Throwable {
        this.shutdown();
    }

    protected abstract DBConnection getNewConnection() throws SQLException;

    protected abstract String getDriverName();

    public abstract String getColumnNameTableInformationColumnName();

    public abstract String getClauseTableInformation(String var1);

    public abstract DateFormat getDateFormat();

    public abstract String getDateColumnType();

    public abstract String getIntColumnType();

    public abstract String getLongColumnType();

    public abstract String getFloatColumnType();

    public abstract String getDoubleColumnType();

    public abstract String getStringColumnType();

    public abstract String getBooleanColumnType();

    public String getArraySeparatorTokenizer() {
        return "{}\",";
    }

    public String getClauseStringSet() {
        return "SET";
    }

    public String getClauseStringAnd() {
        return "AND";
    }

    public String getClauseStringOr() {
        return "OR";
    }

    public String getClauseStringOrderBy() {
        return "ORDER BY";
    }

    public String getClauseStringGroupBy() {
        return "GROUP BY";
    }

    public String getClauseStringDelete() {
        return "DELETE";
    }

    public String getClauseStringEqualTo() {
        return "=";
    }

    public String getClauseStringForUpdate() {
        return "FOR UPDATE";
    }

    public String getClauseStringUpdate() {
        return "UPDATE";
    }

    public String getClauseStringFrom() {
        return "FROM";
    }

    public String getCluaseStringGroupBy() {
        return "GROUP BY";
    }

    public String getClauseStringInsert() {
        return "INSERT INTO";
    }

    public String getClauseStringSelect() {
        return "SELECT";
    }

    public String getClauseStringDistinct() {
        return "DISTINCT";
    }

    public String getClauseStringWhere() {
        return "WHERE";
    }

    public String getClauseStringIn() {
        return "IN";
    }

    public String getClauseStringUnion() {
        return "UNION";
    }

    public String getClauseStringValues() {
        return "VALUES";
    }

    public String getClauseStringLike() {
        return "LIKE";
    }

    public String getClauseStringAS() {
        return "AS";
    }

    public String getClauseStringBetween() {
        return "BETWEEN";
    }

    public String getClauseStringIsNull() {
        return "IS NULL";
    }

    public String getClauseStringEscape() {
        return "ESCAPE";
    }

    public String getClauseStringNot() {
        return "NOT";
    }

    public String getClauseStringExists() {
        return "EXISTS";
    }

    public String getDropTableClause() {
        return "DROP TABLE";
    }

    public String getCreateTableClause() {
        return "CREATE TABLE";
    }

    public String getLeftOuterJoinClause() {
        return "LEFT OUTER JOIN";
    }

    public String getRightOuterJoinClause() {
        return "RIGHT OUTER JOIN";
    }

    public String getFullOuterJoinClause() {
        return "FULL OUTER JOIN";
    }

    public String getJoinOnClause() {
        return "ON";
    }

    public abstract String getIfNullFunctionName();

    public abstract String getTimeStampRetrievalString(String var1);

    public abstract String getAnonymousSelectClause();

    public abstract String getUpdateCountSetString(String var1);

    public abstract void addLimitOffsetClause(SQLStatement var1, int var2, int var3);

    public abstract PersistenceManagerException wrapSQLException(SQLException var1);
}

