/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.sql;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Uninterruptible;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class DBConnection {
    private Connection mConnection;
    private Date mCreationDate;
    private static final String QUERY_LOGGER_CATEGORY = "pm.query";
    private static final String METRICS_LOGGER_CATEGORY = "pm.metrics";

    public DBConnection(Connection inConnection) {
        this.mConnection = inConnection;
        this.mCreationDate = new Date();
    }

    public void close() throws SQLException {
        new DBUnInterruptible(){

            public Object execute() throws Exception {
                DBConnection.this.mConnection.close();
                return null;
            }
        }.doExecute();
    }

    public void closeThrowsNoExceptions() {
        block2: {
            try {
                this.close();
            }
            catch (SQLException e) {
                if (!Logger.isErrorEnabled(this)) break block2;
                Logger.error("Error on Close of DB Connection", e, this);
            }
        }
    }

    public boolean isClosed() throws SQLException {
        return (Boolean)new DBUnInterruptible(){

            public Object execute() throws Exception {
                return new Boolean(DBConnection.this.mConnection.isClosed());
            }
        }.doExecute();
    }

    public void commit() throws SQLException {
        new DBUnInterruptible(){

            public Object execute() throws Exception {
                DBConnection.this.mConnection.commit();
                return null;
            }
        }.doExecute();
    }

    public void rollback() throws SQLException {
        new DBUnInterruptible(){

            public Object execute() throws Exception {
                DBConnection.this.mConnection.rollback();
                return null;
            }
        }.doExecute();
    }

    public void clearWarnings() throws SQLException {
        new DBUnInterruptible(){

            public Object execute() throws Exception {
                DBConnection.this.mConnection.clearWarnings();
                return null;
            }
        }.doExecute();
    }

    public Date getCreationDate() {
        return this.mCreationDate;
    }

    public void finalize() {
        this.closeThrowsNoExceptions();
    }

    public ResultSet processQuery(final SQLStatement inStatement) throws SQLException {
        return (ResultSet)new DBUnInterruptible(){

            public Object execute() throws Exception {
                ResultSet rs = null;
                PreparedStatement pstmt = DBConnection.this.mConnection.prepareStatement(inStatement.getSQLString());
                pstmt.setEscapeProcessing(false);
                PersistenceManager.getInstance().getTransactionManager().addSQLStatement(inStatement);
                if (Logger.isDebugEnabled(DBConnection.QUERY_LOGGER_CATEGORY)) {
                    Logger.debug("Running Query " + inStatement.getSQLString(), DBConnection.QUERY_LOGGER_CATEGORY);
                }
                for (int i = 0; i < inStatement.getNumParameters(); ++i) {
                    int SQLParamNum = i + 1;
                    int pmParamNum = i;
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug(" Parameter Number " + SQLParamNum + " " + inStatement.getParameter(i), this);
                    }
                    pstmt.setObject(SQLParamNum, inStatement.getParameter(pmParamNum));
                }
                long time = System.currentTimeMillis();
                rs = pstmt.executeQuery();
                if (Logger.isDebugEnabled(DBConnection.METRICS_LOGGER_CATEGORY)) {
                    time = System.currentTimeMillis() - time;
                    Logger.debug("TIME:" + time + ":QUERY:" + inStatement.getSQLString(), DBConnection.METRICS_LOGGER_CATEGORY);
                }
                pstmt.clearParameters();
                inStatement.setStatement(pstmt);
                return rs;
            }
        }.doExecute();
    }

    public int processUpdate(final SQLStatement inStatement) throws SQLException {
        return (Integer)new DBUnInterruptible(){

            public Object execute() throws Exception {
                PreparedStatement pstmt = DBConnection.this.mConnection.prepareStatement(inStatement.getSQLString());
                pstmt.setEscapeProcessing(false);
                PersistenceManager.getInstance().getTransactionManager().addSQLStatement(inStatement);
                if (Logger.isDebugEnabled(DBConnection.QUERY_LOGGER_CATEGORY)) {
                    Logger.debug("Running Update " + inStatement.getSQLString(), DBConnection.QUERY_LOGGER_CATEGORY);
                }
                for (int i = 0; i < inStatement.getNumParameters(); ++i) {
                    int SQLParamNum = i + 1;
                    int pmParamNum = i;
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug(" Parameter Number " + SQLParamNum + " " + inStatement.getParameter(i), this);
                    }
                    pstmt.setObject(SQLParamNum, inStatement.getParameter(pmParamNum));
                }
                long time = System.currentTimeMillis();
                int results = pstmt.executeUpdate();
                if (Logger.isDebugEnabled(DBConnection.METRICS_LOGGER_CATEGORY)) {
                    time = System.currentTimeMillis() - time;
                    Logger.debug("TIME:" + time + ":QUERY:" + inStatement.getSQLString(), DBConnection.METRICS_LOGGER_CATEGORY);
                }
                pstmt.clearParameters();
                inStatement.setStatement(pstmt);
                return new Integer(results);
            }
        }.doExecute();
    }

    public void testConnection() throws SQLException {
        if (this.isClosed()) {
            ROXMessage theMessage = new ROXMessage("pm.CONNECTION_IS_CLOSED");
            throw new SQLException(theMessage.getMessageString());
        }
        new DBUnInterruptible(){

            public Object execute() throws Exception {
                DBConnection.this.mConnection.getMetaData();
                return null;
            }
        }.doExecute();
    }

    public void setAutoCommit(final boolean inAutoCommit) throws SQLException {
        new DBUnInterruptible(){

            public Object execute() throws Exception {
                DBConnection.this.mConnection.setAutoCommit(inAutoCommit);
                return null;
            }
        }.doExecute();
    }

    private static abstract class DBUnInterruptible
    extends Uninterruptible {
        private DBUnInterruptible() {
        }

        public Object doExecute() throws SQLException {
            try {
                return this.run();
            }
            catch (SQLException sqle) {
                throw sqle;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception unexpected) {
                throw new SQLException(unexpected.toString());
            }
        }
    }
}

