/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.sql;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.sql.ConnectionNotAvailable;
import com.raplix.rolloutexpress.persist.sql.DBConnection;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.util.locks.DeadlockException;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.FIFOQueue;
import java.sql.SQLException;
import java.util.Stack;

public class ConnectionPool {
    private Database mDB;
    private Stack mUsedConnections;
    private Stack mFreeConnections;
    private FIFOQueue mThreadQueue;
    private int mConnectionCheckoutLimit;

    public ConnectionPool(Database inDB, int inMaxConnections, int inConnectionCheckoutTimeLimit) {
        this.mDB = inDB;
        this.mUsedConnections = new Stack();
        this.mFreeConnections = new Stack();
        this.mConnectionCheckoutLimit = inConnectionCheckoutTimeLimit;
        this.mThreadQueue = new FIFOQueue(inMaxConnections);
    }

    public synchronized int getNumFreeConnections() {
        return this.mFreeConnections.size();
    }

    public synchronized int getNumConnectionsInUse() {
        return this.mUsedConnections.size();
    }

    public synchronized int getNumAllocatedConnections() {
        return this.mFreeConnections.size() + this.mUsedConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBConnection getConnection() throws ConnectionNotAvailable {
        try {
            this.mThreadQueue.acquire();
        }
        catch (InterruptedException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Couldn't acquire connection", e, this);
            }
            throw new ConnectionNotAvailable(new ROXMessage("pm.cp.NO_CONNECTION", new String[0]));
        }
        catch (DeadlockException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Couldn't acquire connection", e, this);
            }
            throw new ConnectionNotAvailable(new ROXMessage("pm.cp.NO_CONNECTION", new String[0]));
        }
        boolean exceptionThrown = false;
        DBConnection conn = null;
        try {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                Logger.debug("Retreiving Connection " + this.getNumConnectionsInUse() + " connections in use " + this.getNumFreeConnections() + " free ", this);
                while (conn == null && this.mFreeConnections.size() > 0) {
                    conn = (DBConnection)this.mFreeConnections.pop();
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Popped " + conn + " off of free pool", this);
                    }
                    try {
                        conn.testConnection();
                    }
                    catch (SQLException e) {
                        conn.closeThrowsNoExceptions();
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("Closing bad connection: " + conn, this);
                        }
                        conn = null;
                    }
                }
                SQLException connError = null;
                if (conn == null) {
                    try {
                        conn = this.mDB.getNewConnection();
                    }
                    catch (SQLException e) {
                        conn = null;
                        connError = e;
                    }
                }
                if (conn == null) {
                    throw new ConnectionNotAvailable(new ROXMessage("pm.cp.NO_CONNECTION", new String[0]), connError);
                }
                this.mUsedConnections.push(conn);
            }
        }
        catch (Throwable e) {
            exceptionThrown = true;
            if (e instanceof ConnectionNotAvailable) {
                throw (ConnectionNotAvailable)e;
            }
            throw new ConnectionNotAvailable(e);
        }
        finally {
            if (exceptionThrown) {
                this.mThreadQueue.release(null);
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Get Connection Completed - returning:  " + conn + " " + " Connections free now: " + this.mFreeConnections.size() + " Connections Used: " + this.mUsedConnections.size(), this);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void returnConnection(DBConnection inConnection) {
        Logger.debug("Returng Connection " + this.getNumConnectionsInUse() + " connections in use " + this.getNumFreeConnections() + " free ", this);
        try {
            this.mUsedConnections.remove(inConnection);
            boolean connectionIsBad = false;
            try {
                inConnection.clearWarnings();
            }
            catch (SQLException e) {
                connectionIsBad = true;
            }
            if (connectionIsBad) {
                inConnection.closeThrowsNoExceptions();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Destroying connection " + inConnection, this);
                }
            } else {
                this.mFreeConnections.push(inConnection);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Added connection " + inConnection + " to the free pool", this);
                }
            }
        }
        finally {
            this.mThreadQueue.release(null);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Connection Checked in: " + inConnection + " Connections free now: " + this.mFreeConnections.size() + " Connections Used: " + this.mUsedConnections.size(), this);
        }
    }

    private synchronized void closeAllConnectionsOnStack(Stack inConnectionStack) {
        if (inConnectionStack != null) {
            for (int i = 0; i < inConnectionStack.size(); ++i) {
                DBConnection conn = (DBConnection)inConnectionStack.pop();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Closing connection: " + conn, this);
                }
                conn.closeThrowsNoExceptions();
            }
        }
    }

    public synchronized void shutdown() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Database " + this + " is shutting down ", this);
        }
        this.closeAllConnectionsOnStack(this.mFreeConnections);
        this.closeAllConnectionsOnStack(this.mUsedConnections);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Database " + this + " shutdown complete", this);
        }
    }

    protected synchronized void finalize() throws Throwable {
        this.shutdown();
    }
}

