/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.DateColumn;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserDataTable;

public abstract class VersionedTable
extends Table {
    public final transient IDColumn RootID = new IDColumn(this, "RootID");
    public final transient IDColumn UserID = new IDColumn(this, "UserID");
    public final transient IntColumn Version = new IntColumn(this, "Version");
    public final transient DateColumn TimeStamp = new DateColumn(this, "TimeStamp");
    private static final String INNER_TBL_SUFFIX = "_inner";

    private VersionedTable() {
        this(null);
    }

    public VersionedTable(String inAlias) {
        super(inAlias);
        this.addColumn(this.RootID);
        this.addColumn(this.UserID);
        this.addColumn(this.Version);
        this.addColumn(this.TimeStamp);
    }

    public IDColumn cRootID() {
        return this.RootID;
    }

    public IDColumn cUserID() {
        return this.UserID;
    }

    public IntColumn cVersion() {
        return this.Version;
    }

    public DateColumn cTimeStamp() {
        return this.TimeStamp;
    }

    public ConditionalExpression isLatest() {
        return VersionedTable.in(VersionedTable.cList(this.Version, (ColumnNode)this.RootID), ((VersionedTable)this.instance(this.getAlias() + INNER_TBL_SUFFIX)).selectMostRecent());
    }

    public Select selectLatest(VersionedObjectID inRootID) {
        return VersionedTable.select(this.allColumns(), VersionedTable.tList(this), VersionedTable.where(VersionedTable.and(VersionedTable.equals(this.RootID, inRootID), VersionedTable.equals((ColumnNode)this.Version, VersionedTable.select(VersionedTable.sList(VersionedTable.max(this.Version)), VersionedTable.tList(this), VersionedTable.where(VersionedTable.equals(this.RootID, inRootID)))))));
    }

    public Select selectMostRecent() {
        return VersionedTable.select(VersionedTable.sList(VersionedTable.max(this.Version), (ScalarExp)this.RootID), VersionedTable.tList(this), null, VersionedTable.gList(this.RootID));
    }

    public ConditionalExpression isVersionOf(VersionedTable innerTable, ConditionalExpression uniqueExp) {
        return VersionedTable.equals((ColumnNode)this.RootID, innerTable.selectRootIDWhere(uniqueExp));
    }

    public ConditionalExpression isVersionOf(VersionedObjectID inObjectID) {
        VersionedTable innerTable = (VersionedTable)this.instance(this.getAlias() + INNER_TBL_SUFFIX);
        return this.isVersionOf(innerTable, VersionedTable.equals(innerTable.ID, inObjectID));
    }

    public ConditionalExpression isVersionOfAny(Select ids) {
        VersionedTable innerTable = (VersionedTable)this.instance(this.getAlias() + INNER_TBL_SUFFIX);
        return VersionedTable.in((ColumnNode)this.RootID, innerTable.selectRootIDsOf(ids));
    }

    public Select selectRootIDWhere(ConditionalExpression uniqueExp) {
        return this.select(VersionedTable.sList(this.RootID), VersionedTable.where(uniqueExp));
    }

    private Select selectRootIDsOf(Select ids) {
        return this.selectRootIDWhere(VersionedTable.in((ColumnNode)this.ID, ids));
    }

    public int lockRoots(Select ids) throws PersistenceManagerException {
        return VersionedTable.lock(this.select(VersionedTable.sList(this.ID), VersionedTable.where(VersionedTable.in((ColumnNode)this.ID, this.selectRootIDsOf(ids)))));
    }

    public ConditionalExpression matchesVersion(String version) {
        VersionNumber vn;
        if (version == null) {
            return this.isLatest();
        }
        try {
            vn = new VersionNumber(version);
        }
        catch (PersistenceManagerException e) {
            return VersionedTable.none();
        }
        return VersionedTable.equals(this.Version, vn.getSingleVersionNumber());
    }

    public OrderByList orderByVersionAsc(QueryContext ctx) {
        return VersionedTable.oList(VersionedTable.orderByAsc(this.Version));
    }

    public OrderByList orderByVersionDesc(QueryContext ctx) {
        return VersionedTable.oList(VersionedTable.orderByDesc(this.Version));
    }

    public OrderByList orderByTimeStampAsc(QueryContext ctx) {
        return VersionedTable.oList(VersionedTable.orderByAsc(this.TimeStamp));
    }

    public OrderByList orderByTimeStampDesc(QueryContext ctx) {
        return VersionedTable.oList(VersionedTable.orderByDesc(this.TimeStamp));
    }

    public OrderByList orderByUsernameAsc(QueryContext ctx) {
        PersistentUserDataTable uT = this.joinUserTable(ctx);
        OrderByList result = VersionedTable.dictOrderAsc(uT.Username);
        result.add(this.orderByVersionDesc(ctx));
        return result;
    }

    private PersistentUserDataTable joinUserTable(QueryContext ctx) {
        PersistentUserDataTable uT = new PersistentUserDataTable("uT");
        ctx.addTable(uT);
        ctx.addAndWhereCondition(VersionedTable.equals((ColumnNode)uT.ID, this.UserID));
        return uT;
    }

    public OrderByList orderByUsernameDesc(QueryContext ctx) {
        PersistentUserDataTable uT = this.joinUserTable(ctx);
        OrderByList result = VersionedTable.dictOrderDesc(uT.Username);
        result.add(this.orderByVersionDesc(ctx));
        return result;
    }
}

