/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.map.attribute.BooleanAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.DateAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.DoubleAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.EnumAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.FloatAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.IDAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.IntAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.LongAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.util.enum.Enum;
import java.util.Date;

class ValueWrapper
implements ScalarExp {
    private String valueString;
    static final ValueWrapper NULL = new ValueWrapper();

    private ValueWrapper() {
        this.valueString = "NULL";
    }

    public ValueWrapper(int value) {
        this.valueString = IntAttributeMap.convertToString(value);
    }

    public ValueWrapper(long value) {
        this.valueString = LongAttributeMap.convertToString(value);
    }

    public ValueWrapper(float value) {
        this.valueString = FloatAttributeMap.convertToString(value);
    }

    public ValueWrapper(double value) {
        this.valueString = DoubleAttributeMap.convertToString(value);
    }

    public ValueWrapper(boolean value) {
        this.valueString = BooleanAttributeMap.convertToString(value);
    }

    public ValueWrapper(String value) {
        this.valueString = "'" + StringAttributeMap.convertToString(value) + "'";
    }

    public ValueWrapper(Date value) {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        this.valueString = "'" + DateAttributeMap.convertToString(value) + "'";
    }

    public ValueWrapper(ObjectID value) {
        this.valueString = "'" + IDAttributeMap.convertToString(value) + "'";
    }

    public ValueWrapper(Enum value) {
        this.valueString = EnumAttributeMap.convertToString(value);
    }

    public void writeSQL(SQLStatement stmt) {
        stmt.addSQLClause(this.valueString).addSQLClause(" ");
    }
}

