/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.MapXMLReader;
import com.raplix.rolloutexpress.persist.map.attribute.AssociationAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.BooleanAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.DateAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.DoubleAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.EnumAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.FloatAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.IDAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.IntAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.LongAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.BooleanColumn;
import com.raplix.rolloutexpress.persist.query.builder.DateColumn;
import com.raplix.rolloutexpress.persist.query.builder.DoubleColumn;
import com.raplix.rolloutexpress.persist.query.builder.EnumColumn;
import com.raplix.rolloutexpress.persist.query.builder.FloatColumn;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.IllegalAttributeType;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.LongColumn;
import com.raplix.rolloutexpress.persist.query.builder.StandardObjectTable;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.VersionedTable;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.REUtil;
import com.raplix.util.regex.RegEx;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class TableClassGenerator
extends Application {
    private static final String T = "\t";
    public static final String TABLE_CLASS_SUFFIX = "Table";
    public static final String DEFAULT_INSTANCE_NAME = "DEFAULT";
    PersistenceManager pSubsystem;
    private File directory = null;
    private RegEx mFileMatchPattern = null;
    private boolean mGenerateFiles = true;
    private boolean mVerifyFiles = true;
    private boolean mListVerificationErrors = false;
    private boolean mReadSystemMapping = true;
    private LinkedList mExtraMappings = new LinkedList();
    private NetSubsystem mNetSubsystem = NetSubsystem.createNetSubsystemForTest(this);
    private static final Hashtable attrTypeMap = new Hashtable();
    private static final HashSet skipColumns;
    private static final HashSet skipVersionColumns;

    public static int verifyAllTableClasses(String[] appArgs) throws ConfigurationException, UnsupportedSubsystemException, IOException, IllegalAttributeType {
        TableClassGenerator tGen = new TableClassGenerator(appArgs);
        tGen.mReadSystemMapping = true;
        tGen.mListVerificationErrors = true;
        tGen.mGenerateFiles = false;
        tGen.mVerifyFiles = true;
        tGen.mFileMatchPattern = null;
        tGen.mExtraMappings.add("mapping/typeTest/associationMapping.xml");
        tGen.mExtraMappings.add("mapping/typeTest/booleanMapping.xml");
        tGen.mExtraMappings.add("mapping/typeTest/dateMapping.xml");
        tGen.mExtraMappings.add("mapping/typeTest/doubleMapping.xml");
        tGen.mExtraMappings.add("mapping/typeTest/floatMapping.xml");
        tGen.mExtraMappings.add("mapping/typeTest/idMapping.xml");
        tGen.mExtraMappings.add("mapping/typeTest/intMapping.xml");
        tGen.mExtraMappings.add("mapping/typeTest/longMapping.xml");
        tGen.mExtraMappings.add("mapping/typeTest/stringMapping.xml");
        tGen.mExtraMappings.add("mapping/typeTest/enumMapping.xml");
        tGen.mExtraMappings.add("mapping/correct_mapping.xml");
        tGen.mExtraMappings.add("mapping/permission_mapping.xml");
        tGen.mExtraMappings.add("mapping/version.xml");
        tGen.mExtraMappings.add("mapping/cache_mapping.xml");
        tGen.mExtraMappings.add("mapping/query_builder.xml");
        tGen.mExtraMappings.add("mapping/test_bean_mapping.xml");
        tGen.mExtraMappings.add("mapping/vehicle_mapping.xml");
        tGen.mExtraMappings.add("mapping/catdb.xml");
        tGen.postInit();
        return tGen.generateHelpers();
    }

    public TableClassGenerator(String[] args) throws ConfigurationException {
        super(args);
    }

    private void parseArguments(String[] args) throws ConfigurationException {
        StringTokenizer extraMappings = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-d") && ++i < args.length) {
                this.directory = new File(args[i]);
                if (!(this.directory.exists() && this.directory.isDirectory() && this.directory.canWrite())) {
                    throw new ConfigurationException("Cannot write to :" + this.directory.getAbsolutePath());
                }
            }
            if (args[i].startsWith("-p") && ++i < args.length) {
                this.mFileMatchPattern = REUtil.compileWildcard(args[i]);
            }
            if (args[i].startsWith("-g")) {
                this.mGenerateFiles = false;
            }
            if (args[i].startsWith("-v")) {
                this.mVerifyFiles = false;
            }
            if (args[i].startsWith("-s")) {
                this.mReadSystemMapping = false;
            }
            if (args[i].startsWith("-e")) {
                this.mListVerificationErrors = true;
            }
            if (!args[i].startsWith("-m") || ++i >= args.length) continue;
            extraMappings = new StringTokenizer(args[i], ",");
        }
        if (this.directory == null) {
            throw new ConfigurationException("Please supply a directory to write the files into as -d <directory>");
        }
        if (extraMappings != null) {
            while (extraMappings.hasMoreTokens()) {
                this.mExtraMappings.add(extraMappings.nextToken());
            }
        }
    }

    private void postInit() throws ConfigurationException {
        this.pSubsystem = PersistenceManager.createPMForTableGen(this, this.mReadSystemMapping);
        try {
            this.pSubsystem.registerRPCInterfaces(this.getNetSubsystem().getRPC());
        }
        catch (RPCException e) {
            throw new ConfigurationException("Error registering rpc interface", (Throwable)e);
        }
        if (this.mExtraMappings.size() > 0) {
            try {
                Iterator mappings = this.mExtraMappings.iterator();
                while (mappings.hasNext()) {
                    FileInputStream is = new FileInputStream((String)mappings.next());
                    MapXMLReader reader = new MapXMLReader(this.pSubsystem, is, true);
                    reader.readFromXML();
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Error adding extra mappings", (Throwable)e);
            }
        }
    }

    protected String getVersionString() {
        return "Ver 1.0";
    }

    public NetSubsystem getNetSubsystem() {
        return this.mNetSubsystem;
    }

    protected void shutdown() throws RaplixShutdownException {
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
    }

    public PersistenceManager getPMSubsystem() throws UnsupportedSubsystemException {
        return this.pSubsystem;
    }

    public static void main(String[] args) {
        try {
            TableClassGenerator tGen = new TableClassGenerator(args);
            tGen.parseArguments(args);
            tGen.postInit();
            tGen.generateHelpers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int generateHelpers() throws UnsupportedSubsystemException, IOException, IllegalAttributeType, ConfigurationException {
        Enumeration maps = this.pSubsystem.getClassMaps();
        LinkedList errorList = null;
        int cntTableVerificationFailures = 0;
        while (maps.hasMoreElements()) {
            ClassMap classMap = (ClassMap)maps.nextElement();
            if (this.mFileMatchPattern != null && !this.mFileMatchPattern.match(classMap.getMappedClass().getName())) continue;
            if (this.mVerifyFiles) {
                this.verifyClassMapTableParameters(classMap);
                errorList = this.verifyTableClass(classMap);
                if (errorList != null && errorList.size() > 0) {
                    ++cntTableVerificationFailures;
                    if (this.mListVerificationErrors) {
                        Iterator iter = errorList.iterator();
                        if (Logger.isErrorEnabled(class$com$raplix$rolloutexpress$persist$query$builder$TableClassGenerator == null ? TableClassGenerator.class$("com.raplix.rolloutexpress.persist.query.builder.TableClassGenerator") : class$com$raplix$rolloutexpress$persist$query$builder$TableClassGenerator)) {
                            while (iter.hasNext()) {
                                Logger.error("VerificationErr:", (Throwable)iter.next(), class$com$raplix$rolloutexpress$persist$query$builder$TableClassGenerator == null ? TableClassGenerator.class$("com.raplix.rolloutexpress.persist.query.builder.TableClassGenerator") : class$com$raplix$rolloutexpress$persist$query$builder$TableClassGenerator);
                            }
                        }
                    }
                } else if (Logger.isInfoEnabled(class$com$raplix$rolloutexpress$persist$query$builder$TableClassGenerator == null ? TableClassGenerator.class$("com.raplix.rolloutexpress.persist.query.builder.TableClassGenerator") : class$com$raplix$rolloutexpress$persist$query$builder$TableClassGenerator)) {
                    Logger.info("Verified:" + classMap.getMappedClass().getName(), class$com$raplix$rolloutexpress$persist$query$builder$TableClassGenerator == null ? TableClassGenerator.class$("com.raplix.rolloutexpress.persist.query.builder.TableClassGenerator") : class$com$raplix$rolloutexpress$persist$query$builder$TableClassGenerator);
                }
            }
            if (!this.mGenerateFiles || this.mVerifyFiles && (!this.mVerifyFiles || errorList.size() <= 0)) continue;
            this.generateHelper(classMap, this.getFileName(classMap, this.directory));
        }
        return cntTableVerificationFailures;
    }

    private File getFileName(ClassMap map, File directory) {
        String name = map.getMappedClass().getName().replace('.', File.separatorChar);
        File destination = new File(directory, name + TABLE_CLASS_SUFFIX + ".java");
        return destination;
    }

    private void generateHelper(ClassMap inClassMap, File fileName) throws IOException, IllegalAttributeType, ConfigurationException {
        Class cls;
        AttributeMap attrMap;
        if (Logger.isInfoEnabled(TableClassGenerator.class)) {
            Logger.info("Generating:" + fileName.getAbsolutePath(), TableClassGenerator.class);
        }
        PrintWriter pw = new PrintWriter(new FileWriter(fileName));
        this.verifyClassMapTableParameters(inClassMap);
        Class mappedClass = inClassMap.getMappedClass();
        String baseClass = inClassMap.getTableBaseClassName();
        String interfaceNameList = inClassMap.getTableClassInterfaces();
        pw.println("package " + mappedClass.getPackage().getName() + ";");
        pw.println("/*---------------THIS IS A GENERATED FILE---------*");
        pw.println(" *---------------------DO NOT EDIT----------------*/");
        String clsName = mappedClass.getName();
        clsName = clsName.substring(clsName.lastIndexOf(46) + 1);
        clsName = clsName + TABLE_CLASS_SUFFIX;
        pw.print("public class " + clsName + " extends ");
        if (baseClass != null && baseClass.trim().length() > 0) {
            pw.print(baseClass);
        } else if (VersionedPersistentBean.class.isAssignableFrom(mappedClass)) {
            pw.print(VersionedTable.class.getName());
        } else {
            pw.print(Table.class.getName());
        }
        if (StandardObject.class.isAssignableFrom(mappedClass)) {
            interfaceNameList = interfaceNameList == null || interfaceNameList.trim().length() < 1 ? StandardObjectTable.class.getName() : interfaceNameList + ", " + StandardObjectTable.class.getName();
        }
        if (interfaceNameList != null && interfaceNameList.trim().length() > 0) {
            pw.print(" implements " + interfaceNameList);
        }
        pw.println(" {");
        pw.println("\tpublic Class getJavaClass() {");
        pw.println("\t\treturn " + mappedClass.getName() + ".class;");
        pw.println("\t}");
        Iterator attributes = inClassMap.getAttributeMaps().values().iterator();
        while (attributes.hasNext()) {
            attrMap = (AttributeMap)attributes.next();
            if (TableClassGenerator.skipColumn(attrMap)) continue;
            cls = (Class)attrTypeMap.get(attrMap.getClass());
            if (cls == null) {
                throw new IllegalAttributeType("Attribute type not supported:" + attrMap);
            }
            pw.println("\tpublic transient final " + cls.getName() + " " + attrMap.getAttributeName() + " = new " + cls.getName() + "(this,\"" + attrMap.getAttributeName() + "\");");
            pw.println("\tpublic " + cls.getName() + " c" + attrMap.getAttributeName() + "() {");
            pw.println("\t\treturn " + attrMap.getAttributeName() + ";");
            pw.println("\t}");
        }
        pw.println("\tpublic " + clsName + "(String alias) {");
        pw.println("\t\tsuper(alias);");
        attributes = inClassMap.getAttributeMaps().values().iterator();
        while (attributes.hasNext()) {
            attrMap = (AttributeMap)attributes.next();
            if (TableClassGenerator.skipColumn(attrMap) || (cls = (Class)attrTypeMap.get(attrMap.getClass())) == null) continue;
            pw.println("\t\taddColumn(" + attrMap.getAttributeName() + ");");
        }
        pw.println("\t}");
        pw.println("\tprivate " + clsName + "() {");
        pw.println("\t\tthis(null);");
        pw.println("\t}");
        pw.println("\tpublic static final " + clsName + " " + DEFAULT_INSTANCE_NAME + " = new " + clsName + "();");
        pw.println("\tpublic " + mappedClass.getName() + " retrieveObject(" + ResultSet.class.getName() + " inRS)" + " throws " + ClassMapException.class.getName() + "," + SQLException.class.getName() + " {");
        pw.println("\t\treturn (" + mappedClass.getName() + ")retrieveObjectFrom(inRS);");
        pw.println("\t}");
        pw.println("\tpublic " + Table.class.getName() + " instance() {");
        pw.println("\t\treturn DEFAULT;");
        pw.println("\t}");
        pw.println("\tpublic " + Table.class.getName() + " instance(String alias) {");
        pw.println("\t\treturn new " + clsName + "(alias);");
        pw.println("\t}");
        pw.println("}");
        pw.close();
    }

    private void verifyClassMapTableParameters(ClassMap clsMap) throws ConfigurationException {
        String interfaces;
        String baseClass = clsMap.getTableBaseClassName();
        if (baseClass != null && baseClass.trim().length() > 0) {
            try {
                Class<?> base = Class.forName(baseClass);
                Class objectClass = clsMap.getMappedClass();
                if (!Table.class.isAssignableFrom(base)) {
                    throw new ConfigurationException("The supplied base class:" + base + "should descend from Table");
                }
                if (VersionedPersistentBean.class.isAssignableFrom(objectClass) && !VersionedTable.class.isAssignableFrom(objectClass)) {
                    throw new ConfigurationException("The supplied base class:" + base + "should extend VersionedTable");
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException("Specified baseClass not found:" + baseClass, (Throwable)cnfe);
            }
        }
        if ((interfaces = clsMap.getTableClassInterfaces()) != null && interfaces.trim().length() > 0) {
            StringTokenizer strTok = new StringTokenizer(interfaces, ",");
            String name = null;
            try {
                while (strTok.hasMoreTokens()) {
                    name = strTok.nextToken();
                    Class.forName(name);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException("Interface:" + name + " not found", (Throwable)cnfe);
            }
        }
    }

    private static boolean skipColumn(AttributeMap aMap) {
        return skipColumns.contains(aMap.getAttributeName()) || VersionedPersistentBean.class.isAssignableFrom(aMap.getClassMap().getMappedClass()) && skipVersionColumns.contains(aMap.getAttributeName());
    }

    public static String getTableClassName(Class mappedClass) {
        return mappedClass.getName() + TABLE_CLASS_SUFFIX;
    }

    private LinkedList verifyTableClass(ClassMap inClassMap) {
        LinkedList<Throwable> errorList = new LinkedList<Throwable>();
        try {
            String tableClassName = TableClassGenerator.getTableClassName(inClassMap.getMappedClass());
            Class<?> tableClass = Class.forName(tableClassName);
            String baseClassName = inClassMap.getTableBaseClassName();
            String interfacesList = inClassMap.getTableClassInterfaces();
            if (baseClassName != null && baseClassName.trim().length() > 0) {
                if (!tableClass.getSuperclass().getName().equals(baseClassName)) {
                    throw new ConfigurationException("Table class doesn't extend the specified base class:" + baseClassName);
                }
            } else if (VersionedPersistentBean.class.isAssignableFrom(inClassMap.getMappedClass())) {
                if (!tableClass.getSuperclass().equals(VersionedTable.class)) {
                    throw new ConfigurationException("Table superclass is not VersionTable:" + tableClassName);
                }
            } else if (!tableClass.getSuperclass().equals(Table.class)) {
                throw new ConfigurationException("Table superclass is not Table:" + tableClassName);
            }
            HashSet interfaceSet = new HashSet();
            Class<?>[] intfClasses = tableClass.getInterfaces();
            for (int i = 0; i < intfClasses.length; ++i) {
                interfaceSet.add(intfClasses[i]);
            }
            if (interfacesList != null && interfacesList.trim().length() > 0) {
                StringTokenizer strTok = new StringTokenizer(interfacesList, ",");
                while (strTok.hasMoreTokens()) {
                    Class<?> cls = Class.forName(strTok.nextToken());
                    if (interfaceSet.remove(cls)) continue;
                    throw new ConfigurationException("tableClass:" + tableClass + " doesn't implement the interface:" + cls);
                }
            }
            if (StandardObject.class.isAssignableFrom(inClassMap.getMappedClass()) && !interfaceSet.remove(StandardObjectTable.class)) {
                throw new ConfigurationException("Table class doesn't implement StandardObject:" + tableClassName);
            }
            if (!interfaceSet.isEmpty()) {
                throw new ConfigurationException("Table class implements extra interfaces:" + interfaceSet);
            }
            Field[] fields = tableClass.getDeclaredFields();
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                fieldMap.put(fields[i].getName(), fields[i]);
            }
            Iterator attributes = inClassMap.getAttributeMaps().values().iterator();
            while (attributes.hasNext()) {
                try {
                    Method method;
                    AttributeMap attrMap = (AttributeMap)attributes.next();
                    if (TableClassGenerator.skipColumn(attrMap)) continue;
                    Class cls = (Class)attrTypeMap.get(attrMap.getClass());
                    if (cls == null) {
                        throw new IllegalAttributeType("Attribute type not supported:" + attrMap);
                    }
                    Field field = (Field)fieldMap.get(attrMap.getAttributeName());
                    if (field == null) {
                        throw new IllegalAttributeType("No Field defined for attribute:" + attrMap.getAttributeName());
                    }
                    fieldMap.remove(attrMap.getAttributeName());
                    if (!field.getType().equals(cls)) {
                        throw new IllegalAttributeType("Field type mismatch:" + attrMap.getAttributeName());
                    }
                    if (!Modifier.isTransient(field.getModifiers())) {
                        throw new IllegalAttributeType("Field not transient:" + attrMap.getAttributeName());
                    }
                    try {
                        method = tableClass.getDeclaredMethod("c" + attrMap.getAttributeName(), new Class[0]);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new IllegalAttributeType("Accessor method not found for attribute:" + attrMap.getAttributeName());
                    }
                    if (cls.equals(method.getReturnType())) continue;
                    throw new IllegalAttributeType("Incorrect accesor return type for attribute:" + attrMap.getAttributeName());
                }
                catch (Exception ex) {
                    errorList.add(ex);
                }
            }
            if (fieldMap.size() > 0) {
                throw new IllegalAttributeType("Extra fields in table class:" + fieldMap);
            }
        }
        catch (Exception e) {
            errorList.add(e);
        }
        catch (LinkageError le) {
            errorList.add(le);
        }
        return errorList;
    }

    static {
        attrTypeMap.put(IntAttributeMap.class, IntColumn.class);
        attrTypeMap.put(LongAttributeMap.class, LongColumn.class);
        attrTypeMap.put(FloatAttributeMap.class, FloatColumn.class);
        attrTypeMap.put(DoubleAttributeMap.class, DoubleColumn.class);
        attrTypeMap.put(StringAttributeMap.class, StringColumn.class);
        attrTypeMap.put(BooleanAttributeMap.class, BooleanColumn.class);
        attrTypeMap.put(DateAttributeMap.class, DateColumn.class);
        attrTypeMap.put(AssociationAttributeMap.class, IDColumn.class);
        attrTypeMap.put(IDAttributeMap.class, IDColumn.class);
        attrTypeMap.put(EnumAttributeMap.class, EnumColumn.class);
        skipColumns = new HashSet();
        skipVersionColumns = new HashSet();
        skipColumns.add("UpdateCount");
        skipColumns.add("Visibility");
        skipVersionColumns.add("RootID");
        skipVersionColumns.add("UserID");
        skipVersionColumns.add("Version");
        skipVersionColumns.add("TimeStamp");
    }
}

