/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnList;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Delete;
import com.raplix.rolloutexpress.persist.query.builder.EnumColumn;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.IDValueProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Insert;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.SetList;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableColumnList;
import com.raplix.rolloutexpress.persist.query.builder.TableDependency;
import com.raplix.rolloutexpress.persist.query.builder.Update;
import com.raplix.rolloutexpress.persist.query.builder.ValueList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderObjectTable;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.util.collections.TypedSet;
import java.io.ObjectStreamException;
import java.security.AccessController;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class Table
extends QueryBuilder
implements TableClause {
    public static final String TABLE_COLUMN_DELIMITER = ".";
    public static final String TABLE_COLUMN_ALIAS_DELIMITER = "_";
    public final transient IDColumn ID;
    public final transient IntColumn UpdateCount;
    public final transient EnumColumn Visibility;
    private String mAlias;
    private String mColumnAliasPrefix;
    private String mColumnPrefix;
    private transient Vector mColumns = new Vector();
    private transient ClassMap mClassMap;
    private transient PersistenceManager mPM = null;

    protected Table(String inAlias) {
        this.mAlias = inAlias;
        if (this.mAlias == null) {
            this.mColumnAliasPrefix = "";
            this.mColumnPrefix = "";
        } else {
            this.mColumnAliasPrefix = this.mAlias + TABLE_COLUMN_ALIAS_DELIMITER;
            this.mColumnPrefix = this.mAlias + TABLE_COLUMN_DELIMITER;
        }
        this.ID = new IDColumn(this);
        this.UpdateCount = new IntColumn(this, "UpdateCount");
        this.Visibility = new EnumColumn(this, "Visibility");
        this.addColumn(this.ID);
        this.addColumn(this.UpdateCount);
        this.addColumn(this.Visibility);
    }

    protected Table() {
        this(null);
    }

    protected void addColumn(ColumnNode mColumnNode) {
        this.mColumns.add(mColumnNode);
    }

    public Enumeration getColumns() {
        return this.mColumns.elements();
    }

    public TableColumnList allColumns() {
        return new TableColumnList(this);
    }

    public void writeSQL(SQLStatement stmt) {
        stmt.addSQLClause(this.getTableName()).addSQLClause(" ");
        if (this.mAlias != null) {
            stmt.addSQLClause(this.mAlias).addSQLClause(" ");
        }
    }

    void writeColumnPrefix(SQLStatement stmt) {
        if (this.mAlias != null) {
            stmt.addSQLClause(this.mAlias).addSQLClause(TABLE_COLUMN_DELIMITER);
        }
    }

    String getColumnAliasPrefix() {
        return this.mColumnAliasPrefix;
    }

    public IDColumn cID() {
        return this.ID;
    }

    public IntColumn cUpdateCount() {
        return this.UpdateCount;
    }

    public EnumColumn cVisibility() {
        return this.Visibility;
    }

    String getColumnPrefix() {
        return this.mColumnPrefix;
    }

    public int hashCode() {
        return this.getJavaClass().hashCode();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Table) {
            Table table = (Table)o;
            return this.getJavaClass().equals(table.getJavaClass()) && (this.mAlias == null ? table.mAlias == null : this.mAlias.equals(table.mAlias));
        }
        return false;
    }

    public ClassMap getClassMap() {
        if (!this.isValidPM() || this.mClassMap == null) {
            this.mClassMap = this.mPM.getClassMap(this.getJavaClass().getName());
        }
        return this.mClassMap;
    }

    boolean isValidPM() {
        PersistenceManager curPM = PersistenceManager.getInstance();
        if (this.mPM == curPM) {
            return true;
        }
        this.mPM = curPM;
        return false;
    }

    public PersistentBean retrieveObjectFrom(ResultSet inResultSet) throws ClassMapException, SQLException {
        return this.getClassMap().retrieveObject(inResultSet, this);
    }

    public PersistentBean retrieveObjectFrom(ResultSet inResultSet, int inFlushCount) throws ClassMapException, SQLException {
        return this.getClassMap().retrieveObject(inResultSet, this, inFlushCount);
    }

    public int getCacheFlushCount() {
        return this.getClassMap().getCacheFlushCount();
    }

    public String getTableName() {
        return this.getClassMap().getTableMap().getTableName();
    }

    public void checkReadPermission() {
        this.getClassMap().checkReadPermission();
    }

    public void checkWritePermission() {
        this.getClassMap().checkWritePermission();
    }

    public void checkDeletePermission() {
        this.getClassMap().checkDeletePermission();
    }

    public abstract Class getJavaClass();

    public abstract Table instance();

    public abstract Table instance(String var1);

    public Select select() {
        return new Select(this);
    }

    public Select select(SelectList inSelectList) {
        return Table.select(inSelectList, Table.tList(this));
    }

    public Select select(WhereClause inWhereClause) {
        return this.select(this.allColumns(), inWhereClause);
    }

    public Select select(SelectList inSelectList, WhereClause inWhereClause) {
        return Table.select(inSelectList, Table.tList(this), inWhereClause);
    }

    public Select select(SelectList inSelectList, WhereClause inWhereClause, Select inUnionSelect) {
        return Table.select(inSelectList, Table.tList(this), inWhereClause, inUnionSelect);
    }

    public Select select(SelectList inSelectList, WhereClause inWhereClause, OrderByList inOrderList) {
        return Table.select(inSelectList, Table.tList(this), inWhereClause, inOrderList);
    }

    public Select select(SelectList inSelectList, WhereClause inWhereClause, Select inUnionSelect, OrderByList inOrderList) {
        return Table.select(inSelectList, Table.tList(this), inWhereClause, inUnionSelect, inOrderList);
    }

    public int selectCount(WhereClause inWhere) throws PersistenceManagerException {
        return Table.selectCount(this, inWhere);
    }

    public int selectCount() throws PersistenceManagerException {
        return Table.selectCount(this);
    }

    public Insert insert(ColumnList inColumnList, Select inSelect) {
        return Table.insert(inColumnList, this, inSelect);
    }

    public Insert insert(ColumnList inColumnList, ValueList inValueList) {
        return Table.insert(inColumnList, this, inValueList);
    }

    public Update update(SetList inSetList, WhereClause inWhereClause) {
        return new Update(this, inSetList, inWhereClause);
    }

    public Update update(SetList inSetList) {
        return new Update(this, inSetList);
    }

    public Update incrUpdateCountWhere(ConditionalExpression cond) {
        return this.update(Table.uList(Table.increment(this.cUpdateCount())), Table.where(cond));
    }

    public Update incrUpdateCountByID(Select idQuery) {
        return this.incrUpdateCountWhere(Table.in((ColumnNode)this.cID(), idQuery));
    }

    public Update incrUpdateCountByID(ObjectID objID) {
        return this.incrUpdateCountWhere(Table.equals(this.cID(), objID));
    }

    public int execIncrUpdateCountByID(ObjectID objID) throws PersistenceManagerException {
        return Table.execute(this.incrUpdateCountByID(objID));
    }

    public void executeIDsResult(IDColumn inIDCol, WhereClause inWhere, TypedSet outResults) throws PersistenceManagerException {
        IDValueProcessor p = new IDValueProcessor(inIDCol);
        Table.execute(this.select(Table.sList(inIDCol), inWhere), p);
        outResults.addAll((Collection)p.getRetrievedValues());
    }

    public Delete delete(WhereClause inWhereClause) {
        return new Delete(this, inWhereClause);
    }

    public Delete delete() {
        return new Delete(this);
    }

    public int updateVisibilityWhere(Visibility vis, WhereClause where) throws PersistenceManagerException {
        return Table.execute(this.update(Table.uList(Table.increment(this.cUpdateCount()), Table.set(this.cVisibility(), vis)), where));
    }

    protected String getAlias() {
        return this.mAlias == null ? "" : this.mAlias;
    }

    public Table getTableOfType(Class tableClass) {
        return tableClass.isInstance(this) ? this : null;
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.instance(this.mAlias);
    }

    public void registerDependency(TableDependency dep) {
        this.getClassMap().registerDependency(dep);
    }

    public void notifyDependenciesOfUpdate(Select idsUpdated) throws PersistenceManagerException {
        Enumeration deps = this.getClassMap().getDependencies();
        while (deps.hasMoreElements()) {
            TableDependency dep = (TableDependency)deps.nextElement();
            dep.onUpdate(idsUpdated);
        }
    }

    public TableDependency getInvalidateByIDDependency(final IDColumn idCol) {
        return new TableDependency(){

            public void onUpdate(Select idsSelected) throws PersistenceManagerException {
                QueryBuilder.execute(Table.this.incrUpdateCountWhere(QueryBuilder.in((ColumnNode)idCol, idsSelected)));
            }
        };
    }

    public void checkFolderPerm(Select candidateIDs) throws PersistenceManagerException {
        if (this instanceof FolderObjectTable) {
            IDColumn pathID = ((FolderObjectTable)((Object)this)).cPathID();
            IDValueProcessor valueProcessor = new IDValueProcessor(pathID);
            Table.execute(this.select(Table.sList(pathID), Table.where(Table.in((ColumnNode)this.ID, candidateIDs))), valueProcessor);
            Iterator iter = valueProcessor.getRetrievedValues().iterator();
            while (iter.hasNext()) {
                AccessController.checkPermission(new FolderPermission((FolderID)iter.next(), "write"));
            }
        }
    }
}

