/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class SingleResultSetProcessor
extends ResultSetProcessor {
    private Table mTable;
    private PersistentBean mObject = null;
    private boolean mLoadAssociation;

    public SingleResultSetProcessor(Table inTable) {
        this(inTable, true);
    }

    public SingleResultSetProcessor(Table inTable, boolean inLoadAssociation) {
        this.mTable = inTable;
        this.mLoadAssociation = inLoadAssociation;
    }

    public void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException {
        if (inResultSet.next()) {
            this.mObject = this.mTable.retrieveObjectFrom(inResultSet);
        }
    }

    public boolean loadAssociations() {
        return this.mLoadAssociation;
    }

    public PersistentBean getResult() {
        return this.mObject;
    }

    public Iterator getResultIterator() {
        return new SingleResultIterator(this.mObject);
    }

    private static class SingleResultIterator
    implements Iterator {
        private PersistentBean mObject;

        public SingleResultIterator(PersistentBean inObject) {
            this.mObject = inObject;
        }

        public boolean hasNext() {
            return this.mObject != null;
        }

        public Object next() {
            PersistentBean obj = this.mObject;
            this.mObject = null;
            return obj;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

