/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.query.builder.GroupByList;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.SqlQuery;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.util.Enumeration;

public class Select
implements SqlQuery {
    private static final String COMMA = ",";
    private SelectList mSelectList = null;
    private WhereClause mWhereClause = null;
    private TableList mTableList = null;
    private Select mUnionSelect = null;
    private GroupByList mGroupByList = null;
    private OrderByList mOrderByList = null;
    private int mLimit = -1;
    private int mOffset = -1;
    private boolean isDistinct = false;
    private boolean isForUpdate = false;

    public Select(Table inTable) {
        this.mSelectList = inTable.allColumns();
        this.mTableList = new TableList();
        this.mTableList.add(inTable);
    }

    public Select(SelectList inSelectList) {
        this.mSelectList = inSelectList;
    }

    public Select(SelectList inSelectList, Select inUnionSelect) {
        this.mSelectList = inSelectList;
        this.mUnionSelect = inUnionSelect;
    }

    public Select(SelectList inSelectList, TableList inTables, WhereClause inWhereClause) {
        this(inSelectList, inTables, inWhereClause, null, null);
    }

    public Select(SelectList inSelectList, TableList inTables, WhereClause inWhereClause, Select inUnionSelect) {
        this(inSelectList, inTables, inWhereClause, inUnionSelect, null);
    }

    public Select(SelectList inSelectList, TableList inTables, WhereClause inWhereClause, GroupByList inGroupByList) {
        this(inSelectList, inTables, inWhereClause, inGroupByList, null, null);
    }

    public Select(SelectList inSelectList, TableList inTables, WhereClause inWhereClause, Select inUnionSelect, OrderByList inOrderByList) {
        this(inSelectList, inTables, inWhereClause, null, inUnionSelect, inOrderByList);
    }

    public Select(SelectList inSelectList, TableList inTables, WhereClause inWhereClause, GroupByList inGroupByList, Select inUnionSelect, OrderByList inOrderByList) {
        this.mSelectList = inSelectList;
        this.mTableList = inTables;
        this.mWhereClause = inWhereClause;
        this.mGroupByList = inGroupByList;
        this.mUnionSelect = inUnionSelect;
        this.mOrderByList = inOrderByList;
    }

    public void writeSQL(SQLStatement stmt) {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        stmt.addSQLClause(db.getClauseStringSelect()).addSQLClause(" ");
        if (this.isDistinct) {
            stmt.addSQLClause(db.getClauseStringDistinct()).addSQLClause(" ");
        }
        this.mSelectList.writeSQL(stmt);
        if (this.mTableList != null) {
            Enumeration e = this.mTableList.getElements();
            while (e.hasMoreElements()) {
                ((TableClause)e.nextElement()).checkReadPermission();
            }
            stmt.addSQLClause(db.getClauseStringFrom()).addSQLClause(" ");
            this.mTableList.writeSQL(stmt);
        } else {
            db.getAnonymousSelectClause();
        }
        stmt.addSQLClause(" ");
        if (this.mWhereClause != null) {
            this.mWhereClause.writeSQL(stmt);
        }
        if (this.mGroupByList != null) {
            stmt.addSQLClause(db.getClauseStringGroupBy()).addSQLClause(" ");
            this.mGroupByList.writeSQL(stmt);
        }
        if (this.mUnionSelect != null) {
            stmt.addSQLClause(db.getClauseStringUnion()).addSQLClause(" ");
            this.mUnionSelect.writeSQL(stmt);
        }
        if (this.mOrderByList != null) {
            stmt.addSQLClause(db.getClauseStringOrderBy()).addSQLClause(" ");
            this.mOrderByList.writeSQL(stmt);
        }
        if (this.mLimit > 0 || this.mOffset > 0) {
            db.addLimitOffsetClause(stmt, this.mLimit, this.mOffset);
        }
        if (this.isForUpdate) {
            stmt.addSQLClause(" ").addSQLClause(db.getClauseStringForUpdate());
        }
    }

    void setDistinct(boolean distinct) {
        this.isDistinct = distinct;
    }

    void setForUpdate(boolean forUpdate) {
        this.isForUpdate = forUpdate;
    }

    void setLimit(int inLimit) {
        this.mLimit = inLimit;
    }

    void setOffset(int inOffset) {
        this.mOffset = inOffset;
    }

    public String toString() {
        return "Select:" + this.mSelectList + ":where:" + this.mWhereClause;
    }

    private Select() {
    }
}

