/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.QueryExecutor;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.Database;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

class QueryExecutorProcessor
extends QueryExecutor {
    private ResultSetProcessor mProcessor;

    public QueryExecutorProcessor(Database inDatabase, Select inSelect, ResultSetProcessor inProcessor) {
        super(inDatabase, inSelect);
        this.mProcessor = inProcessor;
    }

    protected void prepareToRunQuery() throws PersistenceManagerException, SQLException {
        super.prepareToRunQuery();
        this.mProcessor.prepareToRunQuery();
    }

    protected void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        this.mProcessor.processResultSet(inResultSet);
    }

    protected void finalizeQuery() throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        Iterator iter;
        super.finalizeQuery();
        if (this.mProcessor.loadAssociations() && (iter = this.mProcessor.getResultIterator()) != null) {
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof PersistentBean)) continue;
                PersistentBean bean = (PersistentBean)obj;
                PersistenceManager.getBeanManager().getClassMap(bean).loadAssociations(bean);
            }
        }
    }
}

