/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.builder.Insert;
import com.raplix.rolloutexpress.persist.query.builder.SqlModQuery;
import com.raplix.rolloutexpress.persist.query.builder.SqlQuery;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class QueryExecutor
extends Query {
    private SqlQuery mSqlQuery;
    private int mUpdateCount = -1;

    public QueryExecutor(Database db, SqlQuery inSqlQuery) {
        super(db, inSqlQuery instanceof SqlModQuery);
        this.mSqlQuery = inSqlQuery;
    }

    public QueryExecutor(SqlQuery inSqlQuery) {
        this(PersistenceManager.getInstance().getDefaultDatabase(), inSqlQuery);
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    protected SQLStatement generateSQLStatement() throws PersistenceManagerException, ClassMapException {
        SQLStatement sql = new SQLStatement();
        this.mSqlQuery.writeSQL(sql);
        return sql;
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
        this.mUpdateCount = numRowsAffected;
    }

    protected void prepareToRunQuery() throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
    }

    protected void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
    }

    protected void finalizeQuery() throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        if (this.mSqlQuery instanceof SqlModQuery && !(this.mSqlQuery instanceof Insert)) {
            ((SqlModQuery)this.mSqlQuery).getModTable().getClassMap().invalidateCache();
        }
    }
}

