/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.Between;
import com.raplix.rolloutexpress.persist.query.builder.BinaryOperator;
import com.raplix.rolloutexpress.persist.query.builder.BooleanColumn;
import com.raplix.rolloutexpress.persist.query.builder.ColumnList;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Comparison;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.DateColumn;
import com.raplix.rolloutexpress.persist.query.builder.Delete;
import com.raplix.rolloutexpress.persist.query.builder.DoubleColumn;
import com.raplix.rolloutexpress.persist.query.builder.EnumColumn;
import com.raplix.rolloutexpress.persist.query.builder.Exists;
import com.raplix.rolloutexpress.persist.query.builder.FloatColumn;
import com.raplix.rolloutexpress.persist.query.builder.Function;
import com.raplix.rolloutexpress.persist.query.builder.GroupByList;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.IfNullFunction;
import com.raplix.rolloutexpress.persist.query.builder.InExpr;
import com.raplix.rolloutexpress.persist.query.builder.Insert;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.IntValueProcessor;
import com.raplix.rolloutexpress.persist.query.builder.IsNull;
import com.raplix.rolloutexpress.persist.query.builder.Join;
import com.raplix.rolloutexpress.persist.query.builder.Like;
import com.raplix.rolloutexpress.persist.query.builder.LongColumn;
import com.raplix.rolloutexpress.persist.query.builder.MultiResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Not;
import com.raplix.rolloutexpress.persist.query.builder.OrExp;
import com.raplix.rolloutexpress.persist.query.builder.OrderByElement;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.QueryExecutor;
import com.raplix.rolloutexpress.persist.query.builder.QueryExecutorProcessor;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.ScalarList;
import com.raplix.rolloutexpress.persist.query.builder.ScalarSelect;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectAlias;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Set;
import com.raplix.rolloutexpress.persist.query.builder.SetIncrement;
import com.raplix.rolloutexpress.persist.query.builder.SetList;
import com.raplix.rolloutexpress.persist.query.builder.SingleResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.SqlModQuery;
import com.raplix.rolloutexpress.persist.query.builder.SqlNode;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.Update;
import com.raplix.rolloutexpress.persist.query.builder.ValueList;
import com.raplix.rolloutexpress.persist.query.builder.ValueWrapper;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.util.enum.Enum;
import com.raplix.util.regex.GlobPattern;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class QueryBuilder
implements RPCSerializable {
    public static Select anonSelect(SelectList inSelectList) {
        return new Select(inSelectList);
    }

    public static Select anonSelect(SelectList inSelectList, Select inUnionSelect) {
        return new Select(inSelectList, inUnionSelect);
    }

    public static Select select(Table inTable) {
        return new Select(inTable);
    }

    public static Select select(SelectList inSelectList, TableList inTableList) {
        return new Select(inSelectList, inTableList, null);
    }

    public static Select select(SelectList inSelectList, TableList inTableList, WhereClause inWhereClause) {
        return new Select(inSelectList, inTableList, inWhereClause);
    }

    public static Select select(SelectList inSelectList, TableList inTableList, WhereClause inWhereClause, Select inUnionSelect) {
        return new Select(inSelectList, inTableList, inWhereClause, inUnionSelect);
    }

    public static Select select(SelectList inSelectList, TableList inTableList, WhereClause inWhereClause, OrderByList inOrderList) {
        return new Select(inSelectList, inTableList, inWhereClause, null, inOrderList);
    }

    public static Select select(SelectList inSelectList, TableList inTableList, WhereClause inWhereClause, GroupByList inGroupByList) {
        return new Select(inSelectList, inTableList, inWhereClause, inGroupByList);
    }

    public static Select select(SelectList inSelectList, TableList inTableList, WhereClause inWhereClause, Select inUnionSelect, OrderByList inOrderList) {
        return new Select(inSelectList, inTableList, inWhereClause, inUnionSelect, inOrderList);
    }

    public static Select limit(Select inSelect, int inLimit, int inOffset) {
        inSelect.setLimit(inLimit);
        inSelect.setOffset(inOffset);
        return inSelect;
    }

    public static Select distinct(Select inSelect) {
        inSelect.setDistinct(true);
        return inSelect;
    }

    public static int lock(Select inSelect) throws PersistenceManagerException {
        inSelect.setForUpdate(true);
        RowCountProcessor rcp = new RowCountProcessor();
        QueryBuilder.execute(inSelect, rcp);
        return rcp.getRowCount();
    }

    public static Select selectExists(Select inSelect) {
        return QueryBuilder.anonSelect(QueryBuilder.sList(QueryBuilder.exists(inSelect)));
    }

    public static Insert insert(ColumnList inColumnList, Table inTable, Select inSelect) {
        return new Insert(inColumnList, inTable, inSelect);
    }

    public static Insert insert(ColumnList inColumnList, Table inTable, ValueList inValueList) {
        return new Insert(inColumnList, inTable, inValueList);
    }

    public static Update update(Table inTable, SetList inSetList, WhereClause inWhereClause) {
        return new Update(inTable, inSetList, inWhereClause);
    }

    public static Update update(Table inTable, SetList inSetList) {
        return new Update(inTable, inSetList);
    }

    public static Delete delete(Table inTable, WhereClause inWhereClause) {
        return new Delete(inTable, inWhereClause);
    }

    public static Delete delete(Table inTable) {
        return new Delete(inTable);
    }

    public static WhereClause where(ConditionalExpression inExpr) {
        return new WhereClause(inExpr);
    }

    public static AndExp and(ConditionalExpression inLeft, ConditionalExpression inRight) {
        return new AndExp(inLeft, inRight);
    }

    public static AndExp and() {
        return new AndExp();
    }

    public static OrExp or() {
        return new OrExp();
    }

    public static OrExp or(ConditionalExpression inLeft, ConditionalExpression inRight) {
        return new OrExp(inLeft, inRight);
    }

    public static IsNull isNull(ColumnNode inColumnNode) {
        return new IsNull(inColumnNode);
    }

    public static Like like(StringColumn inColumn, String inMatchString, char inEscapeChar) {
        return new Like(inColumn, QueryBuilder.v(inMatchString), QueryBuilder.v(inEscapeChar));
    }

    public static Like like(StringColumn inColumn, String inMatchString) {
        return new Like(inColumn, QueryBuilder.v(inMatchString));
    }

    public static Like like(IDColumn inColumn, String inMatchString) {
        return new Like(inColumn, QueryBuilder.v(inMatchString));
    }

    public static Like likeLower(StringColumn inColumn, GlobPattern inPattern) {
        return new Like(QueryBuilder.lower(inColumn), QueryBuilder.v(inPattern.toSQLPattern()));
    }

    public static Like like(Function inFunction, StringColumn inColumn) {
        return new Like(inFunction, inColumn);
    }

    public static Like like(ScalarExp inScalarExp, ScalarExp inPattern) {
        return new Like(inScalarExp, inPattern);
    }

    public static Not not(ConditionalExpression inExpr) {
        return new Not(inExpr);
    }

    public static Between between(StringColumn inColumn, String inFirstValue, String inSecondValue) {
        return new Between(inColumn, QueryBuilder.v(inFirstValue), QueryBuilder.v(inSecondValue));
    }

    public static Between between(DateColumn inColumn, Date inFirstValue, Date inSecondValue) {
        return new Between(inColumn, QueryBuilder.v(inFirstValue), QueryBuilder.v(inSecondValue));
    }

    public static Between between(IntColumn inColumn, int inFirstValue, int inSecondValue) {
        return new Between(inColumn, QueryBuilder.v(inFirstValue), QueryBuilder.v(inSecondValue));
    }

    public static Between between(LongColumn inColumn, long inFirstValue, long inSecondValue) {
        return new Between(inColumn, QueryBuilder.v(inFirstValue), QueryBuilder.v(inSecondValue));
    }

    public static Between between(FloatColumn inColumn, float inFirstValue, float inSecondValue) {
        return new Between(inColumn, QueryBuilder.v(inFirstValue), QueryBuilder.v(inSecondValue));
    }

    public static Between between(DoubleColumn inColumn, double inFirstValue, double inSecondValue) {
        return new Between(inColumn, QueryBuilder.v(inFirstValue), QueryBuilder.v(inSecondValue));
    }

    public static Comparison equals(StringColumn column, String value) {
        return new Comparison(Comparison.equals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison equals(IntColumn column, int value) {
        return new Comparison(Comparison.equals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison equals(LongColumn column, long value) {
        return new Comparison(Comparison.equals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison equals(DateColumn column, java.util.Date value) {
        return new Comparison(Comparison.equals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison equals(BooleanColumn column, boolean value) {
        return new Comparison(Comparison.equals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison isTrue(BooleanColumn column) {
        return QueryBuilder.equals(column, true);
    }

    public static Comparison isFalse(BooleanColumn column) {
        return QueryBuilder.equals(column, false);
    }

    public static Comparison equals(IDColumn column, ObjectID value) {
        return new Comparison(Comparison.equals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison equals(EnumColumn column, Enum value) {
        return new Comparison(Comparison.equals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison equals(ColumnNode column1, ColumnNode column2) {
        return new Comparison(Comparison.equals, column1, column2);
    }

    public static Comparison equals(ColumnNode column, Select inSelect) {
        return new Comparison(Comparison.equals, column, inSelect);
    }

    public static Comparison greaterEquals(StringColumn column, String value) {
        return new Comparison(Comparison.greaterEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterEquals(IntColumn column, int value) {
        return new Comparison(Comparison.greaterEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterEquals(LongColumn column, long value) {
        return new Comparison(Comparison.greaterEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterEquals(DateColumn column, java.util.Date value) {
        return new Comparison(Comparison.greaterEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterEquals(ColumnNode column1, ColumnNode column2) {
        return new Comparison(Comparison.greaterEquals, column1, column2);
    }

    public static Comparison greaterEquals(ColumnNode column, Select inSelect) {
        return new Comparison(Comparison.greaterEquals, column, inSelect);
    }

    public static Comparison greaterThan(StringColumn column, String value) {
        return new Comparison(Comparison.greaterThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterThan(IntColumn column, int value) {
        return new Comparison(Comparison.greaterThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterThan(LongColumn column, long value) {
        return new Comparison(Comparison.greaterThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterThan(FloatColumn column, float value) {
        return new Comparison(Comparison.greaterThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterThan(DoubleColumn column, double value) {
        return new Comparison(Comparison.greaterThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterThan(DateColumn column, java.util.Date value) {
        return new Comparison(Comparison.greaterThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison greaterThan(ColumnNode column, Select inSelect) {
        return new Comparison(Comparison.greaterThan, column, inSelect);
    }

    public static Comparison greaterThan(ColumnNode column1, ColumnNode column2) {
        return new Comparison(Comparison.greaterThan, column1, column2);
    }

    public static Comparison greaterThan(Select inSelect, int value) {
        return new Comparison(Comparison.greaterThan, inSelect, (ScalarExp)QueryBuilder.v(value));
    }

    public static Comparison lessEquals(StringColumn column, String value) {
        return new Comparison(Comparison.lessEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessEquals(IntColumn column, int value) {
        return new Comparison(Comparison.lessEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessEquals(LongColumn column, long value) {
        return new Comparison(Comparison.lessEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessEquals(DateColumn column, java.util.Date value) {
        return new Comparison(Comparison.lessEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessEquals(ColumnNode column1, ColumnNode column2) {
        return new Comparison(Comparison.lessEquals, column1, column2);
    }

    public static Comparison lessEquals(ColumnNode column, Select inSelect) {
        return new Comparison(Comparison.lessEquals, column, inSelect);
    }

    public static Comparison lessThan(StringColumn column, String value) {
        return new Comparison(Comparison.lessThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessThan(IntColumn column, int value) {
        return new Comparison(Comparison.lessThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessThan(LongColumn column, long value) {
        return new Comparison(Comparison.lessThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessThan(FloatColumn column, float value) {
        return new Comparison(Comparison.lessThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessThan(DoubleColumn column, double value) {
        return new Comparison(Comparison.lessThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessThan(DateColumn column, java.util.Date value) {
        return new Comparison(Comparison.lessThan, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison lessThan(ColumnNode column1, ColumnNode column2) {
        return new Comparison(Comparison.lessThan, column1, column2);
    }

    public static Comparison lessThan(ColumnNode column, Select inSelect) {
        return new Comparison(Comparison.lessThan, column, inSelect);
    }

    public static Comparison notEquals(StringColumn column, String value) {
        return new Comparison(Comparison.notEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison notEquals(IntColumn column, int value) {
        return new Comparison(Comparison.notEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison notEquals(LongColumn column, long value) {
        return new Comparison(Comparison.notEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison notEquals(DateColumn column, java.util.Date value) {
        return new Comparison(Comparison.notEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison notEquals(BooleanColumn column, boolean value) {
        return new Comparison(Comparison.notEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison notEquals(IDColumn column, ObjectID value) {
        return new Comparison(Comparison.notEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison notEquals(EnumColumn column, Enum value) {
        return new Comparison(Comparison.notEquals, (ColumnNode)column, QueryBuilder.v(value));
    }

    public static Comparison notEquals(ColumnNode column1, ColumnNode column2) {
        return new Comparison(Comparison.notEquals, column1, column2);
    }

    public static Comparison notEquals(ColumnNode column, Select inSelect) {
        return new Comparison(Comparison.notEquals, column, inSelect);
    }

    public static InExpr in(ColumnNode column, ScalarList values) {
        return new InExpr(QueryBuilder.cList(column), values);
    }

    public static ConditionalExpression none() {
        return new Comparison(Comparison.equals, QueryBuilder.v(1), (SqlNode)QueryBuilder.v(0));
    }

    public static ConditionalExpression all() {
        return new Comparison(Comparison.equals, QueryBuilder.v(0), (SqlNode)QueryBuilder.v(0));
    }

    public static ConditionalExpression emptyIn(ColumnNode column, ScalarList values) {
        if (values.isEmpty()) {
            return new Comparison(Comparison.equals, QueryBuilder.v(1), (SqlNode)QueryBuilder.v(0));
        }
        return new InExpr(QueryBuilder.cList(column), values);
    }

    public static InExpr in(ColumnNode column, Select inSelect) {
        return new InExpr(QueryBuilder.cList(column), inSelect);
    }

    public static InExpr in(ColumnList columnList, Select inSelect) {
        return new InExpr(columnList, inSelect);
    }

    public static Exists exists(Select inSelect) {
        return new Exists(inSelect);
    }

    public static Function max(ScalarExp inArgument) {
        return QueryBuilder.function("max", inArgument);
    }

    public static Function sum(ScalarExp inArgument) {
        return QueryBuilder.function("sum", inArgument);
    }

    public static Function min(ScalarExp inArgument) {
        return QueryBuilder.function("min", inArgument);
    }

    public static Function count(ScalarExp inArgument) {
        return QueryBuilder.function("count", inArgument);
    }

    public static Function count() {
        return QueryBuilder.count(QueryBuilder.v("x"));
    }

    public static Function upper(ScalarExp inArgument) {
        return QueryBuilder.function("upper", inArgument);
    }

    public static Function upper(ScalarExp inArgument, SelectAlias inColumnAlias) {
        return QueryBuilder.function("upper", inArgument, inColumnAlias);
    }

    public static Function lower(ScalarExp inArgument) {
        return QueryBuilder.function("lower", inArgument);
    }

    public static Function ifNull(ScalarExp inArg, ScalarExp inResultIfArgNull) {
        return new IfNullFunction(QueryBuilder.rList(inArg, inResultIfArgNull));
    }

    public static Function function(String functionName, ScalarList inArguments) {
        return new Function(functionName, inArguments);
    }

    public static Function function(String functionName, ScalarExp inArgument) {
        return new Function(functionName, QueryBuilder.rList(inArgument));
    }

    public static Function function(String functionName, ScalarExp inArgument, SelectAlias inColumnAlias) {
        return new Function(functionName, QueryBuilder.rList(inArgument), inColumnAlias);
    }

    public static BinaryOperator plus(ScalarExp inScalarLHS, ScalarExp inScalarRHS) {
        return new BinaryOperator("+", inScalarLHS, inScalarRHS);
    }

    public static BinaryOperator minus(ScalarExp inScalarLHS, ScalarExp inScalarRHS) {
        return new BinaryOperator("-", inScalarLHS, inScalarRHS);
    }

    public static BinaryOperator times(ScalarExp inScalarLHS, ScalarExp inScalarRHS) {
        return new BinaryOperator("*", inScalarLHS, inScalarRHS);
    }

    public static BinaryOperator by(ScalarExp inScalarLHS, ScalarExp inScalarRHS) {
        return new BinaryOperator("/", inScalarLHS, inScalarRHS);
    }

    public static BinaryOperator concat(ScalarExp inScalarLHS, ScalarExp inScalarRHS) {
        return new BinaryOperator("||", inScalarLHS, inScalarRHS);
    }

    public static Set set(BooleanColumn inColumn, boolean value) {
        return new Set(inColumn, QueryBuilder.v(value));
    }

    public static Set set(IntColumn inColumn, int value) {
        return new Set(inColumn, QueryBuilder.v(value));
    }

    public static Set increment(IntColumn inColumn) {
        return new Set(inColumn, new SetIncrement(inColumn));
    }

    public static Set set(LongColumn inColumn, long value) {
        return new Set(inColumn, QueryBuilder.v(value));
    }

    public static Set set(ColumnNode inColumn, ScalarExp value) {
        return new Set(inColumn, value);
    }

    public static Set set(FloatColumn inColumn, float value) {
        return new Set(inColumn, QueryBuilder.v(value));
    }

    public static Set set(DoubleColumn inColumn, double value) {
        return new Set(inColumn, QueryBuilder.v(value));
    }

    public static Set set(StringColumn inColumn, String value) {
        return new Set(inColumn, QueryBuilder.v(value));
    }

    public static Set set(DateColumn inColumn, java.util.Date value) {
        return new Set(inColumn, QueryBuilder.v(value));
    }

    public static Set set(IDColumn inColumn, ObjectID value) {
        return new Set(inColumn, QueryBuilder.v(value));
    }

    public static Set set(EnumColumn inColumn, Enum value) {
        return new Set(inColumn, QueryBuilder.v(value));
    }

    public static Set set(ColumnNode inColumn1, ColumnNode inColumn2) {
        return new Set(inColumn1, inColumn2);
    }

    public static ScalarExp scalar(Select inSelect) {
        return new ScalarSelect(inSelect);
    }

    public static ValueWrapper v(boolean value) {
        return new ValueWrapper(value);
    }

    public static ValueWrapper v(int value) {
        return new ValueWrapper(value);
    }

    public static ValueWrapper v(long value) {
        return new ValueWrapper(value);
    }

    public static ValueWrapper v(float value) {
        return new ValueWrapper(value);
    }

    public static ValueWrapper v(double value) {
        return new ValueWrapper(value);
    }

    public static ValueWrapper v(String value) {
        return value == null ? ValueWrapper.NULL : new ValueWrapper(value);
    }

    public static ValueWrapper v(java.util.Date value) {
        return value == null ? ValueWrapper.NULL : new ValueWrapper(value);
    }

    public static ValueWrapper v(ObjectID value) {
        return value == null ? ValueWrapper.NULL : new ValueWrapper(value);
    }

    public static ValueWrapper v(Enum value) {
        return value == null ? ValueWrapper.NULL : new ValueWrapper(value);
    }

    public static SelectList sList() {
        return new SelectList();
    }

    public static SelectList sList(SelectList sList, ScalarExp inScalar) {
        sList.add(inScalar);
        return sList;
    }

    public static SelectList sList(ValueList vList) {
        return new SelectList(vList);
    }

    public static SelectList sList(ScalarExp inScalar) {
        SelectList sList = QueryBuilder.sList();
        sList.add(inScalar);
        return sList;
    }

    public static SelectList sList(ScalarExp inScalar1, ScalarExp inScalar2) {
        SelectList sList = QueryBuilder.sList();
        sList.add(inScalar1);
        sList.add(inScalar2);
        return sList;
    }

    public static SelectList sList(ScalarExp inScalar1, ScalarExp inScalar2, ScalarExp inScalar3) {
        SelectList sList = QueryBuilder.sList();
        sList.add(inScalar1);
        sList.add(inScalar2);
        sList.add(inScalar3);
        return sList;
    }

    public static SelectList sList(ScalarExp inScalar1, ScalarExp inScalar2, ScalarExp inScalar3, ScalarExp inScalar4) {
        SelectList sList = QueryBuilder.sList();
        sList.add(inScalar1);
        sList.add(inScalar2);
        sList.add(inScalar3);
        sList.add(inScalar4);
        return sList;
    }

    public static SelectList sList(SelectList sList1, SelectList sList2) {
        SelectList sList = sList1;
        sList.add(sList2);
        return sList;
    }

    public static SelectList sList(SelectList sList1, SelectList sList2, SelectList sList3) {
        SelectList sList = sList1;
        sList.add(sList2);
        sList.add(sList3);
        return sList;
    }

    public static SelectAlias sAlias(String inAliasName) {
        return new SelectAlias(inAliasName);
    }

    public static TableList tList() {
        return new TableList();
    }

    public static TableList tList(TableList tList, TableClause inTable) {
        tList.addElement(inTable);
        return tList;
    }

    public static TableList tList(TableClause inTable) {
        TableList tList = QueryBuilder.tList();
        tList.addElement(inTable);
        return tList;
    }

    public static TableList tList(TableClause inTable1, TableClause inTable2) {
        TableList tList = QueryBuilder.tList();
        tList.addElement(inTable1);
        tList.addElement(inTable2);
        return tList;
    }

    public static TableList tList(TableClause inTable1, TableClause inTable2, TableClause inTable3) {
        TableList tList = QueryBuilder.tList();
        tList.addElement(inTable1);
        tList.addElement(inTable2);
        tList.addElement(inTable3);
        return tList;
    }

    public static TableClause leftOuterJoin(Table leftTable, TableClause rightTable, ConditionalExpression onClause) {
        return new Join(0, leftTable, rightTable, onClause);
    }

    public static TableClause rightOuterJoin(Table leftTable, TableClause rightTable, ConditionalExpression onClause) {
        return new Join(1, leftTable, rightTable, onClause);
    }

    public static TableClause fullOuterJoin(Table leftTable, TableClause rightTable, ConditionalExpression onClause) {
        return new Join(2, leftTable, rightTable, onClause);
    }

    public static OrderByList oList() {
        return new OrderByList();
    }

    public static OrderByList oList(OrderByList oList, OrderByElement inOrderByElement) {
        oList.add(inOrderByElement);
        return oList;
    }

    public static OrderByList oList(OrderByElement inOrderByElement) {
        OrderByList oList = QueryBuilder.oList();
        oList.add(inOrderByElement);
        return oList;
    }

    public static OrderByList oList(OrderByElement inOrderByElement1, OrderByElement inOrderByElement2) {
        OrderByList oList = QueryBuilder.oList();
        oList.add(inOrderByElement1);
        oList.add(inOrderByElement2);
        return oList;
    }

    public static OrderByList oList(OrderByElement inOrderByElement1, OrderByElement inOrderByElement2, OrderByElement inOrderByElement3) {
        OrderByList oList = QueryBuilder.oList();
        oList.add(inOrderByElement1);
        oList.add(inOrderByElement2);
        oList.add(inOrderByElement3);
        return oList;
    }

    public static OrderByList dictOrderAsc(ScalarExp exp) {
        OrderByList result = QueryBuilder.oList();
        result.add(QueryBuilder.orderByAsc(QueryBuilder.upper(exp)));
        result.add(QueryBuilder.orderByAsc(exp));
        return result;
    }

    public static OrderByList dictOrderDesc(ScalarExp exp) {
        OrderByList result = QueryBuilder.oList();
        result.add(QueryBuilder.orderByDesc(QueryBuilder.upper(exp)));
        result.add(QueryBuilder.orderByDesc(exp));
        return result;
    }

    private static GroupByList gList() {
        return new GroupByList();
    }

    public static GroupByList gList(GroupByList gList, ColumnNode inColumnNode) {
        gList.add(inColumnNode);
        return gList;
    }

    public static GroupByList gList(ColumnNode inColumnNode) {
        GroupByList gList = QueryBuilder.gList();
        gList.add(inColumnNode);
        return gList;
    }

    public static GroupByList gList(ColumnNode inColumnNode1, ColumnNode inColumnNode2) {
        GroupByList gList = QueryBuilder.gList();
        gList.add(inColumnNode1);
        gList.add(inColumnNode2);
        return gList;
    }

    public static GroupByList gList(ColumnNode inColumnNode1, ColumnNode inColumnNode2, ColumnNode inColumnNode3) {
        GroupByList gList = QueryBuilder.gList();
        gList.add(inColumnNode1);
        gList.add(inColumnNode2);
        gList.add(inColumnNode3);
        return gList;
    }

    public static SetList uList() {
        return new SetList();
    }

    public static SetList uList(SetList uList, Set inSet) {
        uList.add(inSet);
        return uList;
    }

    public static SetList uList(Set inSet) {
        SetList uList = QueryBuilder.uList();
        uList.add(inSet);
        return uList;
    }

    public static SetList uList(Set inSet1, Set inSet2) {
        SetList uList = QueryBuilder.uList();
        uList.add(inSet1);
        uList.add(inSet2);
        return uList;
    }

    public static SetList uList(Set inSet1, Set inSet2, Set inSet3) {
        SetList uList = QueryBuilder.uList();
        uList.add(inSet1);
        uList.add(inSet2);
        uList.add(inSet3);
        return uList;
    }

    public static ValueList vList() {
        return new ValueList();
    }

    public static ValueList vList(ValueList vList, ValueWrapper inValue) {
        vList.add(inValue);
        return vList;
    }

    public static ValueList vList(ValueWrapper inValue) {
        ValueList vList = QueryBuilder.vList();
        vList.add(inValue);
        return vList;
    }

    public static ValueList vList(ValueWrapper inValue1, ValueWrapper inValue2) {
        ValueList vList = QueryBuilder.vList();
        vList.add(inValue1);
        vList.add(inValue2);
        return vList;
    }

    public static ValueList vList(ValueWrapper inValue1, ValueWrapper inValue2, ValueWrapper inValue3) {
        ValueList vList = QueryBuilder.vList();
        vList.add(inValue1);
        vList.add(inValue2);
        vList.add(inValue3);
        return vList;
    }

    public static ValueList vList(int[] values) {
        ValueList vList = QueryBuilder.vList();
        for (int i = 0; i < values.length; ++i) {
            vList.add(QueryBuilder.v(values[i]));
        }
        return vList;
    }

    public static ValueList vList(long[] values) {
        ValueList vList = QueryBuilder.vList();
        for (int i = 0; i < values.length; ++i) {
            vList.add(QueryBuilder.v(values[i]));
        }
        return vList;
    }

    public static ValueList vList(float[] values) {
        ValueList vList = QueryBuilder.vList();
        for (int i = 0; i < values.length; ++i) {
            vList.add(QueryBuilder.v(values[i]));
        }
        return vList;
    }

    public static ValueList vList(double[] values) {
        ValueList vList = QueryBuilder.vList();
        for (int i = 0; i < values.length; ++i) {
            vList.add(QueryBuilder.v(values[i]));
        }
        return vList;
    }

    public static ValueList vList(String[] values) {
        ValueList vList = QueryBuilder.vList();
        for (int i = 0; i < values.length; ++i) {
            vList.add(QueryBuilder.v(values[i]));
        }
        return vList;
    }

    public static ValueList vList(java.util.Date[] values) {
        ValueList vList = QueryBuilder.vList();
        for (int i = 0; i < values.length; ++i) {
            vList.add(QueryBuilder.v(values[i]));
        }
        return vList;
    }

    public static ValueList vList(ObjectID[] values) {
        ValueList vList = QueryBuilder.vList();
        for (int i = 0; i < values.length; ++i) {
            vList.add(QueryBuilder.v(values[i]));
        }
        return vList;
    }

    public static ValueList vList(Enum[] values) {
        ValueList vList = QueryBuilder.vList();
        for (int i = 0; i < values.length; ++i) {
            vList.add(QueryBuilder.v(values[i]));
        }
        return vList;
    }

    public static ColumnList cList() {
        return new ColumnList();
    }

    public static ColumnList cList(ColumnList cList, ColumnNode inColumn) {
        cList.add(inColumn);
        return cList;
    }

    public static ColumnList cList(ColumnNode inColumn) {
        ColumnList cList = QueryBuilder.cList();
        cList.add(inColumn);
        return cList;
    }

    public static ColumnList cList(ColumnNode inColumn1, ColumnNode inColumn2) {
        ColumnList cList = QueryBuilder.cList();
        cList.add(inColumn1);
        cList.add(inColumn2);
        return cList;
    }

    public static ColumnList cList(ColumnNode inColumn1, ColumnNode inColumn2, ColumnNode inColumn3) {
        ColumnList cList = QueryBuilder.cList();
        cList.add(inColumn1);
        cList.add(inColumn2);
        cList.add(inColumn3);
        return cList;
    }

    public static ColumnList cList(ColumnNode inColumn1, ColumnNode inColumn2, ColumnNode inColumn3, ColumnNode inColumn4) {
        ColumnList cList = QueryBuilder.cList();
        cList.add(inColumn1);
        cList.add(inColumn2);
        cList.add(inColumn3);
        cList.add(inColumn4);
        return cList;
    }

    public static ScalarList rList(boolean[] values) {
        ScalarList rList = QueryBuilder.rList();
        for (int i = 0; i < values.length; ++i) {
            rList.add(QueryBuilder.v(values[i]));
        }
        return rList;
    }

    public static ScalarList rList(int[] values) {
        ScalarList rList = QueryBuilder.rList();
        for (int i = 0; i < values.length; ++i) {
            rList.add(QueryBuilder.v(values[i]));
        }
        return rList;
    }

    public static ScalarList rList(long[] values) {
        ScalarList rList = QueryBuilder.rList();
        for (int i = 0; i < values.length; ++i) {
            rList.add(QueryBuilder.v(values[i]));
        }
        return rList;
    }

    public static ScalarList rList(float[] values) {
        ScalarList rList = QueryBuilder.rList();
        for (int i = 0; i < values.length; ++i) {
            rList.add(QueryBuilder.v(values[i]));
        }
        return rList;
    }

    public static ScalarList rList(double[] values) {
        ScalarList rList = QueryBuilder.rList();
        for (int i = 0; i < values.length; ++i) {
            rList.add(QueryBuilder.v(values[i]));
        }
        return rList;
    }

    public static ScalarList rList(String[] values) {
        ScalarList rList = QueryBuilder.rList();
        for (int i = 0; i < values.length; ++i) {
            rList.add(QueryBuilder.v(values[i]));
        }
        return rList;
    }

    public static ScalarList rList(Date[] values) {
        ScalarList rList = QueryBuilder.rList();
        for (int i = 0; i < values.length; ++i) {
            rList.add(QueryBuilder.v(values[i]));
        }
        return rList;
    }

    public static ScalarList rList(ObjectID[] values) {
        ScalarList rList = QueryBuilder.rList();
        for (int i = 0; i < values.length; ++i) {
            rList.add(QueryBuilder.v(values[i]));
        }
        return rList;
    }

    public static ScalarList rList(Enum[] values) {
        ScalarList rList = QueryBuilder.rList();
        for (int i = 0; i < values.length; ++i) {
            rList.add(QueryBuilder.v(values[i]));
        }
        return rList;
    }

    public static ScalarList rList() {
        return new ScalarList();
    }

    public static ScalarList rList(ScalarList rList, ScalarExp inScalar) {
        rList.add(inScalar);
        return rList;
    }

    public static ScalarList rList(ScalarExp inScalar) {
        ScalarList rList = QueryBuilder.rList();
        rList.add(inScalar);
        return rList;
    }

    public static ScalarList rList(ScalarExp inScalar1, ScalarExp inScalar2) {
        ScalarList rList = QueryBuilder.rList();
        rList.add(inScalar1);
        rList.add(inScalar2);
        return rList;
    }

    public static ScalarList rList(ScalarExp inScalar1, ScalarExp inScalar2, ScalarExp inScalar3) {
        ScalarList rList = QueryBuilder.rList();
        rList.add(inScalar1);
        rList.add(inScalar2);
        rList.add(inScalar3);
        return rList;
    }

    public static OrderByElement orderByAsc(ScalarExp inExp) {
        return new OrderByElement(inExp, true);
    }

    public static OrderByElement orderByDesc(ScalarExp inExp) {
        return new OrderByElement(inExp, false);
    }

    public static OrderByElement orderByAsc(Function inFunction) {
        return new OrderByElement(inFunction, true);
    }

    public static OrderByElement orderByDesc(Function inFunction) {
        return new OrderByElement(inFunction, false);
    }

    public static void execute(Select inSelect, ResultSetProcessor inProcessor) throws PersistenceManagerException {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        QueryExecutorProcessor query = new QueryExecutorProcessor(db, inSelect, inProcessor);
        query.runQuery();
    }

    public static int executeInt(Select inSelect) throws PersistenceManagerException {
        IntValueProcessor ivp = new IntValueProcessor();
        QueryBuilder.execute(inSelect, ivp);
        return ivp.getValue();
    }

    public static int selectCount(Table inTable, WhereClause inWhere) throws PersistenceManagerException {
        return QueryBuilder.executeInt(QueryBuilder.select(QueryBuilder.sList(QueryBuilder.count()), QueryBuilder.tList(inTable), inWhere));
    }

    public static int selectCount(Table inTable) throws PersistenceManagerException {
        return QueryBuilder.executeInt(QueryBuilder.select(QueryBuilder.sList(QueryBuilder.count()), QueryBuilder.tList(inTable)));
    }

    public static PersistentBean[] executeMultiResult(Select inSelect, Table inTable) throws PersistenceManagerException {
        MultiResultSetProcessor processor = new MultiResultSetProcessor(inTable);
        QueryBuilder.execute(inSelect, processor);
        return processor.getResults();
    }

    public static PersistentBean[] executeMultiResult(Select inSelect, Table inTable, Class arrType) throws PersistenceManagerException {
        MultiResultSetProcessor processor = new MultiResultSetProcessor(inTable);
        QueryBuilder.execute(inSelect, processor);
        return processor.getResults(arrType);
    }

    public static PersistentBean executeSingleResult(Select inSelect, Table inTable) throws PersistenceManagerException {
        SingleResultSetProcessor processor = new SingleResultSetProcessor(inTable);
        QueryBuilder.execute(inSelect, processor);
        return processor.getResult();
    }

    public static PersistentBean[] selectAll(Table inTable) throws PersistenceManagerException {
        return QueryBuilder.executeMultiResult(QueryBuilder.select(inTable), inTable);
    }

    public static PersistentBean[] selectWhere(Table inTable, WhereClause inWhere) throws PersistenceManagerException {
        return QueryBuilder.executeMultiResult(QueryBuilder.select(inTable.allColumns(), QueryBuilder.tList(inTable), inWhere), inTable);
    }

    public static PersistentBean[] selectWhere(Table inTable, TableList inFrom, WhereClause inWhere) throws PersistenceManagerException {
        return QueryBuilder.executeMultiResult(QueryBuilder.select(inTable.allColumns(), inFrom, inWhere), inTable);
    }

    public static PersistentBean selectSingleWhere(Table inTable, WhereClause inWhere) throws PersistenceManagerException {
        return QueryBuilder.executeSingleResult(QueryBuilder.select(inTable.allColumns(), QueryBuilder.tList(inTable), inWhere), inTable);
    }

    public static int execute(SqlModQuery inSqlModQuery) throws PersistenceManagerException {
        QueryExecutor query = new QueryExecutor(inSqlModQuery);
        query.runQuery();
        return query.getUpdateCount();
    }

    private static class RowCountProcessor
    extends ResultSetProcessor {
        private int mRowCount = 0;

        private RowCountProcessor() {
        }

        public void processResultSet(ResultSet rs) throws PersistenceManagerException, SQLException {
            while (rs.next()) {
                ++this.mRowCount;
            }
        }

        public int getRowCount() {
            return this.mRowCount;
        }
    }
}

