/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.TableDependency;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class PrivilegedTableDependency
implements TableDependency {
    private TableDependency mNestedDep;

    public PrivilegedTableDependency(TableDependency dep) {
        this.mNestedDep = dep;
    }

    public void onUpdate(final Select idsUpdated) throws PersistenceManagerException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PersistenceManagerException {
                    PrivilegedTableDependency.this.mNestedDep.onUpdate(idsUpdated);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            if (e instanceof PersistenceManagerException) {
                throw (PersistenceManagerException)e;
            }
            throw new PersistenceManagerException(e);
        }
    }
}

