/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public class MultiResultSetProcessor
extends ResultSetProcessor {
    private Table mTable;
    private Vector vector = new Vector();
    private boolean mLoadAssociation;

    public MultiResultSetProcessor(Table inTable) {
        this(inTable, true);
    }

    public MultiResultSetProcessor(Table inTable, boolean inLoadAssociation) {
        this.mTable = inTable;
        this.mLoadAssociation = inLoadAssociation;
    }

    public void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException {
        while (inResultSet.next()) {
            this.vector.add(this.mTable.retrieveObjectFrom(inResultSet));
        }
    }

    public boolean loadAssociations() {
        return this.mLoadAssociation;
    }

    public PersistentBean[] getResults() {
        return this.vector.toArray(new PersistentBean[this.vector.size()]);
    }

    public PersistentBean[] getResults(Class arrType) {
        return (PersistentBean[])this.vector.toArray((Object[])Array.newInstance(arrType, this.vector.size()));
    }

    public Iterator getResultIterator() {
        return this.vector.iterator();
    }
}

