/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.query.builder.SqlNode;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.util.Enumeration;
import java.util.Vector;

class ListExpr
implements SqlNode {
    public static final String COMMA = ",";
    private Vector elements = null;

    protected ListExpr() {
    }

    protected void addList(ListExpr inList) {
        Enumeration e = inList.getElements();
        if (e != null) {
            while (e.hasMoreElements()) {
                this.addElement((SqlNode)e.nextElement());
            }
        }
    }

    protected void addElement(SqlNode inSqlNode) {
        if (this.elements == null) {
            this.elements = new Vector();
        }
        this.elements.add(inSqlNode);
    }

    public Enumeration getElements() {
        if (this.elements == null) {
            return null;
        }
        return this.elements.elements();
    }

    public void writeSQL(SQLStatement stmt) {
        block1: {
            if (this.elements == null || this.elements.size() <= 0) break block1;
            int i = 0;
            while (true) {
                SqlNode tmpNode = (SqlNode)this.elements.elementAt(i);
                this.writeSqlNode(stmt, tmpNode);
                if (++i >= this.elements.size()) break;
                stmt.addSQLClause(COMMA);
            }
            stmt.addSQLClause(" ");
        }
    }

    protected void writeSqlNode(SQLStatement stmt, SqlNode sNode) {
        sNode.writeSQL(stmt);
    }

    public int size() {
        return this.elements.size();
    }

    public Object elementAt(int idx) {
        return this.elements.elementAt(idx);
    }

    public boolean contains(SqlNode inSqlNode) {
        if (this.elements != null) {
            return this.elements.contains(inSqlNode);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    public String toString() {
        return this.getClass().getName() + this.elements;
    }
}

