/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.ValueWrapper;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;

class Like
extends ConditionalExpression {
    public static final String SINGLE_CHAR = "_";
    public static final String MULTI_CHAR = "%";
    private ScalarExp mColumn;
    private ScalarExp mMatchString;
    private ValueWrapper mEscapeChar = null;

    Like(ScalarExp inColumn, ScalarExp inMatchString, ValueWrapper inEscapeChar) {
        this.mColumn = inColumn;
        this.mMatchString = inMatchString;
        this.mEscapeChar = inEscapeChar;
    }

    Like(ScalarExp inColumn, ScalarExp inMatchString) {
        this(inColumn, inMatchString, null);
    }

    protected void writeExp(SQLStatement stmt) {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        this.mColumn.writeSQL(stmt);
        stmt.addSQLClause(db.getClauseStringLike()).addSQLClause(" ");
        this.mMatchString.writeSQL(stmt);
        if (this.mEscapeChar != null) {
            stmt.addSQLClause(db.getClauseStringEscape()).addSQLClause(" ");
            this.mEscapeChar.writeSQL(stmt);
        }
    }

    private Like() {
    }
}

