/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;

class Join
implements TableClause {
    private Table mLeftTable;
    private TableClause mRightTable;
    private ConditionalExpression mOnCondition;
    private int mJoinType;
    public static final int LEFT_JOIN = 0;
    public static final int RIGHT_JOIN = 1;
    public static final int FULL_JOIN = 2;

    private Join() {
    }

    public Join(int joinType, Table leftTable, TableClause rightTable, ConditionalExpression onCondition) {
        this.mLeftTable = leftTable;
        this.mRightTable = rightTable;
        this.mOnCondition = onCondition;
        this.mJoinType = joinType;
    }

    public void writeSQL(SQLStatement stmt) {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        stmt.addSQLClause("(");
        this.mLeftTable.writeSQL(stmt);
        stmt.addSQLClause(" ");
        switch (this.mJoinType) {
            case 0: {
                stmt.addSQLClause(db.getLeftOuterJoinClause());
                break;
            }
            case 1: {
                stmt.addSQLClause(db.getRightOuterJoinClause());
                break;
            }
            case 2: {
                stmt.addSQLClause(db.getFullOuterJoinClause());
            }
        }
        stmt.addSQLClause(" ");
        this.mRightTable.writeSQL(stmt);
        stmt.addSQLClause(" ");
        stmt.addSQLClause(db.getJoinOnClause());
        stmt.addSQLClause("(");
        this.mOnCondition.writeSQL(stmt);
        stmt.addSQLClause(")");
        stmt.addSQLClause(")");
    }

    public void checkReadPermission() {
        this.mLeftTable.checkReadPermission();
        this.mRightTable.checkReadPermission();
    }

    public Table getTableOfType(Class tableClass) {
        Table result = null;
        result = this.mLeftTable.getTableOfType(tableClass);
        if (result != null) {
            return result;
        }
        return this.mRightTable.getTableOfType(tableClass);
    }
}

