/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.query.builder.ColumnList;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SqlModQuery;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.ValueList;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;

class Insert
implements SqlModQuery {
    private ColumnList mColumnList;
    private ValueList mValueList = null;
    private Select mSelect;
    private Table mTable;

    public Insert(ColumnList inColumnList, Table inTable, ValueList inValueList) {
        this.mColumnList = inColumnList;
        this.mValueList = inValueList;
        this.mTable = inTable;
    }

    public Insert(ColumnList inColumnList, Table inTable, Select inSelect) {
        this.mColumnList = inColumnList;
        this.mTable = inTable;
        this.mSelect = inSelect;
    }

    public void writeSQL(SQLStatement stmt) {
        this.mTable.checkWritePermission();
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        stmt.addSQLClause(db.getClauseStringInsert()).addSQLClause(" ");
        this.mTable.writeSQL(stmt);
        stmt.addSQLClause("(").addSQLClause(" ");
        this.mColumnList.writeSQL(stmt);
        stmt.addSQLClause(")").addSQLClause(" ");
        if (this.mValueList != null) {
            stmt.addSQLClause(db.getClauseStringValues()).addSQLClause(" ");
            stmt.addSQLClause("(").addSQLClause(" ");
            this.mValueList.writeSQL(stmt);
            stmt.addSQLClause(")").addSQLClause(" ");
        } else {
            this.mSelect.writeSQL(stmt);
        }
    }

    public Table getModTable() {
        return this.mTable;
    }

    private Insert() {
    }
}

